
#include "bdl.h"

static BDL_Record moonrecords[] = {

     {
          2451179.3,
          {4.8851,0.00602,185.0229,0.24263,0.001658,1.6594}, /*cmx*/
          {-0.392676,-1.7605,-2.9197,-5.5336}, /*cfx*/
          {-0.6957,0.01813,41.0121,0.11493,0.001648,0.399}, /*cmy*/
          {-2.070012,-3.5732,-2.1793,-0.9516}, /*cfy*/
          {2.4904,-0.0846,181.0908,0.11885,0.002362,1.6569}, /*cmz*/
          {-5.106395,-0.4913,-0.5333,-3.9517} /*cfz*/
     },
     {
          2451234.3,
          {5.1164,-0.06326,184.1932,0.40657,0.002323,1.6583}, /*cmx*/
          {-4.502154,-5.8317,-1.0027,-2.1273}, /*cfx*/
          {0.3459,0.02189,46.7892,0.21838,0.000559,0.4833}, /*cmy*/
          {-6.241467,-0.441,-5.4449,-3.8464}, /*cfy*/
          {-2.3226,-0.04957,179.9438,0.37585,0.000436,1.6647}, /*cmz*/
          {-2.922724,-4.7162,-4.7176,-0.5474} /*cfz*/
     },
     {
          2451289.3,
          {1.5094,-0.0776,184.7016,0.36883,0.000899,1.6836}, /*cmx*/
          {-2.371582,-3.8201,-5.5053,-4.9503}, /*cfx*/
          {1.628,0.00331,58.7351,0.2149,0.000857,0.5651}, /*cmy*/
          {-4.05685,-4.1912,-1.4852,-0.3338}, /*cfy*/
          {-5.0289,0.01093,176.6106,0.42721,0.001042,1.5663}, /*cmz*/
          {-0.785426,-2.6387,-6.059,-3.4032} /*cfz*/
     },
     {
          2451344.3,
          {-2.9392,-0.0474,185.4528,0.21253,0.001152,1.7241}, /*cmx*/
          {-0.217997,-1.811,-5.1059,-1.4411}, /*cfx*/
          {1.7982,-0.0293,68.3068,0.09549,0.001418,0.6511}, /*cmy*/
          {-1.798413,-1.7184,-5.5534,-3.0383}, /*cfy*/
          {-4.4252,0.06529,173.2351,0.37641,0.003551,1.5959}, /*cmz*/
          {-4.922107,-0.4541,-3.6745,-6.2201} /*cfz*/
     },
     {
          2451399.3,
          {-5.5908,0.03191,185.6936,0.02818,0.002457,1.6868}, /*cmx*/
          {-4.283765,-0.8891,-2.904,-4.1769}, /*cfx*/
          {0.0523,-0.02906,70.1626,0.06626,0.001089,0.6333}, /*cmy*/
          {-5.780178,-3.5069,-2.9726,-5.6641}, /*cfy*/
          {-0.6516,0.07902,172.0138,0.10279,0.003774,1.5836}, /*cmz*/
          {-2.718652,-4.0626,-1.1637,-2.6259} /*cfz*/
     },
     {
          2451454.3,
          {-3.6814,0.0939,185.2885,0.30185,0.001033,1.7893}, /*cmx*/
          {-1.989216,-0.4001,-3.4988,-0.5578}, /*cfx*/
          {-1.5772,-0.00204,64.9629,0.14752,0.000461,0.5711}, /*cmy*/
          {-3.461254,-0.6112,-4.8953,-1.9665}, /*cfy*/
          {3.9452,0.02312,173.6255,0.21805,0.001316,1.5867}, /*cmz*/
          {-0.425589,-5.5065,-4.2977,-5.2015} /*cfz*/
     },
     {
          2451509.3,
          {1.8117,0.06423,185.5465,0.2348,0.004099,1.7538}, /*cmx*/
          {-5.943639,-4.2241,-1.0437,-3.2631}, /*cfx*/
          {-1.6315,0.01976,57.5381,0.09317,0.001346,0.5131}, /*cmy*/
          {-1.185556,-3.8305,-1.9009,-4.7931}, /*cfy*/
          {5.1302,-0.06535,175.5489,0.23372,0.003849,1.5859}, /*cmz*/
          {-4.371909,-3.2496,-0.1235,-1.6567} /*cfz*/
     },
     {
          2451564.3,
          {5.3201,-0.01317,185.9888,0.15022,0.00311,1.6201}, /*cmx*/
          {-3.681675,-5.5606,-5.0265,-6.0289}, /*cfx*/
          {-0.5311,0.02649,56.3694,0.1557,0.000736,0.5549}, /*cmy*/
          {-5.297063,-6.1834,-5.6822,-1.4039}, /*cfy*/
          {1.299,-0.07787,176.0926,0.13638,0.003258,1.6131}, /*cmz*/
          {-2.103727,-3.4916,-4.1357,-4.4523} /*cfz*/
     },
     {
          2451619.3,
          {4.5053,-0.07088,186.5193,0.48379,0.001212,1.6532}, /*cmx*/
          {-1.511424,-3.2587,-0.7473,-2.6606}, /*cfx*/
          {1.019,0.0219,64.1495,0.23189,0.000519,0.6585}, /*cmy*/
          {-3.150765,-3.5839,-0.2213,-4.2414}, /*cfy*/
          {-3.1404,-0.03527,173.7764,0.37871,0.001441,1.6118}, /*cmz*/
          {-6.216896,-1.626,-2.1958,-1.026} /*cfz*/
     },
     {
          2451674.3,
          {0.442,-0.07357,186.084,0.53327,0.003104,1.6718}, /*cmx*/
          {-5.660686,-1.0099,-4.0519,-5.5074}, /*cfx*/
          {2.2449,-0.01056,74.1933,0.16577,0.001253,0.7014}, /*cmy*/
          {-0.95608,-1.3078,-4.5031,-0.7344}, /*cfy*/
          {-5.0169,0.02228,169.9939,0.46168,0.001281,1.5202}, /*cmz*/
          {-4.095584,-5.8353,-2.7652,-3.9089} /*cfz*/
     },
     {
          2451729.3,
          {-3.7555,-0.03393,185.1164,0.36529,0.003984,1.6966}, /*cmx*/
          {-3.507809,-5.0209,-1.7488,-1.9518}, /*cfx*/
          {1.5944,-0.03675,79.1537,0.03099,0.001007,0.7413}, /*cmy*/
          {-5.00103,-4.5587,-1.8906,-3.4551}, /*cfy*/
          {-3.7648,0.0698,167.6911,0.27509,0.002183,1.5908}, /*cmz*/
          {-1.962873,-3.5542,-0.6083,-0.4443} /*cfz*/
     },
     {
          2451784.3,
          {-5.6305,0.04885,184.4672,0.06501,0.002273,1.6747}, /*cmx*/
          {-1.293652,-0.871,-5.5205,-4.6716}, /*cfx*/
          {-0.5387,-0.02666,77.6701,0.11061,0.00038,0.7056}, /*cmy*/
          {-2.732411,-0.1715,-4.2382,-6.1442}, /*cfy*/
          {0.2909,0.07273,168.8902,0.06645,0.00185,1.6151}, /*cmz*/
          {-6.039561,-4.7407,-4.7035,-3.152} /*cfz*/
     },
     {
          2451839.3,
          {-2.7533,0.09729,184.942,0.30223,0.001268,1.6934}, /*cmx*/
          {-5.275625,-3.798,-1.0485,-1.0266}, /*cfx*/
          {-2.0036,0.00386,72.7675,0.14172,0.001527,0.6353}, /*cmy*/
          {-0.444617,-4.0888,-1.2883,-2.5045}, /*cfy*/
          {4.4341,0.00587,171.4514,0.3793,0.001931,1.5847}, /*cmz*/
          {-3.730609,-2.1352,-5.0299,-5.7416} /*cfz*/
     },
     {
          2451894.3,
          {2.8771,0.04983,185.1483,0.15702,0.00362,1.7599}, /*cmx*/
          {-2.943394,-1.6712,-4.7399,-3.7487}, /*cfx*/
          {-1.7428,0.02809,69.1004,0.07828,0.001855,0.6141}, /*cmy*/
          {-4.462737,-0.6035,-4.7673,-5.3067}, /*cfy*/
          {4.5702,-0.07511,173.321,0.18341,0.003062,1.5458}, /*cmz*/
          {-1.382913,-5.6635,-2.6231,-2.1899} /*cfz*/
     },
     {
          2451949.3,
          {5.5088,-0.02901,185.0359,0.27075,0.002049,1.6901}, /*cmx*/
          {-0.693193,-2.1112,-2.8142,-0.2842}, /*cfx*/
          {-0.1611,0.03323,71.2583,0.17584,0.000686,0.6582}, /*cmy*/
          {-2.265512,-3.2291,-1.6068,-1.8546}, /*cfy*/
          {0.2561,-0.06936,172.0915,0.29419,0.00087,1.4923}, /*cmz*/
          {-5.402942,-0.9881,-0.7958,-5.0121} /*cfz*/
     },
     {
          2452004.3,
          {3.8023,-0.07699,184.7445,0.42387,0.001638,1.7007}, /*cmx*/
          {-4.824164,-6.2693,-1.1484,-3.1812}, /*cfx*/
          {1.7592,0.01415,78.6433,0.20878,0.001234,0.7541}, /*cmy*/
          {-0.090598,-0.8643,-4.0021,-4.6534}, /*cfy*/
          {-3.6206,-0.02488,168.1278,0.54625,0.001385,1.5188}, /*cmz*/
          {-3.249923,-4.9515,-1.2703,-1.579} /*cfz*/
     },
     {
          2452059.3,
          {-0.5866,-0.06789,185.1582,0.37936,0.000258,1.6752}, /*cmx*/
          {-2.703185,-4.3251,-1.4479,-6.0341}, /*cfx*/
          {2.5232,-0.02348,84.4284,0.10971,0.001404,0.7792}, /*cmy*/
          {-4.179433,-5.0287,-1.2747,-1.1709}, /*cfy*/
          {-4.9587,0.03281,164.8511,0.49012,0.001922,1.5076}, /*cmz*/
          {-1.148415,-2.6763,-5.4565,-4.475} /*cfz*/
     },
     {
          2452114.3,
          {-4.4108,-0.01886,185.4339,0.22137,0.002105,1.6581}, /*cmx*/
          {-0.551628,-2.4093,-5.8846,-2.4893}, /*cfx*/
          {1.1571,-0.03861,84.6127,0.07466,0.000567,0.7783}, /*cmy*/
          {-1.959702,-4.3164,-5.8992,-3.8992}, /*cfy*/
          {-3.1282,0.07299,165.4603,0.28652,0.002944,1.5729}, /*cmz*/
          {-5.30003,-0.3634,-3.5491,-0.9762} /*cfz*/
     },
     {
          2452169.3,
          {-5.484,0.06499,185.7692,0.07018,0.003275,1.6975}, /*cmx*/
          {-4.609063,-1.7341,-3.4019,-5.2185}, /*cfx*/
          {-1.0623,-0.02217,80.6137,0.06849,0.00048,0.7471}, /*cmy*/
          {-6.00114,-2.5897,-4.733,-0.3349}, /*cfy*/
          {1.1507,0.06563,167.4807,0.10133,0.00238,1.5817}, /*cmz*/
          {-3.077434,-2.2474,-1.0906,-3.6703} /*cfz*/
     },
     {
          2452224.3,
          {-1.6598,0.09365,185.7011,0.27792,0.000684,1.7386}, /*cmx*/
          {-2.296224,-0.6012,-3.1996,-1.546}, /*cfx*/
          {-2.2923,0.01025,77.4021,0.01968,0.000356,0.6926}, /*cmy*/
          {-3.734477,-1.3542,-4.1984,-3.031}, /*cfy*/
          {4.8756,-0.01512,168.5542,0.31068,0.001423,1.4961}, /*cmz*/
          {-0.753504,-5.5698,-3.0803,-0.0114} /*cfz*/
     },
     {
          2452279.3,
          {3.7268,0.03447,185.6835,0.07361,0.002601,1.761}, /*cmx*/
          {-6.249109,-4.3213,-1.4157,-4.2545}, /*cfx*/
          {-1.6859,0.03715,77.396,0.08774,0.001063,0.7266}, /*cmy*/
          {-1.471588,-1.6055,-3.1087,-5.8367}, /*cfy*/
          {3.8755,-0.07914,167.5772,0.17916,0.004655,1.5188}, /*cmz*/
          {-4.695592,-3.38,-0.2915,-2.7462} /*cfz*/
     },
     {
          2452334.3,
          {5.5232,-0.04475,185.4079,0.29986,0.001879,1.6682}, /*cmx*/
          {-4.011686,-5.5243,-6.0543,-0.8428}, /*cfx*/
          {0.4624,0.03275,81.9384,0.14406,0.00114,0.7709}, /*cmy*/
          {-5.541857,-5.9586,-1.3511,-2.3532}, /*cfy*/
          {-0.6728,-0.05978,165.7795,0.19635,0.003606,1.468}, /*cmz*/
          {-2.458834,-4.1766,-4.16,-5.5627} /*cfz*/
     },
     {
          2452389.3,
          {2.9738,-0.07762,185.3831,0.51922,0.001037,1.7154}, /*cmx*/
          {-1.86605,-3.4524,-5.7378,-3.7308}, /*cfx*/
          {2.3311,0.0027,87.5729,0.09498,0.001037,0.8017}, /*cmy*/
          {-3.351663,-4.2214,-5.8012,-5.1193}, /*cfy*/
          {-3.9955,-0.01501,164.0977,0.4291,0.001259,1.4447}, /*cmz*/
          {-0.328396,-2.0496,-1.2581,-2.1469} /*cfz*/
     },
     {
          2452444.3,
          {-1.4994,-0.06056,184.6208,0.50635,0.002455,1.7384}, /*cmx*/
          {-6.029903,-1.2929,-4.1205,-0.3035}, /*cfx*/
          {2.4088,-0.03172,88.726,0.13524,0.000231,0.7693}, /*cmy*/
          {-1.157836,-3.4231,-6.1967,-1.6771}, /*cfy*/
          {-4.8118,0.04119,164.8665,0.47891,0.002784,1.4629}, /*cmz*/
          {-4.51022,-6.1739,-3.3976,-5.0708} /*cfz*/
     },
     {
          2452499.3,
          {-4.909,-0.00456,183.9081,0.31098,0.003628,1.6797}, /*cmx*/
          {-3.880667,-5.2992,-2.0727,-3.0649}, /*cfx*/
          {0.5987,-0.03517,84.3289,0.16871,0.001133,0.7453}, /*cmy*/
          {-5.241162,-1.4023,-4.4933,-4.425}, /*cfy*/
          {-2.4721,0.07612,167.0688,0.26426,0.003746,1.546}, /*cmz*/
          {-2.362656,-3.903,-0.8733,-1.5273} /*cfz*/
     },
     {
          2452554.3,
          {-5.1163,0.07583,183.8051,0.15601,0.00158,1.6965}, /*cmx*/
          {-1.655638,-0.5775,-5.5532,-5.7896}, /*cfx*/
          {-1.4165,-0.01796,79.844,0.07169,0.001431,0.7671}, /*cmy*/
          {-3.029011,-5.4567,-2.3166,-0.8497}, /*cfy*/
          {1.9834,0.05479,168.536,0.08474,0.002587,1.6389}, /*cmz*/
          {-0.124733,-4.7499,-4.7099,-4.1754} /*cfz*/
     },
     {
          2452609.3,
          {-0.628,0.08917,184.6145,0.40637,0.003291,1.6729}, /*cmx*/
          {-5.622065,-4.0921,-0.9685,-2.1347}, /*cfx*/
          {-2.412,0.01713,80.2235,0.07305,0.000631,0.7437}, /*cmy*/
          {-0.769293,-6.1144,-1.3734,-3.5579}, /*cfy*/
          {5.0192,-0.0299,167.9499,0.34896,0.002209,1.5307}, /*cmz*/
          {-4.077959,-2.3729,-5.6725,-0.5442} /*cfz*/
     },
     {
          2452664.3,
          {4.4124,0.01894,185.2227,0.16018,0.005051,1.7115}, /*cmx*/
          {-3.295666,-1.7441,-4.8392,-4.7966}, /*cfx*/
          {-1.3886,0.04287,84.3139,0.06937,0.000454,0.7813}, /*cmy*/
          {-4.766421,-4.8993,-5.9504,-0.0537}, /*cfy*/
          {3.1463,-0.07893,166.0729,0.08554,0.002937,1.5029}, /*cmz*/
          {-1.742913,-5.3276,-3.1483,-3.3146} /*cfz*/
     },
     {
          2452719.3,
          {5.2842,-0.05551,185.736,0.31559,0.001884,1.6378}, /*cmx*/
          {-1.068129,-2.8264,-2.3541,-1.3915}, /*cfx*/
          {1.0984,0.02737,88.6215,0.14118,0.001131,0.8209}, /*cmy*/
          {-2.524451,-3.5542,-5.9291,-2.8862}, /*cfy*/
          {-1.3659,-0.05356,163.5209,0.40714,0.000703,1.5082}, /*cmz*/
          {-5.804137,-1.1274,-1.9568,-6.2027} /*cfz*/
     },
     {
          2452774.3,
          {2.1201,-0.07701,185.2223,0.53073,0.000821,1.6691}, /*cmx*/
          {-5.212659,-0.6075,-3.816,-4.2829}, /*cfx*/
          {2.6006,-0.00906,89.5273,0.16483,0.001515,0.79}, /*cmy*/
          {-0.327045,-2.0004,-3.8747,-5.6442}, /*cfy*/
          {-4.3198,-0.00748,162.7277,0.57547,0.002084,1.48}, /*cmz*/
          {-3.687276,-5.1109,-1.4022,-2.7883} /*cfz*/
     },
     {
          2452829.3,
          {-2.2641,-0.05386,184.5027,0.49687,0.002586,1.7374}, /*cmx*/
          {-3.098141,-4.749,-1.6409,-0.8611}, /*cfx*/
          {2.0173,-0.03408,84.7848,0.16808,0.000698,0.7341}, /*cmy*/
          {-4.435577,-0.3259,-1.3505,-2.1656}, /*cfy*/
          {-4.7192,0.05214,165.2683,0.40563,0.002014,1.5218}, /*cmz*/
          {-1.588266,-2.8005,-5.3536,-5.6566} /*cfz*/
     },
     {
          2452884.3,
          {-5.2755,0.01103,184.5605,0.23039,0.003,1.6783}, /*cmx*/
          {-0.945324,-2.5744,-5.7743,-3.6343}, /*cfx*/
          {0.0951,-0.03041,77.9881,0.14344,0.000921,0.6954}, /*cmy*/
          {-2.270243,-4.5779,-2.0047,-4.9466}, /*cfy*/
          {-1.7134,0.07781,169.0703,0.12547,0.001607,1.5533}, /*cmz*/
          {-5.71301,-0.4524,-3.6576,-2.094} /*cfz*/
     },
     {
          2452939.3,
          {-4.6669,0.0864,185.2435,0.07887,0.002832,1.7254}, /*cmx*/
          {-4.987343,-3.1784,-3.4699,-0.0258}, /*cfx*/
          {-1.6346,-0.01378,75.4753,0.03537,0.001013,0.7315}, /*cmy*/
          {-0.075713,-0.3233,-5.7673,-1.3987}, /*cfy*/
          {2.7926,0.0435,170.2875,0.22129,0.000235,1.5828}, /*cmz*/
          {-3.462091,-1.7588,-1.0017,-4.7508} /*cfz*/
     },
     {
          2452994.3,
          {0.4246,0.08041,185.2238,0.2578,0.001136,1.699}, /*cmx*/
          {-2.658782,-1.1168,-4.6291,-2.6805}, /*cfx*/
          {-2.4021,0.02627,79.7232,0.14414,0.000281,0.7562}, /*cmy*/
          {-4.082585,-3.4061,-5.8482,-4.1204}, /*cfy*/
          {5.1451,-0.04673,168.4895,0.32452,0.002528,1.5025}, /*cmz*/
          {-1.127975,-5.5069,-2.3599,-1.152} /*cfz*/
     },
     {
          2453049.3,
          {4.9235,0.0035,184.686,0.06968,0.002314,1.6577}, /*cmx*/
          {-0.338218,-1.3288,-2.4083,-5.4002}, /*cfx*/
          {-0.861,0.04385,85.5579,0.11284,0.001491,0.8152}, /*cmy*/
          {-1.775909,-1.3,-4.0039,-0.5567}, /*cfy*/
          {2.4168,-0.07845,165.1453,0.0543,0.003523,1.5153}, /*cmz*/
          {-5.094322,-2.1462,-0.2055,-3.8837} /*cfz*/
     },
     {
          2453104.3,
          {4.9896,-0.06625,183.542,0.37202,0.002977,1.6495}, /*cmx*/
          {-4.411923,-5.7334,-0.6212,-1.9943}, /*cfx*/
          {1.6579,0.01645,88.2641,0.05206,0.001206,0.8176}, /*cmy*/
          {-5.808739,-1.4695,-1.8657,-3.3727}, /*cfy*/
          {-2.0366,-0.04859,164.3097,0.35394,0.001429,1.5251}, /*cmz*/
          {-2.895459,-4.4905,-4.1039,-0.4893} /*cfz*/
     },
     {
          2453159.3,
          {1.2246,-0.07446,183.3413,0.463,0.001361,1.6693}, /*cmx*/
          {-2.288215,-3.7721,-4.9334,-4.8587}, /*cfx*/
          {2.5096,-0.01852,84.8961,0.19027,0.000435,0.7211}, /*cmy*/
          {-3.611874,-6.0989,-5.7297,-6.1828}, /*cfy*/
          {-4.7212,0.0047,167.115,0.46314,0.000666,1.4986}, /*cmz*/
          {-0.776953,-2.269,-5.7731,-3.3838} /*cfz*/
     },
     {
          2453214.3,
          {-3.0313,-0.04456,183.8893,0.38158,0.000995,1.7034}, /*cmx*/
          {-0.174474,-1.7412,-4.941,-1.4132}, /*cfx*/
          {1.4379,-0.03101,76.4981,0.277,0.001353,0.6562}, /*cmy*/
          {-1.449299,-3.9098,-1.0019,-2.7534}, /*cfy*/
          {-4.4711,0.06211,171.5408,0.42837,0.003056,1.5963}, /*cmz*/
          {-4.93566,-0.1673,-3.3707,-6.2392} /*cfz*/
     },
     {
          2453269.3,
          {-5.516,0.02701,184.7313,0.19474,0.003118,1.672}, /*cmx*/
          {-4.292812,-5.9652,-2.8829,-4.2025}, /*cfx*/
          {-0.2922,-0.02493,68.8968,0.19238,0.002272,0.6182}, /*cmy*/
          {-5.584681,-1.3724,-4.7742,-5.5536}, /*cfy*/
          {-0.8607,0.07724,173.6249,0.2141,0.003806,1.5967}, /*cmz*/
          {-2.756642,-4.2271,-0.9951,-2.6846} /*cfz*/
     },
     {
          2453324.3,
          {-3.9238,0.09111,184.7378,0.19627,0.000909,1.794}, /*cmx*/
          {-2.042346,-0.4451,-0.5081,-0.6008}, /*cfx*/
          {-1.7579,-0.0066,68.6797,0.10356,0.001708,0.648}, /*cmy*/
          {-3.387705,-3.7043,-2.0644,-1.9176}, /*cfy*/
          {3.6168,0.02777,172.726,0.09242,0.002359,1.5542}, /*cmz*/
          {-0.499355,-5.1674,-4.6866,-5.2807} /*cfz*/
     },
     {
          2453379.3,
          {1.4379,0.0698,184.9364,0.35991,0.003418,1.7779}, /*cmx*/
          {-5.996861,-4.3006,-1.0655,-3.2778}, /*cfx*/
          {-2.1135,0.0321,75.349,0.21499,0.001332,0.7024}, /*cmy*/
          {-1.0874,-0.4846,-3.8427,-4.6156}, /*cfy*/
          {5.0718,-0.05804,169.4488,0.27128,0.003103,1.5066}, /*cmz*/
          {-4.458494,-2.858,-6.2709,-1.7026} /*cfz*/
     },
     {
          2453434.3,
          {5.2687,-0.01278,185.0473,0.06332,0.004251,1.6194}, /*cmx*/
          {-3.687516,-1.1433,-5.0659,-5.9859}, /*cfx*/
          {-0.1905,0.03768,81.5729,0.09264,0.001924,0.7496}, /*cmy*/
          {-5.046789,-4.3688,-1.2319,-1.0574}, /*cfy*/
          {1.6391,-0.07727,167.0233,0.03976,0.003538,1.5434}, /*cmz*/
          {-2.162645,-3.0856,-3.7828,-4.4772} /*cfz*/
     },
     {
          2453489.3,
          {4.4382,-0.0714,185.0935,0.43751,0.000987,1.6269}, /*cmx*/
          {-1.483407,-3.274,-1.7913,-2.6155}, /*cfx*/
          {1.9602,0.00386,81.0135,0.09621,0.001554,0.7422}, /*cmy*/
          {-2.789291,-5.1706,-5.5076,-3.8416}, /*cfy*/
          {-2.7714,-0.04278,168.1356,0.34672,0.00167,1.602}, /*cmz*/
          {-6.256458,-1.2922,-1.9199,-1.0539} /*cfz*/
     },
     {
          2453544.3,
          {0.353,-0.07161,184.3732,0.60995,0.002619,1.6461}, /*cmx*/
          {-5.637495,-0.9779,-3.9929,-5.5043}, /*cfx*/
          {2.0714,-0.02172,73.1603,0.24195,0.000132,0.6142}, /*cmy*/
          {-0.602665,-3.1215,-3.3301,-0.3907}, /*cfy*/
          {-5.0932,0.01878,172.2996,0.4464,0.000948,1.5714}, /*cmz*/
          {-4.12819,-5.53,-1.9687,-3.9462} /*cfz*/
     },
     {
          2453599.3,
          {-3.7146,-0.03432,183.9011,0.50126,0.003869,1.6781}, /*cmx*/
          {-3.516299,-5.0047,-1.6679,-2.0013}, /*cfx*/
          {0.8403,-0.02511,62.4793,0.23246,0.001068,0.5356}, /*cmy*/
          {-4.751957,-0.8587,-4.365,-3.27}, /*cfy*/
          {-4.0095,0.07144,175.8906,0.31146,0.001381,1.6665}, /*cmz*/
          {-1.992873,-3.4238,-0.1541,-0.498} /*cfz*/
     },
     {
          2453654.3,
          {-5.6211,0.04323,183.945,0.15301,0.002728,1.6768}, /*cmx*/
          {-1.345411,-2.4414,-5.6024,-4.7673}, /*cfx*/
          {-0.5702,-0.01913,56.6113,0.08643,0.001684,0.5314}, /*cmy*/
          {-2.625635,-4.5416,-2.1069,-6.0818}, /*cfy*/
          {0.1314,0.07393,177.5891,0.08326,0.001759,1.6667}, /*cmz*/
          {-6.090542,-1.681,-4.6488,-3.2423} /*cfz*/
     },
     {
          2453709.3,
          {-3.1072,0.09502,184.406,0.21065,0.000983,1.6962}, /*cmx*/
          {-5.367998,-3.9542,-2.8458,-1.1355}, /*cfx*/
          {-1.6765,0.00033,59.3451,0.14365,0.000603,0.587}, /*cmy*/
          {-0.400109,-6.1226,-5.9718,-2.4143}, /*cfy*/
          {4.3209,0.01265,177.0434,0.23921,0.00082,1.6076}, /*cmz*/
          {-3.827928,-1.8597,-4.1188,-5.8691} /*cfz*/
     },
     {
          2453764.3,
          {2.4441,0.05681,184.232,0.29108,0.00327,1.7321}, /*cmx*/
          {-3.035991,-1.5677,-4.8256,-3.8144}, /*cfx*/
          {-1.6087,0.03542,67.5154,0.18053,0.000897,0.6453}, /*cmy*/
          {-4.344196,-3.5076,-0.5213,-5.1084}, /*cfy*/
          {4.9067,-0.07167,174.9321,0.23018,0.0026,1.5761}, /*cmz*/
          {-1.502977,-5.5848,-2.2742,-2.3069} /*cfz*/
     },
     {
          2453819.3,
          {5.4703,-0.02795,183.6326,0.09834,0.002867,1.6717}, /*cmx*/
          {-0.73937,-2.0371,-2.5711,-0.3065}, /*cfx*/
          {0.4623,0.02582,72.2079,0.02886,0.001378,0.6267}, /*cmy*/
          {-2.006255,-0.0881,-4.6842,-1.5563}, /*cfy*/
          {0.787,-0.07721,173.1795,0.16992,0.001312,1.5318}, /*cmz*/
          {-5.498553,-0.9275,-0.1764,-5.0841} /*cfz*/
     },
     {
          2453874.3,
          {3.8128,-0.07765,182.9247,0.36915,0.002116,1.6865}, /*cmx*/
          {-4.836331,-6.2598,-0.7566,-3.1961}, /*cfx*/
          {1.8748,-0.00591,68.0319,0.19587,0.000552,0.5915}, /*cmy*/
          {-6.035172,-2.4157,-2.8337,-4.3279}, /*cfy*/
          {-3.5772,-0.03299,174.5809,0.45164,0.001206,1.6014}, /*cmz*/
          {-3.309452,-4.715,-0.9146,-1.6286} /*cfz*/
     },
     {
          2453929.3,
          {-0.6111,-0.06739,183.8014,0.41433,0.000261,1.6653}, /*cmx*/
          {-2.714038,-4.2834,-4.5156,-6.0772}, /*cfx*/
          {1.4634,-0.02075,57.1865,0.26704,0.000527,0.488}, /*cmy*/
          {-3.864927,-0.1341,-3.0747,-0.9172}, /*cfy*/
          {-5.3699,0.03628,177.5285,0.4433,0.001873,1.6288}, /*cmz*/
          {-1.174318,-2.4912,-4.7423,-4.5159} /*cfz*/
     },
     {
          2453984.3,
          {-4.3993,-0.01927,185.1729,0.30965,0.001683,1.6479}, /*cmx*/
          {-0.581464,-2.3222,-5.9536,-2.5774}, /*cfx*/
          {0.3298,-0.01831,46.8654,0.19991,0.001534,0.4146}, /*cmy*/
          {-1.754418,-4.1146,-1.1315,-3.7902}, /*cfy*/
          {-3.3039,0.07776,180.1017,0.32869,0.002014,1.7016}, /*cmz*/
          {-5.313495,-0.429,-3.2477,-1.032} /*cfz*/
     },
     {
          2454039.3,
          {-5.4882,0.05911,185.867,0.15851,0.00372,1.6839}, /*cmx*/
          {-4.67228,-0.4524,-3.4237,-5.3468}, /*cfx*/
          {-0.7111,-0.01257,43.1497,0.05258,0.001515,0.4179}, /*cmy*/
          {-5.891581,-0.7977,-4.998,-0.2917}, /*cfy*/
          {1.2196,0.06735,180.7433,0.09634,0.002235,1.7071}, /*cmz*/
          {-3.119702,-4.3968,-1.2125,-3.7716} /*cfz*/
     },
     {
          2454094.3,
          {-2.0299,0.09311,185.2317,0.17186,0.001413,1.7238}, /*cmx*/
          {-2.398026,-0.5791,-1.0498,-1.6765}, /*cfx*/
          {-1.4615,0.00952,46.9968,0.16357,0.00077,0.4526}, /*cmy*/
          {-3.611311,-3.2217,-1.5655,-2.9268}, /*cfy*/
          {5.0431,-0.00844,179.8819,0.15721,0.00088,1.6036}, /*cmz*/
          {-0.851141,-5.5599,-4.7063,-0.1593} /*cfz*/
     },
     {
          2454149.3,
          {3.3673,0.04073,184.4689,0.18317,0.001942,1.7641}, /*cmx*/
          {-0.068813,-4.5883,-1.4901,-4.3412}, /*cfx*/
          {-0.8639,0.03041,54.3122,0.18805,0.002113,0.5049}, /*cmy*/
          {-1.251951,-0.6078,-4.0088,-5.568}, /*cfy*/
          {4.4461,-0.08203,177.7804,0.23869,0.003615,1.6304}, /*cmz*/
          {-4.81799,-3.3603,-0.226,-2.8839} /*cfz*/
     },
     {
          2454204.3,
          {5.5226,-0.04444,183.6714,0.13543,0.002542,1.6562}, /*cmx*/
          {-4.071305,-5.5084,-5.8664,-0.8964}, /*cfx*/
          {0.9108,0.01136,56.8095,0.06183,0.001951,0.4828}, /*cmy*/
          {-5.208716,-2.9656,-1.3721,-1.9836}, /*cfy*/
          {-0.3291,-0.07259,177.8173,0.04974,0.003828,1.6119}, /*cmz*/
          {-2.54658,-3.1915,-4.0963,-5.6481} /*cfz*/
     },
     {
          2454259.3,
          {2.965,-0.0794,183.8776,0.43877,0.000704,1.7055}, /*cmx*/
          {-1.890112,-3.4261,-4.9556,-3.7751}, /*cfx*/
          {1.489,-0.01224,50.2418,0.20283,0.000589,0.4005}, /*cmy*/
          {-2.96805,-5.8702,-4.8924,-4.7415}, /*cfy*/
          {-4.4015,-0.0173,180.5804,0.27274,0.002024,1.613}, /*cmz*/
          {-0.358907,-1.8897,-1.7409,-2.1777} /*cfz*/
     },
     {
          2454314.3,
          {-1.6182,-0.06028,184.2606,0.49457,0.001944,1.7394}, /*cmx*/
          {-6.042218,-1.2476,-3.8743,-0.3593}, /*cfx*/
          {0.7671,-0.01495,39.0754,0.24055,0.00115,0.3027}, /*cmy*/
          {-0.815694,-3.5321,-0.5291,-1.3687}, /*cfy*/
          {-5.2959,0.05155,183.4645,0.43432,0.001734,1.6201}, /*cmz*/
          {-4.494973,-6.2056,-3.5586,-5.0907} /*cfz*/
     },
     {
          2454369.3,
          {-4.9847,-0.00268,184.4003,0.36777,0.002966,1.6828}, /*cmx*/
          {-3.900326,-5.3392,-1.9755,-3.1503}, /*cfx*/
          {-0.0505,-0.01131,30.6297,0.12194,0.001513,0.2705}, /*cmy*/
          {-4.984618,-1.2528,-4.3824,-4.2168}, /*cfy*/
          {-2.3518,0.08078,184.1922,0.36537,0.003173,1.6763}, /*cmz*/
          {-2.340715,-4.0253,-0.9426,-1.5818} /*cfz*/
     },
     {
          2454424.3,
          {-5.0956,0.07239,184.0944,0.05689,0.00166,1.7073}, /*cmx*/
          {-1.704135,-1.8379,-5.7857,-5.9049}, /*cfx*/
          {-0.7142,-0.0037,28.7885,0.04187,0.000985,0.3025}, /*cmy*/
          {-2.769064,-1.9201,-2.2976,-0.6095}, /*cfy*/
          {2.3247,0.05631,183.9634,0.11653,0.00319,1.7581}, /*cmz*/
          {-0.139761,-1.8472,-4.8566,-4.278} /*cfz*/
     },
     {
          2454479.3,
          {-0.8458,0.08876,184.179,0.30617,0.001525,1.6783}, /*cmx*/
          {-5.70901,-4.14,-1.0731,-2.2691}, /*cfx*/
          {-0.9226,0.01297,33.0235,0.14978,0.000317,0.3266}, /*cmy*/
          {-0.419871,-6.1159,-2.9719,-3.1816}, /*cfy*/
          {5.4623,-0.02818,183.5421,0.21241,0.000251,1.6715}, /*cmz*/
          {-4.14804,-2.4959,-5.9415,-0.6734} /*cfz*/
     },
     {
          2454534.3,
          {4.2112,0.0229,184.1574,0.2739,0.004469,1.6945}, /*cmx*/
          {-3.383761,-1.736,-4.8316,-4.9044}, /*cfx*/
          {-0.1234,0.01962,39.2413,0.09203,0.001275,0.358}, /*cmy*/
          {-4.341083,-3.5432,-0.8082,-5.8632}, /*cfy*/
          {3.7221,-0.0907,183.1616,0.13238,0.001929,1.6836}, /*cmz*/
          {-1.827923,-6.2721,-3.1089,-3.4019} /*cfz*/
     },
     {
          2454589.3,
          {5.303,-0.05831,184.5318,0.15929,0.002467,1.6328}, /*cmx*/
          {-1.113391,-3.0344,-2.2711,-1.4508}, /*cfx*/
          {0.9897,-0.00173,39.3229,0.10397,0.000861,0.3264}, /*cmy*/
          {-2.024807,-5.0664,-5.1155,-2.4087}, /*cfy*/
          {-1.5123,-0.06435,182.9863,0.2153,0.001218,1.7016}, /*cmz*/
          {-5.840914,-0.9297,-1.8124,-6.2309} /*cfz*/
     },
     {
          2454644.3,
          {1.9646,-0.08032,184.8628,0.42409,0.000247,1.671}, /*cmx*/
          {-5.217785,-0.5723,-4.404,-4.316}, /*cfx*/
          {0.8296,-0.0112,31.1605,0.20667,0.000454,0.2415}, /*cmy*/
          {-6.069013,-2.6629,-5.0543,-5.1496}, /*cfy*/
          {-5.0598,0.0004,183.4563,0.44817,0.001814,1.6582}, /*cmz*/
          {-3.656847,-5.0547,-0.8614,-2.7713} /*cfz*/
     },
     {
          2454699.3,
          {-2.6099,-0.05048,185.2442,0.4631,0.001842,1.7473}, /*cmx*/
          {-3.08171,-4.7097,-1.5466,-0.896}, /*cfx*/
          {0.1906,-0.00846,21.0969,0.15745,0.001095,0.1675}, /*cmy*/
          {-3.895363,-0.4835,-3.2605,-1.6218}, /*cfy*/
          {-4.9646,0.06577,183.7714,0.39301,0.001824,1.671}, /*cmz*/
          {-1.51881,-2.8471,-4.7821,-5.6366} /*cfz*/
     },
     {
          2454754.3,
          {-5.4072,0.01685,185.3708,0.29035,0.002303,1.686}, /*cmx*/
          {-0.930492,-2.5636,-5.7076,-3.6994}, /*cfx*/
          {-0.271,-0.00374,15.4796,0.04972,0.000887,0.1351}, /*cmy*/
          {-1.659056,-5.4639,-1.2751,-4.332}, /*cfy*/
          {-1.1956,0.08024,184.6874,0.21356,0.000861,1.6819}, /*cmz*/
          {-5.65095,-0.7997,-3.6842,-2.1144} /*cfz*/
     },
     {
          2454809.3,
          {-4.4635,0.08353,185.4164,0.07545,0.003139,1.7261}, /*cmx*/
          {-5.000894,-0.6825,-3.4999,-0.1297}, /*cfx*/
          {-0.4883,0.00417,15.9987,0.08529,0.000301,0.1696}, /*cmy*/
          {-5.513484,-4.8409,-6.2599,-0.6184}, /*cfy*/
          {3.4104,0.04103,185.3983,0.05711,0.000878,1.7257}, /*cmz*/
          {-3.439643,-1.6711,-2.3077,-4.8066} /*cfz*/
     },
     {
          2454864.3,
          {0.4407,0.07932,184.6789,0.17217,0.000738,1.6945}, /*cmx*/
          {-2.710116,-1.1623,-0.464,-2.7867}, /*cfx*/
          {-0.2356,0.01133,20.4049,0.10329,0.000634,0.2123}, /*cmy*/
          {-3.137249,-3.0914,-6.2731,-3.2949}, /*cfy*/
          {5.6682,-0.0524,185.7951,0.23559,0.000871,1.6801}, /*cmz*/
          {-1.149699,-5.6483,-1.6715,-1.2299} /*cfz*/
     },
     {
          2454919.3,
          {4.9171,0.00231,183.9081,0.07288,0.001728,1.6516}, /*cmx*/
          {-0.388641,-5.6144,-2.4422,-5.4622}, /*cfx*/
          {0.4322,0.00482,24.0898,0.03529,0.001336,0.2115}, /*cmy*/
          {-0.864386,-0.9146,-4.1817,-5.9297}, /*cfy*/
          {2.5918,-0.09273,185.2861,0.15726,0.00292,1.7301}, /*cmz*/
          {-5.113821,-3.4306,-0.2637,-3.9238} /*cfz*/
     },
     {
          2454974.3,
          {4.912,-0.07245,183.3159,0.21445,0.003069,1.6539}, /*cmx*/
          {-4.418117,-5.4525,-0.4235,-2.0221}, /*cfx*/
          {0.6693,-0.00867,22.1455,0.1081,0.000471,0.1646}, /*cmy*/
          {-4.860743,-1.977,-1.7686,-2.3117}, /*cfy*/
          {-2.7285,-0.05007,185.4539,0.15546,0.002277,1.7402}, /*cmz*/
          {-2.856523,-4.6075,-4.235,-0.4609} /*cfz*/
     },
     {
          2455029.3,
          {0.7635,-0.07652,184.1642,0.3445,0.00189,1.6806}, /*cmx*/
          {-2.249586,-3.6425,-4.5355,-4.8634}, /*cfx*/
          {0.1517,-0.00741,15.1768,0.15427,0.000779,0.1072}, /*cmy*/
          {-2.492855,-6.0097,-2.4522,-4.8849}, /*cfy*/
          {-5.4505,0.02074,185.9494,0.36751,0.000605,1.6459}, /*cmz*/
          {-0.678988,-2.351,-1.7789,-3.319} /*cfz*/
     },
     {
          2455084.3,
          {-3.6016,-0.0361,185.1007,0.34499,0.000215,1.7177}, /*cmx*/
          {-0.111184,-1.6639,-3.605,-1.411}, /*cfx*/
          {-0.2445,-0.00129,10.1606,0.08143,0.000964,0.1064}, /*cmy*/
          {-6.191887,-4.3195,-0.1793,-1.0383}, /*cfy*/
          {-4.2597,0.07459,186.3092,0.46574,0.002469,1.7023}, /*cmz*/
          {-4.817576,-0.2411,-3.4912,-6.1886} /*cfz*/
     },
     {
          2455139.3,
          {-5.5688,0.03581,185.5354,0.25793,0.002431,1.671}, /*cmx*/
          {-4.233075,-5.9476,-2.9,-4.2239}, /*cfx*/
          {-0.3204,0.00518,12.0703,0.10231,0.000203,0.1445}, /*cmy*/
          {-3.633412,-3.4185,-5.0003,-3.651}, /*cfy*/
          {0.0402,0.07503,185.6742,0.3338,0.003799,1.7047}, /*cmz*/
          {-2.653769,-4.2562,-1.0431,-2.6777} /*cfz*/
     },
     {
          2455194.3,
          {-3.4977,0.0894,184.9629,0.04735,0.001574,1.7719}, /*cmx*/
          {-2.011773,-0.0896,-0.5892,-0.6486}, /*cfx*/
          {-0.0145,0.00911,17.5788,0.10819,0.000857,0.1837}, /*cmy*/
          {-1.338428,-1.3582,-4.2604,-0.0346}, /*cfy*/
          {4.3606,0.01991,184.8587,0.05898,0.003255,1.6776}, /*cmz*/
          {-0.430602,-1.4234,-4.8866,-5.3106} /*cfz*/
     },
     {
          2455249.3,
          {1.7329,0.0659,184.7985,0.28886,0.001722,1.7872}, /*cmx*/
          {-6.000239,-4.2786,-0.8344,-3.3338}, /*cfx*/
          {0.5126,0.00164,21.0161,0.02447,0.000536,0.189}, /*cmy*/
          {-5.393475,-6.0797,-2.3664,-2.7472}, /*cfy*/
          {5.3847,-0.06977,184.3645,0.26466,0.001891,1.6527}, /*cmz*/
          {-4.418952,-3.1097,-0.4541,-1.7202} /*cfz*/
     },
     {
          2455304.3,
          {5.3677,-0.01926,185.1303,0.17196,0.003809,1.644}, /*cmx*/
          {-3.683584,-1.866,-4.9922,-6.0069}, /*cfx*/
          {0.5957,-0.00854,20.4717,0.04445,0.00047,0.1727}, /*cmy*/
          {-3.163995,-0.3807,-1.2538,-5.4409}, /*cfy*/
          {1.257,-0.08837,184.6925,0.14073,0.003503,1.6921}, /*cmz*/
          {-2.105103,-0.8105,-3.8579,-4.4407} /*cfz*/
     },
     {
          2455359.3,
          {4.1441,-0.08051,186.0118,0.25354,0.001528,1.6444}, /*cmx*/
          {-1.432915,-3.3155,-2.1467,-2.5804}, /*cfx*/
          {0.0875,-0.00994,17.8884,0.10603,0.00053,0.1583}, /*cmy*/
          {-0.782993,-4.9048,-0.9975,-1.7583}, /*cfy*/
          {-3.7826,-0.03297,184.8198,0.1895,0.002599,1.7552}, /*cmz*/
          {-6.141674,-1.2151,-1.7944,-0.9658} /*cfz*/
     },
     {
          2455414.3,
          {-0.4656,-0.06974,185.9819,0.49592,0.001712,1.6559}, /*cmx*/
          {-5.542252,-0.8948,-3.8945,-5.455}, /*cfx*/
          {-0.4571,-0.00079,16.8141,0.07282,0.001013,0.1635}, /*cmy*/
          {-4.536917,-3.1554,-5.3386,-4.3121}, /*cfy*/
          {-5.4894,0.03819,184.8202,0.40404,0.000462,1.6749}, /*cmz*/
          {-3.973334,-5.5485,-0.8753,-3.839} /*cfz*/
     },
     {
          2455469.3,
          {-4.4027,-0.02035,185.2276,0.49374,0.003192,1.6867}, /*cmx*/
          {-3.400701,-4.9336,-1.5332,-1.9548}, /*cfx*/
          {-0.5125,0.00684,19.7187,0.09246,0.000681,0.2118}, /*cmy*/
          {-2.190134,-2.415,-3.0456,-0.7561}, /*cfy*/
          {-3.296,0.08006,184.3055,0.35913,0.001035,1.7187}, /*cmz*/
          {-1.833585,-3.4036,-6.1879,-0.4127} /*cfz*/
     },
     {
          2455524.3,
          {-5.4926,0.05413,184.546,0.23624,0.002519,1.6857}, /*cmx*/
          {-1.238602,-2.5496,-5.453,-4.7438}, /*cfx*/
          {-0.1205,0.01328,26.0899,0.15122,0.000447,0.2665}, /*cmy*/
          {-0.032293,-0.3751,-3.8984,-3.5557}, /*cfy*/
          {1.3029,0.06526,183.9355,0.16453,0.001682,1.7181}, /*cmz*/
          {-5.949554,-1.5059,-4.7542,-3.1912} /*cfz*/
     },
     {
          2451179.4,
          {-0.5897,0.00423,237.7127,0.31208,0.002146,0.6393}, /*cmx*/
          {-6.19413,-1.3672,-1.8875,-2.8979}, /*cfx*/
          {-0.2819,-0.00317,58.6366,0.06944,0.000909,0.1605}, /*cmy*/
          {-1.602809,-2.2283,-2.3136,-4.3791}, /*cfy*/
          {1.5731,0.00209,231.0089,0.29728,0.002109,0.6277}, /*cmz*/
          {-4.615945,-6.2054,-0.3012,-1.332} /*cfz*/
     },
     {
          2451279.4,
          {0.0339,0.00477,238.3179,0.68738,0.001744,0.6198}, /*cmx*/
          {-0.193586,-1.7929,-4.671,-3.933}, /*cfx*/
          {-0.5449,-0.00071,71.4847,0.24108,0.000656,0.2046}, /*cmy*/
          {-1.810839,-2.5004,-5.2889,-5.4105}, /*cfy*/
          {1.7985,-0.00335,227.61,0.6931,0.00187,0.5915}, /*cmz*/
          {-4.90004,-0.3284,-3.2708,-2.3544} /*cfz*/
     },
     {
          2451379.4,
          {0.5646,0.01042,238.2643,0.26613,0.002972,0.5788}, /*cmx*/
          {-0.483767,-2.0936,-5.2375,-4.8891}, /*cfx*/
          {-0.5844,0.00263,84.8115,0.08452,0.001093,0.2084}, /*cmy*/
          {-2.037945,-2.8812,-5.8704,-0.1207}, /*cfy*/
          {1.4736,-0.00477,222.6699,0.2502,0.00281,0.515}, /*cmz*/
          {-5.199179,-0.5851,-3.7499,-3.3054} /*cfz*/
     },
     {
          2451479.4,
          {1.4254,0.00462,238.2186,0.33313,0.003386,0.5614}, /*cmx*/
          {-0.549233,-5.2344,-2.0891,-5.6622}, /*cfx*/
          {-0.3208,0.00403,82.393,0.13955,0.001228,0.2117}, /*cmy*/
          {-2.106823,-5.7432,-2.8766,-0.8799}, /*cfy*/
          {0.7104,-0.00798,223.5922,0.35519,0.003531,0.5297}, /*cmz*/
          {-5.264804,-3.7977,-0.625,-4.0998} /*cfz*/
     },
     {
          2451579.4,
          {1.8913,-0.00561,237.993,0.45974,0.001612,0.4714}, /*cmx*/
          {-0.623948,-2.1393,-2.8466,-0.1858}, /*cfx*/
          {0.0532,0.00244,78.8692,0.1599,0.000578,0.1794}, /*cmy*/
          {-2.202175,-3.0808,-3.6619,-1.8786}, /*cfy*/
          {-0.0008,-0.00869,224.4418,0.47087,0.001371,0.4678}, /*cmz*/
          {-5.333174,-0.6488,-1.461,-4.8323} /*cfz*/
     },
     {
          2451679.4,
          {1.5204,-0.00479,238.5051,0.69518,0.002426,0.5256}, /*cmx*/
          {-0.939399,-2.5629,-5.5953,-1.2214}, /*cfx*/
          {0.2778,0.0038,91.075,0.26047,0.001016,0.1986}, /*cmy*/
          {-2.468264,-3.5288,-0.1823,-2.7339}, /*cfy*/
          {-0.6096,-0.00767,220.1325,0.67635,0.002438,0.4553}, /*cmz*/
          {-5.658787,-1.0537,-4.0696,-5.9049} /*cfz*/
     },
     {
          2451779.4,
          {1.0969,-0.00886,237.7975,0.08542,0.002282,0.633}, /*cmx*/
          {-1.203671,-2.5731,-5.8369,-1.8996}, /*cfx*/
          {0.7035,-0.00032,98.5605,0.01357,0.000661,0.244}, /*cmy*/
          {-2.69692,-4.4361,-0.53,-3.3786}, /*cfy*/
          {-1.4894,0.00071,217.3214,0.06401,0.002031,0.5828}, /*cmz*/
          {-5.932956,-1.427,-4.4851,-0.345} /*cfz*/
     },
     {
          2451879.4,
          {-0.0408,-0.01061,237.9886,0.24355,0.004027,0.5911}, /*cmx*/
          {-1.222606,-5.9711,-2.8201,-2.8038}, /*cfx*/
          {0.7054,-0.00167,94.9219,0.08772,0.001465,0.2344}, /*cmy*/
          {-2.729969,-0.3316,-3.7801,-4.2934}, /*cfy*/
          {-1.6527,0.00326,218.5907,0.23998,0.003828,0.5569}, /*cmz*/
          {-5.946891,-4.4974,-1.3309,-1.2378} /*cfz*/
     },
     {
          2451979.4,
          {-1.078,-0.00461,238.2768,0.61781,0.000847,0.6221}, /*cmx*/
          {-1.357594,-2.9452,-4.1488,-3.8957}, /*cfx*/
          {0.4786,-0.00078,95.6707,0.24426,0.00051,0.2695}, /*cmy*/
          {-2.869856,-4.0015,-5.6101,-5.3292}, /*cfy*/
          {-1.1351,0.00086,218.041,0.59191,0.000987,0.5646}, /*cmz*/
          {-6.08106,-1.4145,-2.7824,-2.3367} /*cfz*/
     },
     {
          2452079.4,
          {-1.5903,-0.00097,238.2932,0.6812,0.003189,0.6155}, /*cmx*/
          {-1.699732,-3.3373,-0.1649,-4.854}, /*cfx*/
          {0.3415,-0.0028,104.224,0.25124,0.001187,0.2688}, /*cmy*/
          {-3.172492,-4.5697,-1.3081,-0.0364}, /*cfy*/
          {-0.8728,0.00504,214.7969,0.62959,0.002871,0.5453}, /*cmz*/
          {-0.152886,-1.8095,-4.9145,-3.3128} /*cfz*/
     },
     {
          2452179.4,
          {-1.5516,0.0,237.7897,0.15685,0.000507,0.4754}, /*cmx*/
          {-1.930996,-0.4107,-0.0109,-5.6717}, /*cfx*/
          {0.1299,-0.00762,106.3437,0.05532,0.000176,0.2185}, /*cmy*/
          {-3.373725,-1.3308,-2.1167,-0.9291}, /*cfy*/
          {-0.5254,0.01723,213.9954,0.11228,0.000842,0.4224}, /*cmz*/
          {-0.387933,-4.9712,-5.2993,-4.2484} /*cfz*/
     },
     {
          2452279.4,
          {-1.4648,0.00633,237.7889,0.05588,0.003865,0.5395}, /*cmx*/
          {-1.921822,-0.6384,-3.5814,-0.0038}, /*cfx*/
          {-0.5523,-0.00152,104.191,0.00925,0.001453,0.2352}, /*cmy*/
          {-3.387681,-2.6705,-4.8784,-1.4639}, /*cfy*/
          {0.994,0.00282,214.07,0.07429,0.00373,0.488}, /*cmz*/
          {-0.376682,-5.5681,-2.1129,-4.7004} /*cfz*/
     },
     {
          2452379.4,
          {-0.9238,0.00852,237.7676,0.73878,0.001141,0.5493}, /*cmx*/
          {-2.127153,-3.7093,-5.911,-1.0066}, /*cfx*/
          {-0.8045,0.00085,106.7085,0.2884,0.00067,0.2393}, /*cmy*/
          {-3.587049,-4.9849,-0.7413,-2.4332}, /*cfy*/
          {1.4709,-0.00077,213.4416,0.66343,0.000846,0.4753}, /*cmz*/
          {-0.586393,-2.198,-4.2461,-5.7316} /*cfz*/
     },
     {
          2452479.4,
          {-0.2872,0.01011,237.5007,0.60153,0.003641,0.5611}, /*cmx*/
          {-2.48181,-4.0912,-0.9327,-2.0241}, /*cfx*/
          {-0.7783,0.0009,108.827,0.22965,0.001382,0.2622}, /*cmy*/
          {-3.901558,-5.6253,-2.4536,-3.4593}, /*cfy*/
          {1.551,-0.00074,212.9876,0.55394,0.003343,0.5}, /*cmz*/
          {-0.950057,-2.5452,-5.6796,-0.5445} /*cfz*/
     },
     {
          2452579.4,
          {1.1167,0.00243,237.8824,0.34293,0.001472,0.7192}, /*cmx*/
          {-2.661779,-1.0044,-4.0996,-2.7944}, /*cfx*/
          {-0.6469,0.00277,107.4121,0.10929,0.000445,0.3161}, /*cmy*/
          {-4.062053,-2.6438,-5.6756,-4.221}, /*cfy*/
          {1.4478,-0.00416,213.342,0.27867,0.000923,0.6484}, /*cmz*/
          {-1.130729,-5.8307,-2.8498,-1.238} /*cfz*/
     },
     {
          2452679.4,
          {1.3972,0.00474,237.085,0.1867,0.00304,0.5414}, /*cmx*/
          {-2.652901,-4.0019,-4.5034,-3.861}, /*cfx*/
          {-0.2885,0.0054,108.8614,0.08781,0.001288,0.2614}, /*cmy*/
          {-4.080465,-5.2613,-6.0095,-5.2643}, /*cfy*/
          {0.7673,-0.00927,212.3658,0.14237,0.003014,0.4936}, /*cmz*/
          {-1.120276,-2.5858,-2.8782,-2.3122} /*cfz*/
     },
     {
          2452779.4,
          {1.5776,0.00209,237.4669,0.78251,0.001656,0.5585}, /*cmx*/
          {-2.921597,-4.513,-0.8478,-4.8985}, /*cfx*/
          {0.2072,0.00206,109.6362,0.31894,0.000843,0.2364}, /*cmy*/
          {-4.331188,-6.0306,-2.3173,-6.2735}, /*cfy*/
          {-0.0646,-0.00452,212.7277,0.72033,0.001367,0.4928}, /*cmz*/
          {-1.392088,-2.9817,-5.7783,-3.3644} /*cfz*/
     },
     {
          2452879.4,
          {1.6892,-0.00682,237.2871,0.45873,0.003739,0.5312}, /*cmx*/
          {-3.264048,-4.8891,-1.7497,-5.7129}, /*cfx*/
          {0.4483,0.0022,104.9102,0.17514,0.001442,0.2287}, /*cmy*/
          {-4.633227,-0.3479,-3.5169,-0.7805}, /*cfy*/
          {-0.5337,-0.00671,215.2442,0.4211,0.003447,0.4928}, /*cmz*/
          {-1.740045,-3.2633,-0.1168,-4.1849} /*cfz*/
     },
     {
          2452979.4,
          {1.3011,-0.01733,237.4834,0.40239,0.002877,0.4394}, /*cmx*/
          {-3.377836,-1.7155,-4.8273,-0.0983}, /*cfx*/
          {0.6455,0.00152,103.8779,0.16408,0.001214,0.2295}, /*cmy*/
          {-4.742322,-3.6102,-0.2691,-1.4175}, /*cfy*/
          {-1.1463,-0.00448,215.7715,0.38905,0.002779,0.4349}, /*cmz*/
          {-1.856406,-0.1682,-3.3619,-4.8498} /*cfz*/
     },
     {
          2453079.4,
          {-0.3703,-0.0027,236.6642,0.36291,0.002413,0.613}, /*cmx*/
          {-3.403248,-4.8584,-5.4416,-0.9213}, /*cfx*/
          {0.802,-0.00195,108.0047,0.16731,0.000901,0.2785}, /*cmy*/
          {-4.785948,-0.0619,-0.9887,-2.3}, /*cfy*/
          {-1.6416,0.00166,213.4748,0.3408,0.00196,0.5438}, /*cmz*/
          {-1.877807,-3.4106,-3.6996,-5.6826} /*cfz*/
     },
     {
          2453179.4,
          {-0.8634,-0.00344,237.2394,0.76038,0.002001,0.6011}, /*cmx*/
          {-3.715811,-5.335,-1.9525,-1.9988}, /*cfx*/
          {0.6412,-0.00429,103.5265,0.30218,0.001004,0.2638}, /*cmy*/
          {-5.069149,-0.7687,-3.4871,-3.3873}, /*cfy*/
          {-1.5683,0.0055,216.0982,0.71556,0.002002,0.5404}, /*cmz*/
          {-2.191364,-3.7196,-0.3817,-0.484} /*cfz*/
     },
     {
          2453279.4,
          {-1.3113,-0.00604,236.6997,0.26983,0.003277,0.6148}, /*cmx*/
          {-4.027109,-5.6018,-2.4633,-3.0297}, /*cfx*/
          {0.2412,-0.00297,93.3,0.09857,0.001247,0.2333}, /*cmy*/
          {-5.334131,-1.3893,-4.6211,-4.3909}, /*cfy*/
          {-1.0172,0.00692,220.8137,0.22926,0.002788,0.5788}, /*cmz*/
          {-2.502044,-3.9703,-0.8063,-1.5119} /*cfz*/
     },
     {
          2453379.4,
          {-1.7657,0.00232,236.6666,0.35846,0.003863,0.6208}, /*cmx*/
          {-4.082286,-2.519,-5.6568,-3.7802}, /*cfx*/
          {-0.2175,-0.00294,95.5508,0.1557,0.00155,0.2476}, /*cmy*/
          {-5.399933,-4.6364,-1.1787,-5.1136}, /*cfy*/
          {-0.0051,0.00803,219.8732,0.34073,0.003664,0.5705}, /*cmz*/
          {-2.558448,-0.8024,-4.0089,-2.204} /*cfz*/
     },
     {
          2453479.4,
          {-1.5108,0.00692,236.7919,0.52611,0.001473,0.5064}, /*cmx*/
          {-4.164723,-5.7127,-0.1834,-4.749}, /*cfx*/
          {-0.4479,-0.00268,99.3708,0.2189,0.000868,0.1829}, /*cmy*/
          {-5.497182,-1.0001,-2.5617,-5.9444}, /*cfy*/
          {0.6342,0.00825,217.5263,0.49837,0.00119,0.4501}, /*cmz*/
          {-2.640918,-4.102,-4.9485,-3.2231} /*cfz*/
     },
     {
          2453579.4,
          {-0.8875,0.00513,237.0227,0.73668,0.002747,0.5182}, /*cmx*/
          {-4.501669,-6.1291,-2.9011,-5.7143}, /*cfx*/
          {-0.6165,0.00018,88.8649,0.26333,0.000989,0.1692}, /*cmy*/
          {-5.791868,-1.8695,-4.7886,-0.5743}, /*cfy*/
          {1.1933,0.00571,222.7659,0.67078,0.002495,0.5039}, /*cmz*/
          {-2.974353,-4.471,-1.2031,-4.2455} /*cfz*/
     },
     {
          2453679.4,
          {-0.4308,0.01147,236.4887,0.04533,0.001942,0.542}, /*cmx*/
          {-4.773175,-5.9365,-3.0897,-0.0413}, /*cfx*/
          {-0.6058,0.00272,76.3526,0.02292,0.000998,0.2141}, /*cmy*/
          {-6.000647,-1.9263,-5.5918,-1.3025}, /*cfy*/
          {1.9183,-0.00663,227.5859,0.05099,0.00177,0.499}, /*cmz*/
          {-3.236591,-5.1432,-1.5903,-4.7641} /*cfz*/
     },
     {
          2453779.4,
          {0.8482,0.00801,236.6518,0.20438,0.003988,0.601}, /*cmx*/
          {-4.788199,-3.2322,-0.0942,-0.9668}, /*cfx*/
          {-0.4133,0.00283,83.518,0.12545,0.001539,0.2205}, /*cmy*/
          {-6.050021,-5.8561,-2.2433,-2.2452}, /*cfy*/
          {1.4679,-0.00629,224.616,0.17519,0.00358,0.5486}, /*cmz*/
          {-3.25688,-1.4783,-4.7457,-5.7015} /*cfz*/
     },
     {
          2453879.4,
          {1.6584,0.00066,236.8516,0.64368,0.000751,0.6305}, /*cmx*/
          {-4.937898,-0.2451,-1.8361,-1.9851}, /*cfx*/
          {-0.0703,0.00161,84.201,0.21981,0.000749,0.2028}, /*cmy*/
          {-6.203398,-2.1172,-3.8275,-3.3167}, /*cfy*/
          {0.6845,-0.00303,224.3075,0.5799,0.000844,0.5954}, /*cmz*/
          {-3.408703,-4.8762,-0.0053,-0.4492} /*cfz*/
     },
     {
          2453979.4,
          {1.8407,-0.00264,236.931,0.64351,0.003155,0.5982}, /*cmx*/
          {-5.279771,-0.613,-3.7202,-2.977}, /*cfx*/
          {0.0712,0.00266,67.76,0.23858,0.001211,0.1518}, /*cmy*/
          {-0.180744,-3.0039,-6.1369,-4.3356}, /*cfy*/
          {0.2386,-0.00713,230.2441,0.58383,0.002782,0.5936}, /*cmz*/
          {-3.740269,-5.264,-2.0856,-1.4418} /*cfz*/
     },
     {
          2454079.4,
          {1.3472,-0.00292,237.0865,0.18476,3e-05,0.5523}, /*cmx*/
          {-5.49701,-3.8658,-0.5554,-4.0098}, /*cfx*/
          {0.3662,0.00161,56.2019,0.08648,0.000306,0.102}, /*cmy*/
          {-0.31912,-0.3745,-0.167,-4.9953}, /*cfy*/
          {-0.4255,-0.0136,232.8668,0.12784,0.000379,0.5834}, /*cmz*/
          {-3.947168,-2.1984,-2.1151,-2.436} /*cfz*/
     },
     {
          2454179.4,
          {0.8922,-0.00993,236.4157,0.02444,0.00331,0.5263}, /*cmx*/
          {-5.494871,-5.7398,-0.9054,-4.5507}, /*cfx*/
          {0.5443,-0.00174,67.2831,0.08862,0.001424,0.1435}, /*cmy*/
          {-0.394062,-0.803,-3.2886,-5.6392}, /*cfy*/
          {-1.5967,0.00033,229.7442,0.00648,0.00321,0.481}, /*cmz*/
          {-3.955623,-3.3008,-5.5545,-3.0493} /*cfz*/
     },
     {
          2454279.4,
          {0.1191,-0.00973,236.5572,0.68039,0.00114,0.4946}, /*cmx*/
          {-5.703644,-0.9832,-3.345,-5.5482}, /*cfx*/
          {0.3541,-0.00158,62.5253,0.22479,0.00064,0.1357}, /*cmy*/
          {-0.574257,-3.2718,-5.3004,-0.1779}, /*cfy*/
          {-1.734,0.00226,231.5105,0.62703,0.000879,0.5017}, /*cmz*/
          {-4.160241,-5.6686,-1.6788,-4.0714} /*cfz*/
     },
     {
          2454379.4,
          {-0.6428,-0.00782,237.0337,0.50346,0.003267,0.5444}, /*cmx*/
          {-6.029715,-1.3432,-4.4736,-0.2523}, /*cfx*/
          {0.1075,-0.00082,42.8604,0.19671,0.001405,0.1067}, /*cmy*/
          {-0.726215,-4.0071,-0.8986,-1.0179}, /*cfy*/
          {-1.586,0.00457,235.6851,0.48259,0.003122,0.5719}, /*cmz*/
          {-4.473502,-6.0195,-2.8646,-4.9557} /*cfz*/
     },
     {
          2454479.4,
          {-1.7751,0.00257,237.6226,0.30037,0.001538,0.6408}, /*cmx*/
          {-6.182308,-4.4859,-1.2823,-0.8187}, /*cfx*/
          {0.14,-0.00407,36.5432,0.16793,0.000473,0.1518}, /*cmy*/
          {-0.794963,-1.04,-3.9114,-2.1911}, /*cfy*/
          {-1.1025,0.01017,236.3133,0.27111,0.001375,0.6034}, /*cmz*/
          {-4.623516,-3.0039,-6.2668,-5.5629} /*cfz*/
     },
     {
          2454579.4,
          {-1.5771,-0.00058,236.5866,0.20209,0.002477,0.614}, /*cmx*/
          {-6.194158,-1.3129,-1.7677,-1.9498}, /*cfx*/
          {-0.2624,-6e-05,48.2054,0.05497,0.001122,0.0929}, /*cmy*/
          {-0.949844,-2.5696,-4.4249,-3.1234}, /*cfy*/
          {0.104,0.00909,234.5112,0.18772,0.002372,0.6095}, /*cmz*/
          {-4.641884,-6.1457,-0.0433,-0.3961} /*cfz*/
     },
     {
          2454679.4,
          {-1.4102,0.00241,237.1674,0.67268,0.001411,0.6049}, /*cmx*/
          {-0.164434,-1.753,-4.5026,-2.951}, /*cfx*/
          {-0.3339,0.00279,37.799,0.22341,0.000593,0.039}, /*cmy*/
          {-1.068602,-4.3904,-0.4159,-3.7524}, /*cfy*/
          {1.0113,0.00364,236.6384,0.65773,0.00145,0.6151}, /*cmz*/
          {-4.888315,-0.1723,-3.0004,-1.3931} /*cfz*/
     },
     {
          2454779.4,
          {-1.1319,0.01098,237.4516,0.3479,0.003066,0.5508}, /*cmx*/
          {-0.464874,-2.0759,-5.2238,-3.8307}, /*cfx*/
          {-0.1093,0.00042,21.8712,0.13815,0.001458,0.0491}, /*cmy*/
          {-0.80498,-4.9642,-1.8577,-3.7889}, /*cfy*/
          {1.3988,0.00388,238.2277,0.32902,0.002877,0.553}, /*cmz*/
          {-5.18031,-0.4887,-3.6264,-2.2172} /*cfz*/
     },
     {
          2454879.4,
          {-0.1941,0.01413,237.4356,0.31177,0.002637,0.5082}, /*cmx*/
          {-0.559913,-5.2135,-2.0618,-4.6049}, /*cfx*/
          {0.0184,-0.00131,21.4777,0.18666,0.00091,0.0719}, /*cmy*/
          {-0.906327,-1.8338,-4.8561,-4.4673}, /*cfy*/
          {1.6203,-0.00107,238.2983,0.31653,0.00277,0.5085}, /*cmz*/
          {-5.276408,-3.6418,-0.52,-2.9916} /*cfz*/
     },
     {
          2454979.4,
          {1.1826,0.00177,236.9495,0.34498,0.001866,0.5323}, /*cmx*/
          {-0.613657,-2.106,-2.6147,-5.286}, /*cfx*/
          {-0.0763,0.00278,27.7295,0.06715,0.000959,0.0865}, /*cmy*/
          {-1.274008,-4.4088,-5.566,-5.9604}, /*cfy*/
          {1.5168,-0.00716,237.3838,0.36088,0.001577,0.542}, /*cmz*/
          {-5.330649,-0.5489,-1.059,-3.7565} /*cfz*/
     },
     {
          2455079.4,
          {1.5358,0.0013,237.7143,0.65787,0.001914,0.5326}, /*cmx*/
          {-0.898902,-2.509,-5.4907,-0.0793}, /*cfx*/
          {0.1453,0.0003,19.1448,0.22385,0.000645,0.057}, /*cmy*/
          {-0.901895,-5.5118,-2.0731,-0.1899}, /*cfy*/
          {0.9767,-0.00981,238.1676,0.65081,0.002009,0.5509}, /*cmz*/
          {-5.610549,-0.9223,-3.846,-4.7598} /*cfz*/
     },
     {
          2455179.4,
          {1.7709,-0.00107,237.5122,0.17039,0.002404,0.6478}, /*cmx*/
          {-1.168975,-2.6708,-5.8302,-1.0077}, /*cfx*/
          {0.12,-0.00119,25.194,0.05534,0.001231,0.0449}, /*cmy*/
          {-0.27862,-5.7357,-2.6324,-6.0177}, /*cfy*/
          {-0.0251,-0.00735,237.5154,0.15121,0.00215,0.6403}, /*cmz*/
          {-5.876488,-1.2543,-4.3926,-5.7035} /*cfz*/
     },
     {
          2455279.4,
          {1.5033,-0.00862,237.4726,0.24058,0.003266,0.6056}, /*cmx*/
          {-1.218015,-5.9523,-2.8074,-1.7546}, /*cfx*/
          {0.0701,-0.00086,21.1744,0.17312,0.001242,0.0304}, /*cmy*/
          {-0.554099,-2.6411,-5.8274,-1.3175}, /*cfy*/
          {-1.0546,-0.00583,237.9118,0.23191,0.003192,0.5884}, /*cmz*/
          {-5.926901,-4.3778,-1.2292,-0.1921} /*cfz*/
     },
     {
          2455379.4,
          {0.5994,-0.00767,237.5605,0.48949,0.000963,0.5501}, /*cmx*/
          {-1.323806,-2.8879,-3.6423,-2.8388}, /*cfx*/
          {-0.0179,-0.0015,19.7418,0.11156,0.000632,0.0818}, /*cmy*/
          {-0.864724,-5.9597,-0.3513,-1.6458}, /*cfy*/
          {-1.4618,-0.00431,237.7894,0.48796,0.001109,0.556}, /*cmz*/
          {-6.033563,-1.2847,-2.3693,-1.2833} /*cfz*/
     },
     {
          2455479.4,
          {-0.1927,-0.00582,238.0264,0.63218,0.002663,0.5594}, /*cmx*/
          {-1.628405,-3.2477,-0.0615,-3.8066}, /*cfx*/
          {-0.1719,-0.0019,31.7888,0.22595,0.001014,0.1188}, /*cmy*/
          {-0.515106,-0.2568,-3.3111,-2.4946}, /*cfy*/
          {-1.6876,0.00066,236.7445,0.60866,0.002493,0.5565}, /*cmz*/
          {-0.051125,-1.7186,-4.7786,-2.2194} /*cfz*/
     },
     {
          2451179.3,
          {0.0688,-0.00133,294.6166,0.11744,0.002624,0.0941}, /*cmx*/
          {-5.203124,-0.2472,-0.6718,-0.6399}, /*cfx*/
          {0.0204,-0.00057,77.7443,0.07119,0.001029,0.0406}, /*cmy*/
          {-0.586855,-0.2237,-1.2001,-1.0512}, /*cfy*/
          {0.1028,-1e-05,284.5509,0.11576,0.002569,0.1307}, /*cmz*/
          {-3.626241,-5.25,-5.4411,-5.4587} /*cfz*/
     },
     {
          2451284.3,
          {-0.0702,0.00104,295.1929,0.63822,0.002269,0.0761}, /*cmx*/
          {-1.468965,-3.0697,-6.1182,-3.7123}, /*cfx*/
          {0.0049,0.00035,93.4102,0.2452,0.000899,0.0375}, /*cmy*/
          {-3.043599,-3.5211,-0.3189,-4.7998}, /*cfy*/
          {-0.0867,5e-05,280.0074,0.63361,0.002188,0.1053}, /*cmz*/
          {-6.181867,-1.6343,-4.7142,-2.293} /*cfz*/
     },
     {
          2451389.3,
          {-0.0928,0.0,294.6342,0.02149,0.003112,0.1372}, /*cmx*/
          {-4.030374,-4.5682,-2.3696,-2.8056}, /*cfx*/
          {-0.0259,0.00044,107.5391,0.03273,0.001119,0.0429}, /*cmy*/
          {-5.534982,-4.4597,-3.0528,-3.6654}, /*cfy*/
          {-0.0032,-0.00138,274.8444,0.03934,0.003277,0.1079}, /*cmz*/
          {-2.469391,-3.9161,-0.9145,-1.59} /*cfz*/
     },
     {
          2451494.3,
          {0.0548,-0.00071,295.1255,0.5674,0.004537,0.0347}, /*cmx*/
          {-0.058626,-4.7349,-1.5933,-5.0727}, /*cfx*/
          {0.029,-0.00033,100.3656,0.20695,0.001717,0.0126}, /*cmy*/
          {-1.569892,-5.4505,-2.2918,-5.0058}, /*cfy*/
          {-0.0475,0.00065,277.5958,0.56494,0.004513,0.0156}, /*cmz*/
          {-4.779242,-3.2593,-0.1206,-4.1625} /*cfz*/
     },
     {
          2451599.3,
          {-0.0137,0.00114,294.7145,0.47349,0.000856,0.1004}, /*cmx*/
          {-2.441233,-3.9856,-4.7723,-4.6365}, /*cfx*/
          {0.0319,0.00016,98.2539,0.18812,0.000436,0.0504}, /*cmy*/
          {-3.964564,-4.6758,-5.8931,-5.2298}, /*cfy*/
          {-0.1299,0.0009,278.3145,0.47882,0.000662,0.1103}, /*cmz*/
          {-0.876393,-2.5506,-3.3879,-2.8264} /*cfz*/
     },
     {
          2451704.3,
          {0.0099,-0.00062,294.9055,0.57736,0.003775,0.0565}, /*cmx*/
          {-5.046596,-0.368,-3.5039,-1.0515}, /*cfx*/
          {-0.0327,0.00017,112.6574,0.21804,0.001391,0.0304}, /*cmy*/
          {-0.250801,-1.324,-4.488,-2.2486}, /*cfy*/
          {0.0772,-0.00046,273.0903,0.5589,0.003685,0.0659}, /*cmz*/
          {-3.490584,-5.1925,-2.0446,-5.5729} /*cfz*/
     },
     {
          2451809.3,
          {0.2352,-0.00169,294.6121,0.50033,0.000455,0.2314}, /*cmx*/
          {-1.25176,-5.9563,-3.4201,-6.0684}, /*cfx*/
          {0.0244,-0.00078,117.2605,0.16747,0.000168,0.0724}, /*cmy*/
          {-2.728707,-0.6966,-4.2826,-0.9803}, /*cfy*/
          {0.0784,0.00161,271.4467,0.44674,0.000337,0.2278}, /*cmz*/
          {-5.979741,-4.4438,-2.8711,-4.87} /*cfz*/
     },
     {
          2451914.3,
          {0.0514,0.0006,294.7886,0.14764,0.003961,0.1066}, /*cmx*/
          {-3.509736,-2.0035,-5.1241,-5.29}, /*cfx*/
          {0.0388,-0.00011,110.512,0.02824,0.001423,0.0443}, /*cmy*/
          {-5.025826,-3.6965,-6.1324,-5.8021}, /*cfy*/
          {-0.0681,0.00111,273.3399,0.14191,0.003821,0.0773}, /*cmz*/
          {-1.946771,-0.5332,-3.6773,-3.6527} /*cfz*/
     },
     {
          2452019.3,
          {-0.0761,-0.00041,294.9637,0.67243,0.001346,0.1215}, /*cmx*/
          {-6.018588,-1.336,-4.2109,-1.9959}, /*cfx*/
          {-0.0507,0.00048,118.5138,0.28238,0.000712,0.0449}, /*cmy*/
          {-1.24987,-2.3319,-5.1066,-2.9731}, /*cfy*/
          {0.0854,-0.00112,270.4911,0.6552,0.001387,0.086}, /*cmz*/
          {-4.457408,-6.144,-2.7341,-0.2819} /*cfz*/
     },
     {
          2452124.3,
          {0.0082,-0.0007,294.7242,0.31596,0.004448,0.0241}, /*cmx*/
          {-2.342732,-3.9122,-0.766,-1.209}, /*cfx*/
          {-0.001,-0.00026,128.3261,0.11504,0.001643,0.0228}, /*cmy*/
          {-3.83043,-5.0253,-2.0684,-2.4018}, /*cfy*/
          {-0.0018,0.00042,265.799,0.2987,0.004139,0.0409}, /*cmz*/
          {-0.791368,-2.41,-5.5237,-5.9521} /*cfz*/
     },
     {
          2452229.3,
          {-0.1745,0.00181,294.9871,0.73842,0.00418,0.1199}, /*cmx*/
          {-4.715044,-3.0886,-6.2301,-3.2622}, /*cfx*/
          {0.0142,0.0002,129.8186,0.26205,0.001502,0.0526}, /*cmy*/
          {-6.202949,-4.4424,-1.1742,-4.6968}, /*cfy*/
          {-0.1208,0.00023,265.6979,0.67327,0.003791,0.1572}, /*cmz*/
          {-3.161974,-1.5604,-4.7473,-1.9239} /*cfz*/
     },
     {
          2452334.3,
          {-0.1443,0.00049,294.8393,0.33354,0.001904,0.1462}, /*cmx*/
          {-0.74305,-2.2833,-2.6239,-2.5274}, /*cfx*/
          {-0.0455,0.00069,130.173,0.1503,0.000789,0.0445}, /*cmy*/
          {-2.250307,-3.1522,-4.2717,-3.6907}, /*cfy*/
          {0.0287,-0.00129,264.4745,0.3131,0.001915,0.1076}, /*cmz*/
          {-5.470043,-0.7957,-1.0896,-1.2828} /*cfz*/
     },
     {
          2452439.3,
          {0.0993,-0.00035,294.8812,0.70692,0.003185,0.1029}, /*cmx*/
          {-3.344071,-4.9781,-1.805,-5.5923}, /*cfx*/
          {0.0084,-0.00046,137.6099,0.25201,0.001319,0.0343}, /*cmy*/
          {-4.810078,-0.0174,-3.0617,-1.3284}, /*cfy*/
          {-0.0335,0.00093,261.6233,0.67703,0.002952,0.0674}, /*cmz*/
          {-1.800879,-3.4214,-0.2521,-4.1171} /*cfz*/
     },
     {
          2452544.3,
          {0.034,0.00199,294.2328,0.17632,0.002493,0.1945}, /*cmx*/
          {-5.897807,-4.3775,-4.1603,-4.8674}, /*cfx*/
          {0.0693,-0.00038,137.7141,0.11408,0.000761,0.0799}, /*cmy*/
          {-1.035257,-5.8278,-5.7108,-6.1114}, /*cfy*/
          {-0.1635,0.00093,261.591,0.17767,0.002072,0.1908}, /*cmz*/
          {-4.369607,-2.885,-2.5783,-2.986} /*cfz*/
     },
     {
          2452649.3,
          {-0.0349,0.00033,294.0942,0.44075,0.004979,0.0461}, /*cmx*/
          {-1.883946,-0.3146,-3.4605,-3.3498}, /*cfx*/
          {-0.0093,0.00045,139.4899,0.18867,0.001932,0.0184}, /*cmy*/
          {-3.31203,-1.8555,-4.9216,-4.99}, /*cfy*/
          {0.0066,-0.00083,260.9051,0.4014,0.004626,0.0463}, /*cmz*/
          {-0.353772,-5.0109,-1.8872,-2.3215} /*cfz*/
     },
     {
          2452754.3,
          {0.1203,-0.00123,294.0766,0.64742,0.000729,0.1044}, /*cmx*/
          {-4.325562,-5.9162,-1.75,-6.19}, /*cfx*/
          {-0.0181,-0.00036,140.7549,0.22975,0.000634,0.0501}, /*cmy*/
          {-5.737453,-1.0823,-3.0493,-1.8114}, /*cfy*/
          {0.0469,0.00066,260.3611,0.59315,0.000407,0.1084}, /*cmz*/
          {-2.801369,-4.3525,-0.2316,-4.9534} /*cfz*/
     },
     {
          2452859.3,
          {-0.0707,0.00069,293.3364,0.54453,0.004539,0.0411}, /*cmx*/
          {-0.675087,-2.2968,-5.4345,-2.7845}, /*cfx*/
          {0.0276,-0.00014,134.9738,0.19549,0.001655,0.0293}, /*cmy*/
          {-2.025896,-4.263,-0.8707,-5.2742}, /*cfy*/
          {-0.0019,-0.00012,264.4008,0.50156,0.004143,0.0394}, /*cmz*/
          {-5.442892,-0.6255,-3.813,-1.342} /*cfz*/
     },
     {
          2452964.3,
          {-0.153,-0.00076,293.3705,0.64855,0.002005,0.2627}, /*cmx*/
          {-3.123357,-1.519,-4.7846,-1.8694}, /*cfx*/
          {-0.0816,0.00091,129.4764,0.26842,0.000898,0.0804}, /*cmy*/
          {-4.447031,-3.0896,-6.2536,-3.3761}, /*cfy*/
          {0.2267,-0.0022,267.5856,0.62566,0.002073,0.2007}, /*cmz*/
          {-1.611132,-6.209,-3.1134,-0.0351} /*cfz*/
     },
     {
          2453069.3,
          {0.0602,-0.00149,292.7266,0.08823,0.003301,0.1079}, /*cmx*/
          {-5.386182,-0.2803,-0.8507,-0.8779}, /*cfx*/
          {-0.0514,-2e-05,133.961,0.03872,0.001274,0.0665}, /*cmy*/
          {-0.450327,-2.0368,-2.6494,-2.2978}, /*cfy*/
          {0.1123,-0.0001,264.8145,0.07593,0.002887,0.1347}, /*cmz*/
          {-3.871727,-5.2185,-5.4592,-5.5329} /*cfz*/
     },
     {
          2453174.3,
          {-0.0585,0.00122,293.1276,0.74133,0.002259,0.0851}, /*cmx*/
          {-1.66565,-3.2678,-6.264,-4.032}, /*cfx*/
          {0.0533,-0.00037,126.8764,0.29906,0.000949,0.0503}, /*cmy*/
          {-2.986678,-5.1812,-1.5641,-5.9232}, /*cfy*/
          {-0.0856,3e-05,268.8479,0.65954,0.002005,0.1063}, /*cmz*/
          {-0.149492,-1.6478,-4.7432,-2.3096} /*cfz*/
     },
     {
          2453279.3,
          {-0.0729,0.0002,292.7533,0.12404,0.003888,0.1164}, /*cmx*/
          {-4.265371,-5.7019,-2.6405,-3.0311}, /*cfx*/
          {0.0076,0.00048,111.3531,0.09805,0.001592,0.0419}, /*cmy*/
          {-5.54187,-1.9708,-4.7407,-5.326}, /*cfy*/
          {-0.0026,-0.00126,275.3169,0.12051,0.003682,0.0917}, /*cmz*/
          {-2.739273,-3.9088,-0.9751,-1.7407} /*cfz*/
     },
     {
          2453384.3,
          {0.0946,-0.00093,293.438,0.65316,0.004827,0.0629}, /*cmx*/
          {-0.304457,-4.9792,-1.8361,-5.1326}, /*cfx*/
          {0.0104,-0.00025,114.1046,0.23612,0.001846,0.0214}, /*cmy*/
          {-1.609718,-0.6047,-3.6904,-1.3437}, /*cfy*/
          {-0.0596,0.00077,274.1971,0.6102,0.004455,0.031}, /*cmz*/
          {-5.061734,-3.3406,-0.2008,-3.6817} /*cfz*/
     },
     {
          2453489.3,
          {0.0172,0.00103,293.1667,0.47008,0.001119,0.1162}, /*cmx*/
          {-2.667513,-4.2051,-4.846,-4.8199}, /*cfx*/
          {0.0586,-0.00062,117.6696,0.20836,0.000692,0.0457}, /*cmy*/
          {-3.997846,-6.0254,-1.1079,-0.0056}, /*cfy*/
          {-0.1262,0.00089,272.2827,0.43487,0.000862,0.1069}, /*cmz*/
          {-1.139415,-2.6062,-3.1598,-2.8267} /*cfz*/
     },
     {
          2453594.3,
          {-0.0091,-0.00056,293.6509,0.6313,0.003696,0.0698}, /*cmx*/
          {-5.283762,-0.6038,-3.7366,-1.382}, /*cfx*/
          {-0.0264,0.00052,102.8737,0.2731,0.00147,0.0333}, /*cmy*/
          {-0.303878,-2.8419,-5.8497,-3.9082}, /*cfy*/
          {0.084,-0.00052,278.3345,0.57953,0.003453,0.0746}, /*cmz*/
          {-3.748079,-5.2396,-2.1138,-5.6769} /*cfz*/
     },
     {
          2453699.3,
          {0.2054,-0.00202,293.6458,0.43069,0.000384,0.2154}, /*cmx*/
          {-1.511376,-6.2019,-5.606,-0.0688}, /*cfx*/
          {-0.0883,7e-05,91.186,0.14001,0.000337,0.1022}, /*cmy*/
          {-2.784651,-2.1297,-1.7548,-2.4574}, /*cfy*/
          {0.093,0.00142,282.152,0.37,0.000683,0.2233}, /*cmz*/
          {-6.250587,-4.5947,-3.8295,-4.9649} /*cfz*/
     },
     {
          2453804.3,
          {0.0597,0.00037,293.6479,0.21442,0.00409,0.1005}, /*cmx*/
          {-3.768754,-2.2173,-5.3641,-5.4827}, /*cfx*/
          {0.0176,-0.00051,104.9303,0.10153,0.001648,0.0303}, /*cmy*/
          {-5.088489,-4.6221,-1.3195,-1.0489}, /*cfy*/
          {-0.052,0.00094,276.8354,0.19596,0.003818,0.0655}, /*cmz*/
          {-2.231885,-0.5826,-3.7275,-3.7551} /*cfz*/
     },
     {
          2453909.3,
          {-0.0909,-0.00013,293.7238,0.63964,0.001125,0.1208}, /*cmx*/
          {-6.25925,-1.5775,-4.4115,-2.1545}, /*cfx*/
          {0.0002,0.00049,100.3349,0.24469,0.000695,0.0421}, /*cmy*/
          {-1.276186,-3.8093,-5.9173,-4.7238}, /*cfy*/
          {0.0791,-0.00112,278.9754,0.60655,0.001112,0.0831}, /*cmz*/
          {-4.720611,-6.1848,-2.7289,-0.3387} /*cfz*/
     },
     {
          2454014.3,
          {0.0125,-0.00061,293.4719,0.34634,0.004216,0.011}, /*cmx*/
          {-2.58088,-4.1571,-1.0088,-1.415}, /*cfx*/
          {-0.0109,0.00011,79.5346,0.18338,0.001749,0.0121}, /*cmy*/
          {-3.782651,-0.6407,-3.5307,-1.9956}, /*cfy*/
          {-0.012,0.00035,285.6128,0.31979,0.003902,0.0275}, /*cmz*/
          {-1.036282,-2.4533,-5.6369,-5.9439} /*cfz*/
     },
     {
          2454119.3,
          {-0.1411,0.00175,293.6367,0.6824,0.003433,0.1247}, /*cmx*/
          {-4.972053,-3.3333,-0.1954,-3.6225}, /*cfx*/
          {0.0852,-0.00061,78.4045,0.26547,0.001308,0.0674}, /*cmy*/
          {-6.143452,-5.6769,-2.6323,-5.8205}, /*cfy*/
          {-0.1313,0.00023,286.4453,0.61205,0.003086,0.1578}, /*cmz*/
          {-3.426144,-1.7094,-4.8817,-1.9963} /*cfz*/
     },
     {
          2454224.3,
          {-0.1372,0.00071,293.0776,0.2456,0.001946,0.1271}, /*cmx*/
          {-0.992281,-2.5262,-2.789,-2.7283}, /*cfx*/
          {0.0247,0.00026,90.0322,0.0834,0.001056,0.0542}, /*cmy*/
          {-2.195723,-4.9718,-5.4652,-5.1003}, /*cfy*/
          {0.0184,-0.00113,282.5554,0.22221,0.001924,0.0982}, /*cmz*/
          {-5.738712,-0.7825,-1.1482,-1.3434} /*cfz*/
     },
     {
          2454329.3,
          {0.0903,-0.00046,293.2128,0.63621,0.002715,0.0882}, /*cmx*/
          {-3.565726,-5.1852,-2.0132,-5.7089}, /*cfx*/
          {-0.0515,0.0001,70.8705,0.30465,0.000921,0.0578}, /*cmy*/
          {-4.636663,-1.6451,-4.4772,-2.4185}, /*cfy*/
          {-0.0204,0.00087,288.5728,0.58772,0.002513,0.0644}, /*cmz*/
          {-2.019748,-3.4999,-0.3219,-4.3677} /*cfz*/
     },
     {
          2454434.3,
          {0.0504,0.00143,293.0448,0.10972,0.002459,0.1635}, /*cmx*/
          {-6.111456,-4.676,-4.3813,-5.0874}, /*cfx*/
          {-0.0062,-0.00069,49.526,0.05046,0.001236,0.0621}, /*cmy*/
          {-0.645005,-4.715,-0.9158,-1.5847}, /*cfy*/
          {-0.1269,0.00102,292.6393,0.13935,0.002063,0.1449}, /*cmz*/
          {-4.556338,-3.0809,-2.7787,-3.1656} /*cfz*/
     },
     {
          2454539.3,
          {-0.0215,0.00026,292.8529,0.4391,0.004281,0.0177}, /*cmx*/
          {-2.121434,-0.5274,-3.6681,-3.5862}, /*cfx*/
          {-0.0065,0.00021,58.7014,0.15214,0.001754,0.0107}, /*cmy*/
          {-3.049431,-3.0384,-6.2809,-5.7349}, /*cfy*/
          {0.0179,-0.00067,291.3335,0.41123,0.00396,0.0217}, /*cmz*/
          {-0.570081,-5.1889,-2.0339,-2.7167} /*cfz*/
     },
     {
          2454644.3,
          {0.0921,-0.00112,292.9381,0.51093,0.00046,0.0868}, /*cmx*/
          {-4.538592,-6.0985,-1.5751,-0.0474}, /*cfx*/
          {-0.0526,0.00039,55.9085,0.24747,0.000465,0.0449}, /*cmy*/
          {-5.434869,-2.533,-3.7411,-2.814}, /*cfy*/
          {0.0496,0.00054,291.7044,0.45722,0.000473,0.1004}, /*cmz*/
          {-2.986538,-4.4666,-5.971,-5.011} /*cfz*/
     },
     {
          2454749.3,
          {-0.065,0.00061,293.605,0.46817,0.003824,0.038}, /*cmx*/
          {-0.850196,-2.44,-5.5874,-2.9665}, /*cfx*/
          {0.0386,-0.00034,32.288,0.29142,0.001702,0.0263}, /*cmy*/
          {-1.22988,-5.3276,-2.2457,-5.9146}, /*cfy*/
          {-0.0235,2e-05,294.8026,0.43301,0.003587,0.0485}, /*cmz*/
          {-5.566638,-0.8628,-4.0086,-1.722} /*cfz*/
     },
     {
          2454854.3,
          {-0.1591,-0.00032,294.0904,0.53159,0.001345,0.2223}, /*cmx*/
          {-3.296708,-1.7062,-5.0307,-2.0227}, /*cfx*/
          {0.0449,0.00039,25.7855,0.16182,0.000349,0.0915}, /*cmy*/
          {-3.277357,-4.7123,-1.9081,-4.9261}, /*cfy*/
          {0.1625,-0.00189,295.2017,0.53931,0.001445,0.1654}, /*cmz*/
          {-1.727792,-0.1019,-3.3045,-0.294} /*cfz*/
     },
     {
          2454959.3,
          {0.0234,-0.00108,293.4742,0.02632,0.002953,0.0853}, /*cmx*/
          {-5.576513,-5.0697,-0.9599,-1.1056}, /*cfx*/
          {-0.0314,0.00044,31.3737,0.03315,0.001309,0.0323}, /*cmy*/
          {-6.111578,-2.5913,-3.8868,-3.5154}, /*cfy*/
          {0.0907,-0.00012,294.5137,0.01522,0.00275,0.1078}, /*cmz*/
          {-4.010947,-3.3072,-5.6489,-5.6173} /*cfz*/
     },
     {
          2455064.3,
          {-0.0501,0.00108,294.2312,0.59386,0.001726,0.0758}, /*cmx*/
          {-1.81115,-3.3903,-0.108,-4.1205}, /*cfx*/
          {0.0254,-0.00058,22.0512,0.29101,0.000675,0.0377}, /*cmy*/
          {-1.797928,-0.013,-2.858,-0.8952}, /*cfy*/
          {-0.0931,0.00023,295.2271,0.56973,0.001652,0.1059}, /*cmz*/
          {-0.241011,-1.8601,-4.867,-2.4719} /*cfz*/
     },
     {
          2455169.3,
          {-0.063,0.00031,294.4577,0.10215,0.003299,0.0923}, /*cmx*/
          {-4.376755,-5.8364,-2.7571,-3.1268}, /*cfx*/
          {0.0202,-0.00014,30.0372,0.10461,0.001578,0.0346}, /*cmy*/
          {-3.33691,-2.4333,-5.8221,-0.102}, /*cfy*/
          {-0.0099,-0.00108,293.8195,0.11329,0.003353,0.0884}, /*cmz*/
          {-2.800766,-4.3502,-1.2142,-1.9713} /*cfz*/
     },
     {
          2455274.3,
          {0.0881,-0.00072,294.7668,0.56754,0.00379,0.0631}, /*cmx*/
          {-0.429953,-5.1037,-1.9665,-5.213}, /*cfx*/
          {-0.0369,0.0002,23.6621,0.22495,0.00152,0.0368}, /*cmy*/
          {-5.825031,-1.9003,-5.0478,-1.9424}, /*cfy*/
          {-0.0421,0.00065,294.6668,0.56159,0.003738,0.0393}, /*cmz*/
          {-5.13989,-3.541,-0.3975,-3.881} /*cfz*/
     },
     {
          2455379.3,
          {0.0218,0.00082,294.3143,0.33052,0.001175,0.0974}, /*cmx*/
          {-2.78593,-4.3163,-4.7112,-4.8854}, /*cfx*/
          {-0.0002,-0.00045,19.4522,0.14274,0.000698,0.041}, /*cmy*/
          {-2.225185,-1.0451,-1.7295,-1.5654}, /*cfy*/
          {-0.1087,0.0009,294.8295,0.33808,0.001073,0.0929}, /*cmz*/
          {-1.212592,-2.7696,-3.3083,-2.9537} /*cfz*/
     },
     {
          2455484.3,
          {-0.0083,-0.00052,294.7434,0.53857,0.003199,0.0668}, /*cmx*/
          {-5.358558,-0.6705,-3.8042,-1.3874}, /*cfx*/
          {0.0163,0.00016,35.8209,0.26299,0.001269,0.0381}, /*cmy*/
          {-4.148886,-3.9152,-0.7714,-4.8887}, /*cfy*/
          {0.0888,-0.00071,293.3876,0.53604,0.003235,0.0706}, /*cmz*/
          {-3.782969,-5.4703,-2.3061,-5.9015} /*cfz*/
     },
     {
          2451179.4,
          {1.1717,-0.0012,377.4234,0.30988,0.003678,0.4316}, /*cmx*/
          {1.377894,6.1754,5.876,-2.7167}, /*cfx*/
          {0.1103,-2e-05,93.0308,0.09755,0.001381,0.1316}, /*cmy*/
          {5.97411,5.5822,5.3373,-3.9882}, /*cfy*/
          {-0.472,-1e-05,365.5789,0.31121,0.00371,0.3182}, /*cmz*/
          {2.957099,1.4707,1.0012,-0.5425} /*cfz*/
     },
     {
          2451279.4,
          {1.0694,0.00126,378.1275,1.02431,0.002396,0.3275}, /*cmx*/
          {4.610331,3.0014,0.1073,-2.3159}, /*cfx*/
          {0.1312,0.00054,113.0956,0.37779,0.001121,0.1639}, /*cmy*/
          {2.994071,2.3761,5.9623,-4.3218}, /*cfy*/
          {-0.5087,0.00103,360.3526,1.00586,0.002346,0.4774}, /*cmz*/
          {6.186143,4.4933,1.645,-1.0106} /*cfz*/
     },
     {
          2451379.4,
          {1.125,-0.00029,377.5825,0.45114,0.004958,0.4267}, /*cmx*/
          {1.523014,6.2286,3.0884,-2.018}, /*cfx*/
          {0.1638,0.0007,134.4061,0.1414,0.001766,0.1356}, /*cmy*/
          {6.251956,5.3204,2.344,-3.8715}, /*cfy*/
          {-0.4133,-0.00154,353.101,0.4398,0.004903,0.4077}, /*cmz*/
          {3.091012,1.4156,4.5314,-0.7863} /*cfz*/
     },
     {
          2451479.4,
          {1.1028,-0.00263,377.7669,0.59256,0.004887,0.3701}, /*cmx*/
          {4.935366,0.2512,3.3894,-1.9283}, /*cfx*/
          {0.2499,9e-05,130.597,0.23691,0.001895,0.1634}, /*cmy*/
          {3.37653,5.9626,2.7003,-3.2044}, /*cfy*/
          {-0.6292,-0.00139,354.6969,0.61176,0.004966,0.4418}, /*cmz*/
          {0.219146,1.7236,4.8839,-6.0747} /*cfz*/
     },
     {
          2451579.4,
          {0.933,-0.00065,377.2829,0.57995,0.002706,0.2699}, /*cmx*/
          {2.084773,0.5695,0.0762,-1.5637}, /*cfx*/
          {0.3044,2e-05,125.1317,0.21658,0.001015,0.1732}, /*cmy*/
          {0.504704,6.0776,5.3688,-3.2104}, /*cfy*/
          {-0.8246,0.00117,356.1633,0.58713,0.00248,0.4781}, /*cmz*/
          {3.658592,2.0449,1.4881,-5.9907} /*cfz*/
     },
     {
          2451679.4,
          {0.8592,0.00123,377.9509,1.05021,0.003419,0.4614}, /*cmx*/
          {5.275653,3.6607,0.6407,-1.2756}, /*cfx*/
          {0.3194,0.00059,144.6989,0.39318,0.001453,0.1272}, /*cmy*/
          {3.74706,2.7019,6.0958,-3.1821}, /*cfy*/
          {-0.7432,0.00017,349.2507,1.0354,0.003478,0.3244}, /*cmz*/
          {0.557937,5.1471,2.1225,-0.1826} /*cfz*/
     },
     {
          2451779.4,
          {0.8589,-0.00049,377.5321,0.16985,0.004094,0.5759}, /*cmx*/
          {2.209297,0.6429,3.8004,-1.1835}, /*cfx*/
          {0.3339,0.00114,156.2156,0.04138,0.001301,0.1269}, /*cmy*/
          {0.715621,5.5672,2.8158,-2.4367}, /*cfy*/
          {-0.6854,-0.00264,343.932,0.13487,0.003695,0.2307}, /*cmz*/
          {3.761936,2.2203,5.2769,-6.0623} /*cfz*/
     },
     {
          2451879.4,
          {0.7081,-0.00167,377.6169,0.48661,0.006041,0.3803}, /*cmx*/
          {5.671032,0.9687,4.1064,-0.6755}, /*cfx*/
          {0.4079,0.00044,150.6444,0.17109,0.002243,0.1788}, /*cmy*/
          {4.164501,0.1054,3.1557,-2.1908}, /*cfy*/
          {-0.9201,-0.00086,346.3594,0.48457,0.005892,0.4287}, /*cmz*/
          {0.946189,2.433,5.5804,-5.3549} /*cfz*/
     },
     {
          2451979.4,
          {0.5936,0.00031,377.0751,0.82576,0.001788,0.3806}, /*cmx*/
          {2.765375,1.2259,0.281,-0.0752}, /*cfx*/
          {0.4787,-0.00013,151.9477,0.31883,0.000854,0.1543}, /*cmy*/
          {1.253107,0.1986,5.2127,-2.2287}, /*cfy*/
          {-1.0396,0.00169,346.1183,0.79955,0.00138,0.4428}, /*cmz*/
          {4.32494,2.6769,1.8071,-5.3574} /*cfz*/
     },
     {
          2452079.4,
          {0.6014,0.00053,377.3228,1.03596,0.004618,0.4652}, /*cmx*/
          {5.926356,4.3114,1.226,-0.5512}, /*cfx*/
          {0.47,0.0005,165.3086,0.39278,0.00183,0.1401}, /*cmy*/
          {4.456064,3.0466,0.0207,-1.6618}, /*cfy*/
          {-0.8917,-0.00067,340.7428,0.99121,0.004506,0.2752}, /*cmz*/
          {1.19121,5.8117,2.7005,-4.9926} /*cfz*/
     },
     {
          2452179.4,
          {0.5603,-0.00251,377.6121,0.19936,0.001801,0.4582}, /*cmx*/
          {2.892305,4.581,4.4153,-0.7642}, /*cfx*/
          {0.4459,0.00137,168.0622,0.07282,0.000575,0.2283}, /*cmy*/
          {1.449134,3.2275,3.3647,-1.2748}, /*cfy*/
          {-0.808,-0.00393,338.4087,0.19219,0.001648,0.4002}, /*cmz*/
          {4.432978,5.8388,6.2193,-4.3732} /*cfz*/
     },
     {
          2452279.4,
          {0.3061,-0.00162,376.8957,0.22826,0.006002,0.3449}, /*cmx*/
          {0.108306,1.5624,4.7512,-6.0122}, /*cfx*/
          {0.5137,0.00034,165.1961,0.07302,0.002301,0.2167}, /*cmy*/
          {4.925575,0.2189,3.5168,-1.23}, /*cfy*/
          {-1.0234,-0.00089,339.8845,0.23189,0.005767,0.4385}, /*cmz*/
          {1.65356,3.1288,6.2782,-4.4035} /*cfz*/
     },
     {
          2452379.4,
          {0.2181,0.00124,376.9965,1.02122,0.001423,0.54}, /*cmx*/
          {3.420516,1.848,0.0133,-5.5969}, /*cfx*/
          {0.5785,-0.00041,169.1709,0.39982,0.000875,0.1387}, /*cmy*/
          {1.960597,0.5812,4.9928,-0.8928}, /*cfy*/
          {-1.1365,0.00148,338.5359,0.94069,0.000928,0.2921}, /*cmz*/
          {4.96185,3.342,1.5231,-4.366} /*cfz*/
     },
     {
          2452479.4,
          {0.3245,-0.00068,376.7033,0.9476,0.005694,0.3453}, /*cmx*/
          {0.283546,4.9484,1.8223,-5.8113}, /*cfx*/
          {0.54,0.00027,172.586,0.35845,0.002156,0.1897}, /*cmy*/
          {5.145822,3.4259,0.3125,-0.578}, /*cfy*/
          {-1.0038,-0.00081,337.6534,0.86984,0.005232,0.381}, /*cmz*/
          {1.81473,0.2193,3.3645,-3.9944} /*cfz*/
     },
     {
          2452579.4,
          {0.2974,-0.00542,376.4644,0.54552,0.001489,0.107}, /*cmx*/
          {3.580497,5.1869,2.0496,-5.0082}, /*cfx*/
          {0.4947,0.00083,170.6815,0.18216,0.000432,0.2542}, /*cmy*/
          {2.181641,3.6616,0.6175,-0.6802}, /*cfy*/
          {-0.9198,-0.00259,338.7932,0.45689,0.000919,0.5612}, /*cmz*/
          {5.113476,0.4694,3.4151,-3.9621} /*cfz*/
     },
     {
          2452679.4,
          {-0.065,-0.00164,376.4884,0.11,0.005093,0.3763}, /*cmx*/
          {0.805668,5.8258,5.3614,-4.7075}, /*cfx*/
          {0.5366,-6e-05,172.5614,0.07776,0.002041,0.1863}, /*cmy*/
          {5.662536,4.8345,3.7961,-0.444}, /*cfy*/
          {-1.0486,-0.00039,336.3102,0.08642,0.004869,0.4108}, /*cmz*/
          {2.338173,1.1189,0.6299,-3.7319} /*cfz*/
     },
     {
          2452779.4,
          {-0.1543,0.00189,376.8224,1.13594,0.002015,0.5196}, /*cmx*/
          {4.054601,2.4504,6.1499,-4.9457}, /*cfx*/
          {0.5737,-0.00065,173.6282,0.44406,0.001067,0.1778}, /*cmy*/
          {2.644132,0.9586,4.879,-5.9155}, /*cfy*/
          {-1.1487,0.00074,336.8705,1.02352,0.001583,0.3441}, /*cmz*/
          {5.581887,4.0212,1.4261,-2.9663} /*cfz*/
     },
     {
          2452879.4,
          {0.0077,-0.00152,375.9963,0.74751,0.006055,0.3665}, /*cmx*/
          {0.921009,5.5921,2.4495,-4.5976}, /*cfx*/
          {0.5172,-0.00012,166.2307,0.28319,0.002298,0.1966}, /*cmy*/
          {5.835512,3.835,0.6627,-5.8791}, /*cfy*/
          {-1.1069,5e-05,341.2664,0.68255,0.005543,0.3858}, /*cmz*/
          {2.444747,0.9228,4.0691,-3.0311} /*cfz*/
     },
     {
          2452979.4,
          {-0.0648,-0.00549,375.4534,0.69402,0.00412,0.4662}, /*cmx*/
          {4.281926,5.8634,2.7079,-3.8453}, /*cfx*/
          {0.4781,-0.00025,164.8228,0.25925,0.001524,0.1313}, /*cmy*/
          {2.919932,4.1219,1.1404,-6.1313}, /*cfy*/
          {-1.0619,0.00072,342.9805,0.63398,0.003656,0.2994}, /*cmz*/
          {5.805647,1.2683,4.3948,-3.3998} /*cfz*/
     },
     {
          2453079.4,
          {-0.4214,-0.00107,375.8173,0.41781,0.003863,0.5062}, /*cmx*/
          {1.478193,6.2696,5.9011,-3.9155}, /*cfx*/
          {0.4633,-0.00046,170.7468,0.19508,0.001583,0.1019}, /*cmy*/
          {0.095821,4.9098,3.9594,-5.4266}, /*cfy*/
          {-1.0209,0.0002,337.991,0.39374,0.003467,0.2305}, /*cmz*/
          {3.003862,1.5603,1.1968,-2.7043} /*cfz*/
     },
     {
          2453179.4,
          {-0.4996,0.00202,376.3548,1.15241,0.002904,0.3683}, /*cmx*/
          {4.678265,3.0563,0.1508,-4.0235}, /*cfx*/
          {0.4687,-0.0008,163.9469,0.44175,0.001284,0.2138}, /*cmy*/
          {3.322706,1.3138,4.9124,-4.9863}, /*cfy*/
          {-1.0883,-0.00016,342.4772,1.05286,0.002616,0.4937}, /*cmz*/
          {6.201808,4.6895,1.8135,-2.1458} /*cfz*/
     },
     {
          2453279.4,
          {-0.3888,-0.00112,375.2098,0.45521,0.005437,0.3434}, /*cmx*/
          {1.568689,6.2821,3.1406,-3.4548}, /*cfx*/
          {0.4138,-0.00058,147.9337,0.17147,0.002149,0.2091}, /*cmy*/
          {0.260747,4.2903,1.0532,-4.8789}, /*cfy*/
          {-1.1329,0.00091,350.1004,0.41141,0.004949,0.4854}, /*cmz*/
          {3.093989,1.6063,4.7668,-2.0303} /*cfz*/
     },
     {
          2453379.4,
          {-0.5521,-0.00282,375.578,0.6437,0.00566,0.4697}, /*cmx*/
          {4.9922,0.3092,3.4494,-3.2361}, /*cfx*/
          {0.3654,-0.00082,151.5892,0.26796,0.002235,0.1205}, /*cmy*/
          {3.672736,4.529,1.5756,-4.2307}, /*cfy*/
          {-1.0386,0.00212,348.5997,0.60613,0.005318,0.2612}, /*cmz*/
          {0.231999,1.9822,5.0914,-1.4228} /*cfz*/
     },
     {
          2453479.4,
          {-0.747,-0.0003,375.0236,0.67152,0.002559,0.4285}, /*cmx*/
          {2.135618,0.6141,0.0213,-3.272}, /*cfx*/
          {0.3093,-0.00064,157.886,0.27653,0.001206,0.1404}, /*cmy*/
          {0.803881,5.2145,3.9762,-3.779}, /*cfy*/
          {-0.9098,0.00038,345.331,0.63008,0.002115,0.3196}, /*cmz*/
          {3.660242,2.198,1.6727,-1.0907} /*cfz*/
     },
     {
          2453579.4,
          {-0.7979,0.00147,375.7107,1.08803,0.003759,0.3747}, /*cmx*/
          {5.307258,3.6878,0.6491,-2.6479}, /*cfx*/
          {0.2934,-0.00079,140.8776,0.4101,0.001498,0.1958}, /*cmy*/
          {4.020809,1.6363,4.985,-4.2355}, /*cfy*/
          {-0.9431,-0.00078,353.353,1.01856,0.003609,0.4862}, /*cmz*/
          {0.553813,5.3354,2.3137,-1.4511} /*cfz*/
     },
     {
          2453679.4,
          {-0.806,-0.00044,375.4139,0.1173,0.003844,0.5403}, /*cmx*/
          {2.238579,0.6752,3.8398,-2.1702}, /*cfx*/
          {0.245,-0.00062,120.7953,0.02974,0.001546,0.1848}, /*cmy*/
          {1.007988,5.2758,1.488,-4.2447}, /*cfy*/
          {-0.9578,0.00056,360.0938,0.0788,0.003187,0.431}, /*cmz*/
          {3.771694,2.3687,5.5228,-1.3219} /*cfz*/
     },
     {
          2453779.4,
          {-0.9578,-0.00089,375.257,0.44215,0.006058,0.4316}, /*cmx*/
          {5.707764,0.9947,4.1332,-2.1331}, /*cfx*/
          {0.1661,-0.00054,132.2616,0.21009,0.002367,0.1447}, /*cmy*/
          {4.444975,4.8819,1.9862,-3.2392}, /*cfy*/
          {-0.7659,0.00118,356.2068,0.39912,0.005512,0.3753}, /*cmz*/
          {0.95544,2.7037,5.7908,-0.4658} /*cfz*/
     },
     {
          2453879.4,
          {-1.0074,0.00017,374.8277,0.848,0.001492,0.2544}, /*cmx*/
          {2.790335,1.2455,0.1429,-2.0741}, /*cfx*/
          {0.1192,-0.00059,133.482,0.31605,0.001003,0.1745}, /*cmy*/
          {1.52555,5.5166,3.9532,-2.8852}, /*cfy*/
          {-0.6938,0.00028,356.0347,0.7809,0.001184,0.4619}, /*cmz*/
          {4.320619,2.8543,1.8511,-0.3253} /*cfz*/
     },
     {
          2453979.4,
          {-1.0231,0.00038,375.4284,0.97675,0.004584,0.4935}, /*cmx*/
          {5.95393,4.3469,1.2488,-1.722}, /*cfx*/
          {0.0946,-0.00048,107.3125,0.37146,0.001855,0.1024}, /*cmy*/
          {4.769775,1.9597,5.1275,-3.5461}, /*cfy*/
          {-0.7023,-0.00067,365.1567,0.9169,0.004347,0.3662}, /*cmz*/
          {1.211866,5.9718,2.8719,-0.4256} /*cfz*/
     },
     {
          2454079.4,
          {-1.0721,-0.00123,376.1347,0.24118,0.001095,0.7032}, /*cmx*/
          {2.933806,4.6191,4.4029,-1.5979}, /*cfx*/
          {0.0354,3e-05,89.0748,0.13936,0.000476,0.0437}, /*cmy*/
          {1.824106,1.8296,2.071,-3.9434}, /*cfy*/
          {-0.5886,0.00016,368.722,0.21158,0.001023,0.2925}, /*cmz*/
          {4.482492,6.1097,0.2545,-5.9277} /*cfz*/
     },
     {
          2454179.4,
          {-1.1528,-0.00078,375.0746,0.13964,0.005271,0.4438}, /*cmx*/
          {0.143466,1.536,4.7787,-1.225}, /*cfx*/
          {-0.0381,0.0,106.9372,0.12334,0.002158,0.1228}, /*cmy*/
          {5.242911,5.1282,2.3741,-2.0547}, /*cfy*/
          {-0.3647,0.0003,364.4008,0.13175,0.004967,0.4339}, /*cmz*/
          {1.683262,3.3774,0.1703,-5.6397} /*cfz*/
     },
     {
          2454279.4,
          {-1.1774,0.00039,375.3384,0.94668,0.001227,0.3613}, /*cmx*/
          {3.450517,1.8813,6.0999,-0.5607}, /*cfx*/
          {-0.0423,-0.0004,99.297,0.33859,0.000835,0.1412}, /*cmy*/
          {2.295045,5.7998,3.8984,-2.1171}, /*cfy*/
          {-0.375,0.00024,366.8469,0.87145,0.001041,0.4136}, /*cmz*/
          {4.992929,3.5066,1.5393,-5.851} /*cfz*/
     },
     {
          2454379.4,
          {-1.1605,-0.00043,375.8459,0.8153,0.005158,0.4496}, /*cmx*/
          {0.338103,5.0176,1.885,-0.8445}, /*cfx*/
          {-0.0628,-5e-05,68.1693,0.31424,0.002237,0.0271}, /*cmy*/
          {5.639985,2.3424,5.4403,-1.2801}, /*cfy*/
          {-0.3812,0.00039,373.7904,0.76306,0.004793,0.3796}, /*cmz*/
          {1.892845,0.3395,3.4931,-5.4225} /*cfz*/
     },
     {
          2454479.4,
          {-1.143,-0.00212,375.8632,0.49664,0.001863,0.4119}, /*cmx*/
          {3.65683,5.2658,2.125,-0.9322}, /*cfx*/
          {-0.1275,0.00057,58.1427,0.25735,0.000668,0.0931}, /*cmy*/
          {2.772689,2.4455,5.5264,-0.464}, /*cfy*/
          {-0.1784,0.00147,375.4046,0.42185,0.001389,0.5902}, /*cmz*/
          {5.219009,0.6385,3.6984,-4.8824} /*cfz*/
     },
     {
          2454579.4,
          {-1.1717,-0.00113,375.5775,0.16114,0.004065,0.3431}, /*cmx*/
          {0.860243,5.7132,5.4281,-0.0834}, /*cfx*/
          {-0.1622,0.00045,76.1616,0.05096,0.00183,0.1163}, /*cmy*/
          {6.103717,4.6697,2.7284,-1.0534}, /*cfy*/
          {0.0581,0.00038,371.3904,0.15014,0.003978,0.5335}, /*cmz*/
          {2.412224,1.1088,0.7396,-4.7849} /*cfz*/
     },
     {
          2454679.4,
          {-1.2415,0.00061,376.1894,0.98349,0.001817,0.4983}, /*cmx*/
          {4.120301,2.5282,6.0943,-6.0339}, /*cfx*/
          {-0.1132,-0.00018,59.8012,0.35851,0.00081,0.0511}, /*cmy*/
          {3.21105,6.1084,3.6639,-1.4889}, /*cfy*/
          {0.0176,0.00026,374.7404,0.92279,0.001644,0.2986}, /*cmz*/
          {5.677916,4.1447,1.5481,-4.6179} /*cfz*/
     },
     {
          2454779.4,
          {-1.2261,0.0002,376.3182,0.57957,0.005027,0.4247}, /*cmx*/
          {1.025494,5.7165,2.5737,-5.9997}, /*cfx*/
          {-0.1063,-2e-05,34.5997,0.21538,0.002288,0.0348}, /*cmy*/
          {0.682927,2.8219,5.9262,-5.7871}, /*cfy*/
          {-0.0115,0.0019,377.5744,0.56044,0.00485,0.3743}, /*cmz*/
          {2.59364,1.006,4.1485,-4.2877} /*cfz*/
     },
     {
          2454879.4,
          {-1.1226,-0.00087,376.0606,0.55414,0.003744,0.3284}, /*cmx*/
          {4.405388,5.994,2.8417,-5.3618}, /*cfx*/
          {-0.1533,0.00036,34.2157,0.29729,0.001512,0.0816}, /*cmy*/
          {4.058744,3.0956,6.2383,-0.2014}, /*cfy*/
          {0.2237,0.00292,378.1419,0.5292,0.003573,0.5392}, /*cmz*/
          {5.972956,1.3564,4.4978,-4.2367} /*cfz*/
     },
     {
          2454979.4,
          {-1.0639,-0.00107,375.9475,0.39906,0.002977,0.4431}, /*cmx*/
          {1.574903,0.0628,6.0298,-5.0903}, /*cfx*/
          {-0.1666,0.00081,44.0252,0.10162,0.001432,0.0524}, /*cmy*/
          {0.90905,3.8004,3.0389,-0.5974}, /*cfy*/
          {0.4649,0.00072,376.2386,0.40345,0.00283,0.4443}, /*cmz*/
          {3.140377,1.6889,1.2366,-3.9898} /*cfz*/
     },
     {
          2455079.4,
          {-1.1816,0.00091,376.8967,0.97347,0.002651,0.4441}, /*cmx*/
          {4.801537,3.1948,0.2177,-5.2629}, /*cfx*/
          {-0.0655,1e-05,30.53,0.36622,0.001114,0.0526}, /*cmy*/
          {4.793541,0.1944,3.6012,-3.8107}, /*cfy*/
          {0.4354,9e-05,377.7445,0.94693,0.002586,0.4035}, /*cmz*/
          {0.089878,4.773,1.8771,-3.2163} /*cfz*/
     },
     {
          2455179.4,
          {-1.2135,0.00227,376.6567,0.29452,0.004152,0.3427}, /*cmx*/
          {1.73457,0.1899,3.3319,-5.0072}, /*cfx*/
          {-0.0096,-0.00052,40.0557,0.08455,0.001883,0.0796}, /*cmy*/
          {2.619143,3.4114,0.2544,-4.0085}, /*cfy*/
          {0.409,0.00215,376.4856,0.27893,0.003976,0.4721}, /*cmz*/
          {3.309934,1.6851,4.8169,-2.9832} /*cfz*/
     },
     {
          2455279.4,
          {-0.9993,0.00116,376.8637,0.47385,0.00476,0.4475}, /*cmx*/
          {5.166884,0.4873,3.6226,-4.3797}, /*cfx*/
          {-0.0544,0.0001,33.6606,0.2665,0.002005,0.0141}, /*cmy*/
          {5.830392,3.7523,0.5805,-3.3745}, /*cfy*/
          {0.6568,0.00236,377.1328,0.46721,0.00471,0.3635}, /*cmz*/
          {0.45743,2.0207,5.1694,-3.0287} /*cfz*/
     },
     {
          2455379.4,
          {-0.8411,-0.00069,376.1935,0.60186,0.001976,0.5231}, /*cmx*/
          {2.289685,0.7682,0.1982,-4.3038}, /*cfx*/
          {-0.0568,0.00104,31.6884,0.19151,0.000991,0.0662}, /*cmy*/
          {2.750547,4.0241,3.23,-2.2672}, /*cfy*/
          {0.8156,0.00077,377.3811,0.60337,0.001826,0.3134}, /*cmz*/
          {3.864313,2.3078,1.6551,-2.7087} /*cfz*/
     },
     {
          2455479.4,
          {-0.9752,0.00101,377.2198,0.93125,0.0036,0.3361}, /*cmx*/
          {5.493538,3.8876,0.8127,-4.0183}, /*cfx*/
          {0.0771,0.00016,50.7341,0.34877,0.001534,0.09}, /*cmy*/
          {0.32803,0.6099,3.8613,-3.0718}, /*cfy*/
          {0.8156,-0.00035,375.3602,0.93249,0.003687,0.518}, /*cmz*/
          {0.78975,5.4011,2.3393,-2.3747} /*cfz*/
     },
     {
          2451179.4,
          {0.7828,-0.00198,526.9287,0.28939,0.005604,0.5225}, /*cmx*/
          {3.24963,1.725,1.5647,0.7685}, /*cfx*/
          {0.2155,-0.00105,132.7857,0.11891,0.002047,0.1532}, /*cmy*/
          {1.560076,1.3216,1.0381,-0.0837}, /*cfy*/
          {-0.7818,0.00092,510.3504,0.27265,0.005595,0.3765}, /*cmz*/
          {4.827369,3.2885,2.9869,2.4312} /*cfz*/
     },
     {
          2451269.4,
          {0.8802,-0.00036,527.2782,1.2993,0.002104,0.4495}, /*cmx*/
          {2.644948,1.0568,4.6756,-0.1741}, /*cfx*/
          {0.2036,0.00018,157.1468,0.48464,0.001218,0.1405}, /*cmy*/
          {1.018486,0.5039,4.3725,-1.7229}, /*cfy*/
          {-0.5362,-0.00057,504.0593,1.26462,0.001838,0.4617}, /*cmz*/
          {4.2213,2.5084,6.1409,1.0777} /*cfz*/
     },
     {
          2451359.4,
          {0.8666,0.00014,527.5671,0.91669,0.007304,0.3365}, /*cmx*/
          {1.979644,0.3783,3.5222,-1.4102}, /*cfx*/
          {0.1643,0.00025,186.7985,0.3159,0.002719,0.1434}, /*cmy*/
          {0.421003,5.8422,2.7796,3.3487}, /*cfy*/
          {-0.4021,-0.00055,493.3898,0.90932,0.007248,0.3585}, /*cmz*/
          {3.549177,1.8516,4.9762,0.1768} /*cfz*/
     },
     {
          2451449.4,
          {0.6841,-0.00234,527.0853,0.67835,0.001442,0.1547}, /*cmx*/
          {1.458395,3.035,6.048,3.5883}, /*cfx*/
          {0.1999,-0.00179,190.4059,0.27684,0.000737,0.1528}, /*cmy*/
          {6.195195,2.3487,5.1878,1.3874}, /*cfy*/
          {-0.771,0.00498,492.1883,0.72286,0.001862,0.3756}, /*cmz*/
          {3.023333,4.4591,1.0044,-2.0847} /*cfz*/
     },
     {
          2451539.4,
          {0.7983,0.00129,527.3152,0.08203,0.007231,0.339}, /*cmx*/
          {1.076244,2.3628,5.7138,3.3106}, /*cfx*/
          {0.1641,0.00085,175.2678,0.01448,0.002643,0.0649}, /*cmy*/
          {5.781917,1.721,5.0104,2.0404}, /*cfy*/
          {-0.3847,-0.00126,496.9885,0.06522,0.006924,0.2586}, /*cmz*/
          {2.648382,3.7981,0.909,-1.1252} /*cfz*/
     },
     {
          2451629.4,
          {0.6987,0.00358,527.6206,1.24077,0.001161,0.3493}, /*cmx*/
          {0.508966,5.1967,3.462,2.5863}, /*cfx*/
          {0.1159,0.00063,189.5342,0.47665,0.001038,0.0516}, /*cmy*/
          {5.237529,4.4367,2.4669,0.814}, /*cfy*/
          {-0.3474,0.00161,492.1393,1.21121,0.001275,0.2809}, /*cmz*/
          {2.076491,0.3976,4.8428,-2.5217} /*cfz*/
     },
     {
          2451719.4,
          {0.7587,0.00179,527.3219,1.18987,0.007027,0.2443}, /*cmx*/
          {6.112651,4.4968,1.3642,1.1477}, /*cfx*/
          {0.1496,-0.00068,214.0567,0.41918,0.002575,0.1395}, /*cmy*/
          {4.6077,3.4628,0.4169,-0.3733}, /*cfy*/
          {-0.2954,0.00231,482.8243,1.13371,0.006637,0.3263}, /*cmz*/
          {1.387025,5.9805,2.8412,2.71} /*cfz*/
     },
     {
          2451809.4,
          {1.2705,-0.0041,527.4027,0.43206,0.00173,0.5939}, /*cmx*/
          {5.540992,0.8126,1.1157,-0.0108}, /*cfx*/
          {0.1711,0.00136,220.1211,0.15859,0.000598,0.203}, /*cmy*/
          {4.057911,6.1746,6.2781,-1.8142}, /*cfy*/
          {-0.0569,-0.00689,478.9495,0.39054,0.002264,0.6477}, /*cmz*/
          {0.809552,2.162,2.6475,0.9832} /*cfz*/
     },
     {
          2451899.4,
          {0.7936,0.00044,526.9617,0.44103,0.008204,0.3156}, /*cmx*/
          {5.162866,0.4224,3.5719,-1.2901}, /*cfx*/
          {0.1522,-0.0001,210.4877,0.14719,0.003047,0.1308}, /*cmy*/
          {3.656993,5.7201,2.6061,3.5381}, /*cfy*/
          {-0.3752,0.00128,483.7369,0.44178,0.008094,0.2309}, /*cmz*/
          {0.438356,1.9292,5.0541,0.199} /*cfz*/
     },
     {
          2451989.4,
          {0.7969,-0.00051,527.208,1.10901,0.002147,0.2073}, /*cmx*/
          {4.640752,3.0757,2.2212,-2.4166}, /*cfx*/
          {0.208,-0.00172,216.2937,0.43666,0.001103,0.1247}, /*cmy*/
          {3.141043,2.0774,0.7814,1.7973}, /*cfy*/
          {-0.4618,0.00454,481.0923,1.09599,0.00158,0.2339}, /*cmz*/
          {6.198556,4.5379,3.7676,-1.4996} /*cfz*/
     },
     {
          2452079.4,
          {1.0081,-0.00273,527.2947,1.37031,0.005881,0.1941}, /*cmx*/
          {3.958029,2.3255,5.5145,2.148}, /*cfx*/
          {0.1667,-0.00065,232.4173,0.51467,0.002362,0.1173}, /*cmy*/
          {2.495257,1.1142,4.4074,1.2049}, /*cfy*/
          {-0.2301,0.00158,474.4922,1.30442,0.005746,0.2429}, /*cmz*/
          {5.502305,3.8581,0.7598,-2.0706} /*cfz*/
     },
     {
          2452169.4,
          {0.6292,0.0049,525.9674,0.04916,0.005374,0.4196}, /*cmx*/
          {3.338628,3.4164,5.0389,2.9973}, /*cfx*/
          {-0.0028,0.00043,236.511,0.01594,0.00182,0.1106}, /*cmy*/
          {1.904366,4.7159,3.6375,0.837}, /*cfy*/
          {0.1075,0.00028,472.4573,0.02747,0.005071,0.3039}, /*cmz*/
          {4.877757,4.3133,0.2122,-2.4324} /*cfz*/
     },
     {
          2452259.4,
          {0.8512,0.00098,526.5917,0.79356,0.008602,0.2901}, /*cmx*/
          {2.941406,4.5218,1.3785,1.3996}, /*cfx*/
          {0.0942,0.00022,233.3778,0.27408,0.003191,0.1273}, /*cmy*/
          {1.491767,3.2706,0.1869,-0.254}, /*cfy*/
          {-0.0626,-0.00028,473.9159,0.74253,0.008032,0.2931}, /*cmz*/
          {4.483606,6.0399,2.886,2.7512} /*cfz*/
     },
     {
          2452349.4,
          {1.0593,-0.00212,526.0586,0.92684,0.003336,0.4846}, /*cmx*/
          {2.47285,0.9257,0.4213,0.0099}, /*cfx*/
          {0.1453,-0.00016,234.9095,0.36462,0.001569,0.186}, /*cmy*/
          {1.016127,6.0485,5.1311,-1.6116}, /*cfy*/
          {-0.1003,-0.00057,473.2942,0.8545,0.003214,0.4247}, /*cmz*/
          {4.015868,2.3953,2.0563,1.1709} /*cfz*/
     },
     {
          2452439.4,
          {0.9295,0.00101,526.4829,1.47158,0.0046,0.3875}, /*cmx*/
          {1.797255,0.1826,3.4911,-1.461}, /*cfx*/
          {-0.0112,0.00044,241.8061,0.57387,0.001932,0.2227}, /*cmy*/
          {0.373047,5.0525,2.1795,3.5421}, /*cfy*/
          {0.1726,-0.00083,470.7371,1.39305,0.004388,0.4537}, /*cmz*/
          {3.331205,1.7165,4.9459,0.3093} /*cfz*/
     },
     {
          2452529.4,
          {0.9165,-0.00214,524.9276,0.46921,0.007781,0.1424}, /*cmx*/
          {1.141334,5.8747,2.7184,-2.5311}, /*cfx*/
          {0.0593,-0.00036,239.4127,0.1669,0.002814,0.1087}, /*cmy*/
          {6.030644,4.2678,1.1683,2.123}, /*cfy*/
          {0.0315,0.00081,472.3401,0.41554,0.007024,0.2489}, /*cmz*/
          {2.667326,1.1803,4.3129,-1.3007} /*cfz*/
     },
     {
          2452619.4,
          {0.8853,-0.00294,525.2171,0.97882,0.007195,0.1258}, /*cmx*/
          {0.701473,2.2679,5.4021,1.9921}, /*cfx*/
          {0.112,-0.0009,240.249,0.37003,0.002873,0.1385}, /*cmy*/
          {5.584819,0.7874,3.9944,1.0871}, /*cfy*/
          {-0.0939,0.00173,472.2839,0.92435,0.006906,0.2858}, /*cmz*/
          {2.229599,3.8737,0.7044,-2.2672} /*cfz*/
     },
     {
          2452709.4,
          {0.7484,0.00304,525.5512,0.61127,0.005159,0.3693}, /*cmx*/
          {0.284749,5.0156,4.7621,2.8343}, /*cfx*/
          {-0.03,0.00025,242.7199,0.26415,0.002028,0.0936}, /*cmy*/
          {5.152031,3.7804,3.0234,1.2178}, /*cfy*/
          {0.193,0.00059,469.6542,0.56117,0.004681,0.2202}, /*cmz*/
          {1.813491,0.2928,0.0173,-2.2994} /*cfz*/
     },
     {
          2452799.4,
          {0.6711,0.00122,525.2216,1.51751,0.003394,0.2228}, /*cmx*/
          {5.916234,4.3095,1.4763,1.4787}, /*cfx*/
          {0.035,-0.00183,241.7458,0.58061,0.001495,0.1919}, /*cmy*/
          {4.526533,2.7391,0.1617,0.0017}, /*cfy*/
          {0.1455,0.00369,471.956,1.37136,0.002826,0.3216}, /*cmz*/
          {1.15712,5.878,3.0175,2.9751} /*cfz*/
     },
     {
          2452889.4,
          {0.7798,7e-05,524.5713,0.84481,0.008458,0.3056}, /*cmx*/
          {5.233362,3.6354,0.4941,-0.1246}, /*cfx*/
          {-0.0609,-4e-05,230.3393,0.32446,0.00325,0.1484}, /*cmy*/
          {3.881431,1.8655,4.9905,-1.4954}, /*cfy*/
          {0.35,-5e-05,477.6876,0.7803,0.007825,0.3045}, /*cmz*/
          {0.471734,5.2507,2.1107,1.4356} /*cfz*/
     },
     {
          2452979.4,
          {1.0112,0.00047,524.4805,0.93268,0.004345,0.4103}, /*cmx*/
          {4.741272,0.0546,3.175,-1.2289}, /*cfx*/
          {-0.185,0.00297,229.2333,0.37522,0.001767,0.2973}, /*cmy*/
          {3.38998,4.5244,1.392,3.6132}, /*cfy*/
          {0.5832,-0.00705,478.5089,0.89371,0.004204,0.6828}, /*cmz*/
          {6.260439,1.6327,4.6604,0.3804} /*cfz*/
     },
     {
          2453069.4,
          {0.7447,-0.0015,524.6643,0.21394,0.006879,0.1712}, /*cmx*/
          {4.359106,2.9532,2.6363,-2.241}, /*cfx*/
          {0.0536,-0.00177,237.9698,0.12111,0.002571,0.0868}, /*cmy*/
          {2.988325,1.6664,0.8766,1.8316}, /*cfy*/
          {0.0634,0.00366,472.9968,0.21771,0.006044,0.2171}, /*cmz*/
          {5.881665,4.382,4.2818,-1.4668} /*cfz*/
     },
     {
          2453159.4,
          {0.8862,-0.00396,524.8454,1.43543,0.001885,0.1571}, /*cmx*/
          {3.74817,2.1394,5.9685,2.0255}, /*cfx*/
          {-0.0312,-0.0002,231.6742,0.55539,0.001344,0.0685}, /*cmy*/
          {2.395329,0.4431,4.5198,1.8218}, /*cfy*/
          {0.1984,0.00202,477.0711,1.30969,0.001827,0.2273}, /*cmz*/
          {5.268078,3.7662,1.2808,-2.064} /*cfz*/
     },
     {
          2453249.4,
          {0.7566,-0.00162,524.1305,1.13304,0.008112,0.2355}, /*cmx*/
          {3.053316,1.4414,4.5834,1.5984}, /*cfx*/
          {-0.1372,0.00073,211.3565,0.42459,0.00304,0.0527}, /*cmy*/
          {1.745673,5.7406,2.5728,1.1118}, /*cfy*/
          {0.4434,-0.00035,487.3061,1.01937,0.007265,0.1833}, /*cmz*/
          {4.576437,3.0782,6.232,3.3437} /*cfz*/
     },
     {
          2453339.4,
          {0.2108,0.00573,524.5851,0.7146,0.001036,0.2879}, /*cmx*/
          {2.5061,4.0829,0.4455,2.5721}, /*cfx*/
          {-0.0254,-0.00254,202.5532,0.27365,0.000326,0.2759}, /*cmy*/
          {1.215637,1.9214,4.0015,0.2738}, /*cfy*/
          {0.4619,0.00366,489.9287,0.60097,0.000587,0.4572}, /*cmz*/
          {4.031443,5.6952,1.528,3.3703} /*cfz*/
     },
     {
          2453429.4,
          {0.8217,-0.00156,523.6897,0.18389,0.007863,0.375}, /*cmx*/
          {2.137609,3.5582,0.5079,0.1199}, /*cfx*/
          {-0.1159,0.00078,218.7277,0.09828,0.003123,0.1545}, /*cmy*/
          {0.816389,1.1987,4.8587,-1.6327}, /*cfy*/
          {0.4326,-0.0013,483.4469,0.17559,0.007314,0.3467}, /*cmz*/
          {3.659778,5.4023,2.1594,1.3602} /*cfz*/
     },
     {
          2453519.4,
          {0.717,-0.00027,524.2195,1.26242,0.001527,0.3486}, /*cmx*/
          {1.576762,6.2819,4.8067,-1.2996}, /*cfx*/
          {-0.1693,0.00059,212.181,0.496,0.001169,0.166}, /*cmy*/
          {0.268913,4.3945,2.6102,3.6115}, /*cfy*/
          {0.5663,-0.00118,486.4372,1.17052,0.001058,0.4487}, /*cmz*/
          {3.100902,1.6164,0.1245,0.415} /*cfz*/
     },
     {
          2453609.4,
          {0.4686,0.00148,524.4529,1.2798,0.006728,0.4216}, /*cmx*/
          {0.885845,5.5438,2.4227,-2.4027}, /*cfx*/
          {-0.1221,-0.00083,184.0258,0.4797,0.002575,0.0778}, /*cmy*/
          {5.913267,3.378,0.2582,1.9782}, /*cfy*/
          {0.6586,-0.00016,498.2002,1.18136,0.0063,0.3151}, /*cmz*/
          {2.415852,0.9253,4.098,-0.62} /*cfz*/
     },
     {
          2453699.4,
          {0.7727,-0.00575,523.6257,0.29246,0.003249,0.2941}, /*cmx*/
          {0.292924,1.681,2.128,1.0895}, /*cfx*/
          {-0.1379,0.0018,165.4686,0.12532,0.001412,0.1053}, /*cmy*/
          {5.363729,5.5176,6.0765,3.274}, /*cfy*/
          {0.3626,-0.00014,504.3214,0.25326,0.00272,0.2157}, /*cmz*/
          {1.830544,3.546,3.6551,-2.2488} /*cfz*/
     },
     {
          2453789.4,
          {0.4981,0.00047,523.8422,0.54931,0.008322,0.2074}, /*cmx*/
          {6.194736,1.4859,4.6255,2.4195}, /*cfx*/
          {-0.1218,-0.00012,184.522,0.24495,0.00327,0.0913}, /*cmy*/
          {4.938452,5.4184,2.4477,1.1239}, /*cfy*/
          {0.5421,0.0001,497.6465,0.49484,0.007537,0.2112}, /*cmz*/
          {1.441734,3.1644,6.2723,-2.4884} /*cfz*/
     },
     {
          2453879.4,
          {0.3564,0.00093,523.5779,1.04828,0.002078,0.212}, /*cmx*/
          {5.689689,4.1304,3.3995,1.8566}, /*cfx*/
          {-0.0808,-0.00117,183.5984,0.39057,0.001252,0.1695}, /*cmy*/
          {4.435301,2.0446,0.8988,0.2413}, /*cfy*/
          {0.5371,0.00256,498.2891,0.9377,0.002146,0.3032}, /*cmz*/
          {0.93705,5.7611,5.1457,3.1226} /*cfz*/
     },
     {
          2453969.4,
          {0.3565,-0.00191,524.512,1.33489,0.005251,0.2922}, /*cmx*/
          {5.013674,3.4091,0.355,0.2501}, /*cfx*/
          {-0.0647,1e-05,150.696,0.51699,0.002137,0.1008}, /*cmy*/
          {3.829353,1.0374,4.2925,-1.0688}, /*cfy*/
          {0.489,0.00298,509.2004,1.25351,0.00489,0.2381}, /*cmz*/
          {0.271651,5.0404,1.9665,2.2809} /*cfz*/
     },
     {
          2454059.4,
          {0.2937,0.0032,523.8611,0.16287,0.00582,0.3849}, /*cmx*/
          {4.390597,2.9578,6.0069,-1.4976}, /*cfx*/
          {-0.1499,-0.00054,122.7036,0.04755,0.002405,0.0465}, /*cmy*/
          {3.288562,1.0637,3.5039,3.3817}, /*cfy*/
          {0.9039,-0.00341,516.1282,0.12399,0.005154,0.4887}, /*cmz*/
          {5.937961,4.6315,1.4236,0.4916} /*cfz*/
     },
     {
          2454149.4,
          {0.3819,0.00121,524.1149,0.77217,0.007403,0.3266}, /*cmx*/
          {3.974346,5.5521,2.412,-2.244}, /*cfx*/
          {-0.1539,0.00021,138.3413,0.35169,0.003011,0.0717}, /*cmy*/
          {2.819449,3.0571,0.0092,2.8739}, /*cfy*/
          {0.7109,-0.00161,512.4328,0.71894,0.006969,0.338}, /*cmz*/
          {5.518386,0.9639,4.0818,-0.3839} /*cfz*/
     },
     {
          2454239.4,
          {0.4813,-0.00404,524.1659,0.7427,0.003488,0.1035}, /*cmx*/
          {3.520436,1.9564,1.6531,2.1002}, /*cfx*/
          {-0.1005,0.00075,146.2889,0.26495,0.001699,0.0515}, /*cmy*/
          {2.343113,6.0221,5.2114,3.1318}, /*cfy*/
          {0.4708,0.00159,509.6379,0.69239,0.003251,0.2236}, /*cmz*/
          {5.061151,3.6331,3.2067,-1.9267} /*cfz*/
     },
     {
          2454329.4,
          {0.4223,-0.00299,524.5922,1.34658,0.003892,0.2135}, /*cmx*/
          {2.871376,1.2721,4.5647,1.4821}, /*cfx*/
          {-0.1751,0.00153,113.8156,0.52555,0.001587,0.0739}, /*cmy*/
          {1.793945,4.9787,2.0867,2.9368}, /*cfy*/
          {0.6863,-0.00159,518.504,1.24098,0.003405,0.094}, /*cmz*/
          {4.421786,2.8954,6.2483,3.2712} /*cfz*/
     },
     {
          2454419.4,
          {0.0761,0.00034,525.0071,0.50424,0.006871,0.2027}, /*cmx*/
          {2.226731,0.6618,3.8069,1.3681}, /*cfx*/
          {-0.0199,-0.00034,79.2267,0.1802,0.00303,0.0755}, /*cmy*/
          {1.339679,4.3355,1.0839,0.3352}, /*cfy*/
          {0.6164,0.00153,523.6337,0.48962,0.006642,0.2786}, /*cmz*/
          {3.786037,2.2851,5.4303,3.1522} /*cfz*/
     },
     {
          2454509.4,
          {0.0022,0.00131,525.1062,0.82588,0.005511,0.2172}, /*cmx*/
          {1.768911,3.38,0.2341,0.6226}, /*cfx*/
          {0.0207,-0.00142,85.9978,0.40876,0.002442,0.1199}, /*cmy*/
          {0.820312,0.6564,3.8128,-0.2954}, /*cfy*/
          {0.5652,0.00326,522.8776,0.78989,0.005234,0.3299}, /*cmz*/
          {3.325527,4.9758,1.7966,2.7117} /*cfz*/
     },
     {
          2454599.4,
          {0.2914,-0.00026,524.6535,0.40532,0.004874,0.2899}, /*cmx*/
          {1.351548,6.1322,5.878,-1.0367}, /*cfx*/
          {-0.155,0.00086,102.6578,0.1401,0.002084,0.0694}, /*cmy*/
          {0.316647,3.7783,3.0929,-2.6476}, /*cfy*/
          {0.7787,-0.00227,519.6337,0.40398,0.00447,0.4194}, /*cmz*/
          {2.90606,1.4428,1.2359,0.6078} /*cfz*/
     },
     {
          2454689.4,
          {0.048,0.00111,525.5076,1.26644,0.002239,0.4066}, /*cmx*/
          {0.737856,5.4186,2.6113,-2.2377}, /*cfx*/
          {-0.027,-0.00064,75.6099,0.49764,0.001061,0.0699}, /*cmy*/
          {6.150658,2.6751,0.1373,0.723}, /*cfy*/
          {0.7859,-0.00044,524.3378,1.21217,0.002357,0.3144}, /*cmz*/
          {2.297818,0.7577,4.3319,-0.4127} /*cfz*/
     },
     {
          2454779.4,
          {0.0136,-1e-05,525.693,0.79315,0.00722,0.2379}, /*cmx*/
          {0.081827,4.7793,1.6374,3.0932}, /*cfx*/
          {-0.0147,-8e-05,45.0717,0.30432,0.003233,0.0209}, /*cmy*/
          {6.049806,1.8861,4.9893,-2.0749}, /*cfy*/
          {0.6921,-0.00011,527.3335,0.76026,0.006869,0.2207}, /*cmz*/
          {1.650464,0.062,3.2049,-1.5906} /*cfz*/
     },
     {
          2454869.4,
          {0.3082,-0.00407,526.2438,0.75852,0.003109,0.2857}, /*cmx*/
          {5.86213,1.1647,4.2041,0.9092}, /*cfx*/
          {-0.1362,0.0021,42.8369,0.38736,0.001435,0.1683}, /*cmy*/
          {5.609208,4.51,1.1925,3.336}, /*cfy*/
          {0.6104,-0.00253,526.938,0.67825,0.002576,0.0148}, /*cmz*/
          {1.149019,2.7344,5.8034,2.9599} /*cfz*/
     },
     {
          2454959.4,
          {-0.0641,0.00094,525.0258,0.09248,0.005805,0.2067}, /*cmx*/
          {5.468356,4.1671,3.8145,1.9934}, /*cfx*/
          {0.0148,-0.00073,58.2873,0.02137,0.002508,0.0974}, /*cmy*/
          {4.794944,2.7911,0.9331,0.5345}, /*cfy*/
          {0.6543,0.00135,526.0997,0.07451,0.00576,0.2866}, /*cmz*/
          {0.750059,5.7051,5.3982,3.3161} /*cfz*/
     },
     {
          2455049.4,
          {-0.0666,-0.00171,525.8371,1.15237,0.001283,0.2563}, /*cmx*/
          {4.892853,3.3196,1.1627,0.5868}, /*cfx*/
          {0.0215,0.00063,44.3673,0.45992,0.00088,0.0388}, /*cmy*/
          {4.580514,0.4064,4.6474,-0.9016}, /*cfy*/
          {0.5299,0.00228,527.3201,1.12764,0.001219,0.2767}, /*cmz*/
          {0.179316,4.8773,2.7062,2.6228} /*cfz*/
     },
     {
          2455139.4,
          {-0.0957,-0.00168,526.61,0.99068,0.006673,0.2739}, /*cmx*/
          {4.234439,2.6258,5.7722,-0.4722}, /*cfx*/
          {0.0196,0.00074,46.464,0.38519,0.00296,0.0279}, /*cmy*/
          {4.972303,5.8063,2.6666,3.5031}, /*cfy*/
          {0.5672,0.00052,526.5821,0.97556,0.006601,0.2095}, /*cmz*/
          {5.809057,4.1745,1.0335,1.0147} /*cfz*/
     },
     {
          2455229.4,
          {-0.329,0.00619,526.0203,0.50656,0.000635,0.566}, /*cmx*/
          {3.69021,5.1919,0.2157,-2.2758}, /*cfx*/
          {0.1109,-0.00272,54.9855,0.27745,0.000429,0.1696}, /*cmy*/
          {4.65354,2.096,3.7856,0.4756}, /*cfy*/
          {0.91,-0.00182,525.7968,0.4983,0.000288,0.3882}, /*cmz*/
          {5.267542,0.5252,2.4303,-0.1915} /*cfz*/
     },
     {
          2455319.4,
          {-0.0304,-0.00163,526.0702,0.23396,0.006672,0.1297}, /*cmx*/
          {3.302285,4.8614,1.7154,3.2993}, /*cfx*/
          {-0.0082,0.00077,40.431,0.13896,0.002872,0.0612}, /*cmy*/
          {3.774399,1.863,4.9503,-2.1686}, /*cfy*/
          {0.5759,0.00012,526.8575,0.22511,0.00642,0.1946}, /*cmz*/
          {4.875113,0.058,3.2421,-1.2975} /*cfz*/
     },
     {
          2455409.4,
          {0.0278,-0.00325,526.0516,1.02584,0.001159,0.1621}, /*cmx*/
          {2.769191,1.2008,0.1474,1.6248}, /*cfx*/
          {-0.0396,0.00145,45.9023,0.40712,0.000764,0.1045}, /*cmy*/
          {3.495086,4.3897,2.9458,3.3997}, /*cfy*/
          {0.6257,-0.00205,526.7298,0.97744,0.001497,0.0748}, /*cmz*/
          {4.343363,2.7398,1.75,-2.1329} /*cfz*/
     },
     {
          2455499.4,
          {-0.1561,-0.00055,526.9719,1.13189,0.005871,0.1573}, /*cmx*/
          {2.113354,0.5152,3.6889,1.2929}, /*cfx*/
          {0.0585,-0.00021,77.707,0.43296,0.002526,0.0491}, /*cmy*/
          {3.349401,3.5047,0.4281,1.7821}, /*cfy*/
          {0.6891,-0.00264,522.6983,1.12556,0.00577,0.0942}, /*cmz*/
          {3.691871,2.0035,5.1537,2.0892} /*cfz*/
     },
     {
          2451179.3,
          {41.0663,0.02828,1220.7455,0.14517,0.015636,17.5423}, /*cmx*/
          {2.430637,1.1604,0.787,5.7388}, /*cfx*/
          {7.1012,0.00555,298.8084,0.19017,0.00574,4.5005}, /*cmy*/
          {0.769378,0.8786,0.3255,4.0855}, /*cfy*/
          {-32.5756,0.04931,1183.873,0.20286,0.014716,16.914}, /*cmz*/
          {4.008164,2.557,2.2279,1.0268} /*cfz*/
     },
     {
          2451249.3,
          {43.2012,0.06117,1221.1634,2.33556,0.003274,17.5221}, /*cmx*/
          {4.809563,3.2426,2.3564,4.2396}, /*cfx*/
          {7.5792,0.00271,336.514,0.97654,0.002356,5.2835}, /*cmy*/
          {3.185579,2.8272,1.1888,2.6361}, /*cfy*/
          {-29.0021,0.09996,1173.932,2.30171,0.003459,16.7384}, /*cmz*/
          {0.101716,4.7047,3.8543,5.8066} /*cfz*/
     },
     {
          2451319.3,
          {47.3888,0.03188,1221.4006,2.65172,0.010625,17.4545}, /*cmx*/
          {0.832733,5.532,2.5107,2.7178}, /*cfx*/
          {7.5276,-0.00726,396.8052,0.98295,0.0044,6.0011}, /*cmy*/
          {5.546983,4.8846,1.9837,1.1626}, /*cfy*/
          {-21.4688,0.07256,1155.9271,2.62055,0.010437,16.4704}, /*cmz*/
          {2.40344,0.6929,3.8898,4.2821} /*cfz*/
     },
     {
          2451389.3,
          {49.7107,-0.00189,1221.4508,1.05238,0.018094,17.5138}, /*cmx*/
          {3.170722,1.5816,4.7246,1.2771}, /*cfx*/
          {6.8205,0.0009,432.6268,0.32653,0.00639,6.2354}, /*cmy*/
          {1.634457,0.7468,3.9748,6.0247}, /*cfy*/
          {-15.8476,-0.00724,1142.2458,0.98748,0.017092,16.4438}, /*cmz*/
          {4.736176,3.0689,6.1916,2.8398} /*cfz*/
     },
     {
          2451459.3,
          {49.8538,-0.04052,1221.2138,1.76986,0.002568,17.4359}, /*cmx*/
          {5.627912,0.9129,3.584,6.2408}, /*cfx*/
          {7.1614,0.00168,426.1491,0.68912,0.001732,5.9113}, /*cmy*/
          {4.0908,0.195,3.1525,4.6871}, /*cfy*/
          {-17.2049,-0.05616,1145.0595,1.80553,0.00333,16.5594}, /*cmz*/
          {0.910171,2.4011,5.2784,1.5235} /*cfz*/
     },
     {
          2451529.3,
          {47.2768,0.0045,1221.294,1.03476,0.018948,17.4386}, /*cmx*/
          {1.881655,3.4506,0.309,4.8948}, /*cfx*/
          {7.5646,-1e-05,397.6606,0.3024,0.006947,5.7492}, /*cmy*/
          {0.320133,2.5854,5.9414,3.3306}, /*cfy*/
          {-21.9419,0.01322,1154.0373,1.00538,0.01856,16.5857}, /*cmz*/
          {3.451834,4.9096,1.741,0.1813} /*cfz*/
     },
     {
          2451599.3,
          {47.586,0.0413,1221.1478,1.74209,0.00826,17.4764}, /*cmx*/
          {4.314004,2.7655,2.4183,3.4254}, /*cfx*/
          {7.6045,-0.01146,410.2149,0.73586,0.003365,6.2423}, /*cmy*/
          {2.756588,2.192,1.2715,1.8874}, /*cfy*/
          {-20.9349,0.0991,1150.1243,1.70948,0.00806,16.438}, /*cmz*/
          {5.883087,4.2008,3.9425,4.9964} /*cfz*/
     },
     {
          2451669.3,
          {50.2907,0.02631,1221.0349,2.84209,0.005796,17.4451}, /*cmx*/
          {0.347969,5.054,2.3488,1.893}, /*cfx*/
          {6.5694,-0.02211,456.7815,1.06912,0.003033,6.8332}, /*cmy*/
          {5.10874,4.2167,1.7291,0.3914}, /*cfy*/
          {-13.5698,0.0978,1133.3789,2.8079,0.005759,16.1151}, /*cmz*/
          {1.911531,0.2226,3.629,3.4575} /*cfz*/
     },
     {
          2451739.3,
          {52.2038,4e-05,1221.1548,2.07328,0.017392,17.5095}, /*cmx*/
          {2.654339,1.0509,4.1961,0.4028}, /*cfx*/
          {4.7707,-0.01255,492.3156,0.73445,0.006449,7.1556}, /*cmy*/
          {1.163066,6.2779,3.1908,5.2075}, /*cfy*/
          {-6.1414,0.04008,1119.108,2.0087,0.016856,16.0271}, /*cmz*/
          {4.209934,2.5349,5.6589,1.9615} /*cfz*/
     },
     {
          2451809.3,
          {52.8598,-0.02351,1219.8321,0.78509,0.01008,17.5025}, /*cmx*/
          {5.051295,0.2532,0.5166,5.3235}, /*cfx*/
          {4.0639,0.01476,499.1892,0.3262,0.003137,7.0481}, /*cmy*/
          {3.571344,5.6429,5.6741,3.8459}, /*cfy*/
          {-3.502,-0.06177,1115.5676,0.73869,0.009906,16.0086}, /*cmz*/
          {0.321163,1.7659,1.9587,0.6042} /*cfz*/
     },
     {
          2451879.3,
          {51.3741,-0.00044,1220.8258,2.03168,0.0179,17.4883}, /*cmx*/
          {1.296701,2.8803,6.0137,4.0145}, /*cfx*/
          {5.4003,0.00917,482.2001,0.70145,0.006644,6.825}, /*cmy*/
          {6.085579,1.8719,5.119,2.5183}, /*cfy*/
          {-8.7733,-0.0273,1122.4828,1.94657,0.017168,16.0773}, /*cmz*/
          {2.854048,4.3674,1.1934,5.5798} /*cfz*/
     },
     {
          2451949.3,
          {51.0445,0.01672,1220.47,0.75936,0.014214,17.5804}, /*cmx*/
          {3.78923,2.2939,2.0768,2.5983}, /*cfx*/
          {6.063,-0.01956,477.2608,0.36112,0.005266,7.015}, /*cmy*/
          {2.284085,1.6252,0.9636,1.1061}, /*cfy*/
          {-10.9682,0.07897,1124.5692,0.75907,0.013388,16.0131}, /*cmz*/
          {5.348397,3.6677,3.6026,4.1595} /*cfz*/
     },
     {
          2452019.3,
          {52.052,0.01052,1220.3168,2.71092,0.003308,17.4994}, /*cmx*/
          {6.137951,4.5686,3.1254,1.0756}, /*cfx*/
          {4.5233,-0.0355,504.5987,1.0466,0.002502,7.409}, /*cmy*/
          {4.652479,3.5577,1.7996,5.8881}, /*cfy*/
          {-5.121,0.10892,1113.0044,2.65553,0.002225,15.7956}, /*cmz*/
          {1.408791,6.0388,4.3245,2.626} /*cfz*/
     },
     {
          2452089.3,
          {52.8075,-0.01534,1220.6009,2.77728,0.013458,17.5256}, /*cmx*/
          {2.146206,0.5336,3.7259,5.8321}, /*cfx*/
          {1.7234,-0.02923,530.751,1.03123,0.005291,7.6655}, /*cmy*/
          {0.688653,5.5979,2.6202,4.3847}, /*cfy*/
          {3.1448,0.07605,1102.559,2.64575,0.012924,15.7379}, /*cmz*/
          {3.691043,2.0539,5.2307,1.0893} /*cfz*/
     },
     {
          2452159.3,
          {52.0223,-0.00126,1218.6815,0.64146,0.018655,17.5287}, /*cmx*/
          {4.488469,2.9529,6.0826,4.4157}, /*cfx*/
          {-0.4512,0.01104,537.7613,0.21749,0.006822,7.6654}, /*cmy*/
          {3.04976,1.5092,4.7668,2.972}, /*cfy*/
          {8.809,-0.02859,1098.5046,0.60876,0.017638,15.7231}, /*cmz*/
          {6.027955,4.556,1.35,5.9492} /*cfz*/
     },
     {
          2452229.3,
          {52.0302,0.01124,1219.7347,2.26034,0.009317,17.4827}, /*cmx*/
          {0.687316,2.2827,5.3711,3.1072}, /*cfx*/
          {0.7444,0.02015,533.9278,0.81149,0.003263,7.575}, /*cmy*/
          {5.528129,0.9915,4.142,1.6515}, /*cfy*/
          {5.6495,-0.04977,1100.2953,2.09517,0.008295,15.7339}, /*cmz*/
          {2.228815,3.7708,0.472,4.6464} /*cfz*/
     },
     {
          2452299.3,
          {52.5517,-0.00157,1219.4207,0.54752,0.01952,17.5226}, /*cmx*/
          {3.225768,4.742,1.6207,1.7496}, /*cfx*/
          {2.4527,-0.01371,528.6233,0.18911,0.007142,7.6367}, /*cmy*/
          {1.767104,3.052,0.387,0.284}, /*cfy*/
          {1.2067,0.03689,1102.5889,0.47006,0.017935,15.8041}, /*cmz*/
          {4.771651,0.0562,3.1328,3.2862} /*cfz*/
     },
     {
          2452369.3,
          {52.3261,-0.00867,1219.0941,2.20845,0.007191,17.4469}, /*cmx*/
          {5.627534,4.0668,3.5886,0.2524}, /*cfx*/
          {1.3367,-0.04035,538.8391,0.87897,0.00321,7.8159}, /*cmy*/
          {4.175311,2.9016,1.8738,5.0898}, /*cfy*/
          {4.1206,0.10291,1097.7031,2.13413,0.005788,15.6887}, /*cmz*/
          {0.88721,5.5654,5.1408,1.7872} /*cfz*/
     },
     {
          2452439.3,
          {51.6174,-0.03959,1219.2243,3.12491,0.008612,17.4288}, /*cmx*/
          {1.641038,0.0366,3.4026,4.988}, /*cfx*/
          {-1.8502,-0.03959,550.7747,1.17567,0.003722,7.8978}, /*cmy*/
          {0.212323,4.9454,2.2881,3.5692}, /*cfy*/
          {11.9922,0.09555,1094.1032,2.89171,0.007728,15.7114}, /*cmz*/
          {3.175677,1.5834,4.9189,0.2338} /*cfz*/
     },
     {
          2452509.3,
          {48.7699,-0.00864,1217.0699,1.90995,0.020242,17.4048}, /*cmx*/
          {3.943828,2.358,5.5053,3.5107}, /*cfx*/
          {-4.7647,-0.00898,548.0863,0.69623,0.007405,7.8589}, /*cmy*/
          {2.539296,0.7851,3.9638,2.1099}, /*cfy*/
          {19.0069,0.02258,1095.9063,1.72902,0.01816,15.8211}, /*cmz*/
          {5.472942,3.9325,0.7869,5.0386} /*cfz*/
     },
     {
          2452579.3,
          {48.5347,0.02133,1217.3242,1.34602,0.005844,17.3816}, /*cmx*/
          {0.077787,1.661,1.7841,2.1684}, /*cfx*/
          {-4.997,0.01997,544.3899,0.52883,0.002096,7.8583}, /*cmy*/
          {4.963009,0.0746,0.4844,0.7625}, /*cfy*/
          {19.6271,-0.04802,1097.3192,1.28743,0.005284,15.7343}, /*cmz*/
          {1.605984,3.1609,3.6154,3.6987} /*cfz*/
     },
     {
          2452649.3,
          {50.2866,0.00647,1217.8263,1.78821,0.020497,17.4267}, /*cmx*/
          {2.622724,4.2088,1.0687,0.8532}, /*cfx*/
          {-3.1147,0.0065,550.4098,0.67633,0.007809,7.976}, /*cmy*/
          {1.209007,2.6544,5.8899,5.7205}, /*cfy*/
          {15.0762,-0.01712,1093.9821,1.66244,0.019139,15.752}, /*cmz*/
          {4.154195,5.7583,2.5921,2.3897} /*cfz*/
     },
     {
          2452719.3,
          {50.4413,-0.02231,1217.4778,1.29435,0.012716,17.4314}, /*cmx*/
          {5.090847,3.542,3.3433,5.692}, /*cfx*/
          {-2.8549,-0.03354,555.0852,0.53004,0.004959,7.9826}, /*cmy*/
          {3.672609,2.2665,1.643,4.2836}, /*cfy*/
          {14.2314,0.08027,1091.3734,1.22722,0.011361,15.6833}, /*cmz*/
          {0.339616,5.0756,4.9066,0.9414} /*cfz*/
     },
     {
          2452789.3,
          {48.6489,-0.06427,1217.1822,3.0674,0.004334,17.4242}, /*cmx*/
          {1.132486,5.8308,3.5176,4.147}, /*cfx*/
          {-5.5623,-0.03849,553.528,1.16578,0.002673,7.8346}, /*cmy*/
          {6.015611,4.2925,2.2399,2.7663}, /*cfy*/
          {20.4925,0.0973,1094.3627,2.78285,0.003056,15.7465}, /*cmz*/
          {2.659441,1.1122,5.0497,5.6771} /*cfz*/
     },
     {
          2452859.3,
          {44.0628,-0.04357,1215.6308,2.70343,0.016124,17.495}, /*cmx*/
          {3.416071,1.8234,5.0143,2.6261}, /*cfx*/
          {-8.3544,-0.0204,536.3214,1.02636,0.006196,7.5665}, /*cmy*/
          {2.044556,0.084,3.3068,1.2734}, /*cfy*/
          {27.5353,0.05966,1104.0426,2.46649,0.01462,15.908}, /*cmz*/
          {4.940546,3.4168,0.2938,4.1578} /*cfz*/
     },
     {
          2452929.3,
          {41.3158,0.01905,1214.91,0.14837,0.017555,17.4571}, /*cmx*/
          {5.772879,4.3794,1.0983,1.2287}, /*cfx*/
          {-9.6757,0.00962,519.628,0.03585,0.006417,7.4977}, /*cmy*/
          {4.419396,2.5395,5.6053,6.1599}, /*cfy*/
          {31.3427,-0.02719,1111.6526,0.10134,0.015372,15.8728}, /*cmz*/
          {1.013677,0.0323,2.7394,2.7568} /*cfz*/
     },
     {
          2452999.3,
          {42.9473,0.04614,1215.0091,2.35319,0.013759,17.5409}, /*cmx*/
          {1.995435,3.5675,0.3749,6.2122}, /*cfx*/
          {-8.742,0.01805,530.8756,0.91651,0.005375,7.7341}, /*cmy*/
          {0.630921,1.8464,5.0036,4.8433}, /*cfy*/
          {28.6197,-0.05131,1106.8299,2.18236,0.013052,15.7587}, /*cmz*/
          {3.519347,5.1975,2.0197,1.4565} /*cfz*/
     },
     {
          2453069.3,
          {45.5712,-0.02187,1215.7906,0.02485,0.018007,17.5051}, /*cmx*/
          {4.521641,3.7594,2.9064,4.8311}, /*cfx*/
          {-7.468,-0.01782,545.3681,0.07649,0.007026,7.8003}, /*cmy*/
          {3.142433,2.8028,1.1594,3.4577}, /*cfy*/
          {24.995,0.0447,1098.7569,0.02509,0.016449,15.7711}, /*cmz*/
          {6.046242,4.0685,4.5104,0.0732} /*cfz*/
     },
     {
          2453139.3,
          {43.7469,-0.07963,1215.1118,2.57838,0.004854,17.4667}, /*cmx*/
          {0.61427,5.3378,4.4206,3.3149}, /*cfx*/
          {-9.0186,-0.0258,537.8207,0.99699,0.002678,7.4916}, /*cmy*/
          {5.529495,3.627,2.3827,1.9624}, /*cfy*/
          {28.7081,0.08247,1103.6344,2.32868,0.003951,15.8842}, /*cmz*/
          {2.137538,0.6351,0.0119,4.8368} /*cfz*/
     },
     {
          2453209.3,
          {38.1673,-0.0814,1214.7263,3.04355,0.010399,17.5166}, /*cmx*/
          {2.901725,1.3091,4.6162,1.7761}, /*cfx*/
          {-10.972,-0.01471,506.9251,1.17171,0.00435,6.9922}, /*cmy*/
          {1.564552,5.7014,2.8714,0.4518}, /*cfy*/
          {34.7729,0.07245,1119.1024,2.79145,0.009617,16.1778}, /*cmz*/
          {4.426224,2.934,6.1998,3.2957} /*cfz*/
     },
     {
          2453279.3,
          {32.3875,-0.00362,1214.1935,1.48338,0.020584,17.4356}, /*cmx*/
          {5.216531,3.6297,0.4892,0.3189}, /*cfx*/
          {-11.9352,-0.00177,470.9369,0.5543,0.007735,6.6866}, /*cmy*/
          {3.909611,1.6024,4.7376,5.2936}, /*cfy*/
          {39.7776,0.00421,1134.2762,1.3326,0.018441,16.304}, /*cmz*/
          {0.460095,5.2978,2.1574,1.8395} /*cfz*/
     },
     {
          2453349.3,
          {32.0141,0.07447,1213.5003,1.84422,0.001814,17.4458}, /*cmx*/
          {1.37453,2.9307,5.0349,5.2763}, /*cfx*/
          {-11.8301,0.00279,469.7774,0.68444,0.000938,6.9871}, /*cmy*/
          {0.070539,0.8983,2.3454,3.9503}, /*cfy*/
          {39.4395,-0.04287,1135.387,1.6117,0.000739,16.2497}, /*cmz*/
          {2.902717,4.6087,6.0468,0.5094} /*cfz*/
     },
     {
          2453419.3,
          {37.0368,-0.00176,1214.7635,1.33304,0.02066,17.483}, /*cmx*/
          {3.922213,5.5191,2.3755,3.9478}, /*cfx*/
          {-11.3163,-0.00154,499.8914,0.51692,0.007904,7.2429}, /*cmy*/
          {2.593078,3.5443,0.4509,2.6106}, /*cfy*/
          {35.7593,0.0031,1122.2886,1.17863,0.018368,16.1356}, /*cmz*/
          {5.447167,0.8851,4.0138,5.4671} /*cfz*/
     },
     {
          2453489.3,
          {36.6613,-0.07696,1213.6637,1.67644,0.009904,17.3974}, /*cmx*/
          {0.080906,4.8362,4.4559,2.478}, /*cfx*/
          {-11.6733,-0.00758,500.2018,0.66883,0.003868,6.9458}, /*cmy*/
          {5.035555,2.9426,2.2926,1.1577}, /*cfy*/
          {36.5349,0.05595,1122.0954,1.53368,0.008718,16.2421}, /*cmz*/
          {1.605416,0.1467,6.2084,3.9988} /*cfz*/
     },
     {
          2453559.3,
          {31.2285,-0.10636,1214.2375,2.98775,0.005141,17.4151}, /*cmx*/
          {2.395309,0.8095,4.4508,0.9372}, /*cfx*/
          {-12.4176,0.00108,462.3424,1.16174,0.002847,6.2791}, /*cmy*/
          {1.09715,5.0363,2.7055,5.9415}, /*cfy*/
          {40.8805,0.06598,1138.6279,2.74713,0.004783,16.6073}, /*cmz*/
          {3.923429,2.4598,6.0799,2.4649} /*cfz*/
     },
     {
          2453629.3,
          {23.5463,-0.04317,1213.882,2.36057,0.01767,17.3881}, /*cmx*/
          {4.690435,3.0993,6.2557,5.7174}, /*cfx*/
          {-12.1911,0.00078,408.5016,0.90439,0.006735,5.6397}, /*cmy*/
          {3.435972,0.8467,3.9896,4.4795}, /*cfy*/
          {45.4235,0.02754,1158.8312,2.11695,0.015476,16.7948}, /*cmz*/
          {6.223513,4.7637,1.6498,0.9715} /*cfz*/
     },
     {
          2453699.3,
          {20.3002,0.05627,1214.154,0.49533,0.012086,17.4326}, /*cmx*/
          {0.787918,2.3734,2.4017,4.3356}, /*cfx*/
          {-11.8862,-0.01175,382.3204,0.21801,0.004857,5.7184}, /*cmy*/
          {5.841717,6.0967,0.2817,3.0967}, /*cfy*/
          {46.7874,-0.01582,1167.0884,0.39515,0.011976,16.8066}, /*cmz*/
          {2.325535,3.936,4.11,5.8765} /*cfz*/
     },
     {
          2453769.3,
          {24.8321,0.03782,1214.9341,2.12717,0.016422,17.4615}, /*cmx*/
          {3.309544,4.9312,1.8002,3.0365}, /*cfx*/
          {-12.7083,0.0016,414.0852,0.85744,0.006682,6.2187}, /*cmy*/
          {2.050509,2.7019,5.8233,1.7647}, /*cfy*/
          {45.1294,-0.02993,1157.0226,1.92571,0.014752,16.6392}, /*cmz*/
          {4.842873,0.2763,3.3996,4.57} /*cfz*/
     },
     {
          2453839.3,
          {27.2491,-0.05347,1213.2915,0.4691,0.015272,17.4122}, /*cmx*/
          {5.812443,4.3742,4.1284,1.6252}, /*cfx*/
          {-12.7924,0.00566,435.7762,0.21043,0.005776,6.1025}, /*cmy*/
          {4.537348,2.3013,1.8654,0.3641}, /*cfy*/
          {43.5807,0.02658,1148.8753,0.4602,0.013437,16.6121}, /*cmz*/
          {1.06035,5.9413,5.8244,3.1624} /*cfz*/
     },
     {
          2453909.3,
          {23.3256,-0.11365,1214.1503,2.57813,0.002862,17.491}, /*cmx*/
          {1.890683,0.3153,5.3631,0.1067}, /*cfx*/
          {-12.5851,0.01841,402.7666,1.02376,0.002342,5.3621}, /*cmy*/
          {0.641954,4.3614,2.8843,5.179}, /*cfy*/
          {45.9152,0.04774,1160.7284,2.37231,0.003043,16.8813}, /*cmz*/
          {3.425216,1.9845,0.7265,1.6521} /*cfz*/
     },
     {
          2453979.3,
          {15.1739,-0.0807,1213.8414,2.74923,0.012263,17.5051}, /*cmx*/
          {4.1871,2.6097,5.8556,4.8684}, /*cfx*/
          {-11.1691,0.01686,338.0955,1.10582,0.005008,4.4465}, /*cmy*/
          {3.000234,0.1692,3.4414,3.7235}, /*cfy*/
          {49.1765,0.03118,1181.2673,2.49906,0.010519,17.0775}, /*cmz*/
          {5.728859,4.2507,1.2096,0.1355} /*cfz*/
     },
     {
          2454049.3,
          {9.2432,0.01385,1215.1511,0.88285,0.018192,17.5633}, /*cmx*/
          {0.242049,4.9118,1.7851,3.4341}, /*cfx*/
          {-9.7768,-0.00713,286.9717,0.33069,0.007396,4.1369}, /*cmy*/
          {5.40086,2.4773,5.5592,2.3108}, /*cfy*/
          {51.0061,-0.00101,1193.8637,0.83347,0.017051,17.1605}, /*cmz*/
          {1.790351,0.3159,3.4669,4.9846} /*cfz*/
     },
     {
          2454119.3,
          {10.6091,0.07563,1214.9651,1.91332,0.004926,17.5617}, /*cmx*/
          {2.709264,4.3069,1.0504,2.119}, /*cfx*/
          {-10.5143,-0.01618,298.8288,0.82919,0.002698,4.6584}, /*cmy*/
          {1.565984,1.8123,4.7346,0.9549}, /*cfy*/
          {51.0691,-0.03235,1191.4,1.84966,0.00572,17.0765}, /*cmz*/
          {4.255349,5.9454,2.6539,3.6669} /*cfz*/
     },
     {
          2454189.3,
          {15.7587,-0.01646,1214.0485,0.79795,0.018489,17.5298}, /*cmx*/
          {5.24415,0.5224,3.668,0.767}, /*cfx*/
          {-11.6853,0.00577,341.1571,0.2991,0.007408,4.8726}, /*cmy*/
          {4.053496,4.4114,1.2333,5.8644}, /*cfy*/
          {49.109,0.00482,1180.0838,0.69921,0.016496,16.9438}, /*cmz*/
          {0.503375,2.1898,5.3352,2.3107} /*cfz*/
     },
     {
          2454259.3,
          {14.429,-0.10267,1214.2965,1.85971,0.006627,17.5744}, /*cmx*/
          {1.381895,6.1091,5.7168,5.5747}, /*cfx*/
          {-11.3731,0.03045,327.1935,0.77143,0.003168,4.2687}, /*cmy*/
          {0.205704,3.6661,2.9819,4.4389}, /*cfy*/
          {49.7915,0.02431,1183.5892,1.69039,0.006868,17.133}, /*cmz*/
          {2.924996,1.4996,1.038,0.8366} /*cfz*/
     },
     {
          2454329.3,
          {7.0727,-0.10296,1214.4775,2.75025,0.006609,17.5302}, /*cmx*/
          {3.698522,2.1326,5.6195,4.0511}, /*cfx*/
          {-9.1873,0.03434,262.6616,1.16136,0.003212,3.2523}, /*cmy*/
          {2.610456,5.8181,3.1601,3.0334}, /*cfy*/
          {51.4786,0.0189,1199.439,2.56447,0.00579,17.3587}, /*cmz*/
          {5.249571,3.7539,0.9323,5.6014} /*cfz*/
     },
     {
          2454399.3,
          {-0.5714,-0.02674,1216.505,1.83962,0.017327,17.5216}, /*cmx*/
          {6.013512,4.4046,1.2566,2.5718}, /*cfx*/
          {-6.5261,0.00741,195.4721,0.75558,0.007486,2.6026}, /*cmy*/
          {5.069003,1.7011,4.8058,1.6694}, /*cfy*/
          {52.5539,-0.00188,1211.5642,1.75017,0.016449,17.4977}, /*cmz*/
          {1.288898,6.0375,2.9021,4.1268} /*cfz*/
     },
     {
          2454469.3,
          {-2.7016,0.07548,1215.3966,0.97119,0.007126,17.5729}, /*cmx*/
          {2.139658,3.6598,3.9432,1.2163}, /*cfx*/
          {-5.9358,-0.03111,178.6833,0.46314,0.00291,2.837}, /*cmy*/
          {1.248996,0.8605,1.4265,0.2565}, /*cfy*/
          {52.6442,-0.00649,1213.9548,0.9344,0.006258,17.4809}, /*cmz*/
          {3.699794,5.3516,5.4354,2.7697} /*cfz*/
     },
     {
          2454539.3,
          {2.9406,0.02015,1215.6649,1.73564,0.017163,17.493}, /*cmx*/
          {4.667329,6.2664,3.1263,6.1819}, /*cfx*/
          {-8.2041,-0.00501,221.0893,0.70927,0.007401,3.3562}, /*cmy*/
          {3.652927,3.6305,0.4533,5.1344}, /*cfy*/
          {52.2094,-0.00382,1207.3559,1.58035,0.015379,17.3784}, /*cmz*/
          {6.223698,1.6171,4.7675,1.4478} /*cfz*/
     },
     {
          2454609.3,
          {4.4863,-0.07467,1214.7025,0.87804,0.011316,17.501}, /*cmx*/
          {0.86349,5.654,5.4055,4.755}, /*cfx*/
          {-8.6675,0.03156,235.189,0.41642,0.00475,3.0732}, /*cmy*/
          {6.104243,2.9609,2.6714,3.7565}, /*cfy*/
          {52.1704,0.00303,1204.4191,0.76929,0.011352,17.4687}, /*cmz*/
          {2.417087,1.001,0.7645,0.0239} /*cfz*/
     },
     {
          2454679.3,
          {-0.941,-0.10777,1215.5668,2.45843,0.002595,17.4923}, /*cmx*/
          {3.216842,1.6568,6.134,3.2427}, /*cfx*/
          {-6.4273,0.04452,184.7391,1.08915,0.002047,2.1563}, /*cmy*/
          {2.305251,5.1968,3.3058,2.4804}, /*cfy*/
          {52.4105,0.00029,1212.6472,2.3431,0.00262,17.5938}, /*cmz*/
          {4.776572,3.2639,1.4136,4.8061} /*cfz*/
     },
     {
          2454749.3,
          {-9.0034,-0.05717,1217.873,2.3809,0.013258,17.5022}, /*cmx*/
          {5.52664,3.9219,0.7976,1.7343}, /*cfx*/
          {-3.0303,0.02248,119.7623,1.01852,0.005989,1.4772}, /*cmy*/
          {4.973968,1.0422,4.2044,1.4115}, /*cfy*/
          {52.1173,-0.01331,1220.1559,2.27221,0.012535,17.6223}, /*cmz*/
          {0.809984,5.5237,2.4363,3.3062} /*cfz*/
     },
     {
          2454819.3,
          {-13.5038,0.03674,1217.3628,0.23045,0.014425,17.5485}, /*cmx*/
          {1.606363,0.1371,3.2163,0.3284}, /*cfx*/
          {-1.217,-0.02045,95.6019,0.05882,0.006091,1.4147}, /*cmy*/
          {1.464757,4.2915,0.3421,0.0854}, /*cfy*/
          {51.1049,0.00944,1221.2326,0.28106,0.014678,17.6834}, /*cmz*/
          {3.177028,1.6595,4.7811,1.9001} /*cfz*/
     },
     {
          2454889.3,
          {-10.143,0.04672,1217.8318,1.97119,0.010076,17.5069}, /*cmx*/
          {4.095567,5.7046,2.5453,5.2968}, /*cfx*/
          {-3.0122,-0.01804,106.5708,0.87406,0.005076,1.7627}, /*cmy*/
          {3.682781,2.8109,5.8604,4.7069}, /*cfy*/
          {52.0929,-0.00109,1220.7365,1.82655,0.008758,17.5971}, /*cmz*/
          {5.664365,0.986,4.0661,0.5856} /*cfz*/
     },
     {
          2454959.3,
          {-6.3607,-0.03482,1215.9377,0.26774,0.015301,17.5278}, /*cmx*/
          {0.332134,1.6477,4.9724,3.9214}, /*cfx*/
          {-4.529,0.01959,134.4384,0.03584,0.006471,1.8415}, /*cmy*/
          {5.933011,5.0357,2.1165,3.2963}, /*cfy*/
          {52.4029,-0.00641,1218.4399,0.26014,0.014665,17.5945}, /*cmz*/
          {1.897017,3.4129,0.3245,5.4929} /*cfz*/
     },
     {
          2455029.3,
          {-8.9972,-0.09799,1216.8702,1.92016,0.004974,17.585}, /*cmx*/
          {2.734395,1.1782,0.7229,2.4414}, /*cfx*/
          {-3.0899,0.04498,113.2668,0.8974,0.002393,1.3828}, /*cmy*/
          {2.251624,4.5779,3.6727,2.2989}, /*cfy*/
          {51.9141,-0.01686,1220.0819,1.85094,0.00496,17.5918}, /*cmz*/
          {4.301843,2.7687,2.1774,4.0168} /*cfz*/
     },
     {
          2455099.3,
          {-16.324,-0.07515,1218.7906,2.57585,0.008275,17.5777}, /*cmx*/
          {5.055044,3.4631,0.4436,0.925}, /*cfx*/
          {0.286,0.03191,91.5655,1.13452,0.004152,1.4998}, /*cmy*/
          {5.359138,0.4419,3.7783,1.6005}, /*cfy*/
          {50.3258,-0.03037,1221.3347,2.46132,0.007596,17.5104}, /*cmz*/
          {0.344,5.0264,2.0933,2.5024} /*cfz*/
     },
     {
          2455169.3,
          {-22.0857,-0.00814,1219.3374,1.31568,0.016835,17.6473}, /*cmx*/
          {1.104566,5.7871,2.6406,5.7549}, /*cfx*/
          {2.7242,-0.00029,121.5506,0.51108,0.00731,1.8307}, /*cmy*/
          {2.014167,2.687,5.8075,0.4276}, /*cfy*/
          {47.9821,-0.00448,1217.5507,1.29957,0.016586,17.5297}, /*cmz*/
          {2.680485,1.0671,4.2046,1.0509} /*cfz*/
     },
     {
          2455239.3,
          {-22.1898,0.05713,1219.4361,1.39375,0.001245,17.6169}, /*cmx*/
          {3.542142,5.138,5.5389,4.4203}, /*cfx*/
          {2.4831,-0.02542,121.8478,0.66152,0.000692,1.5251}, /*cmy*/
          {4.471987,2.0191,4.144,5.1648}, /*cfy*/
          {48.4378,0.01013,1217.036,1.36218,0.002008,17.4835}, /*cmz*/
          {5.117905,0.3352,1.365,5.9946} /*cfz*/
     },
     {
          2455309.3,
          {-17.5418,0.00449,1218.0258,1.26842,0.016377,17.6047}, /*cmx*/
          {6.071986,1.3514,4.4906,3.0846}, /*cfx*/
          {0.4431,0.00143,95.1146,0.48085,0.007285,1.3528}, /*cmy*/
          {0.315258,4.6192,1.4613,3.5441}, /*cfy*/
          {49.7681,0.00352,1220.3101,1.21386,0.015546,17.518}, /*cmz*/
          {1.362563,2.9163,6.054,4.657} /*cfz*/
     },
     {
          2455379.3,
          {-17.2269,-0.07665,1218.3175,1.15847,0.009205,17.619}, /*cmx*/
          {2.244268,0.6958,0.5209,1.6474}, /*cfx*/
          {0.5917,0.03672,96.1482,0.59068,0.003776,1.6007}, /*cmy*/
          {2.773102,3.9545,3.5479,2.4248}, /*cfy*/
          {49.8291,-0.02761,1220.1868,1.11082,0.009278,17.5377}, /*cmz*/
          {3.817883,2.2602,2.0029,3.2178} /*cfz*/
     },
     {
          2455449.3,
          {-22.9359,-0.08052,1219.3634,2.47524,0.00348,17.554}, /*cmx*/
          {4.590092,3.014,0.4103,0.1349}, /*cfx*/
          {3.3099,0.03282,134.3414,1.10941,0.002586,2.4032}, /*cmy*/
          {5.60283,6.1517,3.6408,1.3065}, /*cfy*/
          {47.4712,-0.04731,1216.2135,2.38174,0.003191,17.3997}, /*cmz*/
          {6.166024,4.5379,2.1706,1.7072} /*cfz*/
     },
     {
          2455519.3,
          {-29.102,-0.03839,1220.4786,2.07126,0.014941,17.6093}, /*cmx*/
          {0.625078,5.3102,2.1717,4.9295}, /*cfx*/
          {5.801,0.01035,197.2532,0.83011,0.006531,3.1207}, /*cmy*/
          {1.91437,2.0215,5.178,6.2631}, /*cfy*/
          {43.9088,-0.03441,1207.0907,2.02119,0.014364,17.3461}, /*cmz*/
          {2.203001,0.5287,3.6731,0.2185} /*cfz*/
     },
     {
          2451179.4,
          {471.5819,-31.44555,1706.3774,108.93736,0.927277,2.3572}, /*cmx*/
          {5.249304,2.9716,1.3615,4.6976}, /*cfx*/
          {-11.8719,8.66739,340.0534,16.43305,0.740743,2.3598}, /*cmy*/
          {3.751624,1.9962,0.9145,3.1611}, /*cfy*/
          {29.3374,-32.90667,1350.1839,67.37535,2.882744,9.3307}, /*cmz*/
          {0.662708,5.1748,4.0558,0.0234} /*cfz*/
     },
     {
          2451201.4,
          {560.5317,-40.96511,1692.5937,112.36819,0.471034,3.6606}, /*cmx*/
          {5.417949,3.0155,0.063,0.3396}, /*cfx*/
          {24.8063,5.98381,379.9381,23.86442,0.622495,1.4699}, /*cmy*/
          {4.014701,2.0716,0.7969,3.3772}, /*cfy*/
          {-112.117,-21.44562,1477.6154,95.08244,2.29244,5.5226}, /*cmz*/
          {0.914811,5.221,3.8864,0.2227} /*cfz*/
     },
     {
          2451223.4,
          {596.4193,-45.87147,1644.3514,113.40571,0.823467,5.6691}, /*cmx*/
          {5.614926,3.1725,5.9265,0.9545}, /*cfx*/
          {70.0189,2.44102,434.7349,33.25581,0.55374,0.3753}, /*cmy*/
          {4.245688,2.1486,0.4059,2.4848}, /*cfy*/
          {-265.974,-7.91167,1613.2988,125.32939,2.032574,1.3917}, /*cmz*/
          {1.13054,5.2875,3.4481,5.5624} /*cfz*/
     },
     {
          2451245.4,
          {578.9179,-45.8872,1585.5151,114.0306,0.898477,5.5737}, /*cmx*/
          {5.845556,3.4413,6.2476,1.5363}, /*cfx*/
          {121.7867,-1.90383,496.5336,43.93152,0.69879,1.6953}, /*cmy*/
          {4.447665,2.2394,6.2103,1.3151}, /*cfy*/
          {-418.1916,6.53219,1732.3092,154.56422,2.536874,5.7222}, /*cmz*/
          {1.318242,5.3752,3.0188,4.4561} /*cfz*/
     },
     {
          2451267.4,
          {501.2824,-40.10954,1547.8308,121.10284,1.010152,4.5536}, /*cmx*/
          {6.116356,3.8184,0.916,2.5946}, /*cfx*/
          {174.5455,-6.64691,554.1994,54.35531,1.02682,3.3392}, /*cmy*/
          {4.629931,2.3507,6.0034,1.5054}, /*cfy*/
          {-552.9842,20.42225,1813.5576,178.73816,3.462265,10.5407}, /*cmz*/
          {1.488325,5.4842,2.8546,4.6411} /*cfz*/
     },
     {
          2451289.4,
          {362.868,-28.18199,1569.6437,143.57523,2.115788,8.0749}, /*cmx*/
          {0.133806,4.2269,1.6913,3.792}, /*cfx*/
          {215.3166,-10.63641,591.6474,61.7747,1.337958,4.3539}, /*cmy*/
          {4.810144,2.5032,6.0266,1.8281}, /*cfy*/
          {-640.9994,30.88231,1829.022,191.95395,4.223783,13.1323}, /*cmz*/
          {1.656381,5.63,2.8851,4.9554} /*cfz*/
     },
     {
          2451311.4,
          {190.9664,-12.38842,1656.4403,178.90499,3.852962,14.4362}, /*cmx*/
          {0.424983,4.5641,2.0226,4.3524}, /*cfx*/
          {227.5884,-12.29115,596.1444,63.99745,1.472352,4.4098}, /*cmy*/
          {5.015737,2.7353,6.2331,2.346}, /*cfy*/
          {-648.4818,34.44794,1760.4788,190.46771,4.455266,12.907}, /*cmz*/
          {1.846412,5.8459,3.0756,5.4477} /*cfz*/
     },
     {
          2451333.4,
          {43.2321,1.99191,1746.449,210.18105,5.409801,18.8638}, /*cmx*/
          {0.674184,4.8263,2.2404,4.7643}, /*cfx*/
          {204.0101,-10.77818,573.4804,62.89078,1.478725,4.567}, /*cmy*/
          {5.273816,3.086,0.3725,3.1645}, /*cfy*/
          {-565.9567,29.76332,1631.8071,180.21229,4.31658,12.7133}, /*cmz*/
          {2.08364,6.1691,3.458,6.225} /*cfz*/
     },
     {
          2451355.4,
          {-23.0375,9.43805,1756.3915,221.02166,6.151048,19.4474}, /*cmx*/
          {0.886769,5.0679,2.4666,5.2503}, /*cfx*/
          {156.951,-7.05732,549.2783,64.06466,1.634718,6.0322}, /*cmy*/
          {5.581336,3.5205,0.9288,3.9402}, /*cfy*/
          {-429.058,19.65553,1510.2687,175.82037,4.50908,15.9519}, /*cmz*/
          {2.370283,0.2971,3.9811,0.7206} /*cfz*/
     },
     {
          2451377.4,
          {6.338,8.20326,1660.6162,209.56107,6.024376,18.6377}, /*cmx*/
          {1.091799,5.3456,2.7704,5.9322}, /*cfx*/
          {113.8639,-3.55065,540.0658,68.09636,1.944499,7.3365}, /*cmy*/
          {5.88253,3.9131,1.3767,4.5165}, /*cfy*/
          {-305.7451,10.13753,1443.3868,180.98433,5.156983,19.2731}, /*cmz*/
          {2.661323,0.6873,4.433,1.3054} /*cfz*/
     },
     {
          2451399.4,
          {86.0247,2.0415,1518.4003,190.69544,5.677416,20.2687}, /*cmx*/
          {1.31643,5.6867,3.1745,0.401}, /*cfx*/
          {97.9433,-2.41103,531.9703,68.58858,2.080181,7.3493}, /*cmy*/
          {6.123405,4.216,1.6968,5.1135}, /*cfy*/
          {-253.514,6.549,1404.9421,181.15814,5.495931,19.5081}, /*cmz*/
          {2.902395,0.9957,4.7613,1.8923} /*cfz*/
     },
     {
          2451421.4,
          {140.2868,-2.25168,1424.1501,180.06033,5.681091,22.0182}, /*cmx*/
          {1.557847,6.0377,3.5767,1.0427}, /*cfx*/
          {110.1468,-3.82915,507.4597,62.3912,1.921409,7.1075}, /*cmy*/
          {0.02888,4.4816,1.9969,5.8659}, /*cfy*/
          {-278.7737,9.73251,1347.5315,166.58546,5.139967,18.9016}, /*cmz*/
          {3.092468,1.262,5.0595,2.631} /*cfz*/
     },
     {
          2451443.4,
          {118.458,0.12749,1418.467,175.38497,5.739588,20.8751}, /*cmx*/
          {1.778462,0.0234,3.8609,1.7001}, /*cfx*/
          {129.3169,-5.95031,472.0297,53.70315,1.675262,7.6912}, /*cmy*/
          {0.216559,4.7743,2.3575,0.3274}, /*cfy*/
          {-332.3762,15.42679,1272.48,145.34343,4.526124,20.6771}, /*cmz*/
          {3.27899,1.5525,5.4157,3.3869} /*cfz*/
     },
     {
          2451465.4,
          {32.5452,8.40302,1459.6867,166.67026,5.431571,19.8955}, /*cmx*/
          {1.961494,0.206,4.0522,2.5071}, /*cfx*/
          {130.9728,-6.52898,448.1369,49.08841,1.607419,7.8907}, /*cmy*/
          {0.447312,5.0935,2.731,0.9486}, /*cfy*/
          {-348.3704,17.66602,1229.4861,134.39487,4.381148,21.9951}, /*cmz*/
          {3.510818,1.8798,5.8023,4.0184} /*cfz*/
     },
     {
          2451487.4,
          {-55.7641,17.183,1483.7798,152.73675,4.875555,22.1393}, /*cmx*/
          {2.138071,0.3774,4.2498,3.274}, /*cfx*/
          {107.4507,-4.78393,452.361,50.01782,1.713297,7.0704}, /*cmy*/
          {0.708388,5.3558,2.989,1.5928}, /*cfy*/
          {-296.291,13.5747,1266.668,139.85816,4.788676,20.3812}, /*cmz*/
          {3.781375,2.16,6.0813,4.6595} /*cfz*/
     },
     {
          2451509.4,
          {-87.698,21.14133,1468.36,140.93385,4.543866,23.7933}, /*cmx*/
          {2.347991,0.617,4.539,3.8766}, /*cfx*/
          {71.0116,-1.75031,476.7788,52.80408,1.836392,6.5013}, /*cmy*/
          {0.950884,5.5381,3.1487,2.3599}, /*cfy*/
          {-201.7163,5.39359,1366.6484,151.63576,5.286291,18.9115}, /*cmz*/
          {4.036971,2.3543,6.2512,5.4291} /*cfz*/
     },
     {
          2451531.4,
          {-50.5655,19.00982,1445.5045,139.96861,4.813872,22.578}, /*cmx*/
          {2.600558,0.9242,4.8801,4.4527}, /*cfx*/
          {40.6604,0.86757,499.2464,54.09224,1.890563,6.9824}, /*cmy*/
          {1.158615,5.6982,3.3057,3.0713}, /*cfy*/
          {-118.8305,-1.89386,1455.736,158.09996,5.541794,20.3762}, /*cmz*/
          {4.253711,2.517,0.125,6.1614} /*cfz*/
     },
     {
          2451553.4,
          {22.7339,13.66619,1452.4502,149.0603,5.486251,21.0132}, /*cmx*/
          {2.861858,1.2123,5.1653,5.0995}, /*cfx*/
          {28.4904,1.93259,506.5556,53.1466,1.889115,7.4872}, /*cmy*/
          {1.348713,5.8921,3.5281,3.6237}, /*cfy*/
          {-86.4188,-4.57569,1480.6939,155.49572,5.53732,21.8776}, /*cmz*/
          {4.446648,2.7065,0.341,0.4444} /*cfz*/
     },
     {
          2451575.4,
          {85.0172,9.36639,1480.0796,157.16922,6.023032,21.5465}, /*cmx*/
          {3.0861,1.4357,5.3883,5.7292}, /*cfx*/
          {35.2666,1.30197,501.0596,51.53089,1.921368,7.3503}, /*cmy*/
          {1.540806,6.143,3.8269,4.1269}, /*cfy*/
          {-106.6157,-2.24882,1444.6941,148.20204,5.521879,21.2229}, /*cmz*/
          {4.63555,2.9477,0.6299,0.9486} /*cfz*/
     },
     {
          2451597.4,
          {103.6347,9.12038,1489.5978,154.80476,6.088433,22.5971}, /*cmx*/
          {3.255756,1.6151,5.5986,6.231}, /*cfx*/
          {52.7338,-0.34945,494.53,51.3451,2.059334,6.9842}, /*cmy*/
          {1.739753,0.1417,4.1452,4.6776}, /*cfy*/
          {-152.7893,2.79927,1387.0994,142.88196,5.716641,19.6202}, /*cmz*/
          {4.826278,3.2184,0.9395,1.4901} /*cfz*/
     },
     {
          2451619.4,
          {71.7634,13.62097,1456.6793,140.10769,5.702752,21.8549}, /*cmx*/
          {3.380697,1.7865,5.8443,0.3642}, /*cfx*/
          {68.3358,-1.92986,498.413,52.72466,2.251533,7.1213}, /*cmy*/
          {1.930211,0.3921,4.4156,5.2515}, /*cfy*/
          {-189.2982,7.34393,1346.7998,140.92733,6.011989,19.1956}, /*cmz*/
          {5.006419,3.4604,1.2042,2.0534} /*cfz*/
     },
     {
          2451641.4,
          {5.0407,21.50424,1386.1673,117.77396,5.167254,19.1224}, /*cmx*/
          {3.481186,1.9838,6.1582,0.7899}, /*cfx*/
          {70.1462,-2.36108,516.3945,53.48186,2.36009,7.7082}, /*cmy*/
          {2.087405,0.5666,4.6237,5.7366}, /*cfy*/
          {-187.8776,8.71839,1339.5993,137.7804,6.090847,19.9381}, /*cmz*/
          {5.154811,3.6299,1.4062,2.5344} /*cfz*/
     },
     {
          2451663.4,
          {-68.267,30.21269,1303.1092,95.77482,4.850456,16.0805}, /*cmx*/
          {3.579657,2.2289,0.2422,1.3106}, /*cfx*/
          {51.0005,-0.9505,544.3495,51.35021,2.270354,7.9667}, /*cmy*/
          {2.198312,0.656,4.7911,6.1097}, /*cfy*/
          {-135.8488,5.5899,1360.1689,128.87625,5.718961,20.0175}, /*cmz*/
          {5.25968,3.7147,1.5629,2.9039} /*cfz*/
     },
     {
          2451685.4,
          {-117.7403,36.93244,1239.8646,81.01513,4.850178,14.8648}, /*cmx*/
          {3.696645,2.4961,0.5834,1.9114}, /*cfx*/
          {10.9936,2.3733,575.2514,45.86088,1.949958,7.3157}, /*cmy*/
          {2.27094,0.6601,4.949,0.1434}, /*cfy*/
          {-37.4104,-1.88723,1395.4926,113.8098,4.856612,18.1312}, /*cmz*/
          {5.327556,3.7137,1.6998,3.2096} /*cfz*/
     },
     {
          2451707.4,
          {-119.8277,39.4106,1225.6865,74.92845,4.901378,15.4122}, /*cmx*/
          {3.842945,2.6876,0.8344,2.4321}, /*cfx*/
          {-42.4645,7.03759,602.2842,38.67764,1.45714,5.7396}, /*cmy*/
          {2.327815,0.5751,5.1405,0.482}, /*cfy*/
          {89.5802,-12.33084,1432.1878,96.4893,3.637172,14.2444}, /*cmz*/
          {5.37857,3.6248,1.848,3.5183} /*cfz*/
     },
     {
          2451729.4,
          {-63.9044,36.51116,1277.0426,75.29816,4.691283,15.549}, /*cmx*/
          {4.012333,2.7214,0.9906,2.8112}, /*cfx*/
          {-97.05,12.02104,619.3126,32.59721,0.926602,3.7894}, /*cmy*/
          {2.396046,0.4168,5.4569,0.9768}, /*cfy*/
          {219.5322,-23.6402,1456.9704,82.6568,2.308994,9.3865}, /*cmz*/
          {5.437617,3.4662,2.0665,3.9369} /*cfz*/
     },
     {
          2451751.4,
          {45.8082,28.39889,1388.9496,82.42004,4.09481,13.7351}, /*cmx*/
          {4.188632,2.624,1.0639,3.1017}, /*cfx*/
          {-139.6926,16.20898,622.2236,29.28245,0.562066,2.5861}, /*cmy*/
          {2.500398,0.273,6.1007,1.8512}, /*cfy*/
          {326.4542,-33.63511,1458.5977,75.31592,1.204988,5.6206}, /*cmz*/
          {5.527893,3.3157,2.5381,4.7117} /*cfz*/
     },
     {
          2451773.4,
          {193.5269,16.25238,1535.8969,97.72535,3.192847,9.7828}, /*cmx*/
          {4.362263,2.5043,1.0401,3.3526}, /*cfx*/
          {-160.8012,18.75532,611.9112,27.94918,0.517668,2.7707}, /*cmy*/
          {2.659516,0.2711,0.6265,2.7587}, /*cfy*/
          {390.6857,-40.63431,1433.8123,72.23444,0.81857,5.3386}, /*cmz*/
          {5.667876,3.2801,3.5574,5.7728} /*cfz*/
     },
     {
          2451795.4,
          {359.303,1.60892,1684.4804,119.00605,2.250494,4.3684}, /*cmx*/
          {4.535004,2.4454,0.8293,3.5529}, /*cfx*/
          {-156.2111,19.23875,595.9774,27.79805,0.552646,3.0056}, /*cmy*/
          {2.88316,0.4772,1.0429,3.3297}, /*cfy*/
          {401.6806,-43.65911,1392.5335,70.45938,0.993721,6.3131}, /*cmz*/
          {5.870245,3.422,4.2348,0.1714} /*cfz*/
     },
     {
          2451817.4,
          {524.8972,-14.12487,1805.2908,141.46997,1.824519,1.7188}, /*cmx*/
          {4.713018,2.4625,0.2928,1.1685}, /*cfx*/
          {-125.7113,17.51155,587.1372,30.47854,0.452775,2.4244}, /*cmy*/
          {3.168637,0.864,1.1175,3.7872}, /*cfy*/
          {354.6106,-42.05337,1358.9054,72.00237,0.938004,5.7664}, /*cmz*/
          {6.140425,3.7583,4.4399,0.669} /*cfz*/
     },
     {
          2451839.4,
          {670.6914,-29.28394,1873.0757,159.69785,2.290944,6.9964}, /*cmx*/
          {4.902405,2.547,6.1157,1.2219}, /*cfx*/
          {-70.592,13.47843,599.2871,38.75923,0.288745,0.9199}, /*cmy*/
          {3.495267,1.293,0.4021,4.5037}, /*cfy*/
          {245.3,-34.96342,1369.6692,84.97496,0.502621,2.9868}, /*cmz*/
          {0.186252,4.2195,3.9519,1.3277} /*cfz*/
     },
     {
          2451861.4,
          {766.3749,-40.93437,1864.2814,167.77591,2.918733,10.2227}, /*cmx*/
          {5.113545,2.7039,6.0326,1.5453}, /*cfx*/
          {5.012,7.27122,639.2427,52.76574,0.642244,1.7691}, /*cmy*/
          {3.822542,1.6374,5.7368,0.8052}, /*cfy*/
          {75.2605,-21.84786,1458.0738,115.3745,1.159115,3.4304}, /*cmz*/
          {0.536247,4.6346,2.5403,3.7199} /*cfz*/
     },
     {
          2451883.4,
          {774.0427,-45.07227,1775.9635,163.23526,3.038664,10.1827}, /*cmx*/
          {5.367788,2.9696,6.2272,2.042}, /*cfx*/
          {89.0406,-0.18585,694.9991,68.80933,1.292381,4.4309}, /*cmy*/
          {4.111786,1.8919,5.6365,1.269}, /*cfy*/
          {-130.8363,-4.31283,1609.0803,156.33161,2.795585,9.8956}, /*cmz*/
          {0.853523,4.9337,2.4306,4.3356} /*cfz*/
     },
     {
          2451905.4,
          {675.0008,-39.22386,1659.9966,156.56836,2.811114,9.4094}, /*cmx*/
          {5.688311,3.3921,0.4898,2.9563}, /*cfx*/
          {160.1467,-6.96899,737.4021,81.21311,1.871881,6.3232}, /*cmy*/
          {4.356188,2.1061,5.7202,1.6211}, /*cfy*/
          {-316.8938,12.81357,1742.873,191.51809,4.367142,15.0572}, /*cmz*/
          {1.116591,5.1651,2.5185,4.7013} /*cfz*/
     },
     {
          2451927.4,
          {498.6756,-25.42759,1605.8837,168.15491,3.466463,13.7427}, /*cmx*/
          {6.057879,3.9006,1.2546,3.8916}, /*cfx*/
          {195.7527,-10.89117,740.2489,85.52124,2.157981,6.7047}, /*cmy*/
          {4.579603,2.3358,5.9057,2.0603}, /*cfy*/
          {-418.64,23.46582,1774.0762,206.34023,5.231753,16.4874}, /*cmz*/
          {1.345669,5.3936,2.696,5.1216} /*cfz*/
     },
     {
          2451949.4,
          {318.9574,-10.18915,1633.4023,195.46339,4.979983,19.383}, /*cmx*/
          {0.117387,4.3165,1.7438,4.4501}, /*cfx*/
          {186.0453,-10.85222,701.3155,82.22108,2.13664,6.3209}, /*cmy*/
          {4.816149,2.6342,6.2259,2.7329}, /*cfy*/
          {-406.3745,24.40273,1683.1278,199.24045,5.246175,15.3666}, /*cmz*/
          {1.575616,5.675,2.99,5.7477} /*cfz*/
     },
     {
          2451971.4,
          {212.3246,-0.7086,1655.5609,213.24948,6.058768,21.3813}, /*cmx*/
          {0.381719,4.6182,2.0474,4.9358}, /*cfx*/
          {143.4555,-7.80195,647.4663,77.72057,2.088919,7.116}, /*cmy*/
          {5.085343,3.0195,0.413,3.5376}, /*cfy*/
          {-309.4626,17.76282,1532.3209,184.54655,5.006329,16.2718}, /*cmz*/
          {1.829564,6.0354,3.4237,0.257} /*cfz*/
     },
     {
          2451993.4,
          {208.1103,-0.15115,1597.3625,208.00553,6.170131,20.3922}, /*cmx*/
          {0.581517,4.8783,2.3257,5.5436}, /*cfx*/
          {97.5425,-4.35417,611.959,77.46744,2.255502,8.5926}, /*cmy*/
          {5.361669,3.4131,0.8831,4.1766}, /*cfy*/
          {-198.7483,9.71662,1409.1985,177.34949,5.163142,19.1153}, /*cmz*/
          {2.091941,0.1332,3.8829,0.9146} /*cfz*/
     },
     {
          2452015.4,
          {271.8123,-5.83156,1474.5656,187.62271,5.701703,20.6974}, /*cmx*/
          {0.754255,5.1547,2.6556,6.2709}, /*cfx*/
          {76.4138,-3.11396,601.0344,78.17552,2.428037,8.9361}, /*cmy*/
          {5.585917,3.7141,1.2135,4.7496}, /*cfy*/
          {-139.7842,6.25944,1345.9508,174.41945,5.425555,19.7683}, /*cmz*/
          {2.310739,0.4341,4.2181,1.4796} /*cfz*/
     },
     {
          2452037.4,
          {332.0798,-11.45591,1366.1391,170.12742,5.40454,22.5231}, /*cmx*/
          {0.928716,5.4497,3.0158,0.6349}, /*cfx*/
          {87.6299,-4.88243,597.6944,74.33303,2.352526,8.4842}, /*cmy*/
          {5.736152,3.9213,1.4442,5.4394}, /*cfy*/
          {-152.3692,9.39,1315.3963,164.4558,5.238253,18.3173}, /*cmz*/
          {2.45764,0.635,4.4397,2.1393} /*cfz*/
     },
     {
          2452059.4,
          {331.1122,-11.67774,1341.4892,164.79742,5.503757,22.1826}, /*cmx*/
          {1.106012,5.6952,3.2903,1.2143}, /*cfx*/
          {114.2179,-8.19798,590.2819,66.28874,2.078358,8.9833}, /*cmy*/
          {5.850203,4.0937,1.6618,6.2032}, /*cfy*/
          {-204.3066,16.33632,1288.769,146.3486,4.618787,18.5808}, /*cmz*/
          {2.561163,0.7846,4.625,2.9042} /*cfz*/
     },
     {
          2452081.4,
          {260.4023,-5.48548,1405.3606,166.93464,5.68611,19.8647}, /*cmx*/
          {1.267777,5.8456,3.4376,1.8911}, /*cfx*/
          {128.5836,-10.53415,580.7516,59.15886,1.865183,10.0051}, /*cmy*/
          {5.988151,4.2972,1.9308,0.558}, /*cfy*/
          {-239.5335,21.97668,1259.2773,128.65262,4.031157,20.7091}, /*cmz*/
          {2.678181,0.9525,4.8508,3.5627} /*cfz*/
     },
     {
          2452103.4,
          {160.4429,3.63921,1500.9713,168.69579,5.727052,19.8605}, /*cmx*/
          {1.412195,5.9433,3.5288,2.6835}, /*cfx*/
          {113.0881,-10.17445,580.6671,57.95347,1.928613,9.9365}, /*cmy*/
          {6.186317,4.5486,2.2195,1.1286}, /*cfy*/
          {-217.7901,22.44375,1240.0851,121.28374,3.956816,21.1445}, /*cmz*/
          {2.852125,1.1834,5.1321,4.1224} /*cfz*/
     },
     {
          2452125.4,
          {89.3038,10.45978,1559.779,165.1773,5.59653,22.4802}, /*cmx*/
          {1.560811,6.0667,3.6656,3.3574}, /*cfx*/
          {71.7377,-7.33979,601.0512,62.8414,2.221623,9.0775}, /*cmy*/
          {0.144401,4.7911,2.4472,1.7857}, /*cfy*/
          {-139.2813,17.47398,1255.5905,127.58625,4.460275,19.4706}, /*cmz*/
          {3.081814,1.4411,5.3907,4.7352} /*cfz*/
     },
     {
          2452147.4,
          {84.0959,11.49193,1551.0993,156.99396,5.457217,23.5653}, /*cmx*/
          {1.740182,6.2777,3.9198,3.9075}, /*cfx*/
          {26.0514,-3.88877,633.9527,68.63604,2.513045,9.0971}, /*cmy*/
          {0.3813,4.9954,2.6334,2.5215}, /*cfy*/
          {-41.7981,10.28625,1307.4222,139.71339,5.124539,18.8387}, /*cmz*/
          {3.324646,1.6693,5.5999,5.4517} /*cfz*/
     },
     {
          2452169.4,
          {138.8936,7.10513,1501.2742,151.30886,5.636552,22.1894}, /*cmx*/
          {1.965125,0.3012,4.2726,4.4834}, /*cfx*/
          {0.1033,-2.00086,653.5057,69.72996,2.610705,9.9013}, /*cmy*/
          {0.591209,5.1953,2.8487,3.1472}, /*cfy*/
          {24.1137,5.42401,1353.7721,145.01739,5.463744,20.3618}, /*cmz*/
          {3.544578,1.8766,5.8139,6.1042} /*cfz*/
     },
     {
          2452191.4,
          {209.5815,1.20433,1465.7359,152.60041,6.132,21.3127}, /*cmx*/
          {2.220282,0.6288,4.6186,5.1467}, /*cfx*/
          {5.4653,-2.80144,640.8139,64.64207,2.514455,9.8919}, /*cmy*/
          {0.787367,5.444,3.1567,3.6698}, /*cfy*/
          {25.9283,5.97769,1345.8029,136.78367,5.317619,20.9453}, /*cmz*/
          {3.742607,2.1118,6.1012,0.3518} /*cfz*/
     },
     {
          2452213.4,
          {239.9468,-1.06142,1468.7394,152.63895,6.393213,22.487}, /*cmx*/
          {2.459042,0.8935,4.906,5.7607}, /*cfx*/
          {34.3747,-5.69732,601.9362,57.33217,2.438514,8.8055}, /*cmy*/
          {0.996662,5.7801,3.5697,4.23}, /*cfy*/
          {-30.7762,11.6963,1275.8358,119.98334,5.040233,18.9673}, /*cmz*/
          {3.943792,2.4282,0.2211,0.8849} /*cfz*/
     },
     {
          2452235.4,
          {195.5499,3.61731,1480.8466,139.75008,5.933486,22.7752}, /*cmx*/
          {2.645117,1.0828,5.172,6.2397}, /*cfx*/
          {64.3725,-8.73975,564.92,53.40979,2.542104,8.0241}, /*cmy*/
          {1.233557,6.1575,3.982,4.9027}, /*cfy*/
          {-104.0123,19.01898,1189.7919,107.77961,5.140482,16.6602}, /*cmz*/
          {4.172468,2.8209,0.6685,1.5395} /*cfz*/
     },
     {
          2452257.4,
          {85.1266,14.66256,1463.9153,112.2202,4.833684,19.8588}, /*cmx*/
          {2.782572,1.2248,5.4922,0.3848}, /*cfx*/
          {71.8748,-9.81355,557.8785,52.82186,2.658383,8.3811}, /*cmy*/
          {1.474123,0.1566,4.286,5.5247}, /*cfy*/
          {-139.9954,23.18684,1154.7437,105.50349,5.466813,16.8894}, /*cmz*/
          {4.421272,3.156,1.0182,2.2128} /*cfz*/
     },
     {
          2452279.4,
          {-46.5562,28.11464,1411.0128,79.07685,3.743123,14.9478}, /*cmx*/
          {2.902205,1.3557,5.9529,0.9031}, /*cfx*/
          {45.7515,-7.86984,585.6338,51.38063,2.549007,8.6705}, /*cmy*/
          {1.672134,0.2755,4.4841,5.9667}, /*cfy*/
          {-105.4112,21.12983,1200.7984,104.83829,5.436143,17.9591}, /*cmz*/
          {4.643822,3.3186,1.2408,2.7057} /*cfz*/
     },
     {
          2452301.4,
          {-148.4442,39.25765,1344.6002,52.50019,3.33403,11.6735}, /*cmx*/
          {3.038515,1.5179,0.2186,1.6266}, /*cfx*/
          {-9.0239,-3.29503,632.5977,47.9976,2.161943,7.8406}, /*cmy*/
          {1.8127,0.244,4.6141,0.012}, /*cfy*/
          {-3.0183,12.9471,1301.9296,100.62228,4.798255,16.9842}, /*cmz*/
          {4.808132,3.3093,1.3734,3.0508} /*cfz*/
     },
     {
          2452323.4,
          {-189.77,45.07564,1298.3559,40.52734,3.419513,11.757}, /*cmx*/
          {3.211834,1.7158,0.6194,2.329}, /*cfx*/
          {-77.8909,2.64463,680.8953,45.08968,1.59869,5.9391}, /*cmy*/
          {1.916288,0.1067,4.7011,0.3179}, /*cfy*/
          {138.022,1.12891,1413.4922,96.6654,3.7141,13.5091}, /*cmz*/
          {4.925111,3.179,1.4421,3.3413} /*cfz*/
     },
     {
          2452345.4,
          {-167.4836,45.02557,1298.809,43.83539,3.406378,12.3187}, /*cmx*/
          {3.416662,1.8439,0.8227,2.7938}, /*cfx*/
          {-145.5551,8.59517,718.7094,44.79536,1.002996,3.5961}, /*cmy*/
          {2.009715,6.2311,4.7465,0.7118}, /*cfy*/
          {283.0445,-11.28491,1503.3317,97.66746,2.504196,8.6688}, /*cmz*/
          {5.021282,3.0173,1.4426,3.6637} /*cfz*/
     },
     {
          2452367.4,
          {-97.3302,40.30621,1350.9182,58.38942,3.097619,11.2548}, /*cmx*/
          {3.628646,1.8846,0.8863,3.1195}, /*cfx*/
          {-201.4939,13.61974,740.7389,46.63804,0.490984,1.7032}, /*cmy*/
          {2.111676,6.1363,4.6836,1.5348}, /*cfy*/
          {407.5074,-22.12346,1557.6564,103.0009,1.458219,4.0009}, /*cmz*/
          {5.117245,2.9109,1.3049,4.2199} /*cfz*/
     },
     {
          2452389.4,
          {-0.1415,32.64427,1438.6019,79.61169,2.59738,8.4509}, /*cmx*/
          {3.827497,1.9147,0.827,3.3966}, /*cfx*/
          {-241.4934,17.34569,746.9779,48.94084,0.177924,1.6898}, /*cmy*/
          {2.231391,6.1341,3.926,2.9803}, /*cfy*/
          {501.9258,-30.5569,1577.0623,109.29304,0.837956,2.3146}, /*cmz*/
          {5.223861,2.8873,0.7937,5.8729} /*cfz*/
     },
     {
          2452411.4,
          {109.6335,23.24396,1541.9404,104.13848,2.131535,4.4143}, /*cmx*/
          {4.008628,1.9649,0.6039,3.6571}, /*cfx*/
          {-265.8139,19.80075,740.3134,50.66861,0.28001,2.5798}, /*cmy*/
          {2.371856,6.214,2.8523,3.7277}, /*cfy*/
          {567.8308,-36.75017,1569.1471,114.38212,0.879532,4.5603}, /*cmz*/
          {5.345083,2.9348,0.0912,0.5956} /*cfz*/
     },
     {
          2452433.4,
          {228.4835,12.3445,1651.2565,130.68865,2.035356,0.5033}, /*cmx*/
          {4.176169,2.0353,0.1943,1.0975}, /*cfx*/
          {-275.0446,21.03005,724.0723,51.55741,0.41902,3.0768}, /*cmy*/
          {2.535703,0.0831,2.8375,4.2357}, /*cfy*/
          {608.3361,-41.00397,1540.8688,117.43028,1.195183,6.4346}, /*cmz*/
          {5.483524,3.0402,6.1558,1.0938} /*cfz*/
     },
     {
          2452455.4,
          {358.6094,-0.32617,1764.0037,158.90558,2.581278,5.9899}, /*cmx*/
          {4.334123,2.1197,6.0956,1.1171}, /*cfx*/
          {-266.1229,20.71821,702.7077,52.13173,0.453578,2.915}, /*cmy*/
          {2.731568,0.3194,3.1627,4.781}, /*cfy*/
          {618.3223,-42.83065,1496.601,118.22259,1.405732,7.0612}, /*cmz*/
          {5.647634,3.2121,6.2464,1.5575} /*cfz*/
     },
     {
          2452477.4,
          {494.1683,-14.28134,1868.241,186.38257,3.58398,11.3735}, /*cmx*/
          {4.485745,2.2179,5.9212,1.3755}, /*cfx*/
          {-232.4472,18.18288,686.433,54.75785,0.493433,2.4475}, /*cmy*/
          {2.972616,0.6568,3.9583,5.694}, /*cfy*/
          {581.7007,-40.65511,1446.708,118.87109,1.436352,6.3449}, /*cmz*/
          {5.855022,3.4831,0.3503,2.2095} /*cfz*/
     },
     {
          2452499.4,
          {608.4831,-27.03852,1930.3981,206.58601,4.575374,15.0837}, /*cmx*/
          {4.639606,2.343,5.9146,1.6715}, /*cfx*/
          {-170.4081,12.97236,692.1845,63.39502,0.910626,3.7046}, /*cmy*/
          {3.257626,1.049,4.7439,0.5422}, /*cfy*/
          {482.3544,-32.78374,1420.412,127.04665,1.742867,7.0036}, /*cmz*/
          {6.120677,3.8642,1.0905,3.2639} /*cfz*/
     },
     {
          2452521.4,
          {657.1014,-34.30536,1907.3838,211.39008,5.064116,15.6558}, /*cmx*/
          {4.815323,2.5267,6.0472,2.0837}, /*cfx*/
          {-88.9748,5.77877,727.8257,78.24155,1.649805,6.4443}, /*cmy*/
          {3.55269,1.3964,5.1197,1.1483}, /*cfy*/
          {326.2123,-19.46399,1454.0893,150.44473,2.936205,11.8801}, /*cmz*/
          {0.144291,4.2678,1.6867,4.0622} /*cfz*/
     },
     {
          2452543.4,
          {606.0236,-32.52998,1788.9604,200.20026,4.903058,14.4817}, /*cmx*/
          {5.042789,2.8177,0.0757,2.7671}, /*cfx*/
          {-13.0189,-1.18994,770.9711,92.50874,2.3577,8.5099}, /*cmy*/
          {3.819475,1.676,5.3582,1.5767}, /*cfy*/
          {157.0692,-4.46807,1535.731,181.25671,4.486344,17.0467}, /*cmz*/
          {0.441643,4.6017,2.0194,4.5486} /*cfz*/
     },
     {
          2452565.4,
          {469.9501,-22.52238,1636.7867,188.23541,4.755669,16.6564}, /*cmx*/
          {5.344234,3.2432,0.6045,3.6312}, /*cfx*/
          {27.7099,-5.15978,780.8181,97.90419,2.707089,8.7754}, /*cmy*/
          {4.056769,1.9382,5.6009,2.0728}, /*cfy*/
          {42.5406,6.02417,1584.0115,199.50981,5.506386,18.779}, /*cmz*/
          {0.701246,4.8838,2.2803,5.0252} /*cfz*/
     },
     {
          2452587.4,
          {322.5218,-10.66956,1541.911,190.62434,5.325981,20.8624}, /*cmx*/
          {5.688022,3.7068,1.1571,4.3045}, /*cfx*/
          {20.7636,-4.82921,738.6397,92.46972,2.631,8.2736}, /*cmy*/
          {4.295062,2.2486,5.9363,2.7923}, /*cfy*/
          {26.2937,7.74724,1528.1387,193.58998,5.557109,17.6288}, /*cmz*/
          {0.942005,5.1822,2.5907,5.6872} /*cfz*/
     },
     {
          2452609.4,
          {250.2703,-4.97243,1504.0287,193.98816,5.851354,21.6409}, /*cmx*/
          {5.991603,4.0816,1.5575,4.9174}, /*cfx*/
          {-13.9638,-1.85186,672.5647,83.78814,2.464686,9.0541}, /*cmy*/
          {4.564205,2.6412,0.1165,3.5988}, /*cfy*/
          {83.6788,2.59883,1394.4704,173.9161,5.118181,18.2883}, /*cmz*/
          {1.200726,5.5537,3.0229,0.226} /*cfz*/
     },
     {
          2452631.4,
          {278.3511,-8.20406,1448.4675,180.12436,5.550082,20.3853}, /*cmx*/
          {6.225178,4.3859,1.8914,5.6806}, /*cfx*/
          {-36.7236,0.16327,632.337,79.87537,2.503936,9.8174}, /*cmy*/
          {4.847797,3.0356,0.5659,4.2712}, /*cfy*/
          {134.8649,-2.23661,1288.555,161.36927,5.030433,20.1171}, /*cmz*/
          {1.483767,5.9588,3.493,0.9338} /*cfz*/
     },
     {
          2452653.4,
          {347.0166,-15.38269,1361.554,156.25712,4.853162,21.7117}, /*cmx*/
          {0.150774,4.6968,2.2699,0.2027}, /*cfx*/
          {-22.462,-1.22442,632.5629,77.8944,2.529249,9.1124}, /*cmy*/
          {5.085213,3.3166,0.8632,4.9677}, /*cfy*/
          {116.0685,-0.66646,1274.2321,157.60146,5.142244,19.0424}, /*cmz*/
          {1.739403,6.2681,3.8231,1.6071} /*cfz*/
     },
     {
          2452675.4,
          {370.5057,-18.80874,1306.8984,143.44177,4.666561,22.7804}, /*cmx*/
          {0.386628,5.028,2.6653,0.8625}, /*cfx*/
          {17.9744,-5.22131,647.2274,72.86829,2.34636,8.7523}, /*cmy*/
          {5.263311,3.4984,1.0613,5.8134}, /*cfy*/
          {34.9972,7.01726,1313.1652,151.01564,4.929132,17.453}, /*cmz*/
          {1.932976,0.1738,4.0204,2.4301} /*cfz*/
     },
     {
          2452697.4,
          {313.1948,-15.03731,1341.3147,148.5853,5.084017,20.6603}, /*cmx*/
          {0.643454,5.2933,2.932,1.5211}, /*cfx*/
          {51.6049,-8.89781,651.5129,66.03225,2.090032,9.7508}, /*cmy*/
          {5.430946,3.6739,1.2755,0.2885}, /*cfy*/
          {-46.1092,15.34722,1340.3314,139.58546,4.471872,18.9918}, /*cmz*/
          {2.098286,0.3271,4.1981,3.2352} /*cfz*/
     },
     {
          2452719.4,
          {208.3521,-6.86212,1440.6999,160.3032,5.599026,18.9246}, /*cmx*/
          {0.875023,5.4668,3.0841,2.3171}, /*cfx*/
          {53.5003,-9.90372,643.6563,61.86007,2.013515,10.097}, /*cmy*/
          {5.63554,3.9202,1.5751,0.897}, /*cfy*/
          {-70.5721,19.04425,1332.1245,129.64725,4.197008,20.365}, /*cmz*/
          {2.284488,0.5364,4.4552,3.8614} /*cfz*/
     },
     {
          2452741.4,
          {119.1502,0.02179,1524.6749,166.13132,5.863047,20.4455}, /*cmx*/
          {1.067959,5.6149,3.2317,3.066}, /*cfx*/
          {24.368,-8.15113,639.7908,63.28943,2.21967,9.3047}, /*cmy*/
          {5.880594,4.2134,1.8898,1.5281}, /*cfy*/
          {-28.7236,16.93262,1312.9137,128.30466,4.431526,19.2715}, /*cmz*/
          {2.509169,0.8157,4.7727,4.458} /*cfz*/
     },
     {
          2452763.4,
          {88.5358,1.57179,1538.2793,161.83879,5.849385,21.7217}, /*cmx*/
          {1.242543,5.801,3.4529,3.6455}, /*cfx*/
          {-14.1563,-5.48969,648.6189,67.52796,2.51779,8.9103}, /*cmy*/
          {6.123862,4.4707,2.1432,2.2381}, /*cfy*/
          {44.4004,11.93861,1314.8203,134.96278,5.008954,18.0349}, /*cmz*/
          {2.745433,1.0892,5.0525,5.1329} /*cfz*/
     },
     {
          2452785.4,
          {115.2231,-2.28591,1488.7726,152.51435,5.841331,20.6353}, /*cmx*/
          {1.420456,6.0506,3.759,4.1867}, /*cfx*/
          {-37.1893,-4.15042,656.1846,68.46824,2.643797,9.3819}, /*cmy*/
          {0.040423,4.6744,2.3646,2.8651}, /*cfy*/
          {99.4181,8.45046,1332.8234,139.61825,5.417763,18.7175}, /*cmz*/
          {2.948974,1.3054,5.2805,5.7772} /*cfz*/
     },
     {
          2452807.4,
          {162.6957,-8.32983,1425.6973,145.96763,6.069017,19.1076}, /*cmx*/
          {1.606711,0.0481,4.0829,4.7906}, /*cfx*/
          {-32.4004,-5.29551,643.7698,62.81724,2.503033,9.3561}, /*cmy*/
          {0.190775,4.8594,2.6156,3.3575}, /*cfy*/
          {103.4814,9.50848,1334.599,133.17041,5.316998,19.3774}, /*cmz*/
          {3.099937,1.4782,5.5053,6.2818} /*cfz*/
     },
     {
          2452829.4,
          {185.0379,-12.31654,1397.0305,142.83398,6.322674,19.3611}, /*cmx*/
          {1.783888,0.284,4.3496,5.3867}, /*cfx*/
          {-4.8799,-8.5266,608.2914,52.14027,2.221709,8.1964}, /*cmy*/
          {0.311833,5.0701,2.9492,3.8252}, /*cfy*/
          {54.529,15.43136,1300.5811,114.48714,4.762636,17.9053}, /*cmz*/
          {3.208979,1.6435,5.7848,0.4329} /*cfz*/
     },
     {
          2452851.4,
          {151.205,-11.19661,1418.0486,137.03718,6.192031,20.1966}, /*cmx*/
          {1.927142,0.4239,4.5472,5.8516}, /*cfx*/
          {28.6238,-12.36246,562.9174,41.16747,2.032262,6.6793}, /*cmy*/
          {0.432603,5.3419,3.361,4.3931}, /*cfy*/
          {-22.9754,24.11323,1238.7368,89.7885,4.151194,14.7195}, /*cmz*/
          {3.302673,1.8408,6.1613,0.9198} /*cfz*/
     },
     {
          2452873.4,
          {56.2478,-4.19736,1474.6149,124.87636,5.46754,19.2428}, /*cmx*/
          {2.029907,0.458,4.7008,6.2023}, /*cfx*/
          {49.7933,-15.13542,527.2411,34.2828,2.019508,6.0615}, /*cmy*/
          {0.579357,5.6472,3.7442,5.0586}, /*cfy*/
          {-92.8598,32.30846,1174.4816,68.50212,3.898274,12.1998}, /*cmz*/
          {3.412836,2.0989,0.309,1.5534} /*cfz*/
     },
     {
          2452895.4,
          {-80.975,7.3072,1541.5415,109.00196,4.229201,15.7484}, /*cmx*/
          {2.108953,0.3916,4.8431,0.2328}, /*cfx*/
          {46.7167,-15.72059,517.945,32.14596,2.03744,6.3159}, /*cmy*/
          {0.760822,5.8601,4.0117,5.6119}, /*cfy*/
          {-123.0095,37.04133,1137.8595,57.59867,3.965155,12.0992}, /*cmz*/
          {3.565375,2.3681,0.6653,2.2072} /*cfz*/
     },
     {
          2452917.4,
          {-228.2349,20.6733,1593.319,95.44973,2.75094,10.6016}, /*cmx*/
          {2.190747,0.2526,5.0225,0.6122}, /*cfx*/
          {16.7346,-13.80953,541.9888,33.09913,1.933666,6.3209}, /*cmy*/
          {0.960601,5.8995,4.1679,5.9922}, /*cfy*/
          {-95.803,36.56048,1154.4345,57.34292,3.963934,12.8}, /*cmz*/
          {3.76442,2.5072,0.8916,2.6824} /*cfz*/
     },
     {
          2452939.4,
          {-352.1921,33.03685,1610.405,87.57617,1.397998,5.906}, /*cmx*/
          {2.299703,0.1202,5.3788,1.3005}, /*cfx*/
          {-35.2499,-9.76717,593.804,36.79717,1.671578,5.4749}, /*cmy*/
          {1.155486,5.8186,4.2353,6.2747}, /*cfy*/
          {-11.2198,30.64354,1233.3348,65.62293,3.639337,12.1109}, /*cmz*/
          {3.987865,2.4861,1.0057,3.0111} /*cfz*/
     },
     {
          2452961.4,
          {-427.9136,42.11131,1587.0291,83.21208,0.720072,4.9394}, /*cmx*/
          {2.453942,0.0938,0.116,2.4664}, /*cfx*/
          {-100.4708,-4.2978,659.3667,43.34651,1.302931,3.8214}, /*cmy*/
          {1.336995,5.725,4.2053,0.2315}, /*cfy*/
          {116.2814,20.34756,1357.9694,81.5532,2.998848,9.4235}, /*cmz*/
          {4.208616,2.4171,1.012,3.2665} /*cfz*/
     },
     {
          2452983.4,
          {-443.8305,46.58048,1536.8609,79.59495,0.907823,6.2876}, /*cmx*/
          {2.663247,0.2323,0.9804,3.208}, /*cfx*/
          {-169.4444,1.83263,722.9532,51.58757,0.939636,1.6994}, /*cmy*/
          {1.50959,5.6851,4.007,0.4289}, /*cfy*/
          {264.5044,7.45431,1493.9581,102.27889,2.260812,5.2512}, /*cmz*/
          {4.414891,2.3896,0.8603,3.4632} /*cfz*/
     },
     {
          2453005.4,
          {-401.7014,46.10109,1489.6283,78.96715,0.947316,6.3273}, /*cmx*/
          {2.924706,0.5436,1.1678,3.6657}, /*cfx*/
          {-233.6007,7.91098,771.574,59.62561,0.761926,0.5322}, /*cmy*/
          {1.679937,5.71,3.5625,4.2375}, /*cfy*/
          {411.131,-6.13817,1607.8189,123.23156,1.821236,0.8273}, /*cmz*/
          {4.607434,2.4205,0.476,2.8204} /*cfz*/
     },
     {
          2453027.4,
          {-311.9588,41.00711,1477.0948,87.61555,0.678809,4.3942}, /*cmx*/
          {3.218816,0.954,0.8414,4.1257}, /*cfx*/
          {-286.007,13.29723,797.2659,65.78336,0.861061,2.4191}, /*cmy*/
          {1.852149,5.7898,3.1556,4.2728}, /*cfy*/
          {539.3588,-18.86381,1679.6131,140.59433,1.97608,4.1549}, /*cmz*/
          {4.789699,2.4978,0.0575,1.1631} /*cfz*/
     },
     {
          2453049.4,
          {-186.807,31.87842,1517.5716,108.82358,0.877172,1.6362}, /*cmx*/
          {3.514787,1.3311,6.0393,5.522}, /*cfx*/
          {-321.1614,17.39682,797.6291,68.99594,1.048558,3.7069}, /*cmy*/
          {2.029775,5.918,3.0291,4.5518}, /*cfy*/
          {638.1302,-29.52804,1703.1488,152.06966,2.441578,7.6476}, /*cmz*/
          {4.965138,2.6104,6.1574,1.3672} /*cfz*/
     },
     {
          2453071.4,
          {-37.7277,19.441,1608.8555,139.69027,1.962095,5.4599}, /*cmx*/
          {3.784433,1.6154,5.671,0.8455}, /*cfx*/
          {-333.6684,19.57836,775.1794,69.03574,1.151822,4.1194}, /*cmy*/
          {2.220831,6.103,3.1153,4.9142}, /*cfy*/
          {697.2007,-36.94282,1679.7735,156.50864,2.823344,9.5269}, /*cmz*/
          {5.140821,2.7605,6.1701,1.6655} /*cfz*/
     },
     {
          2453093.4,
          {119.1872,5.06294,1726.9001,173.88799,3.350025,11.0329}, /*cmx*/
          {4.013579,1.8249,5.6316,1.244}, /*cfx*/
          {-318.4117,19.23108,738.2719,67.22131,1.139211,3.7785}, /*cmy*/
          {2.439357,0.0858,3.4092,5.474}, /*cfy*/
          {704.3053,-39.73456,1617.2675,154.47588,2.939967,9.5181}, /*cmz*/
          {5.330751,2.9681,0.0575,2.0884} /*cfz*/
     },
     {
          2453115.4,
          {257.0957,-8.72031,1829.3712,203.25687,4.666942,15.4864}, /*cmx*/
          {4.204969,1.9965,5.6869,1.5473}, /*cfx*/
          {-274.6338,16.15907,702.472,67.14139,1.178653,3.9068}, /*cmy*/
          {2.695824,0.4425,3.9448,0.0577}, /*cfy*/
          {651.0273,-36.89921,1536.4749,150.47428,2.894339,8.91}, /*cmz*/
          {5.552047,3.2603,0.4212,2.7689} /*cfz*/
     },
     {
          2453137.4,
          {342.0122,-18.56182,1870.018,219.65878,5.555834,17.3464}, /*cmx*/
          {4.373866,2.1663,5.8061,1.8866}, /*cfx*/
          {-211.2578,11.08627,683.751,72.18468,1.514998,5.558}, /*cmy*/
          {2.977433,0.8294,4.5073,0.8043}, /*cfy*/
          {544.6362,-28.89798,1472.5267,153.1052,3.167352,10.8413}, /*cmz*/
          {5.809857,3.628,0.9518,3.5882} /*cfz*/
     },
     {
          2453159.4,
          {349.2161,-21.83611,1823.3421,219.29368,5.822595,16.715}, /*cmx*/
          {4.54115,2.3684,6.004,2.3586}, /*cfx*/
          {-147.3579,5.72633,681.5264,80.2122,2.018804,7.3538}, /*cmy*/
          {3.24596,1.1612,4.8863,1.2951}, /*cfy*/
          {415.2009,-18.35247,1451.5855,166.38286,4.030004,14.9289}, /*cmz*/
          {6.080207,3.9937,1.4247,4.1826} /*cfz*/
     },
     {
          2453181.4,
          {282.7518,-18.50182,1706.147,206.97404,5.654924,16.1939}, /*cmx*/
          {4.72596,2.6296,0.022,3.0174}, /*cfx*/
          {-104.2111,2.07345,674.5159,84.81967,2.368069,7.9687}, /*cmy*/
          {3.4721,1.4268,5.1538,1.7402}, /*cfy*/
          {307.8049,-9.39215,1457.5579,181.49714,4.981107,17.7524}, /*cmz*/
          {0.039517,4.2947,1.751,4.6447} /*cfz*/
     },
     {
          2453203.4,
          {181.7787,-11.80844,1574.7717,194.14045,5.546889,17.8672}, /*cmx*/
          {4.933814,2.9441,0.4033,3.7007}, /*cfx*/
          {-92.5527,1.21818,642.6777,81.964,2.399252,7.4684}, /*cmy*/
          {3.658877,1.6673,5.4076,2.2952}, /*cfy*/
          {259.3582,-5.55123,1443.3885,185.56996,5.43162,17.8572}, /*cmz*/
          {0.235241,4.5424,2.0095,5.1526} /*cfz*/
     },
     {
          2453225.4,
          {103.2672,-6.82649,1485.8584,187.11066,5.684886,19.2713}, /*cmx*/
          {5.143384,3.2511,0.7591,4.2882}, /*cfx*/
          {-104.6077,2.5589,588.5888,73.43938,2.202922,7.1601}, /*cmy*/
          {3.831186,1.9282,5.712,2.9995}, /*cfy*/
          {273.3803,-7.39262,1382.946,174.68564,5.25565,17.1157}, /*cmz*/
          {0.398201,4.7816,2.2808,5.8117} /*cfz*/
     },
     {
          2453247.4,
          {87.1041,-7.27712,1451.2727,180.11594,5.687507,18.2781}, /*cmx*/
          {5.321418,3.4917,1.0227,4.9099}, /*cfx*/
          {-118.5908,4.14475,536.6817,65.15892,2.028994,7.4953}, /*cmy*/
          {4.01635,2.2239,6.0694,3.6819}, /*cfy*/
          {313.1682,-11.74162,1300.6692,157.46358,4.858914,18.0261}, /*cmz*/
          {0.560895,5.0498,2.6084,0.2413} /*cfz*/
     },
     {
          2453269.4,
          {127.6537,-12.82368,1441.9483,166.33703,5.265096,17.3468}, /*cmx*/
          {5.466209,3.6748,1.2297,5.6934}, /*cfx*/
          {-113.9051,4.03534,513.7105,61.37441,2.007719,7.2919}, /*cmy*/
          {4.221185,2.5037,0.1009,4.3024}, /*cfy*/
          {324.3651,-13.62159,1254.3317,147.22027,4.7607,18.7689}, /*cmz*/
          {0.751791,5.3353,2.945,0.875} /*cfz*/
     },
     {
          2453291.4,
          {175.6784,-19.0715,1425.7652,148.198,4.635642,19.1175}, /*cmx*/
          {5.619211,3.8657,1.4657,0.1897}, /*cfx*/
          {-85.8775,1.68161,525.9365,60.97915,2.04337,6.4225}, /*cmy*/
          {4.426002,2.7107,0.3096,5.0319}, /*cfy*/
          {275.2285,-9.92248,1285.1191,148.06751,4.980843,17.179}, /*cmz*/
          {0.968121,5.5746,3.1931,1.5455} /*cfz*/
     },
     {
          2453313.4,
          {175.5078,-20.84561,1399.2426,135.83839,4.35573,20.2788}, /*cmx*/
          {5.831906,4.1368,1.7967,0.8409}, /*cfx*/
          {-48.9131,-1.7085,554.0246,60.65761,2.02878,6.4373}, /*cmy*/
          {4.621478,2.8735,0.4727,5.902}, /*cfy*/
          {184.1023,-2.04997,1369.8854,152.31673,5.178137,15.9788}, /*cmz*/
          {1.185768,5.7548,3.3643,2.3941} /*cfz*/
     },
     {
          2453335.4,
          {112.0844,-16.54227,1396.9225,137.91511,4.748142,18.7832}, /*cmx*/
          {6.117581,4.4725,2.1542,1.5298}, /*cfx*/
          {-25.5827,-4.0945,572.1344,58.63103,1.962836,7.328}, /*cmy*/
          {4.829798,3.0759,0.7021,0.3573}, /*cfy*/
          {107.3455,4.97163,1434.6095,150.86679,5.13267,17.7326}, /*cmz*/
          {1.40393,5.9423,3.5624,3.2104} /*cfz*/
     },
     {
          2453357.4,
          {27.5311,-9.85909,1437.9932,147.90206,5.373189,18.0235}, /*cmx*/
          {0.143463,4.7826,2.4568,2.3465}, /*cfx*/
          {-28.8885,-4.20355,572.2942,56.36651,1.966647,7.4848}, /*cmy*/
          {5.080624,3.3797,1.0597,0.9988}, /*cfy*/
          {91.3417,6.77812,1429.9706,142.69901,4.977326,18.6681}, /*cmz*/
          {1.647657,6.2132,3.8801,3.8725} /*cfz*/
     },
     {
          2453379.4,
          {-14.2773,-6.7641,1470.4974,149.29717,5.585508,19.2275}, /*cmx*/
          {0.421909,5.0602,2.7575,3.0779}, /*cfx*/
          {-50.2544,-2.68481,570.6124,56.88088,2.14224,7.095}, /*cmy*/
          {5.372106,3.7433,1.4594,1.7207}, /*cfy*/
          {129.1224,3.73967,1384.4058,136.60606,5.108234,17.3558}, /*cmz*/
          {1.93137,0.2893,4.2901,4.5602} /*cfz*/
     },
     {
          2453401.4,
          {13.4197,-10.08975,1437.6921,136.82776,5.362475,18.6089}, /*cmx*/
          {0.669071,5.3651,3.1373,3.6864}, /*cfx*/
          {-64.9687,-1.71553,580.9776,58.23477,2.309063,7.3908}, /*cmy*/
          {5.651603,4.0526,1.7936,2.454}, /*cfy*/
          {166.0307,0.68669,1360.763,136.06125,5.430345,16.9815}, /*cmz*/
          {2.221821,0.6305,4.6588,5.31} /*cfz*/
     },
     {
          2453423.4,
          {77.3371,-17.16852,1359.6977,121.7899,5.276414,16.0757}, /*cmx*/
          {0.910823,5.7276,3.5851,4.3469}, /*cfx*/
          {-53.1639,-3.139,591.5765,54.85555,2.211248,7.6682}, /*cmy*/
          {5.86841,4.272,2.0847,3.0219}, /*cfy*/
          {149.6048,2.48186,1368.6464,130.74605,5.338601,17.7254}, /*cmz*/
          {2.459378,0.8698,4.9501,5.9226} /*cfz*/
     },
     {
          2453445.4,
          {117.0295,-22.5891,1308.8835,115.27236,5.503688,15.2333}, /*cmx*/
          {1.153696,6.0655,3.9666,5.0786}, /*cfx*/
          {-15.9015,-6.94281,585.2436,45.37486,1.850176,6.7585}, /*cmy*/
          {6.024616,4.4351,2.4144,3.4964}, /*cfy*/
          {70.3336,10.19742,1372.3934,113.56617,4.596345,16.5154}, /*cmz*/
          {2.62494,1.0142,5.2244,0.1029} /*cfz*/
     },
     {
          2453467.4,
          {91.8001,-22.46163,1332.3602,114.10597,5.557811,16.1818}, /*cmx*/
          {1.370485,6.259,4.2119,5.6485}, /*cfx*/
          {28.6316,-11.5123,561.3599,33.57538,1.47313,5.0554}, /*cmy*/
          {6.155577,4.5847,2.8547,4.0455}, /*cfy*/
          {-40.9741,21.1699,1352.5095,88.94274,3.542146,12.8867}, /*cmz*/
          {2.744907,1.0948,5.5634,0.5562} /*cfz*/
     },
     {
          2453489.4,
          {-0.6511,-16.26887,1419.5343,112.64236,5.108863,15.8989}, /*cmx*/
          {1.536388,0.0058,4.3467,6.022}, /*cfx*/
          {60.4793,-14.99053,531.7007,24.38296,1.301905,3.9364}, /*cmy*/
          {0.014865,4.7515,3.343,4.7869}, /*cfy*/
          {-142.206,31.55551,1316.7676,66.19976,2.739876,9.0443}, /*cmz*/
          {2.857259,1.1401,6.0209,1.1671} /*cfz*/
     },
     {
          2453511.4,
          {-135.292,-6.00704,1531.6922,112.17385,4.236668,13.3267}, /*cmx*/
          {1.65754,6.2072,4.3992,0.0095}, /*cfx*/
          {69.2477,-16.3366,509.3926,20.52815,1.266166,3.905}, /*cmy*/
          {0.187598,4.9168,3.6951,5.4739}, /*cfy*/
          {-204.4075,38.58741,1283.5274,52.30115,2.456175,7.5837}, /*cmz*/
          {2.989654,1.1906,0.2062,1.9548} /*cfz*/
     },
     {
          2453533.4,
          {-280.3973,5.62665,1634.8003,115.6622,3.213229,9.186}, /*cmx*/
          {1.755312,6.0923,4.3713,0.2399}, /*cfx*/
          {55.779,-15.52763,501.711,21.77287,1.194855,3.9219}, /*cmy*/
          {0.384061,5.0195,3.8677,5.9119}, /*cfy*/
          {-219.2665,41.33346,1270.0061,49.44869,2.411995,7.957}, /*cmz*/
          {3.150779,1.2892,0.5121,2.5711} /*cfz*/
     },
     {
          2453555.4,
          {-412.367,16.58635,1710.176,122.58935,2.309212,4.6023}, /*cmx*/
          {1.847676,6.0106,4.2349,0.4613}, /*cfx*/
          {27.4771,-13.17043,507.3081,26.34224,1.047851,3.3907}, /*cmy*/
          {0.583812,5.0706,3.8972,6.1984}, /*cfy*/
          {-193.6828,40.26543,1285.5376,56.37041,2.304803,7.8719}, /*cmz*/
          {3.332378,1.4252,0.6436,2.9632} /*cfz*/
     },
     {
          2453577.4,
          {-520.3454,25.93151,1752.96,130.30393,1.726918,0.3929}, /*cmx*/
          {1.944854,5.9861,3.9517,0.5911}, /*cfx*/
          {-7.479,-9.98801,519.4553,32.39247,0.878064,2.3835}, /*cmy*/
          {0.772026,5.1171,3.7961,0.1109}, /*cfy*/
          {-139.7958,36.37969,1329.1577,70.27275,2.089104,6.5752}, /*cmz*/
          {3.520408,1.5618,0.6337,3.2455} /*cfz*/
     },
     {
          2453599.4,
          {-602.8219,33.54873,1765.9297,136.70113,1.558241,3.0665}, /*cmx*/
          {2.051799,6.0148,3.5898,4.1203}, /*cfx*/
          {-43.7383,-6.48582,532.2463,38.66539,0.76302,1.1649}, /*cmy*/
          {0.945839,5.1788,3.565,0.1182}, /*cfy*/
          {-66.7281,30.4426,1394.4506,88.62503,1.871648,4.1873}, /*cmz*/
          {3.705833,1.6893,0.4799,3.447} /*cfz*/
     },
     {
          2453621.4,
          {-660.3344,39.49934,1752.8028,140.57904,1.676137,5.5753}, /*cmx*/
          {2.172498,6.0898,3.3437,4.3881}, /*cfx*/
          {-79.4119,-2.87882,543.7153,44.63725,0.763078,0.6132}, /*cmy*/
          {1.108451,5.2567,3.269,4.9776}, /*cfy*/
          {22.7868,22.66162,1476.7424,110.17703,1.84616,1.1222}, /*cmz*/
          {3.886422,1.8116,0.1849,3.1046} /*cfz*/
     },
     {
          2453643.4,
          {-688.749,43.39367,1715.4751,141.19561,1.836431,6.8712}, /*cmx*/
          {2.314351,6.2161,3.2899,4.7017}, /*cfx*/
          {-114.4944,0.78102,554.5296,50.1884,0.879469,1.747}, /*cmy*/
          {1.263553,5.3477,3.0362,4.5126}, /*cfy*/
          {129.9985,12.87947,1574.0179,134.43253,2.207235,3.3635}, /*cmz*/
          {4.062526,1.9318,6.1522,1.2425} /*cfz*/
     },
     {
          2453665.4,
          {-676.5192,44.10462,1658.0923,138.98226,1.87794,6.7237}, /*cmx*/
          {2.491079,0.133,3.4454,5.1383}, /*cfx*/
          {-148.5237,4.40529,564.9426,55.11539,1.060116,2.895}, /*cmy*/
          {1.41493,5.452,2.9223,4.6356}, /*cfy*/
          {252.9834,1.21523,1679.4108,159.9637,2.944217,7.6916}, /*cmz*/
          {4.234419,2.0526,5.9606,1.3452} /*cfz*/
     },
     {
          2453687.4,
          {-609.4375,40.15867,1597.7059,138.07174,1.896742,6.0906}, /*cmx*/
          {2.719697,0.4359,3.8827,5.9063}, /*cfx*/
          {-178.5125,7.68892,572.4576,58.79811,1.237865,3.6928}, /*cmy*/
          {1.569634,5.579,2.9175,4.8636}, /*cfy*/
          {378.2131,-11.14677,1771.6667,182.76904,3.825168,11.4719}, /*cmz*/
          {4.404344,2.1824,5.9062,1.5576} /*cfz*/
     },
     {
          2453709.4,
          {-483.5614,30.90048,1569.533,147.00495,2.420524,8.2885}, /*cmx*/
          {3.004593,0.8249,4.5044,0.5668}, /*cfx*/
          {-198.0328,10.02627,571.8056,60.31333,1.345601,3.9148}, /*cmy*/
          {1.741557,5.7506,3.0215,5.2015}, /*cfy*/
          {477.4754,-21.62078,1815.3399,196.4997,4.514939,13.4222}, /*cmz*/
          {4.580632,2.3389,5.9638,1.8418} /*cfz*/
     },
     {
          2453731.4,
          {-319.7349,17.87849,1600.9285,169.32378,3.626834,12.9479}, /*cmx*/
          {3.316791,1.2083,4.9637,1.158}, /*cfx*/
          {-199.1479,10.67394,559.0918,59.42259,1.352635,3.694}, /*cmy*/
          {1.951239,6.0014,3.2694,5.7526}, /*cfy*/
          {517.9143,-27.07483,1780.3905,196.30097,4.734475,12.9877}, /*cmz*/
          {4.779242,2.5503,6.1377,2.2671} /*cfz*/
     },
     {
          2453753.4,
          {-165.1485,5.12922,1664.3218,194.1039,4.903565,16.4438}, /*cmx*/
          {3.60995,1.527,5.2642,1.5854}, /*cfx*/
          {-178.5513,9.29655,539.3714,58.18342,1.350532,3.954}, /*cmy*/
          {2.215113,0.0726,3.7002,0.2542}, /*cfy*/
          {484.8825,-25.92091,1674.34,185.21026,4.545259,11.969}, /*cmz*/
          {5.018626,2.8487,0.1781,2.9376} /*cfz*/
     },
     {
          2453775.4,
          {-69.4155,-2.87578,1690.1118,206.20874,5.640053,16.9662}, /*cmx*/
          {3.865752,1.8043,5.5261,2.0465}, /*cfx*/
          {-144.4927,6.61351,526.5262,59.82803,1.509459,5.0709}, /*cmy*/
          {2.519266,0.4829,4.2096,0.9423}, /*cfy*/
          {400.0824,-19.88739,1552.033,175.17651,4.461419,13.3339}, /*cmz*/
          {5.302375,3.2319,0.6419,3.7052} /*cfz*/
     },
     {
          2453797.4,
          {-50.1317,-4.3816,1640.2938,201.2343,5.707956,15.8736}, /*cmx*/
          {4.098193,2.0865,5.8243,2.6555}, /*cfx*/
          {-114.5916,4.24194,524.7054,63.24988,1.760141,5.8581}, /*cmy*/
          {2.812056,0.8492,4.6185,1.4834}, /*cfy*/
          {312.7759,-13.37215,1468.7537,173.66091,4.784439,15.533}, /*cmz*/
          {5.597947,3.6226,1.0998,4.3173} /*cfz*/
     },
     {
          2453819.4,
          {-79.7828,-1.69636,1545.5809,188.26181,5.513795,15.9371}, /*cmx*/
          {4.326526,2.3967,6.1812,3.3582}, /*cfx*/
          {-102.7621,3.51979,519.4461,63.60297,1.869754,5.7212}, /*cmy*/
          {3.054106,1.1438,4.9316,2.0587}, /*cfy*/
          {266.8414,-10.48692,1423.6502,173.14505,5.082325,15.762}, /*cmz*/
          {5.855627,3.9456,1.4518,4.8803} /*cfz*/
     },
     {
          2453841.4,
          {-107.4178,0.63178,1470.8054,178.78911,5.488462,16.4684}, /*cmx*/
          {4.55161,2.7056,0.253,3.9922}, /*cfx*/
          {-107.7694,4.41959,498.8751,59.13451,1.77821,5.4029}, /*cmy*/
          {3.253295,1.4065,5.2288,2.7641}, /*cfy*/
          {271.6394,-12.30327,1381.8374,164.6234,4.966342,14.7798}, /*cmz*/
          {6.059697,4.2075,1.7417,5.5476} /*cfz*/
     },
     {
          2453863.4,
          {-95.6069,-0.85192,1453.3226,174.36036,5.565811,15.2728}, /*cmx*/
          {4.753775,2.9551,0.5242,4.6138}, /*cfx*/
          {-115.0839,5.65465,469.0746,52.88448,1.628802,5.5044}, /*cmy*/
          {3.443773,1.6768,5.5547,3.4727}, /*cfy*/
          {299.1148,-16.4335,1331.3406,150.06089,4.587331,15.0256}, /*cmz*/
          {6.236021,4.4539,2.0372,6.28} /*cfz*/
     },
     {
          2453885.4,
          {-44.3399,-6.24906,1478.3315,169.53866,5.480068,13.5881}, /*cmx*/
          {4.922001,3.1325,0.7124,5.3798}, /*cfx*/
          {-109.6758,5.81865,445.8936,48.82742,1.572377,5.309}, /*cmy*/
          {3.651902,1.949,5.8697,4.1008}, /*cfy*/
          {306.7589,-19.02049,1294.0321,139.105,4.390545,15.7151}, /*cmz*/
          {0.138774,4.7132,2.3529,0.641} /*cfz*/
     },
     {
          2453907.4,
          {13.2944,-12.58112,1505.4147,161.44971,5.202039,14.277}, /*cmx*/
          {5.073805,3.2819,0.8814,6.2016}, /*cfx*/
          {-88.0782,4.51224,437.7243,47.6223,1.597772,4.5243}, /*cmy*/
          {3.873392,2.181,6.1085,4.7874}, /*cfy*/
          {268.9598,-17.59798,1300.0132,138.606,4.601963,14.7334}, /*cmz*/
          {0.349977,4.965,2.6294,1.2605} /*cfz*/
     },
     {
          2453929.4,
          {38.6238,-16.22858,1506.5749,152.00759,4.935285,15.7837}, /*cmx*/
          {5.239399,3.464,1.1026,0.5857}, /*cfx*/
          {-59.9852,2.54346,436.1226,46.83432,1.604846,4.0545}, /*cmy*/
          {4.087719,2.3684,0.0093,5.6229}, /*cfy*/
          {194.9383,-12.82219,1352.8301,145.58806,5.025479,13.157}, /*cmz*/
          {0.56908,5.1765,2.8375,2.0079} /*cfz*/
     },
     {
          2453951.4,
          {17.374,-15.69814,1486.6524,145.7551,4.931314,15.6547}, /*cmx*/
          {5.437128,3.7065,1.3931,1.1965}, /*cfx*/
          {-39.0671,1.12991,425.1984,44.23576,1.537351,4.2079}, /*cmy*/
          {4.291374,2.5562,0.2138,0.104}, /*cfy*/
          {120.8732,-7.87559,1415.4352,151.08418,5.336408,13.5939}, /*cmz*/
          {0.774521,5.3621,3.0272,2.8095} /*cfz*/
     },
     {
          2453973.4,
          {-29.2623,-12.74736,1471.2622,144.49169,5.185931,14.9386}, /*cmx*/
          {5.657506,3.9745,1.6956,1.8737}, /*cfx*/
          {-31.7197,0.87004,398.8883,39.87525,1.427288,4.1229}, /*cmy*/
          {4.49967,2.7913,0.4953,0.7354}, /*cfy*/
          {82.0841,-5.99155,1441.4806,148.8147,5.385964,14.7492}, /*cmz*/
          {0.9672,5.5649,3.2645,3.4667} /*cfz*/
     },
     {
          2453995.4,
          {-60.3363,-11.06953,1469.4953,142.35255,5.328055,15.3568}, /*cmx*/
          {5.869153,4.2143,1.9719,2.5395}, /*cfx*/
          {-33.0594,1.34178,366.4644,35.6543,1.350183,3.6985}, /*cmy*/
          {4.725019,3.0777,0.8383,1.3855}, /*cfy*/
          {86.0225,-7.94551,1419.5266,140.35363,5.327846,14.4012}, /*cmz*/
          {1.163322,5.8169,3.5783,4.0658} /*cfz*/
     },
     {
          2454017.4,
          {-44.8862,-13.61676,1460.6368,131.13644,5.008452,15.4614}, /*cmx*/
          {6.049856,4.4161,2.2525,3.0815}, /*cfx*/
          {-32.3438,1.56183,342.3453,32.72105,1.306266,3.5024}, /*cmy*/
          {4.956261,3.3551,1.1624,2.0663}, /*cfy*/
          {106.0802,-11.36743,1383.8019,132.5485,5.391298,13.576}, /*cmz*/
          {1.373876,6.102,3.9234,4.7323} /*cfz*/
     },
     {
          2454039.4,
          {15.7119,-20.48902,1423.1359,109.56384,4.300067,13.4315}, /*cmx*/
          {6.207697,4.6103,2.6062,3.5767}, /*cfx*/
          {-21.5096,0.75856,332.955,30.16349,1.214897,3.5024}, /*cmy*/
          {5.162748,3.5534,1.4247,2.6216}, /*cfy*/
          {99.9814,-12.30673,1382.3826,128.10637,5.445949,14.0708}, /*cmz*/
          {1.588249,0.0633,4.2199,5.3786} /*cfz*/
     },
     {
          2454061.4,
          {88.1697,-28.83171,1361.5319,85.34135,3.711882,10.2295}, /*cmx*/
          {0.090997,4.8447,3.0761,4.1999}, /*cfx*/
          {0.343,-1.19976,335.1801,26.97781,1.030235,3.1957}, /*cmy*/
          {5.328532,3.6554,1.6497,3.0364}, /*cfy*/
          {38.2727,-7.80934,1432.6629,122.87605,5.105653,14.5259}, /*cmz*/
          {1.781681,0.2027,4.4412,5.859} /*cfz*/
     },
     {
          2454083.4,
          {127.3863,-34.54319,1308.4163,70.11148,3.619131,8.9519}, /*cmx*/
          {0.300728,5.1372,3.5454,5.0089}, /*cfx*/
          {28.5535,-3.92857,343.5291,23.41044,0.778541,2.444}, /*cmy*/
          {5.467997,3.6814,1.8961,3.4121}, /*cfy*/
          {-77.3159,2.31357,1510.0438,114.23625,4.194055,12.8252}, /*cmz*/
          {1.94519,0.2289,4.6079,6.2111} /*cfz*/
     },
     {
          2454105.4,
          {101.9549,-34.55365,1308.4863,70.21592,3.694224,9.7315}, /*cmx*/
          {0.561995,5.383,3.8493,5.6344}, /*cfx*/
          {56.483,-6.84296,353.7985,20.33657,0.530112,1.4955}, /*cmy*/
          {5.610071,3.6742,2.259,3.918}, /*cfy*/
          {-216.0848,15.52037,1572.8342,104.87921,2.898039,8.8719}, /*cmz*/
          {2.09461,0.1815,4.7528,0.2477} /*cfz*/
     },
     {
          2454127.4,
          {9.0467,-28.24431,1384.91,82.95448,3.515956,9.5762}, /*cmx*/
          {0.840754,5.4918,3.9744,5.9863}, /*cfx*/
          {77.5648,-9.33357,363.1569,18.42037,0.379139,0.918}, /*cmy*/
          {5.780916,3.707,2.8349,4.9123}, /*cfy*/
          {-337.103,28.09176,1591.0349,97.75105,1.608478,4.2111}, /*cmz*/
          {2.253852,0.1408,4.924,0.7042} /*cfz*/
     },
     {
          2454149.4,
          {-128.6067,-17.32417,1513.9206,103.01559,3.083245,7.5231}, /*cmx*/
          {1.094428,5.5286,3.9437,6.1573}, /*cfx*/
          {86.4626,-10.84942,371.0435,18.02702,0.358704,1.0807}, /*cmy*/
          {5.993869,3.8586,3.3769,5.8734}, /*cfy*/
          {-410.9917,37.06972,1562.5599,92.50535,0.689813,1.7181}, /*cmz*/
          {2.439762,0.1891,5.2663,2.1962} /*cfz*/
     },
     {
          2454171.4,
          {-278.8739,-4.50934,1647.2648,125.02273,2.679376,4.5276}, /*cmx*/
          {1.30872,5.5657,3.7698,6.0598}, /*cfx*/
          {80.8957,-11.05807,379.8226,19.7133,0.36788,1.1723}, /*cmy*/
          {6.24292,4.1307,3.561,0.0211}, /*cfy*/
          {-430.6085,41.34278,1510.7634,88.89961,0.361025,2.9091}, /*cmz*/
          {2.655888,0.3612,6.0292,3.317} /*cfz*/
     },
     {
          2454193.4,
          {-417.0052,7.95985,1750.5441,144.64405,2.567215,3.2214}, /*cmx*/
          {1.489774,5.6245,3.5214,5.2836}, /*cfx*/
          {62.7521,-9.98666,391.8629,23.77247,0.369877,0.8421}, /*cmy*/
          {0.221579,4.4272,3.4016,0.1848}, /*cfy*/
          {-405.6544,41.34881,1465.8697,89.3844,0.417403,3.0336}, /*cmz*/
          {2.892935,0.6355,6.1939,3.74} /*cfz*/
     },
     {
          2454215.4,
          {-530.8941,18.86839,1812.8239,159.70819,2.75119,5.2189}, /*cmx*/
          {1.647268,5.7038,3.3244,4.8028}, /*cfx*/
          {36.4831,-7.93381,406.1026,29.40305,0.431682,0.3249}, /*cmy*/
          {0.471184,4.6757,3.0565,5.6851}, /*cfy*/
          {-349.8877,38.04282,1448.1329,96.76491,0.698235,1.649}, /*cmz*/
          {3.13528,0.9481,5.8357,4.1782} /*cfz*/
     },
     {
          2454237.4,
          {-615.901,27.65026,1835.769,169.5749,3.053176,7.4481}, /*cmx*/
          {1.789882,5.8009,3.236,4.8285}, /*cfx*/
          {6.8215,-5.29025,418.6004,35.28178,0.584017,0.9252}, /*cmy*/
          {0.695056,4.8714,2.8022,4.5257}, /*cfy*/
          {-273.2107,32.18976,1464.7865,111.57804,1.283063,1.2116}, /*cmz*/
          {3.368739,1.236,5.6372,0.4986} /*cfz*/
     },
     {
          2454259.4,
          {-668.6566,33.8697,1823.9122,174.22715,3.313533,8.7243}, /*cmx*/
          {1.926493,5.9195,3.249,5.0177}, /*cfx*/
          {-21.8779,-2.47115,424.5313,40.18457,0.773679,1.7875}, /*cmy*/
          {0.891497,5.0323,2.6999,4.5617}, /*cfy*/
          {-181.92,24.33671,1513.728,132.19321,2.104919,4.5921}, /*cmz*/
          {3.583924,1.4732,5.5844,1.049} /*cfz*/
     },
     {
          2454281.4,
          {-684.7139,37.00914,1782.3543,174.20682,3.454145,8.8684}, /*cmx*/
          {2.067342,6.0698,3.3573,5.3278}, /*cfx*/
          {-45.5412,0.09455,419.4422,43.11063,0.936827,2.4218}, /*cmy*/
          {1.066107,5.1769,2.6958,4.7281}, /*cfy*/
          {-82.958,15.15111,1584.8723,155.69295,3.064415,8.306}, /*cmz*/
          {3.776333,1.6642,5.5978,1.3058} /*cfz*/
     },
     {
          2454303.4,
          {-661.0253,36.68039,1719.7184,171.30338,3.502108,8.4365}, /*cmx*/
          {2.222935,6.2647,3.5679,5.8045}, /*cfx*/
          {-60.6103,2.00422,400.2656,43.37527,1.026026,2.6568}, /*cmy*/
          {1.22881,5.3235,2.7596,4.9584}, /*cfy*/
          {12.7634,5.70125,1660.1698,178.21481,4.027977,11.5448}, /*cmz*/
          {3.946484,1.8255,5.6501,1.5377} /*cfz*/
     },
     {
          2454325.4,
          {-600.1913,33.00685,1650.5211,168.88464,3.607996,8.8265}, /*cmx*/
          {2.40063,0.2261,3.8776,0.1555}, /*cfx*/
          {-65.1584,2.99843,366.9538,40.89293,1.02065,2.4814}, /*cmy*/
          {1.392458,5.4915,2.8887,5.2783}, /*cfy*/
          {90.4796,-2.55672,1716.5724,195.4434,4.831742,13.5565}, /*cmz*/
          {4.099869,1.9762,5.7378,1.7938} /*cfz*/
     },
     {
          2454347.4,
          {-513.8774,26.94497,1592.0264,170.32466,3.944167,10.7657}, /*cmx*/
          {2.599415,0.5048,4.2332,0.7528}, /*cfx*/
          {-60.0642,3.08328,323.7571,36.42585,0.938078,2.0992}, /*cmy*/
          {1.571184,5.7012,3.0961,5.7483}, /*cfy*/
          {135.7426,-8.15714,1733.4113,203.8663,5.332864,13.9718}, /*cmz*/
          {4.245958,2.1354,5.8684,2.119} /*cfz*/
     },
     {
          2454369.4,
          {-422.4444,20.27277,1553.8673,175.57744,4.47851,12.9897}, /*cmx*/
          {2.807467,0.7845,4.5603,1.2296}, /*cfx*/
          {-49.213,2.56341,278.748,31.4606,0.830956,1.8476}, /*cmy*/
          {1.775964,5.9663,3.3927,0.0959}, /*cfy*/
          {141.429,-10.27247,1702.3172,202.59899,5.492497,13.28}, /*cmz*/
          {4.396439,2.3215,6.0555,2.5656} /*cfz*/
     },
     {
          2454391.4,
          {-349.0535,15.07435,1528.8614,179.98105,4.95427,14.0081}, /*cmx*/
          {3.009084,1.0428,4.8387,1.6766}, /*cfx*/
          {-38.037,1.91866,240.6637,27.44874,0.753288,1.8244}, /*cmy*/
          {2.005495,6.2749,3.7503,0.736}, /*cfy*/
          {114.2736,-9.33852,1634.9072,194.6254,5.43383,12.7978}, /*cmz*/
          {4.562254,2.5469,0.0243,3.1425} /*cfz*/
     },
     {
          2454413.4,
          {-308.8316,12.75614,1498.7172,178.11585,5.132274,13.6348}, /*cmx*/
          {3.198187,1.2852,5.0984,2.2008}, /*cfx*/
          {-30.981,1.57176,214.528,24.8402,0.714159,1.7967}, /*cmy*/
          {2.23972,0.301,4.0996,1.3081}, /*cfy*/
          {75.8967,-7.1966,1560.7178,185.3867,5.366951,13.0947}, /*cmz*/
          {4.748068,2.8068,0.3227,3.7539} /*cfz*/
     },
     {
          2454435.4,
          {-298.2789,13.05258,1453.5907,169.1576,5.00976,13.194}, /*cmx*/
          {3.385463,1.5362,5.3815,2.8466}, /*cfx*/
          {-29.5192,1.69361,200.196,23.13951,0.687242,1.6782}, /*cmy*/
          {2.453485,0.5764,4.4045,1.9089}, /*cfy*/
          {54.0792,-6.34546,1509.815,178.0512,5.359676,12.9651}, /*cmz*/
          {4.946877,3.0721,0.6188,4.3512} /*cfz*/
     },
     {
          2454457.4,
          {-293.896,13.84494,1407.6326,158.73953,4.851156,13.4531}, /*cmx*/
          {3.592293,1.8163,5.706,3.518}, /*cfx*/
          {-32.0523,2.17345,195.3712,21.90853,0.66044,1.651}, /*cmy*/
          {2.642101,0.8244,4.6885,2.604}, /*cfy*/
          {65.6871,-8.39665,1489.3437,170.52653,5.256589,11.8342}, /*cmz*/
          {5.146048,3.3153,0.8821,5.0374} /*cfz*/
     },
     {
          2454479.4,
          {-266.6803,12.43727,1393.1618,154.17376,4.919191,12.9644}, /*cmx*/
          {3.831615,2.1107,6.0313,4.1645}, /*cfx*/
          {-35.1815,2.71898,198.5789,21.27087,0.651674,1.8302}, /*cmy*/
          {2.827207,1.0766,4.9911,3.2919}, /*cfy*/
          {101.9695,-12.68625,1479.3789,159.5032,4.934339,11.5247}, /*cmz*/
          {5.345944,3.5442,1.1362,5.87} /*cfz*/
     },
     {
          2454501.4,
          {-206.4004,7.78569,1427.7188,156.02346,5.146986,11.28}, /*cmx*/
          {4.090481,2.3791,0.0226,4.9202}, /*cfx*/
          {-35.0766,2.9767,209.5243,21.74829,0.693075,1.9961}, /*cmy*/
          {3.038729,1.353,5.3146,3.9174}, /*cfy*/
          {131.9674,-16.49802,1457.7279,146.43155,4.543233,12.664}, /*cmz*/
          {5.566435,3.7998,1.4363,0.3598} /*cfz*/
     },
     {
          2454523.4,
          {-133.6846,1.68793,1484.3609,157.81778,5.280175,10.9087}, /*cmx*/
          {4.346393,2.6166,0.2649,5.8338}, /*cfx*/
          {-29.5661,2.73043,227.8622,23.57325,0.791106,1.9483}, /*cmy*/
          {3.285653,1.6341,5.6144,4.6057}, /*cfy*/
          {128.1752,-17.34536,1428.8858,137.67799,4.417111,12.8397}, /*cmz*/
          {5.826829,4.1104,1.7996,1.0348} /*cfz*/
     },
     {
          2454545.4,
          {-82.7964,-2.70195,1516.1426,154.6611,5.233016,12.1215}, /*cmx*/
          {4.596445,2.8613,0.5359,0.3485}, /*cfx*/
          {-20.8291,2.16387,249.4761,25.74519,0.896513,1.9361}, /*cmy*/
          {3.545889,1.8917,5.8773,5.4493}, /*cfy*/
          {92.809,-15.39854,1417.415,136.73126,4.637926,11.8357}, /*cmz*/
          {6.116845,4.441,2.1612,1.772} /*cfz*/
     },
     {
          2454567.4,
          {-67.8989,-3.96039,1510.4212,148.51778,5.172179,12.4582}, /*cmx*/
          {4.850287,3.1402,0.8619,1.0342}, /*cfx*/
          {-14.8513,1.82628,264.2153,26.45427,0.943389,2.1488}, /*cmy*/
          {3.796532,2.1383,6.1499,6.2414}, /*cfy*/
          {55.7096,-13.38222,1424.3889,137.6505,4.872447,11.6882}, /*cmz*/
          {0.116021,4.7411,2.4849,2.5611} /*cfz*/
     },
     {
          2454589.4,
          {-69.6619,-3.72557,1495.4637,143.58492,5.211491,12.2923}, /*cmx*/
          {5.104104,3.4274,1.1973,1.7367}, /*cfx*/
          {-15.0638,2.04811,264.1197,25.07262,0.924329,2.185}, /*cmy*/
          {4.040276,2.4087,0.1958,0.6311}, /*cfy*/
          {45.1487,-13.95758,1419.5754,132.66852,4.851148,11.9089}, /*cmz*/
          {0.367631,5.016,2.8114,3.2389} /*cfz*/
     },
     {
          2454611.4,
          {-53.0343,-5.18117,1496.7574,138.36444,5.128241,12.7727}, /*cmx*/
          {5.333928,3.6649,1.4877,2.3788}, /*cfx*/
          {-17.9793,2.5156,252.1528,22.76038,0.885396,2.0089}, /*cmy*/
          {4.290763,2.7071,0.5634,1.3386}, /*cfy*/
          {61.9819,-17.31273,1387.4808,122.08655,4.692368,10.9647}, /*cmz*/
          {0.596376,5.2975,3.1776,3.8663} /*cfz*/
     },
     {
          2454633.4,
          {3.3301,-10.38473,1508.1777,127.88267,4.636137,12.6247}, /*cmx*/
          {5.520251,3.8238,1.7363,2.8695}, /*cfx*/
          {-16.3305,2.53398,238.0292,20.63872,0.830673,1.963}, /*cmy*/
          {4.545838,2.9734,0.8875,2.046}, /*cfy*/
          {79.6199,-21.05634,1352.1162,112.86512,4.654191,9.8985}, /*cmz*/
          {0.819572,5.5833,3.5468,4.5707} /*cfz*/
     },
     {
          2454655.4,
          {92.3246,-18.84174,1509.8056,111.50476,3.746683,10.5601}, /*cmx*/
          {5.669088,3.9134,1.9874,3.2753}, /*cfx*/
          {-6.1027,1.67547,226.5185,18.48136,0.712073,1.9102}, /*cmy*/
          {4.783652,3.1355,1.1185,2.5684}, /*cfy*/
          {65.1279,-22.07317,1353.7311,109.74992,4.688396,10.2364}, /*cmz*/
          {1.039864,5.8126,3.8374,5.235} /*cfz*/
     },
     {
          2454677.4,
          {185.9891,-28.09457,1492.0453,93.95062,2.77109,7.1673}, /*cmx*/
          {5.804928,3.964,2.3016,3.7327}, /*cfx*/
          {10.0207,0.12745,213.8665,15.94797,0.520509,1.5454}, /*cmy*/
          {4.992559,3.1847,1.2637,2.9233}, /*cfy*/
          {1.3656,-18.55925,1411.1533,111.746,4.528948,10.7447}, /*cmz*/
          {1.242525,5.9307,4.0154,5.6842} /*cfz*/
     },
     {
          2454699.4,
          {254.6444,-35.4112,1460.5349,80.8195,2.085669,4.3831}, /*cmx*/
          {5.953309,4.0256,2.7104,4.4661}, /*cfx*/
          {25.2013,-1.50465,194.5508,13.29258,0.307147,0.9351}, /*cmy*/
          {5.190141,3.1776,1.3406,3.2046}, /*cfy*/
          {-105.5366,-10.7882,1508.8713,117.07833,4.068198,9.8514}, /*cmz*/
          {1.415991,5.9509,4.0889,5.9526} /*cfz*/
     },
     {
          2454721.4,
          {281.4237,-39.12834,1430.6311,75.32911,1.814302,3.861}, /*cmx*/
          {6.128811,4.1501,3.0983,5.3717}, /*cfx*/
          {33.5283,-2.64796,167.7132,10.69914,0.134245,0.3478}, /*cmy*/
          {5.412121,3.211,1.3633,3.5464}, /*cfy*/
          {-234.3343,-0.46045,1614.7345,125.10982,3.430858,7.5344}, /*cmz*/
          {1.564222,5.9297,4.0659,6.0785} /*cfz*/
     },
     {
          2454743.4,
          {264.5208,-38.91703,1419.03,78.49913,1.76069,4.0219}, /*cmx*/
          {0.048239,4.3433,3.2976,5.8752}, /*cfx*/
          {33.1025,-3.0568,138.4003,8.24417,0.033204,0.0863}, /*cmy*/
          {5.698108,3.3942,1.5419,5.469}, /*cfy*/
          {-362.2309,10.48288,1701.5459,134.4183,2.838235,4.8117}, /*cmz*/
          {1.699159,5.9191,3.9492,5.9802} /*cfz*/
     },
     {
          2454765.4,
          {210.5503,-35.23347,1436.4441,89.86811,1.788727,3.3652}, /*cmx*/
          {0.267705,4.5612,3.2873,6.0104}, /*cfx*/
          {25.7944,-2.81725,115.0321,6.58654,0.031349,0.1685}, /*cmy*/
          {6.071183,3.8239,3.0673,6.2323}, /*cfy*/
          {-473.237,20.62416,1755.1586,142.70999,2.462855,3.4443}, /*cmz*/
          {1.831973,5.9447,3.7669,5.4471} /*cfz*/
     },
     {
          2454787.4,
          {127.1781,-28.66855,1485.6061,107.78897,1.964129,2.4481}, /*cmx*/
          {0.491585,4.7654,3.1371,5.586}, /*cfx*/
          {15.3184,-2.19702,103.8392,6.72642,0.078224,0.1321}, /*cmy*/
          {0.205543,4.3858,2.9646,5.8175}, /*cfy*/
          {-558.2187,29.10043,1771.6354,147.98882,2.326317,4.2729}, /*cmz*/
          {1.971427,6.0142,3.6003,5.0183} /*cfz*/
     },
     {
          2454809.4,
          {20.7594,-19.72211,1562.6166,130.0591,2.389064,3.687}, /*cmx*/
          {0.71038,4.9463,2.9657,4.874}, /*cfx*/
          {5.3754,-1.49358,103.11,8.202,0.138095,0.2022}, /*cmy*/
          {0.561958,4.7846,2.8511,4.8912}, /*cfy*/
          {-610.5627,35.22702,1752.2684,149.14344,2.304461,5.2519}, /*cmz*/
          {2.126111,6.1335,3.5375,5.0328} /*cfz*/
     },
     {
          2454831.4,
          {-100.6933,-9.05708,1656.0376,153.85814,3.040097,6.5526}, /*cmx*/
          {0.918597,5.1093,2.8618,4.7484}, /*cfx*/
          {-1.7189,-0.91539,106.7681,9.88615,0.198404,0.3773}, /*cmy*/
          {0.797973,5.0039,2.8209,4.692}, /*cfy*/
          {-623.2706,38.22994,1702.989,146.50438,2.266875,5.3007}, /*cmz*/
          {2.30636,0.0323,3.6314,5.3147} /*cfz*/
     },
     {
          2454853.4,
          {-223.374,2.12522,1744.8539,175.31691,3.765365,9.2939}, /*cmx*/
          {1.115264,5.2653,2.8432,4.8518}, /*cfx*/
          {-5.8511,-0.50138,112.6774,11.52044,0.254357,0.5735}, /*cmy*/
          {0.924536,5.1172,2.8116,4.7163}, /*cfy*/
          {-591.0299,37.42305,1638.68,142.99384,2.238011,4.8433}, /*cmz*/
          {2.522286,0.2919,3.9201,5.9146} /*cfz*/
     },
     {
          2454875.4,
          {-327.6152,12.05676,1802.4919,190.12092,4.364417,10.916}, /*cmx*/
          {1.304268,5.4284,2.9018,5.0562}, /*cfx*/
          {-8.7545,-0.13425,123.146,13.4512,0.314996,0.8009}, /*cmy*/
          {0.987045,5.1774,2.7909,4.8173}, /*cfy*/
          {-516.2911,32.77118,1584.6096,144.1526,2.466274,5.8015}, /*cmz*/
          {2.775486,0.6214,4.3664,0.4608} /*cfz*/
     },
     {
          2454897.4,
          {-394.3151,18.96419,1809.2059,195.55519,4.689061,11.0442}, /*cmx*/
          {1.492967,5.6135,3.0352,5.3622}, /*cfx*/
          {-12.0892,0.30432,139.0518,15.84126,0.389256,1.036}, /*cmy*/
          {1.043377,5.2346,2.7782,4.9845}, /*cfy*/
          {-413.8162,25.35759,1563.7126,153.75599,3.120707,8.5398}, /*cmz*/
          {3.049354,0.9683,4.7909,1.055} /*cfz*/
     },
     {
          2454919.4,
          {-414.8311,21.97247,1765.403,192.67369,4.745363,10.2655}, /*cmx*/
          {1.688637,5.8328,3.2464,5.8083}, /*cfx*/
          {-15.3506,0.74889,155.4738,18.08714,0.464077,1.1852}, /*cmy*/
          {1.131081,5.3275,2.8207,5.2389}, /*cfy*/
          {-307.7252,17.19338,1575.5192,168.65926,3.979054,11.2157}, /*cmz*/
          {3.314436,1.2764,5.1038,1.453} /*cfz*/
     },
     {
          2454941.4,
          {-395.7159,21.57331,1692.2815,186.04322,4.702868,9.9029}, /*cmx*/
          {1.893963,6.0876,3.5284,0.1028}, /*cfx*/
          {-16.4934,0.99759,164.8232,19.21832,0.509898,1.1817}, /*cmy*/
          {1.259668,5.4744,2.9457,5.6193}, /*cfy*/
          {-221.5847,10.36619,1595.0712,181.59925,4.713232,12.6144}, /*cmz*/
          {3.549773,1.535,5.3463,1.8081} /*cfz*/
     },
     {
          2454963.4,
          {-355.1252,19.34103,1617.8304,180.39624,4.745924,10.4973}, /*cmx*/
          {2.103451,0.0776,3.8444,0.6827}, /*cfx*/
          {-14.4413,0.93365,162.8861,18.7844,0.511488,1.0919}, /*cmy*/
          {1.429988,5.6827,3.1607,6.1609}, /*cfy*/
          {-168.7123,6.14856,1596.0896,187.54974,5.148636,12.619}, /*cmz*/
          {3.75343,1.7633,5.5682,2.2047} /*cfz*/
     },
     {
          2454985.4,
          {-314.1351,17.16435,1559.4623,176.885,4.884796,11.0882}, /*cmx*/
          {2.304576,0.3401,4.1428,1.1936}, /*cfx*/
          {-10.5055,0.65848,151.216,17.15741,0.480514,1.0255}, /*cmy*/
          {1.644301,5.953,3.4573,0.5264}, /*cfy*/
          {-148.1298,4.57678,1570.3589,186.22441,5.303816,11.9838}, /*cmz*/
          {3.935312,1.9828,5.7989,2.6834} /*cfz*/
     },
     {
          2455007.4,
          {-287.9016,16.43812,1517.5056,173.03313,4.973395,10.8546}, /*cmx*/
          {2.485908,0.5728,4.4007,1.7005}, /*cfx*/
          {-7.3782,0.408,134.6238,14.98308,0.433404,0.9451}, /*cmy*/
          {1.90412,6.2734,3.8057,1.1973}, /*cfy*/
          {-146.5817,4.57204,1529.7457,180.95842,5.325621,11.5177}, /*cmz*/
          {4.106939,2.2044,6.0449,3.2199} /*cfz*/
     },
     {
          2455029.4,
          {-279.8977,17.514,1482.7918,166.19217,4.894472,10.1807}, /*cmx*/
          {2.646208,0.7784,4.6315,2.2878}, /*cfx*/
          {-6.8309,0.34661,117.1454,12.58084,0.371548,0.8086}, /*cmy*/
          {2.211679,0.3518,4.1889,1.969}, /*cfy*/
          {-145.0574,4.48663,1496.161,175.80595,5.358303,11.0619}, /*cmz*/
          {4.274914,2.423,0.006,3.757} /*cfz*/
     },
     {
          2455051.4,
          {-280.7344,19.55817,1448.6833,156.54188,4.682348,10.0768}, /*cmx*/
          {2.796918,0.9755,4.8637,2.943}, /*cfx*/
          {-8.3271,0.4363,101.2099,10.19828,0.300989,0.758}, /*cmy*/
          {2.584339,0.7884,4.6623,2.9012}, /*cfy*/
          {-127.9833,2.92136,1486.6826,172.58413,5.428004,9.91}, /*cmz*/
          {4.439103,2.6229,0.2232,4.3149} /*cfz*/
     },
     {
          2455073.4,
          {-273.7562,21.02702,1417.7681,147.26407,4.502532,10.4417}, /*cmx*/
          {2.956149,1.185,5.1171,3.5609}, /*cfx*/
          {-9.4821,0.47065,90.9111,8.7727,0.264829,0.8035}, /*cmy*/
          {3.056203,1.3635,5.3085,3.7574}, /*cfy*/
          {-91.5496,-0.50259,1501.8751,170.15561,5.457591,8.3626}, /*cmz*/
          {4.597305,2.796,0.4069,5.0112} /*cfz*/
     },
     {
          2455095.4,
          {-245.4518,20.60378,1400.4892,142.18018,4.516384,10.173}, /*cmx*/
          {3.137811,1.4134,5.3836,4.1456}, /*cfx*/
          {-8.336,0.27745,93.024,9.3627,0.302648,0.7631}, /*cmy*/
          {3.595049,1.967,5.9415,4.5778}, /*cfy*/
          {-46.3721,-4.86212,1525.4308,166.26054,5.375866,8.1256}, /*cmz*/
          {4.752908,2.9547,0.5792,5.8681} /*cfz*/
     },
     {
          2455117.4,
          {-195.3812,18.12524,1405.5772,142.20198,4.720882,9.2021}, /*cmx*/
          {3.341926,1.6471,5.6381,4.8114}, /*cfx*/
          {-5.4307,-0.08753,107.6279,11.15703,0.373231,0.7357}, /*cmy*/
          {4.072411,2.4196,0.1057,5.5724}, /*cfy*/
          {-10.9936,-8.48235,1536.6511,159.77895,5.196204,9.3935}, /*cmz*/
          {4.917007,3.1266,0.7779,0.339} /*cfz*/
     },
     {
          2455139.4,
          {-138.8705,14.87884,1426.4337,143.70384,4.939304,8.9063}, /*cmx*/
          {3.556557,1.8741,5.8809,5.5905}, /*cfx*/
          {-3.1932,-0.38791,125.5733,12.72746,0.43192,0.8669}, /*cmy*/
          {4.448864,2.7687,0.4733,0.2297}, /*cfy*/
          {1.5839,-10.14992,1527.2758,151.84769,5.0198,10.3229}, /*cmz*/
          {5.102322,3.3364,1.0305,0.9648} /*cfz*/
     },
     {
          2455161.4,
          {-97.1685,12.75677,1440.9209,141.70525,5.001874,9.5481}, /*cmx*/
          {3.7734,2.1053,6.1444,0.0302}, /*cfx*/
          {-3.1803,-0.45623,139.4486,13.6226,0.473905,0.9799}, /*cmy*/
          {4.767607,3.0894,0.8354,1.0133}, /*cfy*/
          {-4.3691,-10.21564,1508.1095,144.64841,4.929003,10.5095}, /*cmz*/
          {5.312841,3.583,1.3272,1.5984} /*cfz*/
     },
     {
          2455183.4,
          {-80.4069,12.71061,1432.9562,134.98386,4.925752,9.7131}, /*cmx*/
          {3.997856,2.364,0.1772,0.6775}, /*cfx*/
          {-3.7593,-0.41806,147.8018,13.93514,0.498379,1.0557}, /*cmy*/
          {5.052996,3.3781,1.1691,1.7709}, /*cfy*/
          {-7.4945,-10.64436,1494.7537,137.67793,4.815823,10.8285}, /*cmz*/
          {5.537095,3.8353,1.634,2.2433} /*cfz*/
     },
     {
          2455205.4,
          {-75.3427,13.57317,1415.7913,127.7003,4.876839,9.4418}, /*cmx*/
          {4.241246,2.6516,0.5307,1.3722}, /*cfx*/
          {-1.4882,-0.58317,150.7368,13.44079,0.478951,1.1352}, /*cmy*/
          {5.295291,3.5906,1.436,2.4089}, /*cfy*/
          {15.4373,-13.6767,1485.1674,126.67119,4.435743,10.9333}, /*cmz*/
          {5.757409,4.0653,1.9473,2.8049} /*cfz*/
     },
     {
          2455227.4,
          {-50.423,12.42223,1426.3736,124.0244,4.842215,10.0044}, /*cmx*/
          {4.50089,2.9168,0.853,2.055}, /*cfx*/
          {4.8971,-1.08553,146.7318,11.92437,0.399408,1.0598}, /*cmy*/
          {5.482379,3.7057,1.6384,2.8706}, /*cfy*/
          {68.3886,-19.87036,1460.6462,109.03045,3.742944,9.5031}, /*cmz*/
          {5.971291,4.2802,2.3174,3.3117} /*cfz*/
     },
     {
          2455249.4,
          {21.4934,6.59621,1485.5689,122.51835,4.530866,10.5838}, /*cmx*/
          {4.75254,3.0932,1.0939,2.5531}, /*cfx*/
          {12.771,-1.71044,135.5431,9.89406,0.289096,0.7826}, /*cmy*/
          {5.620863,3.7409,1.8016,3.2363}, /*cfy*/
          {126.3753,-27.08631,1413.2941,89.30046,3.112094,6.8539}, /*cmz*/
          {6.199372,4.5212,2.8032,3.9463} /*cfz*/
     },
     {
          2455271.4,
          {139.6023,-4.08846,1569.1204,120.12971,3.76133,9.3896}, /*cmx*/
          {4.976222,3.1704,1.2529,2.8799}, /*cfx*/
          {18.687,-2.16243,120.9065,8.1178,0.193453,0.4562}, /*cmy*/
          {5.727927,3.7448,1.9588,3.6019}, /*cfy*/
          {149.1823,-31.58133,1368.2641,77.7564,2.954419,5.6508}, /*cmz*/
          {0.184628,4.8204,3.3006,4.8519} /*cfz*/
     },
     {
          2455293.4,
          {273.0454,-16.96685,1630.4587,116.74094,2.707134,6.3621}, /*cmx*/
          {5.177558,3.1995,1.3446,3.0957}, /*cfx*/
          {21.7696,-2.38615,108.1004,6.86245,0.129338,0.2174}, /*cmy*/
          {5.824643,3.7713,2.1663,4.1069}, /*cfy*/
          {109.7411,-30.55385,1371.8659,81.63978,3.04193,6.3786}, /*cmz*/
          {0.491224,5.1069,3.6,5.5084} /*cfz*/
     },
     {
          2455315.4,
          {382.8612,-28.38996,1642.0755,112.99446,1.730042,2.9002}, /*cmx*/
          {5.375604,3.2535,1.3828,3.1717}, /*cfx*/
          {22.7142,-2.48677,99.8585,6.03142,0.09114,0.1145}, /*cmy*/
          {5.948574,3.8633,2.5153,5.0857}, /*cfy*/
          {11.2872,-23.8495,1445.0257,98.25744,3.022094,6.3984}, /*cmz*/
          {0.794752,5.2945,3.6784,5.7656} /*cfz*/
     },
     {
          2455337.4,
          {445.4777,-35.89793,1610.2852,109.21896,1.098654,0.7722}, /*cmx*/
          {5.58515,3.3834,1.4132,2.3888}, /*cfx*/
          {21.0375,-2.46023,96.0437,5.65372,0.081611,0.1268}, /*cmy*/
          {6.153565,4.0889,2.9726,5.8144}, /*cfy*/
          {-120.6214,-13.4415,1560.135,120.43246,2.939883,5.4185}, /*cmz*/
          {1.057378,5.4115,3.5964,5.7174} /*cfz*/
     },
     {
          2455359.4,
          {457.9993,-38.85317,1561.6475,107.21914,0.887523,0.9529}, /*cmx*/
          {5.810329,3.6009,1.5694,1.511}, /*cfx*/
          {14.9987,-2.1564,97.7281,6.2198,0.101362,0.1449}, /*cmy*/
          {0.188182,4.4801,3.177,5.5593}, /*cfy*/
          {-257.411,-1.77977,1673.8286,142.28634,2.992438,4.9831}, /*cmz*/
          {1.273138,5.5065,3.4405,5.3838} /*cfz*/
     },
     {
          2455381.4,
          {429.3325,-37.76654,1523.1389,110.11932,1.085703,0.6365}, /*cmx*/
          {6.045888,3.8802,1.8457,2.6523}, /*cfx*/
          {3.4007,-1.43599,109.1799,8.37995,0.14884,0.2823}, /*cmy*/
          {0.578695,4.8895,3.1046,4.9752}, /*cfy*/
          {-378.8324,9.26519,1758.1494,160.25476,3.229794,6.0327}, /*cmz*/
          {1.453071,5.6026,3.3098,5.1076} /*cfz*/
     },
     {
          2455403.4,
          {371.2017,-33.53158,1511.1974,119.94413,1.628938,2.263}, /*cmx*/
          {6.280979,4.1707,2.0596,3.9848}, /*cfx*/
          {-13.2052,-0.29644,132.505,11.97229,0.230689,0.5762}, /*cmy*/
          {0.94889,5.1964,3.0128,4.8767}, /*cfy*/
          {-473.2448,18.50605,1802.6994,172.62869,3.540442,7.4703}, /*cmz*/
          {1.609994,5.7089,3.2559,5.0839} /*cfz*/
     },
     {
          2455425.4,
          {294.9294,-27.12231,1529.229,135.85834,2.395885,5.0519}, /*cmx*/
          {0.220357,4.4298,2.2,4.3228}, /*cfx*/
          {-32.4236,1.0987,163.5587,16.18967,0.336785,0.9029}, /*cmy*/
          {1.252025,5.4301,3.0126,4.9997}, /*cfy*/
          {-534.2827,25.20086,1807.19,178.97636,3.797307,8.2997}, /*cmz*/
          {1.754958,5.8319,3.2838,5.2296} /*cfz*/
     },
     {
          2455447.4,
          {211.8535,-19.60086,1568.9751,154.69092,3.254427,7.978}, /*cmx*/
          {0.421569,4.6448,2.3094,4.5549}, /*cfx*/
          {-50.7494,2.47277,195.5763,20.19763,0.443651,1.1434}, /*cmy*/
          {1.500813,5.6409,3.1045,5.2424}, /*cfy*/
          {-559.3039,28.94903,1777.1765,179.97291,3.941414,8.3128}, /*cmz*/
          {1.897488,5.9787,3.3877,5.5073} /*cfz*/
     },
     {
          2455469.4,
          {133.3965,-12.09357,1614.7856,172.56125,4.072594,10.3787}, /*cmx*/
          {0.598992,4.8248,2.4131,4.7769}, /*cfx*/
          {-64.6559,3.52949,223.2002,23.4551,0.532829,1.2491}, /*cmy*/
          {1.72179,5.8614,3.2812,5.6171}, /*cfy*/
          {-549.8514,29.74935,1722.8245,177.40551,3.99869,7.9626}, /*cmz*/
          {2.045408,6.1555,3.5636,5.9278} /*cfz*/
     },
     {
          2455491.4,
          {69.7963,-5.65168,1649.7357,186.12407,4.734247,11.7879}, /*cmx*/
          {0.75653,4.9863,2.5264,5.0237}, /*cfx*/
          {-71.8468,4.06815,244.037,25.90336,0.605204,1.3162}, /*cmy*/
          {1.934548,6.1071,3.5369,6.1489}, /*cfy*/
          {-512.3106,28.06567,1657.5445,173.80326,4.058684,8.0987}, /*cmz*/
          {2.203724,0.0799,3.8012,0.1795} /*cfz*/
     },
     {
          2455513.4,
          {28.0024,-1.03943,1661.2967,193.33391,5.165543,12.0951}, /*cmx*/
          {0.902264,5.1457,2.6616,5.3266}, /*cfx*/
          {-72.1846,4.07272,258.4117,27.86101,0.678904,1.5088}, /*cmy*/
          {2.147543,0.0918,3.8449,0.4639}, /*cfy*/
          {-457.4746,24.78891,1594.7974,171.36976,4.206994,9.076}, /*cmz*/
          {2.373242,0.3104,4.0737,0.7096} /*cfz*/
     },
     {
          2455535.4,
          {9.397,1.4921,1645.5075,193.98417,5.361932,11.6586}, /*cmx*/
          {1.046141,5.3171,2.8295,5.7155}, /*cfx*/
          {-67.7087,3.71972,267.5968,29.53675,0.763261,1.7913}, /*cmy*/
          {2.358815,0.3624,4.1553,0.9906}, /*cfy*/
          {-398.675,21.06798,1543.5226,170.63474,4.442228,10.2597}, /*cmz*/
          {2.550369,0.5486,4.347,1.1711} /*cfz*/
     },
     {
          2455557.4,
          {8.6075,2.33215,1608.665,189.80617,5.394752,11.1482}, /*cmx*/
          {1.197807,5.5105,3.0358,6.1956}, /*cfx*/
          {-61.7103,3.2997,271.7073,30.59674,0.837211,1.9585}, /*cmy*/
          {2.5606,0.6143,4.4319,1.4573}, /*cfy*/
          {-348.6552,18.02637,1504.7308,170.04082,4.665987,10.872}, /*cmz*/
          {2.729666,0.7823,4.604,1.6094} /*cfz*/
     },
     {
          2451179.3,
          {25.7378,0.10086,3489.4539,2.02951,0.024922,46.9897}, /*cmx*/
          {5.867118,3.5627,4.6272,5.6189}, /*cfx*/
          {78.2865,-0.69155,1215.2687,1.56054,0.016948,15.756}, /*cmy*/
          {5.051609,2.4745,4.9038,4.8203}, /*cfy*/
          {-315.8934,3.23893,3664.7046,8.62224,0.043434,43.0741}, /*cmz*/
          {1.091224,4.8576,1.6009,0.8255} /*cfz*/
     },
     {
          2451284.3,
          {23.9972,0.7045,3473.2372,7.53913,0.022268,47.4632}, /*cmx*/
          {1.459253,5.94,2.5386,3.2185}, /*cfx*/
          {76.0366,-0.50365,1238.5816,2.0083,0.004207,18.0068}, /*cmy*/
          {0.631777,5.8544,4.6441,2.3419}, /*cfy*/
          {-234.0564,2.11648,3416.0277,4.17644,0.028003,49.427}, /*cmz*/
          {2.938961,0.9059,2.6576,4.6837} /*cfz*/
     },
     {
          2451389.3,
          {142.7007,-1.3835,3455.4886,5.37567,0.071354,50.4951}, /*cmx*/
          {3.323604,2.0055,5.22,0.9353}, /*cfx*/
          {113.6546,-1.14762,1280.6201,3.21191,0.034787,19.3427}, /*cmy*/
          {2.536788,1.612,4.8589,0.1781}, /*cfy*/
          {-256.6652,2.47551,3310.7163,7.50846,0.065447,48.8058}, /*cmz*/
          {4.836051,4.4028,1.1631,2.5024} /*cfz*/
     },
     {
          2451494.3,
          {90.8302,-0.42324,3442.0051,7.49215,0.052583,47.6689}, /*cmx*/
          {5.382903,0.7691,3.9562,5.0786}, /*cfx*/
          {73.0841,-0.40217,1300.2169,2.49498,0.017208,17.246}, /*cmy*/
          {4.575407,0.3699,3.6426,4.2484}, /*cfy*/
          {-166.1797,0.8445,3488.6807,4.99219,0.032957,47.0392}, /*cmz*/
          {0.616951,2.34,5.264,0.2598} /*cfz*/
     },
     {
          2451599.3,
          {57.9394,0.33298,3449.0301,4.79397,0.014923,46.6231}, /*cmx*/
          {1.164385,5.7733,5.8441,2.7283}, /*cfx*/
          {82.9129,-0.59346,1269.3001,0.96397,0.015297,18.4707}, /*cmy*/
          {0.324423,5.7471,4.9916,1.8588}, /*cfy*/
          {-205.8303,1.79022,3443.3897,3.31466,0.035721,48.535}, /*cmz*/
          {2.64105,0.3035,1.8044,4.2255} /*cfz*/
     },
     {
          2451704.3,
          {132.4833,-0.51253,3460.1228,9.18266,0.049705,48.4814}, /*cmx*/
          {2.992944,1.4124,4.6881,0.3771}, /*cfx*/
          {68.2038,-0.30378,1300.9716,2.84628,0.014009,18.0368}, /*cmy*/
          {2.161022,0.6093,4.0345,5.8517}, /*cfy*/
          {-132.1116,0.78584,3404.4506,6.99338,0.030008,46.9858}, /*cmz*/
          {4.482952,3.0571,6.2751,1.8769} /*cfz*/
     },
     {
          2451809.3,
          {33.9924,1.16883,3373.1908,5.40055,0.040175,48.9389}, /*cmx*/
          {4.900209,5.6151,1.6857,4.4265}, /*cfx*/
          {61.5323,-0.27485,1277.9597,0.98596,0.011478,17.6662}, /*cmy*/
          {4.077504,5.0783,0.0241,3.5958}, /*cfy*/
          {-155.0092,1.46156,3448.3119,2.70321,0.048607,48.2101}, /*cmz*/
          {0.126023,0.4595,2.6349,5.8962} /*cfz*/
     },
     {
          2451914.3,
          {155.9917,-1.22241,3377.2338,5.34287,0.076198,48.9513}, /*cmx*/
          {0.751163,2.1106,5.4896,2.1907}, /*cfx*/
          {86.8939,-0.6488,1289.0171,2.07274,0.027379,19.0118}, /*cmy*/
          {6.195498,1.5713,4.863,1.3768}, /*cfy*/
          {-168.0659,1.30458,3468.7434,4.63414,0.056791,48.8422}, /*cmz*/
          {2.240567,4.4189,1.1398,3.7357} /*cfz*/
     },
     {
          2452019.3,
          {141.1151,-0.46749,3446.8646,8.8299,0.020726,46.0728}, /*cmx*/
          {2.703692,1.2254,5.3467,6.1686}, /*cfx*/
          {67.3088,-0.33974,1290.1013,2.76805,0.010041,16.846}, /*cmy*/
          {1.863389,0.3057,4.908,5.3481}, /*cfy*/
          {-77.4635,0.08678,3453.1204,7.53739,0.008418,46.4909}, /*cmz*/
          {4.190323,2.5338,5.8596,1.3588} /*cfz*/
     },
     {
          2452124.3,
          {236.0609,-2.06833,3576.4277,8.72107,0.093015,46.6085}, /*cmx*/
          {4.484936,2.3977,5.7708,3.6986}, /*cfx*/
          {81.3593,-0.63135,1249.9849,3.50194,0.032675,16.6648}, /*cmy*/
          {3.6768,1.5495,4.92,2.8558}, /*cfy*/
          {-75.7738,0.20062,3473.9578,5.96212,0.061437,48.4383}, /*cmz*/
          {6.004807,4.3557,1.2635,5.2403} /*cfz*/
     },
     {
          2452229.3,
          {283.1798,-2.82714,3330.2506,14.9362,0.101296,54.8758}, /*cmx*/
          {0.192457,1.7157,5.0431,1.6153}, /*cfx*/
          {48.9215,0.08165,1193.3997,3.28461,0.019461,18.8073}, /*cmy*/
          {5.687055,0.5725,3.7312,0.8067}, /*cfy*/
          {23.3958,-1.85465,3374.232,9.17601,0.068841,50.6582}, /*cmz*/
          {1.750945,2.9074,5.9906,3.1173} /*cfz*/
     },
     {
          2452334.3,
          {174.5654,-0.85927,3439.421,4.95881,0.036193,45.616}, /*cmx*/
          {2.368832,1.2224,6.243,5.6992}, /*cfx*/
          {61.5224,-0.26495,1245.9393,1.25655,0.016131,16.1749}, /*cmy*/
          {1.520617,0.2335,5.3002,4.8654}, /*cfy*/
          {-27.2715,-0.58655,3492.3682,4.49413,0.010765,47.3662}, /*cmz*/
          {3.859168,2.0339,2.2548,0.8905} /*cfz*/
     },
     {
          2452439.3,
          {254.8269,-1.87646,3621.6907,12.45103,0.07289,44.8386}, /*cmx*/
          {4.17748,2.1254,5.209,3.1003}, /*cfx*/
          {3.9045,0.70613,1146.641,2.66519,0.016574,13.7067}, /*cmy*/
          {3.308034,0.4792,3.0661,2.4081}, /*cfy*/
          {112.9253,-2.90777,3514.552,7.21019,0.069184,42.4975}, /*cmz*/
          {5.649179,3.0557,5.8557,4.7064} /*cfz*/
     },
     {
          2452544.3,
          {160.6245,-0.01124,3445.2297,2.87694,0.026608,55.0155}, /*cmx*/
          {6.019001,0.5377,2.1547,0.8934}, /*cfx*/
          {-7.2134,0.78879,985.3433,1.86976,0.013832,15.9636}, /*cmy*/
          {5.231069,4.9357,1.2535,6.2369}, /*cfy*/
          {149.4651,-3.25214,3290.0616,8.54918,0.057808,55.105}, /*cmz*/
          {1.280046,1.7533,4.7657,2.3548} /*cfz*/
     },
     {
          2452649.3,
          {202.8283,-1.09503,3436.0788,4.90793,0.058876,49.0719}, /*cmx*/
          {1.89544,2.904,6.1919,5.1448}, /*cfx*/
          {31.6314,0.19047,1105.6089,1.45824,0.016791,16.5776}, /*cmy*/
          {1.045337,1.8989,4.989,4.2714}, /*cfy*/
          {43.1017,-1.54275,3529.9619,1.30549,0.020449,51.5}, /*cmz*/
          {3.417561,5.4452,1.3864,0.3782} /*cfz*/
     },
     {
          2452754.3,
          {158.3552,0.10847,3531.2164,6.61593,0.0219,44.8181}, /*cmx*/
          {3.870797,1.9182,3.4513,2.6817}, /*cfx*/
          {-27.1628,1.13666,1072.7871,2.89725,0.023238,11.8642}, /*cmy*/
          {2.962951,5.8714,2.0699,1.9913}, /*cfy*/
          {166.0822,-3.45951,3575.8179,8.46177,0.081346,40.6548}, /*cmz*/
          {5.34349,2.4529,5.209,4.2082} /*cfz*/
     },
     {
          2452859.3,
          {95.7119,1.06853,3496.0098,9.26509,0.060171,48.4031}, /*cmx*/
          {5.686588,4.3267,1.3465,0.1798}, /*cfx*/
          {18.3036,0.08885,867.3831,2.72244,0.016798,10.5593}, /*cmy*/
          {4.816841,2.2588,5.37,5.6759}, /*cfy*/
          {60.4875,-0.97718,3428.2821,5.47746,0.028221,50.2837}, /*cmz*/
          {0.923548,6.0463,2.8783,1.7354} /*cfz*/
     },
     {
          2452964.3,
          {150.0373,0.2947,3525.401,4.36728,0.013851,56.6157}, /*cmx*/
          {1.342855,2.8378,4.0873,4.3886}, /*cfx*/
          {-33.5277,1.16377,829.1114,1.73489,0.023707,14.125}, /*cmy*/
          {0.529772,6.0089,2.4688,3.4682}, /*cfy*/
          {148.3036,-2.90039,3532.8541,2.90655,0.055217,55.5456}, /*cmz*/
          {2.924465,2.8302,5.5284,5.9823} /*cfz*/
     },
     {
          2453069.3,
          {53.7852,2.06408,3458.4504,4.99836,0.085688,45.6258}, /*cmx*/
          {3.462217,5.2371,2.2254,2.2468}, /*cfx*/
          {-11.4464,0.64538,923.2204,1.78825,0.019236,11.4228}, /*cmy*/
          {2.576533,4.7969,0.9994,1.4024}, /*cfy*/
          {105.561,-1.82422,3576.898,5.48309,0.060125,45.0375}, /*cmz*/
          {4.996505,1.5319,4.3413,3.7189} /*cfz*/
     },
     {
          2453174.3,
          {90.3173,1.03937,3502.7278,10.77043,0.03734,46.6316}, /*cmx*/
          {5.394747,4.0115,1.4577,5.9364}, /*cfx*/
          {16.3127,-0.01323,774.8928,3.55744,0.007671,8.1368}, /*cmy*/
          {4.488712,1.8194,5.0873,5.2489}, /*cfy*/
          {10.2281,0.35929,3512.9331,8.44913,0.022196,46.8644}, /*cmz*/
          {0.639733,5.3471,2.3472,1.2465} /*cfz*/
     },
     {
          2453279.3,
          {9.4232,2.62507,3693.6426,8.89958,0.104575,54.6994}, /*cmx*/
          {0.915605,5.1737,2.3592,3.7162}, /*cfx*/
          {-6.2358,0.24261,523.6912,1.86307,0.021839,6.5302}, /*cmy*/
          {0.020203,3.9089,0.7071,2.7809}, /*cfy*/
          {61.7733,-0.22235,3540.9309,3.88111,0.055378,51.7531}, /*cmz*/
          {2.472335,0.94,4.1018,5.2389} /*cfz*/
     },
     {
          2453384.3,
          {48.6055,1.69206,3481.7123,11.85965,0.084876,48.3203}, /*cmx*/
          {2.94749,4.5782,1.5957,1.6}, /*cfx*/
          {42.0542,-0.54206,553.828,3.83188,0.03137,9.4863}, /*cmy*/
          {2.1164,2.2749,5.5036,0.6313}, /*cfy*/
          {-52.0495,1.66266,3426.9269,9.48263,0.078583,50.9764}, /*cmz*/
          {4.539557,5.7206,2.6609,3.1699} /*cfz*/
     },
     {
          2453489.3,
          {101.2389,0.70955,3512.5544,6.52051,0.025054,47.9911}, /*cmx*/
          {5.069073,3.7977,2.3762,5.4702}, /*cfx*/
          {5.1103,0.11685,632.4766,2.12304,0.005658,6.9163}, /*cmy*/
          {4.120339,1.2753,1.7103,4.7211}, /*cfy*/
          {-5.7088,0.92958,3558.1622,6.40895,0.005037,46.7776}, /*cmz*/
          {0.333739,4.9738,3.0906,0.7774} /*cfz*/
     },
     {
          2453594.3,
          {64.7974,1.08904,3639.7106,10.64562,0.063302,49.932}, /*cmx*/
          {0.597122,5.0713,2.0095,3.1678}, /*cfx*/
          {4.246,-0.02144,359.6981,3.17875,0.012698,3.2942}, /*cmy*/
          {5.863262,3.0414,6.1497,2.3773}, /*cfy*/
          {-29.503,1.97677,3601.4476,7.12846,0.05218,50.9584}, /*cmz*/
          {2.130994,6.2488,2.8927,4.6803} /*cfz*/
     },
     {
          2453699.3,
          {172.9625,-0.96429,3515.9771,3.80877,0.037927,49.7686}, /*cmx*/
          {2.49493,3.0811,5.1915,0.8953}, /*cfx*/
          {-30.8028,0.72815,219.3829,1.32439,0.025305,3.0965}, /*cmy*/
          {1.338751,6.1519,2.5955,5.8048}, /*cfy*/
          {-10.3935,1.30485,3433.0847,6.6325,0.038072,49.4694}, /*cmz*/
          {4.056129,4.8343,1.1489,2.4974} /*cfz*/
     },
     {
          2453804.3,
          {92.9509,0.76417,3512.9672,3.71732,0.056994,50.6746}, /*cmx*/
          {4.636887,5.6597,2.8152,4.9714}, /*cfx*/
          {-15.2173,0.33424,340.6735,1.6054,0.021677,4.8043}, /*cmy*/
          {3.526187,4.5273,1.2305,4.0442}, /*cfy*/
          {12.6442,1.03999,3571.4867,0.70007,0.030362,48.4844}, /*cmz*/
          {6.211368,0.9382,4.2847,0.2541} /*cfz*/
     },
     {
          2453909.3,
          {115.3017,-0.06008,3584.1218,7.47164,0.009881,48.4096}, /*cmx*/
          {0.303249,4.8912,1.8037,2.6523}, /*cfx*/
          {-3.7211,0.05747,247.6489,3.07293,0.005552,1.3307}, /*cmy*/
          {5.439622,2.7869,1.0592,2.2567}, /*cfy*/
          {-9.0969,1.87784,3620.9529,7.19234,0.029404,50.2655}, /*cmz*/
          {1.852771,6.0301,2.2654,4.2158} /*cfz*/
     },
     {
          2454014.3,
          {50.839,0.9934,3589.7431,4.73654,0.05197,48.4859}, /*cmx*/
          {2.106136,0.0073,3.226,0.2692}, /*cfx*/
          {-6.7143,0.04222,106.2815,2.77332,0.024252,2.0375}, /*cmy*/
          {5.424597,4.3076,1.1352,3.2243}, /*cfy*/
          {42.6287,1.28476,3500.8272,2.76322,0.023645,48.2325}, /*cmz*/
          {3.682564,2.438,5.1075,1.8876} /*cfz*/
     },
     {
          2454119.3,
          {20.9428,1.48217,3453.9141,9.487,0.062151,52.16}, /*cmx*/
          {4.129141,5.2647,2.0449,4.4065}, /*cfx*/
          {36.9125,-0.78602,91.2387,3.81228,0.029124,1.7817}, /*cmy*/
          {0.832491,2.6948,5.7779,2.0849}, /*cfy*/
          {-33.2357,2.76159,3513.6322,6.50721,0.067481,50.7819}, /*cmz*/
          {5.738193,6.2249,2.8613,5.9161} /*cfz*/
     },
     {
          2454224.3,
          {135.5706,-0.68241,3573.2004,1.63764,0.031576,49.8348}, /*cmx*/
          {6.240089,3.8305,5.0214,2.1575}, /*cfx*/
          {-0.1498,-0.02975,111.2746,1.2397,0.01058,0.6805}, /*cmy*/
          {4.21889,2.2549,1.9778,4.4245}, /*cfy*/
          {3.8158,1.89683,3652.8198,4.74375,0.027425,50.9609}, /*cmz*/
          {1.523527,5.2458,1.2386,3.7578} /*cfz*/
     },
     {
          2454329.3,
          {111.7591,-0.68727,3537.1533,5.9956,0.005637,47.8176}, /*cmx*/
          {1.834732,0.3027,3.9819,6.078}, /*cfx*/
          {28.1109,-0.50191,249.0525,2.7346,0.012443,4.6984}, /*cmy*/
          {4.553436,3.4837,5.9416,2.052}, /*cfy*/
          {-25.8489,2.96716,3467.3812,0.8926,0.041278,44.692}, /*cmz*/
          {3.370902,1.4249,2.4255,1.3525} /*cfz*/
     },
     {
          2454434.3,
          {166.3977,-1.95714,3601.9394,4.98531,0.07938,50.3347}, /*cmx*/
          {3.721417,2.2501,5.6089,3.7184}, /*cfx*/
          {9.3478,-0.05213,419.2908,1.17119,0.018565,5.7671}, /*cmy*/
          {6.203056,0.6906,3.1616,0.2049}, /*cfy*/
          {-33.6184,3.04879,3454.6372,8.34806,0.083623,54.5093}, /*cmz*/
          {5.310648,4.8238,1.6447,5.2647} /*cfz*/
     },
     {
          2454539.3,
          {182.1431,-1.82085,3565.0615,9.0046,0.070777,54.7501}, /*cmx*/
          {5.777821,1.4592,4.7971,1.623}, /*cfx*/
          {-13.8431,0.22801,331.7911,2.53763,0.024508,3.9584}, /*cmy*/
          {2.153473,4.7969,1.7241,4.3287}, /*cfy*/
          {52.2249,1.29537,3645.365,5.04812,0.032891,53.4543}, /*cmz*/
          {1.088831,3.3504,0.1809,3.2396} /*cfz*/
     },
     {
          2454644.3,
          {218.7751,-2.90997,3411.6713,6.23245,0.067717,46.488}, /*cmx*/
          {1.563898,1.1059,5.5469,5.6864}, /*cfx*/
          {5.9688,-0.01606,349.3202,2.13381,0.006531,5.5475}, /*cmy*/
          {4.167341,3.4606,3.4421,1.6093}, /*cfy*/
          {49.6358,1.58925,3519.0922,1.47732,0.041578,46.0576}, /*cmz*/
          {3.093885,1.1426,1.7774,0.8762} /*cfz*/
     },
     {
          2454749.3,
          {199.4807,-2.67924,3652.7128,13.19115,0.098375,48.0993}, /*cmx*/
          {3.420234,1.6683,5.0278,3.0555}, /*cfx*/
          {-25.7405,0.62786,602.4056,4.42058,0.033008,10.1489}, /*cmy*/
          {5.912125,5.0103,1.9535,5.4541}, /*cfy*/
          {207.3049,-1.29156,3608.8696,8.81967,0.07103,48.1083}, /*cmz*/
          {4.939028,2.9377,6.1099,4.6822} /*cfz*/
     },
     {
          2454854.3,
          {155.4905,-1.783,3566.2359,8.87777,0.041157,60.2506}, /*cmx*/
          {5.301706,1.0882,4.9555,1.0065}, /*cfx*/
          {8.2869,-0.09476,684.9925,2.74548,0.010476,10.1728}, /*cmy*/
          {1.48575,3.8211,0.4295,3.6679}, /*cfy*/
          {188.2187,-0.72492,3496.2533,6.99069,0.024034,57.4932}, /*cmz*/
          {0.599766,2.0305,5.0806,2.5491} /*cfz*/
     },
     {
          2454959.3,
          {195.206,-2.5971,3381.3213,6.74067,0.087167,47.2689}, /*cmx*/
          {1.194656,1.8531,5.5075,5.1854}, /*cfx*/
          {-8.8572,0.31519,538.7935,0.70916,0.020861,7.0427}, /*cmy*/
          {3.68633,5.004,2.8097,1.2593}, /*cfy*/
          {192.1371,-1.00655,3542.18,1.92634,0.041212,50.8041}, /*cmz*/
          {2.765718,2.3962,0.5298,0.4264} /*cfz*/
     },
     {
          2455064.3,
          {114.7917,-1.23389,3597.6738,10.50796,0.042115,46.8118}, /*cmx*/
          {3.137179,1.3303,4.5676,2.6049}, /*cfx*/
          {10.9728,0.00183,703.384,3.44158,0.010961,10.9393}, /*cmy*/
          {5.572348,4.5892,1.0972,4.9486}, /*cfy*/
          {311.6923,-3.03598,3712.072,12.53584,0.078278,43.3905}, /*cmz*/
          {4.653045,2.3562,5.4185,4.1768} /*cfz*/
     },
     {
          2455169.3,
          {71.4637,-0.83502,3527.6652,2.69934,0.043816,54.9503}, /*cmx*/
          {4.946835,2.4171,6.0375,0.3336}, /*cfx*/
          {45.4739,-0.47509,869.8814,1.57371,0.015425,14.5558}, /*cmy*/
          {1.06143,1.2388,4.0616,2.7118}, /*cfy*/
          {273.41,-2.27141,3418.8713,2.60717,0.016345,56.546}, /*cmz*/
          {0.187633,1.6066,0.1647,1.8169} /*cfz*/
     },
     {
          2455274.3,
          {55.5316,-0.15394,3449.764,6.4355,0.043337,53.2141}, /*cmx*/
          {0.744423,1.9463,4.9614,4.5439}, /*cfx*/
          {12.7273,-0.00646,839.3251,2.42098,0.017398,12.2771}, /*cmy*/
          {3.157378,5.28,2.097,0.7576}, /*cfy*/
          {314.8128,-3.15868,3439.2091,7.46176,0.077192,54.6784}, /*cmz*/
          {2.330182,2.6588,5.8456,6.1477} /*cfz*/
     },
     {
          2455379.3,
          {11.7627,0.46799,3545.3161,3.98425,0.026648,46.6479}, /*cmx*/
          {2.814662,0.4919,2.2394,2.2075}, /*cfx*/
          {51.81,-0.6786,841.6632,1.44039,0.018944,10.9989}, /*cmy*/
          {5.216629,3.2864,5.3288,4.5413}, /*cfy*/
          {321.1408,-3.06501,3721.6968,10.27063,0.055156,43.9431}, /*cmz*/
          {4.355368,1.9132,4.8919,3.7028} /*cfz*/
     },
     {
          2455484.3,
          {-47.1504,1.01353,3419.811,5.87158,0.016282,49.0936}, /*cmx*/
          {4.683471,3.444,0.8679,6.0184}, /*cfx*/
          {65.4012,-0.67779,952.0396,2.73222,0.010664,15.8194}, /*cmy*/
          {0.749688,0.4556,4.2824,2.0457}, /*cfy*/
          {278.4224,-2.44388,3438.706,2.62613,0.032261,52.2755}, /*cmz*/
          {6.172972,3.9021,6.0369,1.2876} /*cfz*/
     }

};

static unsigned idn_list[] = {2,82,126,168,212,261,324,524};
static double freq_list[] = {6.667,4.586,3.328,2.296,1.391,0.394,0.394,0.079};
static double delt_list[] = {55.0,100.0,105.0,100.0,90.0,70.0,22.0,105.0};

BDL_Dataset saturne_9910 = {
     8, /*nsat*/
     2451179.5, /*djj*/
     idn_list,
     freq_list,
     delt_list,
     moonrecords
};
