/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.openiconic;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.sourceforge.plantuml.openiconic.SvgCommand;
import net.sourceforge.plantuml.openiconic.SvgCommandLetter;
import net.sourceforge.plantuml.openiconic.SvgCommandNumber;
import net.sourceforge.plantuml.openiconic.SvgPosition;

public class Movement {
    private final SvgCommandLetter letter;
    private final List<SvgCommandNumber> arguments;

    public Movement(Iterator<SvgCommand> it) {
        this.letter = (SvgCommandLetter)it.next();
        int nb = this.letter.argumentNumber();
        SvgCommandNumber[] args = new SvgCommandNumber[nb];
        for (int i = 0; i < nb; ++i) {
            args[i] = (SvgCommandNumber)it.next();
        }
        this.arguments = Arrays.asList(args);
    }

    private Movement(SvgCommandLetter letter, SvgCommandNumber ... args) {
        this.letter = letter;
        this.arguments = Arrays.asList(args);
    }

    private Movement(SvgCommandLetter letter) {
        this.letter = letter;
        this.arguments = Collections.emptyList();
    }

    public char getLetter() {
        return this.letter.getLetter();
    }

    private Movement(SvgCommandLetter letter, SvgPosition ... pos) {
        this.letter = letter;
        SvgCommandNumber[] args = new SvgCommandNumber[pos.length * 2];
        for (int i = 0; i < pos.length; ++i) {
            args[2 * i] = pos[i].getX();
            args[2 * i + 1] = pos[i].getY();
        }
        this.arguments = Arrays.asList(args);
    }

    public Movement mutoToC(SvgPosition mirrorControlPoint) {
        if (!this.is('S')) {
            throw new UnsupportedOperationException();
        }
        if (mirrorControlPoint == null) {
            return new Movement(new SvgCommandLetter("C"), this.getSvgPosition(0), this.getSvgPosition(0), this.lastPosition());
        }
        return new Movement(new SvgCommandLetter("C"), mirrorControlPoint, this.getSvgPosition(0), this.lastPosition());
    }

    public String toSvg() {
        StringBuilder result = new StringBuilder();
        result.append(this.letter.toSvg());
        result.append(' ');
        for (SvgCommandNumber arg : this.arguments) {
            result.append(arg.toSvg());
            result.append(' ');
        }
        return result.toString();
    }

    public SvgPosition getSvgPosition(int index) {
        return new SvgPosition(this.arguments.get(index), this.arguments.get(index + 1));
    }

    public double getArgument(int index) {
        return this.arguments.get(index).getDouble();
    }

    public SvgPosition lastPosition() {
        if (this.letter.argumentNumber() == 0) {
            return null;
        }
        return this.getSvgPosition(this.arguments.size() - 2);
    }

    public Movement toAbsoluteUpperCase(SvgPosition delta) {
        Objects.requireNonNull(delta);
        if (this.letter.isUpperCase()) {
            return this;
        }
        if (this.letter.is('m')) {
            return new Movement(new SvgCommandLetter("M"), delta.add(this.getSvgPosition(0)));
        }
        if (this.letter.is('l')) {
            return new Movement(new SvgCommandLetter("L"), delta.add(this.getSvgPosition(0)));
        }
        if (this.letter.is('z')) {
            return new Movement(new SvgCommandLetter("Z"));
        }
        if (this.letter.is('c')) {
            return new Movement(new SvgCommandLetter("C"), delta.add(this.getSvgPosition(0)), delta.add(this.getSvgPosition(2)), delta.add(this.getSvgPosition(4)));
        }
        if (this.letter.is('s')) {
            return new Movement(new SvgCommandLetter("S"), delta.add(this.getSvgPosition(0)), delta.add(this.getSvgPosition(2)));
        }
        if (this.letter.is('a')) {
            SvgPosition last = delta.add(this.lastPosition());
            return new Movement(new SvgCommandLetter("A"), this.arguments.get(0), this.arguments.get(1), this.arguments.get(2), this.arguments.get(3), this.arguments.get(4), last.getX(), last.getY());
        }
        throw new UnsupportedOperationException("Movement::goUpperCase " + this.letter);
    }

    public SvgPosition getMirrorControlPoint() {
        if (this.letter.is('c')) {
            throw new IllegalStateException();
        }
        if (this.letter.is('s')) {
            throw new IllegalStateException();
        }
        if (this.letter.is('C')) {
            SvgPosition center = this.lastPosition();
            SvgPosition controlPoint = this.getSvgPosition(2);
            return center.getMirror(controlPoint);
        }
        if (this.letter.is('S')) {
            SvgPosition center = this.lastPosition();
            SvgPosition controlPoint = this.getSvgPosition(0);
            return center.getMirror(controlPoint);
        }
        return null;
    }

    public boolean is(char c) {
        return this.letter.is(c);
    }
}

