/*
   mkvmerge -- utility for splicing together matroska files
   from component media subtypes

   Distributed under the GPL v2
   see the file COPYING for details
   or visit https://www.gnu.org/licenses/old-licenses/gpl-2.0.html

   ISO 639 language definitions, lookup functions

   Written by Moritz Bunkus <moritz@bunkus.org>.
*/

// -----------------------------------------------------------------------
// NOTE: this file is auto-generated by the "dev:iso639_list" rake target.
// -----------------------------------------------------------------------

#include "common/common_pch.h"

#include "common/iso639.h"

namespace mtx::iso639 {

std::vector<language_t> const g_languages{
  { "Reserved for local use: qaa",                                                         "qaa",  ""s,   ""s     },
  { "Reserved for local use: qab",                                                         "qab",  ""s,   ""s     },
  { "Reserved for local use: qac",                                                         "qac",  ""s,   ""s     },
  { "Reserved for local use: qad",                                                         "qad",  ""s,   ""s     },
  { u8"Abkhazian"s,                                                                        "abk"s, "ab"s, ""s     },
  { u8"Achinese"s,                                                                         "ace"s, ""s,   ""s     },
  { u8"Acoli"s,                                                                            "ach"s, ""s,   ""s     },
  { u8"Adangme"s,                                                                          "ada"s, ""s,   ""s     },
  { u8"Adyghe; Adygei"s,                                                                   "ady"s, ""s,   ""s     },
  { u8"Afar"s,                                                                             "aar"s, "aa"s, ""s     },
  { u8"Afrihili"s,                                                                         "afh"s, ""s,   ""s     },
  { u8"Afrikaans"s,                                                                        "afr"s, "af"s, ""s     },
  { u8"Afro-Asiatic languages"s,                                                           "afa"s, ""s,   ""s     },
  { u8"Ainu"s,                                                                             "ain"s, ""s,   ""s     },
  { u8"Akan"s,                                                                             "aka"s, "ak"s, ""s     },
  { u8"Akkadian"s,                                                                         "akk"s, ""s,   ""s     },
  { u8"Albanian"s,                                                                         "alb"s, "sq"s, "sqi"s  },
  { u8"Aleut"s,                                                                            "ale"s, ""s,   ""s     },
  { u8"Algonquian languages"s,                                                             "alg"s, ""s,   ""s     },
  { u8"Altaic languages"s,                                                                 "tut"s, ""s,   ""s     },
  { u8"Amharic"s,                                                                          "amh"s, "am"s, ""s     },
  { u8"Angika"s,                                                                           "anp"s, ""s,   ""s     },
  { u8"Apache languages"s,                                                                 "apa"s, ""s,   ""s     },
  { u8"Arabic"s,                                                                           "ara"s, "ar"s, ""s     },
  { u8"Aragonese"s,                                                                        "arg"s, "an"s, ""s     },
  { u8"Arapaho"s,                                                                          "arp"s, ""s,   ""s     },
  { u8"Arawak"s,                                                                           "arw"s, ""s,   ""s     },
  { u8"Armenian"s,                                                                         "arm"s, "hy"s, "hye"s  },
  { u8"Aromanian; Arumanian; Macedo-Romanian"s,                                            "rup"s, ""s,   ""s     },
  { u8"Artificial languages"s,                                                             "art"s, ""s,   ""s     },
  { u8"Assamese"s,                                                                         "asm"s, "as"s, ""s     },
  { u8"Asturian; Bable; Leonese; Asturleonese"s,                                           "ast"s, ""s,   ""s     },
  { u8"Athapascan languages"s,                                                             "ath"s, ""s,   ""s     },
  { u8"Australian languages"s,                                                             "aus"s, ""s,   ""s     },
  { u8"Austronesian languages"s,                                                           "map"s, ""s,   ""s     },
  { u8"Avaric"s,                                                                           "ava"s, "av"s, ""s     },
  { u8"Avestan"s,                                                                          "ave"s, "ae"s, ""s     },
  { u8"Awadhi"s,                                                                           "awa"s, ""s,   ""s     },
  { u8"Aymara"s,                                                                           "aym"s, "ay"s, ""s     },
  { u8"Azerbaijani"s,                                                                      "aze"s, "az"s, ""s     },
  { u8"Balinese"s,                                                                         "ban"s, ""s,   ""s     },
  { u8"Baltic languages"s,                                                                 "bat"s, ""s,   ""s     },
  { u8"Baluchi"s,                                                                          "bal"s, ""s,   ""s     },
  { u8"Bambara"s,                                                                          "bam"s, "bm"s, ""s     },
  { u8"Bamileke languages"s,                                                               "bai"s, ""s,   ""s     },
  { u8"Banda languages"s,                                                                  "bad"s, ""s,   ""s     },
  { u8"Bantu (Other)"s,                                                                    "bnt"s, ""s,   ""s     },
  { u8"Basa"s,                                                                             "bas"s, ""s,   ""s     },
  { u8"Bashkir"s,                                                                          "bak"s, "ba"s, ""s     },
  { u8"Basque"s,                                                                           "baq"s, "eu"s, "eus"s  },
  { u8"Batak languages"s,                                                                  "btk"s, ""s,   ""s     },
  { u8"Beja; Bedawiyet"s,                                                                  "bej"s, ""s,   ""s     },
  { u8"Belarusian"s,                                                                       "bel"s, "be"s, ""s     },
  { u8"Bemba"s,                                                                            "bem"s, ""s,   ""s     },
  { u8"Bengali"s,                                                                          "ben"s, "bn"s, ""s     },
  { u8"Berber languages"s,                                                                 "ber"s, ""s,   ""s     },
  { u8"Bhojpuri"s,                                                                         "bho"s, ""s,   ""s     },
  { u8"Bihari languages"s,                                                                 "bih"s, "bh"s, ""s     },
  { u8"Bikol"s,                                                                            "bik"s, ""s,   ""s     },
  { u8"Bini; Edo"s,                                                                        "bin"s, ""s,   ""s     },
  { u8"Bislama"s,                                                                          "bis"s, "bi"s, ""s     },
  { u8"Blin; Bilin"s,                                                                      "byn"s, ""s,   ""s     },
  { u8"Blissymbols; Blissymbolics; Bliss"s,                                                "zbl"s, ""s,   ""s     },
  { u8"Bokmål, Norwegian; Norwegian Bokmål"s,                                              "nob"s, "nb"s, ""s     },
  { u8"Bosnian"s,                                                                          "bos"s, "bs"s, ""s     },
  { u8"Braj"s,                                                                             "bra"s, ""s,   ""s     },
  { u8"Breton"s,                                                                           "bre"s, "br"s, ""s     },
  { u8"Buginese"s,                                                                         "bug"s, ""s,   ""s     },
  { u8"Bulgarian"s,                                                                        "bul"s, "bg"s, ""s     },
  { u8"Buriat"s,                                                                           "bua"s, ""s,   ""s     },
  { u8"Burmese"s,                                                                          "bur"s, "my"s, "mya"s  },
  { u8"Caddo"s,                                                                            "cad"s, ""s,   ""s     },
  { u8"Catalan; Valencian"s,                                                               "cat"s, "ca"s, ""s     },
  { u8"Caucasian languages"s,                                                              "cau"s, ""s,   ""s     },
  { u8"Cebuano"s,                                                                          "ceb"s, ""s,   ""s     },
  { u8"Celtic languages"s,                                                                 "cel"s, ""s,   ""s     },
  { u8"Central American Indian languages"s,                                                "cai"s, ""s,   ""s     },
  { u8"Central Khmer"s,                                                                    "khm"s, "km"s, ""s     },
  { u8"Chagatai"s,                                                                         "chg"s, ""s,   ""s     },
  { u8"Chamic languages"s,                                                                 "cmc"s, ""s,   ""s     },
  { u8"Chamorro"s,                                                                         "cha"s, "ch"s, ""s     },
  { u8"Chechen"s,                                                                          "che"s, "ce"s, ""s     },
  { u8"Cherokee"s,                                                                         "chr"s, ""s,   ""s     },
  { u8"Cheyenne"s,                                                                         "chy"s, ""s,   ""s     },
  { u8"Chibcha"s,                                                                          "chb"s, ""s,   ""s     },
  { u8"Chichewa; Chewa; Nyanja"s,                                                          "nya"s, "ny"s, ""s     },
  { u8"Chinese"s,                                                                          "chi"s, "zh"s, "zho"s  },
  { u8"Chinook jargon"s,                                                                   "chn"s, ""s,   ""s     },
  { u8"Chipewyan; Dene Suline"s,                                                           "chp"s, ""s,   ""s     },
  { u8"Choctaw"s,                                                                          "cho"s, ""s,   ""s     },
  { u8"Church Slavic; Old Slavonic; Church Slavonic; Old Bulgarian; Old Church Slavonic"s, "chu"s, "cu"s, ""s     },
  { u8"Chuukese"s,                                                                         "chk"s, ""s,   ""s     },
  { u8"Chuvash"s,                                                                          "chv"s, "cv"s, ""s     },
  { u8"Classical Newari; Old Newari; Classical Nepal Bhasa"s,                              "nwc"s, ""s,   ""s     },
  { u8"Classical Syriac"s,                                                                 "syc"s, ""s,   ""s     },
  { u8"Coptic"s,                                                                           "cop"s, ""s,   ""s     },
  { u8"Cornish"s,                                                                          "cor"s, "kw"s, ""s     },
  { u8"Corsican"s,                                                                         "cos"s, "co"s, ""s     },
  { u8"Cree"s,                                                                             "cre"s, "cr"s, ""s     },
  { u8"Creek"s,                                                                            "mus"s, ""s,   ""s     },
  { u8"Creoles and pidgins"s,                                                              "crp"s, ""s,   ""s     },
  { u8"Creoles and pidgins, English based"s,                                               "cpe"s, ""s,   ""s     },
  { u8"Creoles and pidgins, French-based"s,                                                "cpf"s, ""s,   ""s     },
  { u8"Creoles and pidgins, Portuguese-based"s,                                            "cpp"s, ""s,   ""s     },
  { u8"Crimean Tatar; Crimean Turkish"s,                                                   "crh"s, ""s,   ""s     },
  { u8"Croatian"s,                                                                         "hrv"s, "hr"s, ""s     },
  { u8"Cushitic languages"s,                                                               "cus"s, ""s,   ""s     },
  { u8"Czech"s,                                                                            "cze"s, "cs"s, "ces"s  },
  { u8"Dakota"s,                                                                           "dak"s, ""s,   ""s     },
  { u8"Danish"s,                                                                           "dan"s, "da"s, ""s     },
  { u8"Dargwa"s,                                                                           "dar"s, ""s,   ""s     },
  { u8"Delaware"s,                                                                         "del"s, ""s,   ""s     },
  { u8"Dinka"s,                                                                            "din"s, ""s,   ""s     },
  { u8"Divehi; Dhivehi; Maldivian"s,                                                       "div"s, "dv"s, ""s     },
  { u8"Dogri"s,                                                                            "doi"s, ""s,   ""s     },
  { u8"Dogrib"s,                                                                           "dgr"s, ""s,   ""s     },
  { u8"Dravidian languages"s,                                                              "dra"s, ""s,   ""s     },
  { u8"Duala"s,                                                                            "dua"s, ""s,   ""s     },
  { u8"Dutch, Middle (ca. 1050-1350)"s,                                                    "dum"s, ""s,   ""s     },
  { u8"Dutch; Flemish"s,                                                                   "dut"s, "nl"s, "nld"s  },
  { u8"Dyula"s,                                                                            "dyu"s, ""s,   ""s     },
  { u8"Dzongkha"s,                                                                         "dzo"s, "dz"s, ""s     },
  { u8"Eastern Frisian"s,                                                                  "frs"s, ""s,   ""s     },
  { u8"Efik"s,                                                                             "efi"s, ""s,   ""s     },
  { u8"Egyptian (Ancient)"s,                                                               "egy"s, ""s,   ""s     },
  { u8"Ekajuk"s,                                                                           "eka"s, ""s,   ""s     },
  { u8"Elamite"s,                                                                          "elx"s, ""s,   ""s     },
  { u8"English"s,                                                                          "eng"s, "en"s, ""s     },
  { u8"English, Middle (1100-1500)"s,                                                      "enm"s, ""s,   ""s     },
  { u8"English, Old (ca. 450-1100)"s,                                                      "ang"s, ""s,   ""s     },
  { u8"Erzya"s,                                                                            "myv"s, ""s,   ""s     },
  { u8"Esperanto"s,                                                                        "epo"s, "eo"s, ""s     },
  { u8"Estonian"s,                                                                         "est"s, "et"s, ""s     },
  { u8"Ewe"s,                                                                              "ewe"s, "ee"s, ""s     },
  { u8"Ewondo"s,                                                                           "ewo"s, ""s,   ""s     },
  { u8"Fang"s,                                                                             "fan"s, ""s,   ""s     },
  { u8"Fanti"s,                                                                            "fat"s, ""s,   ""s     },
  { u8"Faroese"s,                                                                          "fao"s, "fo"s, ""s     },
  { u8"Fijian"s,                                                                           "fij"s, "fj"s, ""s     },
  { u8"Filipino; Pilipino"s,                                                               "fil"s, ""s,   ""s     },
  { u8"Finnish"s,                                                                          "fin"s, "fi"s, ""s     },
  { u8"Finno-Ugrian languages"s,                                                           "fiu"s, ""s,   ""s     },
  { u8"Fon"s,                                                                              "fon"s, ""s,   ""s     },
  { u8"French"s,                                                                           "fre"s, "fr"s, "fra"s  },
  { u8"French, Middle (ca. 1400-1600)"s,                                                   "frm"s, ""s,   ""s     },
  { u8"French, Old (842-ca. 1400)"s,                                                       "fro"s, ""s,   ""s     },
  { u8"Friulian"s,                                                                         "fur"s, ""s,   ""s     },
  { u8"Fulah"s,                                                                            "ful"s, "ff"s, ""s     },
  { u8"Ga"s,                                                                               "gaa"s, ""s,   ""s     },
  { u8"Gaelic; Scottish Gaelic"s,                                                          "gla"s, "gd"s, ""s     },
  { u8"Galibi Carib"s,                                                                     "car"s, ""s,   ""s     },
  { u8"Galician"s,                                                                         "glg"s, "gl"s, ""s     },
  { u8"Ganda"s,                                                                            "lug"s, "lg"s, ""s     },
  { u8"Gayo"s,                                                                             "gay"s, ""s,   ""s     },
  { u8"Gbaya"s,                                                                            "gba"s, ""s,   ""s     },
  { u8"Geez"s,                                                                             "gez"s, ""s,   ""s     },
  { u8"Georgian"s,                                                                         "geo"s, "ka"s, "kat"s  },
  { u8"German"s,                                                                           "ger"s, "de"s, "deu"s  },
  { u8"German, Middle High (ca. 1050-1500)"s,                                              "gmh"s, ""s,   ""s     },
  { u8"German, Old High (ca. 750-1050)"s,                                                  "goh"s, ""s,   ""s     },
  { u8"Germanic languages"s,                                                               "gem"s, ""s,   ""s     },
  { u8"Gilbertese"s,                                                                       "gil"s, ""s,   ""s     },
  { u8"Gondi"s,                                                                            "gon"s, ""s,   ""s     },
  { u8"Gorontalo"s,                                                                        "gor"s, ""s,   ""s     },
  { u8"Gothic"s,                                                                           "got"s, ""s,   ""s     },
  { u8"Grebo"s,                                                                            "grb"s, ""s,   ""s     },
  { u8"Greek, Ancient (to 1453)"s,                                                         "grc"s, ""s,   ""s     },
  { u8"Greek, Modern (1453-)"s,                                                            "gre"s, "el"s, "ell"s  },
  { u8"Guarani"s,                                                                          "grn"s, "gn"s, ""s     },
  { u8"Gujarati"s,                                                                         "guj"s, "gu"s, ""s     },
  { u8"Gwich'in"s,                                                                         "gwi"s, ""s,   ""s     },
  { u8"Haida"s,                                                                            "hai"s, ""s,   ""s     },
  { u8"Haitian; Haitian Creole"s,                                                          "hat"s, "ht"s, ""s     },
  { u8"Hausa"s,                                                                            "hau"s, "ha"s, ""s     },
  { u8"Hawaiian"s,                                                                         "haw"s, ""s,   ""s     },
  { u8"Hebrew"s,                                                                           "heb"s, "he"s, ""s     },
  { u8"Herero"s,                                                                           "her"s, "hz"s, ""s     },
  { u8"Hiligaynon"s,                                                                       "hil"s, ""s,   ""s     },
  { u8"Himachali languages; Western Pahari languages"s,                                    "him"s, ""s,   ""s     },
  { u8"Hindi"s,                                                                            "hin"s, "hi"s, ""s     },
  { u8"Hiri Motu"s,                                                                        "hmo"s, "ho"s, ""s     },
  { u8"Hittite"s,                                                                          "hit"s, ""s,   ""s     },
  { u8"Hmong; Mong"s,                                                                      "hmn"s, ""s,   ""s     },
  { u8"Hungarian"s,                                                                        "hun"s, "hu"s, ""s     },
  { u8"Hupa"s,                                                                             "hup"s, ""s,   ""s     },
  { u8"Iban"s,                                                                             "iba"s, ""s,   ""s     },
  { u8"Icelandic"s,                                                                        "ice"s, "is"s, "isl"s  },
  { u8"Ido"s,                                                                              "ido"s, "io"s, ""s     },
  { u8"Igbo"s,                                                                             "ibo"s, "ig"s, ""s     },
  { u8"Ijo languages"s,                                                                    "ijo"s, ""s,   ""s     },
  { u8"Iloko"s,                                                                            "ilo"s, ""s,   ""s     },
  { u8"Inari Sami"s,                                                                       "smn"s, ""s,   ""s     },
  { u8"Indic languages"s,                                                                  "inc"s, ""s,   ""s     },
  { u8"Indo-European languages"s,                                                          "ine"s, ""s,   ""s     },
  { u8"Indonesian"s,                                                                       "ind"s, "id"s, ""s     },
  { u8"Ingush"s,                                                                           "inh"s, ""s,   ""s     },
  { u8"Interlingua (International Auxiliary Language Association)"s,                       "ina"s, "ia"s, ""s     },
  { u8"Interlingue; Occidental"s,                                                          "ile"s, "ie"s, ""s     },
  { u8"Inuktitut"s,                                                                        "iku"s, "iu"s, ""s     },
  { u8"Inupiaq"s,                                                                          "ipk"s, "ik"s, ""s     },
  { u8"Iranian languages"s,                                                                "ira"s, ""s,   ""s     },
  { u8"Irish"s,                                                                            "gle"s, "ga"s, ""s     },
  { u8"Irish, Middle (900-1200)"s,                                                         "mga"s, ""s,   ""s     },
  { u8"Irish, Old (to 900)"s,                                                              "sga"s, ""s,   ""s     },
  { u8"Iroquoian languages"s,                                                              "iro"s, ""s,   ""s     },
  { u8"Italian"s,                                                                          "ita"s, "it"s, ""s     },
  { u8"Japanese"s,                                                                         "jpn"s, "ja"s, ""s     },
  { u8"Javanese"s,                                                                         "jav"s, "jv"s, ""s     },
  { u8"Judeo-Arabic"s,                                                                     "jrb"s, ""s,   ""s     },
  { u8"Judeo-Persian"s,                                                                    "jpr"s, ""s,   ""s     },
  { u8"Kabardian"s,                                                                        "kbd"s, ""s,   ""s     },
  { u8"Kabyle"s,                                                                           "kab"s, ""s,   ""s     },
  { u8"Kachin; Jingpho"s,                                                                  "kac"s, ""s,   ""s     },
  { u8"Kalaallisut; Greenlandic"s,                                                         "kal"s, "kl"s, ""s     },
  { u8"Kalmyk; Oirat"s,                                                                    "xal"s, ""s,   ""s     },
  { u8"Kamba"s,                                                                            "kam"s, ""s,   ""s     },
  { u8"Kannada"s,                                                                          "kan"s, "kn"s, ""s     },
  { u8"Kanuri"s,                                                                           "kau"s, "kr"s, ""s     },
  { u8"Kara-Kalpak"s,                                                                      "kaa"s, ""s,   ""s     },
  { u8"Karachay-Balkar"s,                                                                  "krc"s, ""s,   ""s     },
  { u8"Karelian"s,                                                                         "krl"s, ""s,   ""s     },
  { u8"Karen languages"s,                                                                  "kar"s, ""s,   ""s     },
  { u8"Kashmiri"s,                                                                         "kas"s, "ks"s, ""s     },
  { u8"Kashubian"s,                                                                        "csb"s, ""s,   ""s     },
  { u8"Kawi"s,                                                                             "kaw"s, ""s,   ""s     },
  { u8"Kazakh"s,                                                                           "kaz"s, "kk"s, ""s     },
  { u8"Khasi"s,                                                                            "kha"s, ""s,   ""s     },
  { u8"Khoisan languages"s,                                                                "khi"s, ""s,   ""s     },
  { u8"Khotanese; Sakan"s,                                                                 "kho"s, ""s,   ""s     },
  { u8"Kikuyu; Gikuyu"s,                                                                   "kik"s, "ki"s, ""s     },
  { u8"Kimbundu"s,                                                                         "kmb"s, ""s,   ""s     },
  { u8"Kinyarwanda"s,                                                                      "kin"s, "rw"s, ""s     },
  { u8"Kirghiz; Kyrgyz"s,                                                                  "kir"s, "ky"s, ""s     },
  { u8"Klingon; tlhIngan-Hol"s,                                                            "tlh"s, ""s,   ""s     },
  { u8"Komi"s,                                                                             "kom"s, "kv"s, ""s     },
  { u8"Kongo"s,                                                                            "kon"s, "kg"s, ""s     },
  { u8"Konkani"s,                                                                          "kok"s, ""s,   ""s     },
  { u8"Korean"s,                                                                           "kor"s, "ko"s, ""s     },
  { u8"Kosraean"s,                                                                         "kos"s, ""s,   ""s     },
  { u8"Kpelle"s,                                                                           "kpe"s, ""s,   ""s     },
  { u8"Kru languages"s,                                                                    "kro"s, ""s,   ""s     },
  { u8"Kuanyama; Kwanyama"s,                                                               "kua"s, "kj"s, ""s     },
  { u8"Kumyk"s,                                                                            "kum"s, ""s,   ""s     },
  { u8"Kurdish"s,                                                                          "kur"s, "ku"s, ""s     },
  { u8"Kurukh"s,                                                                           "kru"s, ""s,   ""s     },
  { u8"Kutenai"s,                                                                          "kut"s, ""s,   ""s     },
  { u8"Ladino"s,                                                                           "lad"s, ""s,   ""s     },
  { u8"Lahnda"s,                                                                           "lah"s, ""s,   ""s     },
  { u8"Lamba"s,                                                                            "lam"s, ""s,   ""s     },
  { u8"Land Dayak languages"s,                                                             "day"s, ""s,   ""s     },
  { u8"Lao"s,                                                                              "lao"s, "lo"s, ""s     },
  { u8"Latin"s,                                                                            "lat"s, "la"s, ""s     },
  { u8"Latvian"s,                                                                          "lav"s, "lv"s, ""s     },
  { u8"Lezghian"s,                                                                         "lez"s, ""s,   ""s     },
  { u8"Limburgan; Limburger; Limburgish"s,                                                 "lim"s, "li"s, ""s     },
  { u8"Lingala"s,                                                                          "lin"s, "ln"s, ""s     },
  { u8"Lithuanian"s,                                                                       "lit"s, "lt"s, ""s     },
  { u8"Lojban"s,                                                                           "jbo"s, ""s,   ""s     },
  { u8"Low German; Low Saxon; German, Low; Saxon, Low"s,                                   "nds"s, ""s,   ""s     },
  { u8"Lower Sorbian"s,                                                                    "dsb"s, ""s,   ""s     },
  { u8"Lozi"s,                                                                             "loz"s, ""s,   ""s     },
  { u8"Luba-Katanga"s,                                                                     "lub"s, "lu"s, ""s     },
  { u8"Luba-Lulua"s,                                                                       "lua"s, ""s,   ""s     },
  { u8"Luiseno"s,                                                                          "lui"s, ""s,   ""s     },
  { u8"Lule Sami"s,                                                                        "smj"s, ""s,   ""s     },
  { u8"Lunda"s,                                                                            "lun"s, ""s,   ""s     },
  { u8"Luo (Kenya and Tanzania)"s,                                                         "luo"s, ""s,   ""s     },
  { u8"Lushai"s,                                                                           "lus"s, ""s,   ""s     },
  { u8"Luxembourgish; Letzeburgesch"s,                                                     "ltz"s, "lb"s, ""s     },
  { u8"Macedonian"s,                                                                       "mac"s, "mk"s, "mkd"s  },
  { u8"Madurese"s,                                                                         "mad"s, ""s,   ""s     },
  { u8"Magahi"s,                                                                           "mag"s, ""s,   ""s     },
  { u8"Maithili"s,                                                                         "mai"s, ""s,   ""s     },
  { u8"Makasar"s,                                                                          "mak"s, ""s,   ""s     },
  { u8"Malagasy"s,                                                                         "mlg"s, "mg"s, ""s     },
  { u8"Malay"s,                                                                            "may"s, "ms"s, "msa"s  },
  { u8"Malayalam"s,                                                                        "mal"s, "ml"s, ""s     },
  { u8"Maltese"s,                                                                          "mlt"s, "mt"s, ""s     },
  { u8"Manchu"s,                                                                           "mnc"s, ""s,   ""s     },
  { u8"Mandar"s,                                                                           "mdr"s, ""s,   ""s     },
  { u8"Mandingo"s,                                                                         "man"s, ""s,   ""s     },
  { u8"Manipuri"s,                                                                         "mni"s, ""s,   ""s     },
  { u8"Manobo languages"s,                                                                 "mno"s, ""s,   ""s     },
  { u8"Manx"s,                                                                             "glv"s, "gv"s, ""s     },
  { u8"Maori"s,                                                                            "mao"s, "mi"s, "mri"s  },
  { u8"Mapudungun; Mapuche"s,                                                              "arn"s, ""s,   ""s     },
  { u8"Marathi"s,                                                                          "mar"s, "mr"s, ""s     },
  { u8"Mari"s,                                                                             "chm"s, ""s,   ""s     },
  { u8"Marshallese"s,                                                                      "mah"s, "mh"s, ""s     },
  { u8"Marwari"s,                                                                          "mwr"s, ""s,   ""s     },
  { u8"Masai"s,                                                                            "mas"s, ""s,   ""s     },
  { u8"Mayan languages"s,                                                                  "myn"s, ""s,   ""s     },
  { u8"Mende"s,                                                                            "men"s, ""s,   ""s     },
  { u8"Mi'kmaq; Micmac"s,                                                                  "mic"s, ""s,   ""s     },
  { u8"Minangkabau"s,                                                                      "min"s, ""s,   ""s     },
  { u8"Mirandese"s,                                                                        "mwl"s, ""s,   ""s     },
  { u8"Mohawk"s,                                                                           "moh"s, ""s,   ""s     },
  { u8"Moksha"s,                                                                           "mdf"s, ""s,   ""s     },
  { u8"Mon-Khmer languages"s,                                                              "mkh"s, ""s,   ""s     },
  { u8"Mongo"s,                                                                            "lol"s, ""s,   ""s     },
  { u8"Mongolian"s,                                                                        "mon"s, "mn"s, ""s     },
  { u8"Mossi"s,                                                                            "mos"s, ""s,   ""s     },
  { u8"Multiple languages"s,                                                               "mul"s, ""s,   ""s     },
  { u8"Munda languages"s,                                                                  "mun"s, ""s,   ""s     },
  { u8"N'Ko"s,                                                                             "nqo"s, ""s,   ""s     },
  { u8"Nahuatl languages"s,                                                                "nah"s, ""s,   ""s     },
  { u8"Nauru"s,                                                                            "nau"s, "na"s, ""s     },
  { u8"Navajo; Navaho"s,                                                                   "nav"s, "nv"s, ""s     },
  { u8"Ndebele, North; North Ndebele"s,                                                    "nde"s, "nd"s, ""s     },
  { u8"Ndebele, South; South Ndebele"s,                                                    "nbl"s, "nr"s, ""s     },
  { u8"Ndonga"s,                                                                           "ndo"s, "ng"s, ""s     },
  { u8"Neapolitan"s,                                                                       "nap"s, ""s,   ""s     },
  { u8"Nepal Bhasa; Newari"s,                                                              "new"s, ""s,   ""s     },
  { u8"Nepali"s,                                                                           "nep"s, "ne"s, ""s     },
  { u8"Nias"s,                                                                             "nia"s, ""s,   ""s     },
  { u8"Niger-Kordofanian languages"s,                                                      "nic"s, ""s,   ""s     },
  { u8"Nilo-Saharan languages"s,                                                           "ssa"s, ""s,   ""s     },
  { u8"Niuean"s,                                                                           "niu"s, ""s,   ""s     },
  { u8"No linguistic content; Not applicable"s,                                            "zxx"s, ""s,   ""s     },
  { u8"Nogai"s,                                                                            "nog"s, ""s,   ""s     },
  { u8"Norse, Old"s,                                                                       "non"s, ""s,   ""s     },
  { u8"North American Indian languages"s,                                                  "nai"s, ""s,   ""s     },
  { u8"Northern Frisian"s,                                                                 "frr"s, ""s,   ""s     },
  { u8"Northern Sami"s,                                                                    "sme"s, "se"s, ""s     },
  { u8"Norwegian Nynorsk; Nynorsk, Norwegian"s,                                            "nno"s, "nn"s, ""s     },
  { u8"Norwegian"s,                                                                        "nor"s, "no"s, ""s     },
  { u8"Nubian languages"s,                                                                 "nub"s, ""s,   ""s     },
  { u8"Nyamwezi"s,                                                                         "nym"s, ""s,   ""s     },
  { u8"Nyankole"s,                                                                         "nyn"s, ""s,   ""s     },
  { u8"Nyoro"s,                                                                            "nyo"s, ""s,   ""s     },
  { u8"Nzima"s,                                                                            "nzi"s, ""s,   ""s     },
  { u8"Occitan (post 1500); Provençal"s,                                                   "oci"s, "oc"s, ""s     },
  { u8"Official Aramaic (700-300 BCE); Imperial Aramaic (700-300 BCE)"s,                   "arc"s, ""s,   ""s     },
  { u8"Ojibwa"s,                                                                           "oji"s, "oj"s, ""s     },
  { u8"Oriya"s,                                                                            "ori"s, "or"s, ""s     },
  { u8"Oromo"s,                                                                            "orm"s, "om"s, ""s     },
  { u8"Osage"s,                                                                            "osa"s, ""s,   ""s     },
  { u8"Ossetian; Ossetic"s,                                                                "oss"s, "os"s, ""s     },
  { u8"Otomian languages"s,                                                                "oto"s, ""s,   ""s     },
  { u8"Pahlavi"s,                                                                          "pal"s, ""s,   ""s     },
  { u8"Palauan"s,                                                                          "pau"s, ""s,   ""s     },
  { u8"Pali"s,                                                                             "pli"s, "pi"s, ""s     },
  { u8"Pampanga; Kapampangan"s,                                                            "pam"s, ""s,   ""s     },
  { u8"Pangasinan"s,                                                                       "pag"s, ""s,   ""s     },
  { u8"Panjabi; Punjabi"s,                                                                 "pan"s, "pa"s, ""s     },
  { u8"Papiamento"s,                                                                       "pap"s, ""s,   ""s     },
  { u8"Papuan languages"s,                                                                 "paa"s, ""s,   ""s     },
  { u8"Pedi; Sepedi; Northern Sotho"s,                                                     "nso"s, ""s,   ""s     },
  { u8"Persian"s,                                                                          "per"s, "fa"s, "fas"s  },
  { u8"Persian, Old (ca. 600-400 B.C.)"s,                                                  "peo"s, ""s,   ""s     },
  { u8"Philippine languages"s,                                                             "phi"s, ""s,   ""s     },
  { u8"Phoenician"s,                                                                       "phn"s, ""s,   ""s     },
  { u8"Pohnpeian"s,                                                                        "pon"s, ""s,   ""s     },
  { u8"Polish"s,                                                                           "pol"s, "pl"s, ""s     },
  { u8"Portuguese"s,                                                                       "por"s, "pt"s, ""s     },
  { u8"Prakrit languages"s,                                                                "pra"s, ""s,   ""s     },
  { u8"Provençal, Old (to 1500)"s,                                                         "pro"s, ""s,   ""s     },
  { u8"Pushto; Pashto"s,                                                                   "pus"s, "ps"s, ""s     },
  { u8"Quechua"s,                                                                          "que"s, "qu"s, ""s     },
  { u8"Rajasthani"s,                                                                       "raj"s, ""s,   ""s     },
  { u8"Rapanui"s,                                                                          "rap"s, ""s,   ""s     },
  { u8"Rarotongan; Cook Islands Maori"s,                                                   "rar"s, ""s,   ""s     },
  { u8"Romance languages"s,                                                                "roa"s, ""s,   ""s     },
  { u8"Romanian; Moldavian; Moldovan"s,                                                    "rum"s, "ro"s, "ron"s  },
  { u8"Romansh"s,                                                                          "roh"s, "rm"s, ""s     },
  { u8"Romany"s,                                                                           "rom"s, ""s,   ""s     },
  { u8"Rundi"s,                                                                            "run"s, "rn"s, ""s     },
  { u8"Russian"s,                                                                          "rus"s, "ru"s, ""s     },
  { u8"Salishan languages"s,                                                               "sal"s, ""s,   ""s     },
  { u8"Samaritan Aramaic"s,                                                                "sam"s, ""s,   ""s     },
  { u8"Sami languages"s,                                                                   "smi"s, ""s,   ""s     },
  { u8"Samoan"s,                                                                           "smo"s, "sm"s, ""s     },
  { u8"Sandawe"s,                                                                          "sad"s, ""s,   ""s     },
  { u8"Sango"s,                                                                            "sag"s, "sg"s, ""s     },
  { u8"Sanskrit"s,                                                                         "san"s, "sa"s, ""s     },
  { u8"Santali"s,                                                                          "sat"s, ""s,   ""s     },
  { u8"Sardinian"s,                                                                        "srd"s, "sc"s, ""s     },
  { u8"Sasak"s,                                                                            "sas"s, ""s,   ""s     },
  { u8"Scots"s,                                                                            "sco"s, ""s,   ""s     },
  { u8"Selkup"s,                                                                           "sel"s, ""s,   ""s     },
  { u8"Semitic languages"s,                                                                "sem"s, ""s,   ""s     },
  { u8"Serbian"s,                                                                          "srp"s, "sr"s, ""s     },
  { u8"Serer"s,                                                                            "srr"s, ""s,   ""s     },
  { u8"Shan"s,                                                                             "shn"s, ""s,   ""s     },
  { u8"Shona"s,                                                                            "sna"s, "sn"s, ""s     },
  { u8"Sichuan Yi; Nuosu"s,                                                                "iii"s, "ii"s, ""s     },
  { u8"Sicilian"s,                                                                         "scn"s, ""s,   ""s     },
  { u8"Sidamo"s,                                                                           "sid"s, ""s,   ""s     },
  { u8"Sign Languages"s,                                                                   "sgn"s, ""s,   ""s     },
  { u8"Siksika"s,                                                                          "bla"s, ""s,   ""s     },
  { u8"Sindhi"s,                                                                           "snd"s, "sd"s, ""s     },
  { u8"Sinhala; Sinhalese"s,                                                               "sin"s, "si"s, ""s     },
  { u8"Sino-Tibetan languages"s,                                                           "sit"s, ""s,   ""s     },
  { u8"Siouan languages"s,                                                                 "sio"s, ""s,   ""s     },
  { u8"Skolt Sami"s,                                                                       "sms"s, ""s,   ""s     },
  { u8"Slave (Athapascan)"s,                                                               "den"s, ""s,   ""s     },
  { u8"Slavic languages"s,                                                                 "sla"s, ""s,   ""s     },
  { u8"Slovak"s,                                                                           "slo"s, "sk"s, "slk"s  },
  { u8"Slovenian"s,                                                                        "slv"s, "sl"s, ""s     },
  { u8"Sogdian"s,                                                                          "sog"s, ""s,   ""s     },
  { u8"Somali"s,                                                                           "som"s, "so"s, ""s     },
  { u8"Songhai languages"s,                                                                "son"s, ""s,   ""s     },
  { u8"Soninke"s,                                                                          "snk"s, ""s,   ""s     },
  { u8"Sorbian languages"s,                                                                "wen"s, ""s,   ""s     },
  { u8"Sotho, Southern"s,                                                                  "sot"s, "st"s, ""s     },
  { u8"South American Indian (Other)"s,                                                    "sai"s, ""s,   ""s     },
  { u8"Southern Altai"s,                                                                   "alt"s, ""s,   ""s     },
  { u8"Southern Sami"s,                                                                    "sma"s, ""s,   ""s     },
  { u8"Spanish; Castilian"s,                                                               "spa"s, "es"s, ""s     },
  { u8"Sranan Tongo"s,                                                                     "srn"s, ""s,   ""s     },
  { u8"Standard Moroccan Tamazight"s,                                                      "zgh"s, ""s,   ""s     },
  { u8"Sukuma"s,                                                                           "suk"s, ""s,   ""s     },
  { u8"Sumerian"s,                                                                         "sux"s, ""s,   ""s     },
  { u8"Sundanese"s,                                                                        "sun"s, "su"s, ""s     },
  { u8"Susu"s,                                                                             "sus"s, ""s,   ""s     },
  { u8"Swahili"s,                                                                          "swa"s, "sw"s, ""s     },
  { u8"Swati"s,                                                                            "ssw"s, "ss"s, ""s     },
  { u8"Swedish"s,                                                                          "swe"s, "sv"s, ""s     },
  { u8"Swiss German; Alemannic; Alsatian"s,                                                "gsw"s, ""s,   ""s     },
  { u8"Syriac"s,                                                                           "syr"s, ""s,   ""s     },
  { u8"Tagalog"s,                                                                          "tgl"s, "tl"s, ""s     },
  { u8"Tahitian"s,                                                                         "tah"s, "ty"s, ""s     },
  { u8"Tai languages"s,                                                                    "tai"s, ""s,   ""s     },
  { u8"Tajik"s,                                                                            "tgk"s, "tg"s, ""s     },
  { u8"Tamashek"s,                                                                         "tmh"s, ""s,   ""s     },
  { u8"Tamil"s,                                                                            "tam"s, "ta"s, ""s     },
  { u8"Tatar"s,                                                                            "tat"s, "tt"s, ""s     },
  { u8"Telugu"s,                                                                           "tel"s, "te"s, ""s     },
  { u8"Tereno"s,                                                                           "ter"s, ""s,   ""s     },
  { u8"Tetum"s,                                                                            "tet"s, ""s,   ""s     },
  { u8"Thai"s,                                                                             "tha"s, "th"s, ""s     },
  { u8"Tibetan"s,                                                                          "tib"s, "bo"s, "bod"s  },
  { u8"Tigre"s,                                                                            "tig"s, ""s,   ""s     },
  { u8"Tigrinya"s,                                                                         "tir"s, "ti"s, ""s     },
  { u8"Timne"s,                                                                            "tem"s, ""s,   ""s     },
  { u8"Tiv"s,                                                                              "tiv"s, ""s,   ""s     },
  { u8"Tlingit"s,                                                                          "tli"s, ""s,   ""s     },
  { u8"Tok Pisin"s,                                                                        "tpi"s, ""s,   ""s     },
  { u8"Tokelau"s,                                                                          "tkl"s, ""s,   ""s     },
  { u8"Tonga (Nyasa)"s,                                                                    "tog"s, ""s,   ""s     },
  { u8"Tonga (Tonga Islands)"s,                                                            "ton"s, "to"s, ""s     },
  { u8"Tsimshian"s,                                                                        "tsi"s, ""s,   ""s     },
  { u8"Tsonga"s,                                                                           "tso"s, "ts"s, ""s     },
  { u8"Tswana"s,                                                                           "tsn"s, "tn"s, ""s     },
  { u8"Tumbuka"s,                                                                          "tum"s, ""s,   ""s     },
  { u8"Tupi languages"s,                                                                   "tup"s, ""s,   ""s     },
  { u8"Turkish"s,                                                                          "tur"s, "tr"s, ""s     },
  { u8"Turkish, Ottoman (1500-1928)"s,                                                     "ota"s, ""s,   ""s     },
  { u8"Turkmen"s,                                                                          "tuk"s, "tk"s, ""s     },
  { u8"Tuvalu"s,                                                                           "tvl"s, ""s,   ""s     },
  { u8"Tuvinian"s,                                                                         "tyv"s, ""s,   ""s     },
  { u8"Twi"s,                                                                              "twi"s, "tw"s, ""s     },
  { u8"Udmurt"s,                                                                           "udm"s, ""s,   ""s     },
  { u8"Ugaritic"s,                                                                         "uga"s, ""s,   ""s     },
  { u8"Uighur; Uyghur"s,                                                                   "uig"s, "ug"s, ""s     },
  { u8"Ukrainian"s,                                                                        "ukr"s, "uk"s, ""s     },
  { u8"Umbundu"s,                                                                          "umb"s, ""s,   ""s     },
  { u8"Uncoded languages"s,                                                                "mis"s, ""s,   ""s     },
  { u8"Undetermined"s,                                                                     "und"s, ""s,   ""s     },
  { u8"Upper Sorbian"s,                                                                    "hsb"s, ""s,   ""s     },
  { u8"Urdu"s,                                                                             "urd"s, "ur"s, ""s     },
  { u8"Uzbek"s,                                                                            "uzb"s, "uz"s, ""s     },
  { u8"Vai"s,                                                                              "vai"s, ""s,   ""s     },
  { u8"Venda"s,                                                                            "ven"s, "ve"s, ""s     },
  { u8"Vietnamese"s,                                                                       "vie"s, "vi"s, ""s     },
  { u8"Volapük"s,                                                                          "vol"s, "vo"s, ""s     },
  { u8"Votic"s,                                                                            "vot"s, ""s,   ""s     },
  { u8"Wakashan languages"s,                                                               "wak"s, ""s,   ""s     },
  { u8"Walamo"s,                                                                           "wal"s, ""s,   ""s     },
  { u8"Walloon"s,                                                                          "wln"s, "wa"s, ""s     },
  { u8"Waray"s,                                                                            "war"s, ""s,   ""s     },
  { u8"Washo"s,                                                                            "was"s, ""s,   ""s     },
  { u8"Welsh"s,                                                                            "wel"s, "cy"s, "cym"s  },
  { u8"Western Frisian"s,                                                                  "fry"s, "fy"s, ""s     },
  { u8"Wolof"s,                                                                            "wol"s, "wo"s, ""s     },
  { u8"Xhosa"s,                                                                            "xho"s, "xh"s, ""s     },
  { u8"Yakut"s,                                                                            "sah"s, ""s,   ""s     },
  { u8"Yao"s,                                                                              "yao"s, ""s,   ""s     },
  { u8"Yapese"s,                                                                           "yap"s, ""s,   ""s     },
  { u8"Yiddish"s,                                                                          "yid"s, "yi"s, ""s     },
  { u8"Yoruba"s,                                                                           "yor"s, "yo"s, ""s     },
  { u8"Yupik languages"s,                                                                  "ypk"s, ""s,   ""s     },
  { u8"Zande languages"s,                                                                  "znd"s, ""s,   ""s     },
  { u8"Zapotec"s,                                                                          "zap"s, ""s,   ""s     },
  { u8"Zaza; Dimili; Dimli; Kirdki; Kirmanjki; Zazaki"s,                                   "zza"s, ""s,   ""s     },
  { u8"Zenaga"s,                                                                           "zen"s, ""s,   ""s     },
  { u8"Zhuang; Chuang"s,                                                                   "zha"s, "za"s, ""s     },
  { u8"Zulu"s,                                                                             "zul"s, "zu"s, ""s     },
  { u8"Zuni"s,                                                                             "zun"s, ""s,   ""s     },
};

} // namespace mtx::iso639
