/* SPDX-License-Identifier: GPL-2.0 */
/*
 * mt8188-reg.h  --  MediaTek 8188 audio driver reg definition
 *
 * Copyright (c) 2022 MediaTek Inc.
 * Author: Bicycle Tsai <bicycle.tsai@mediatek.com>
 *         Trevor Wu <trevor.wu@mediatek.com>
 *         Chun-Chia Chiu <chun-chia.chiu@mediatek.com>
 */

#ifndef _MT8188_REG_H_
#define _MT8188_REG_H_

#define AUDIO_TOP_CON0                    (0x0000)
#define AUDIO_TOP_CON1                    (0x0004)
#define AUDIO_TOP_CON2                    (0x0008)
#define AUDIO_TOP_CON3                    (0x000c)
#define AUDIO_TOP_CON4                    (0x0010)
#define AUDIO_TOP_CON5                    (0x0014)
#define AUDIO_TOP_CON6                    (0x0018)
#define AFE_MAS_HADDR_MSB                 (0x0020)
#define AFE_MEMIF_ONE_HEART               (0x0024)
#define AFE_MUX_SEL_CFG                   (0x0044)
#define PWR1_ASM_CON1                     (0x0108)
#define ASYS_IRQ_CONFIG                   (0x0110)
#define ASYS_IRQ1_CON                     (0x0114)
#define ASYS_IRQ2_CON                     (0x0118)
#define ASYS_IRQ3_CON                     (0x011c)
#define ASYS_IRQ4_CON                     (0x0120)
#define ASYS_IRQ5_CON                     (0x0124)
#define ASYS_IRQ6_CON                     (0x0128)
#define ASYS_IRQ7_CON                     (0x012c)
#define ASYS_IRQ8_CON                     (0x0130)
#define ASYS_IRQ9_CON                     (0x0134)
#define ASYS_IRQ10_CON                    (0x0138)
#define ASYS_IRQ11_CON                    (0x013c)
#define ASYS_IRQ12_CON                    (0x0140)
#define ASYS_IRQ13_CON                    (0x0144)
#define ASYS_IRQ14_CON                    (0x0148)
#define ASYS_IRQ15_CON                    (0x014c)
#define ASYS_IRQ16_CON                    (0x0150)
#define ASYS_IRQ_CLR                      (0x0154)
#define ASYS_IRQ_STATUS                   (0x0158)
#define ASYS_IRQ_MON1                     (0x015c)
#define ASYS_IRQ_MON2                     (0x0160)
#define AFE_IRQ1_CON                      (0x0164)
#define AFE_IRQ2_CON                      (0x0168)
#define AFE_IRQ3_CON                      (0x016c)
#define AFE_IRQ_MCU_CLR                   (0x0170)
#define AFE_IRQ_STATUS                    (0x0174)
#define AFE_IRQ_MASK                      (0x0178)
#define ASYS_IRQ_MASK                     (0x017c)
#define AFE_IRQ3_CON_MON                  (0x01b0)
#define AFE_IRQ_MCU_MON2                  (0x01b4)
#define AFE_IRQ8_CON                      (0x01b8)
#define AFE_IRQ9_CON                      (0x01bc)
#define AFE_IRQ10_CON                     (0x01c0)
#define AFE_IRQ9_CON_MON                  (0x01c4)
#define ADSP_IRQ_MASK                     (0x01c8)
#define ADSP_IRQ_STATUS                   (0x01cc)
#define AFE_SINEGEN_CON0                  (0x01f0)
#define AFE_SINEGEN_CON1                  (0x01f4)
#define AFE_SINEGEN_CON2                  (0x01f8)
#define AFE_SINEGEN_CON3                  (0x01fc)
#define AFE_SPDIF_OUT_CON0                (0x0380)
#define AFE_TDMOUT_CONN0                  (0x0390)
#define PWR1_ASM_CON2                     (0x03b0)
#define PWR1_ASM_CON3                     (0x03b4)
#define AFE_APLL_TUNER_CFG                (0x03f8)
#define AFE_APLL_TUNER_CFG1               (0x03fc)
#define AUDIO_TOP_STA0                    (0x0400)
#define AUDIO_TOP_STA1                    (0x0404)
#define AFE_GAIN1_CON0                    (0x0410)
#define AFE_GAIN1_CON1                    (0x0414)
#define AFE_GAIN1_CON2                    (0x0418)
#define AFE_GAIN1_CON3                    (0x041c)
#define AFE_GAIN1_CUR                     (0x0424)
#define AFE_GAIN2_CON0                    (0x0428)
#define AFE_GAIN2_CON1                    (0x042c)
#define AFE_GAIN2_CON2                    (0x0430)
#define AFE_GAIN2_CON3                    (0x0434)
#define AFE_GAIN2_CUR                     (0x043c)
#define AFE_IEC_CFG                       (0x0480)
#define AFE_IEC_NSNUM                     (0x0484)
#define AFE_IEC_BURST_INFO                (0x0488)
#define AFE_IEC_BURST_LEN                 (0x048c)
#define AFE_IEC_NSADR                     (0x0490)
#define AFE_IEC_CHL_STAT0                 (0x04a0)
#define AFE_IEC_CHL_STAT1                 (0x04a4)
#define AFE_IEC_CHR_STAT0                 (0x04a8)
#define AFE_IEC_CHR_STAT1                 (0x04ac)
#define AFE_SPDIFIN_CFG0                  (0x0500)
#define AFE_SPDIFIN_CFG1                  (0x0504)
#define AFE_SPDIFIN_CHSTS1                (0x0508)
#define AFE_SPDIFIN_CHSTS2                (0x050c)
#define AFE_SPDIFIN_CHSTS3                (0x0510)
#define AFE_SPDIFIN_CHSTS4                (0x0514)
#define AFE_SPDIFIN_CHSTS5                (0x0518)
#define AFE_SPDIFIN_CHSTS6                (0x051c)
#define AFE_SPDIFIN_DEBUG1                (0x0520)
#define AFE_SPDIFIN_DEBUG2                (0x0524)
#define AFE_SPDIFIN_DEBUG3                (0x0528)
#define AFE_SPDIFIN_DEBUG4                (0x052c)
#define AFE_SPDIFIN_EC                    (0x0530)
#define AFE_SPDIFIN_CKLOCK_CFG            (0x0534)
#define AFE_SPDIFIN_BR                    (0x053c)
#define AFE_SPDIFIN_BR_DBG1               (0x0540)
#define AFE_SPDIFIN_CKFBDIV               (0x0544)
#define AFE_SPDIFIN_INT_EXT               (0x0548)
#define AFE_SPDIFIN_INT_EXT2              (0x054c)
#define SPDIFIN_FREQ_INFO                 (0x0550)
#define SPDIFIN_FREQ_INFO_2               (0x0554)
#define SPDIFIN_FREQ_INFO_3               (0x0558)
#define SPDIFIN_FREQ_STATUS               (0x055c)
#define SPDIFIN_USERCODE1                 (0x0560)
#define SPDIFIN_USERCODE2                 (0x0564)
#define SPDIFIN_USERCODE3                 (0x0568)
#define SPDIFIN_USERCODE4                 (0x056c)
#define SPDIFIN_USERCODE5                 (0x0570)
#define SPDIFIN_USERCODE6                 (0x0574)
#define SPDIFIN_USERCODE7                 (0x0578)
#define SPDIFIN_USERCODE8                 (0x057c)
#define SPDIFIN_USERCODE9                 (0x0580)
#define SPDIFIN_USERCODE10                (0x0584)
#define SPDIFIN_USERCODE11                (0x0588)
#define SPDIFIN_USERCODE12                (0x058c)
#define AFE_SPDIFIN_APLL_TUNER_CFG        (0x0594)
#define AFE_SPDIFIN_APLL_TUNER_CFG1       (0x0598)
#define ASYS_TOP_CON                      (0x0600)
#define AFE_LINEIN_APLL_TUNER_CFG         (0x0610)
#define AFE_LINEIN_APLL_TUNER_MON         (0x0614)
#define AFE_EARC_APLL_TUNER_CFG           (0x0618)
#define AFE_EARC_APLL_TUNER_MON           (0x061c)
#define PWR2_TOP_CON0                     (0x0634)
#define PWR2_TOP_CON1                     (0x0638)
#define PCM_INTF_CON1                     (0x063c)
#define PCM_INTF_CON2                     (0x0640)
#define AFE_CM0_CON                       (0x0660)
#define AFE_CM1_CON                       (0x0664)
#define AFE_CM2_CON                       (0x0668)
#define AFE_CM0_MON                       (0x0670)
#define AFE_CM1_MON                       (0x0674)
#define AFE_CM2_MON                       (0x0678)
#define AFE_MPHONE_MULTI_CON0             (0x06a4)
#define AFE_MPHONE_MULTI_CON1             (0x06a8)
#define AFE_MPHONE_MULTI_CON2             (0x06ac)
#define AFE_MPHONE_MULTI_MON              (0x06b0)
#define AFE_MPHONE_MULTI_DET_REG_CON0     (0x06b4)
#define AFE_MPHONE_MULTI_DET_REG_CON1     (0x06b8)
#define AFE_MPHONE_MULTI_DET_REG_CON2     (0x06bc)
#define AFE_MPHONE_MULTI_DET_REG_CON3     (0x06c0)
#define AFE_MPHONE_MULTI_DET_MON0         (0x06c4)
#define AFE_MPHONE_MULTI_DET_MON1         (0x06c8)
#define AFE_MPHONE_MULTI_DET_MON2         (0x06d0)
#define AFE_MPHONE_MULTI2_CON0            (0x06d4)
#define AFE_MPHONE_MULTI2_CON1            (0x06d8)
#define AFE_MPHONE_MULTI2_CON2            (0x06dc)
#define AFE_MPHONE_MULTI2_MON             (0x06e0)
#define AFE_MPHONE_MULTI2_DET_REG_CON0    (0x06e4)
#define AFE_MPHONE_MULTI2_DET_REG_CON1    (0x06e8)
#define AFE_MPHONE_MULTI2_DET_REG_CON2    (0x06ec)
#define AFE_MPHONE_MULTI2_DET_REG_CON3    (0x06f0)
#define AFE_MPHONE_MULTI2_DET_MON0        (0x06f4)
#define AFE_MPHONE_MULTI2_DET_MON1        (0x06f8)
#define AFE_MPHONE_MULTI2_DET_MON2        (0x06fc)
#define AFE_ADDA_IIR_COEF_02_01           (0x0700)
#define AFE_ADDA_IIR_COEF_04_03           (0x0704)
#define AFE_ADDA_IIR_COEF_06_05           (0x0708)
#define AFE_ADDA_IIR_COEF_08_07           (0x070c)
#define AFE_ADDA_IIR_COEF_10_09           (0x0710)
#define AFE_ADDA_ULCF_CFG_02_01           (0x0714)
#define AFE_ADDA_ULCF_CFG_04_03           (0x0718)
#define AFE_ADDA_ULCF_CFG_06_05           (0x071c)
#define AFE_ADDA_ULCF_CFG_08_07           (0x0720)
#define AFE_ADDA_ULCF_CFG_10_09           (0x0724)
#define AFE_ADDA_ULCF_CFG_12_11           (0x0728)
#define AFE_ADDA_ULCF_CFG_14_13           (0x072c)
#define AFE_ADDA_ULCF_CFG_16_15           (0x0730)
#define AFE_ADDA_ULCF_CFG_18_17           (0x0734)
#define AFE_ADDA_ULCF_CFG_20_19           (0x0738)
#define AFE_ADDA_ULCF_CFG_22_21           (0x073c)
#define AFE_ADDA_ULCF_CFG_24_23           (0x0740)
#define AFE_ADDA_ULCF_CFG_26_25           (0x0744)
#define AFE_ADDA_ULCF_CFG_28_27           (0x0748)
#define AFE_ADDA_ULCF_CFG_30_29           (0x074c)
#define AFE_ADDA6_IIR_COEF_02_01          (0x0750)
#define AFE_ADDA6_IIR_COEF_04_03          (0x0754)
#define AFE_ADDA6_IIR_COEF_06_05          (0x0758)
#define AFE_ADDA6_IIR_COEF_08_07          (0x075c)
#define AFE_ADDA6_IIR_COEF_10_09          (0x0760)
#define AFE_ADDA6_ULCF_CFG_02_01          (0x0764)
#define AFE_ADDA6_ULCF_CFG_04_03          (0x0768)
#define AFE_ADDA6_ULCF_CFG_06_05          (0x076c)
#define AFE_ADDA6_ULCF_CFG_08_07          (0x0770)
#define AFE_ADDA6_ULCF_CFG_10_09          (0x0774)
#define AFE_ADDA6_ULCF_CFG_12_11          (0x0778)
#define AFE_ADDA6_ULCF_CFG_14_13          (0x077c)
#define AFE_ADDA6_ULCF_CFG_16_15          (0x0780)
#define AFE_ADDA6_ULCF_CFG_18_17          (0x0784)
#define AFE_ADDA6_ULCF_CFG_20_19          (0x0788)
#define AFE_ADDA6_ULCF_CFG_22_21          (0x078c)
#define AFE_ADDA6_ULCF_CFG_24_23          (0x0790)
#define AFE_ADDA6_ULCF_CFG_26_25          (0x0794)
#define AFE_ADDA6_ULCF_CFG_28_27          (0x0798)
#define AFE_ADDA6_ULCF_CFG_30_29          (0x079c)
#define AFE_ADDA_MTKAIF_CFG0              (0x07a0)
#define AFE_ADDA_MTKAIF_SYNCWORD_CFG      (0x07a8)
#define AFE_ADDA_MTKAIF_RX_CFG0           (0x07b4)
#define AFE_ADDA_MTKAIF_RX_CFG1           (0x07b8)
#define AFE_ADDA_MTKAIF_RX_CFG2           (0x07bc)
#define AFE_ADDA_MTKAIF_MON0              (0x07c8)
#define AFE_ADDA_MTKAIF_MON1              (0x07cc)
#define AFE_AUD_PAD_TOP                   (0x07d4)
#define AFE_ADDA6_MTKAIF_MON0             (0x07d8)
#define AFE_ADDA6_MTKAIF_MON1             (0x07dc)
#define AFE_ADDA6_MTKAIF_CFG0             (0x07e0)
#define AFE_ADDA6_MTKAIF_RX_CFG0          (0x07e4)
#define AFE_ADDA6_MTKAIF_RX_CFG1          (0x07e8)
#define AFE_ADDA6_MTKAIF_RX_CFG2          (0x07ec)
#define AFE_ADDA6_TOP_CON0                (0x07f0)
#define AFE_ADDA6_UL_SRC_CON0             (0x07f4)
#define AFE_ADDA6_UL_SRC_CON1             (0x07f8)
#define AFE_ADDA6_SRC_DEBUG               (0x0800)
#define AFE_ADDA6_SRC_DEBUG_MON0          (0x0804)
#define AFE_ADDA6_UL_SRC_MON0             (0x0818)
#define AFE_ADDA6_UL_SRC_MON1             (0x081c)
#define AFE_CONN0_5                       (0x0830)
#define AFE_CONN1_5                       (0x0834)
#define AFE_CONN2_5                       (0x0838)
#define AFE_CONN3_5                       (0x083c)
#define AFE_CONN4_5                       (0x0840)
#define AFE_CONN5_5                       (0x0844)
#define AFE_CONN6_5                       (0x0848)
#define AFE_CONN7_5                       (0x084c)
#define AFE_CONN8_5                       (0x0850)
#define AFE_CONN9_5                       (0x0854)
#define AFE_CONN10_5                      (0x0858)
#define AFE_CONN11_5                      (0x085c)
#define AFE_CONN12_5                      (0x0860)
#define AFE_CONN13_5                      (0x0864)
#define AFE_CONN14_5                      (0x0868)
#define AFE_CONN15_5                      (0x086c)
#define AFE_CONN16_5                      (0x0870)
#define AFE_CONN17_5                      (0x0874)
#define AFE_CONN18_5                      (0x0878)
#define AFE_CONN19_5                      (0x087c)
#define AFE_CONN20_5                      (0x0880)
#define AFE_CONN21_5                      (0x0884)
#define AFE_CONN22_5                      (0x0888)
#define AFE_CONN23_5                      (0x088c)
#define AFE_CONN24_5                      (0x0890)
#define AFE_CONN25_5                      (0x0894)
#define AFE_CONN26_5                      (0x0898)
#define AFE_CONN27_5                      (0x089c)
#define AFE_CONN28_5                      (0x08a0)
#define AFE_CONN29_5                      (0x08a4)
#define AFE_CONN30_5                      (0x08a8)
#define AFE_CONN31_5                      (0x08ac)
#define AFE_CONN32_5                      (0x08b0)
#define AFE_CONN33_5                      (0x08b4)
#define AFE_CONN34_5                      (0x08b8)
#define AFE_CONN35_5                      (0x08bc)
#define AFE_CONN36_5                      (0x08c0)
#define AFE_CONN37_5                      (0x08c4)
#define AFE_CONN38_5                      (0x08c8)
#define AFE_CONN39_5                      (0x08cc)
#define AFE_CONN40_5                      (0x08d0)
#define AFE_CONN41_5                      (0x08d4)
#define AFE_CONN42_5                      (0x08d8)
#define AFE_CONN43_5                      (0x08dc)
#define AFE_CONN44_5                      (0x08e0)
#define AFE_CONN45_5                      (0x08e4)
#define AFE_CONN46_5                      (0x08e8)
#define AFE_CONN47_5                      (0x08ec)
#define AFE_CONN48_5                      (0x08f0)
#define AFE_CONN49_5                      (0x08f4)
#define AFE_CONN50_5                      (0x08f8)
#define AFE_CONN51_5                      (0x08fc)
#define AFE_CONN52_5                      (0x0900)
#define AFE_CONN53_5                      (0x0904)
#define AFE_CONN54_5                      (0x0908)
#define AFE_CONN55_5                      (0x090c)
#define AFE_CONN56_5                      (0x0910)
#define AFE_CONN57_5                      (0x0914)
#define AFE_CONN58_5                      (0x0918)
#define AFE_CONN59_5                      (0x091c)
#define AFE_CONN60_5                      (0x0920)
#define AFE_CONN61_5                      (0x0924)
#define AFE_CONN62_5                      (0x0928)
#define AFE_CONN63_5                      (0x092c)
#define AFE_CONN64_5                      (0x0930)
#define AFE_CONN65_5                      (0x0934)
#define AFE_CONN66_5                      (0x0938)
#define AFE_CONN67_5                      (0x093c)
#define AFE_CONN68_5                      (0x0940)
#define AFE_CONN69_5                      (0x0944)
#define AFE_CONN70_5                      (0x0948)
#define AFE_CONN71_5                      (0x094c)
#define AFE_CONN72_5                      (0x0950)
#define AFE_CONN73_5                      (0x0954)
#define AFE_CONN74_5                      (0x0958)
#define AFE_CONN75_5                      (0x095c)
#define AFE_CONN76_5                      (0x0960)
#define AFE_CONN77_5                      (0x0964)
#define AFE_CONN78_5                      (0x0968)
#define AFE_CONN79_5                      (0x096c)
#define AFE_CONN80_5                      (0x0970)
#define AFE_CONN81_5                      (0x0974)
#define AFE_CONN82_5                      (0x0978)
#define AFE_CONN83_5                      (0x097c)
#define AFE_CONN84_5                      (0x0980)
#define AFE_CONN85_5                      (0x0984)
#define AFE_CONN86_5                      (0x0988)
#define AFE_CONN87_5                      (0x098c)
#define AFE_CONN88_5                      (0x0990)
#define AFE_CONN89_5                      (0x0994)
#define AFE_CONN90_5                      (0x0998)
#define AFE_CONN91_5                      (0x099c)
#define AFE_CONN92_5                      (0x09a0)
#define AFE_CONN93_5                      (0x09a4)
#define AFE_CONN94_5                      (0x09a8)
#define AFE_CONN95_5                      (0x09ac)
#define AFE_CONN96_5                      (0x09b0)
#define AFE_CONN97_5                      (0x09b4)
#define AFE_CONN98_5                      (0x09b8)
#define AFE_CONN99_5                      (0x09bc)
#define AFE_CONN100_5                     (0x09c0)
#define AFE_CONN101_5                     (0x09c4)
#define AFE_CONN102_5                     (0x09c8)
#define AFE_CONN103_5                     (0x09cc)
#define AFE_CONN104_5                     (0x09d0)
#define AFE_CONN105_5                     (0x09d4)
#define AFE_CONN106_5                     (0x09d8)
#define AFE_CONN107_5                     (0x09dc)
#define AFE_CONN108_5                     (0x09e0)
#define AFE_CONN109_5                     (0x09e4)
#define AFE_CONN110_5                     (0x09e8)
#define AFE_CONN111_5                     (0x09ec)
#define AFE_CONN112_5                     (0x09f0)
#define AFE_CONN113_5                     (0x09f4)
#define AFE_CONN114_5                     (0x09f8)
#define AFE_CONN115_5                     (0x09fc)
#define AFE_CONN116_5                     (0x0a00)
#define AFE_CONN117_5                     (0x0a04)
#define AFE_CONN118_5                     (0x0a08)
#define AFE_CONN119_5                     (0x0a0c)
#define AFE_CONN120_5                     (0x0a10)
#define AFE_CONN121_5                     (0x0a14)
#define AFE_CONN122_5                     (0x0a18)
#define AFE_CONN123_5                     (0x0a1c)
#define AFE_CONN124_5                     (0x0a20)
#define AFE_CONN125_5                     (0x0a24)
#define AFE_CONN126_5                     (0x0a28)
#define AFE_CONN127_5                     (0x0a2c)
#define AFE_CONN128_5                     (0x0a30)
#define AFE_CONN129_5                     (0x0a34)
#define AFE_CONN130_5                     (0x0a38)
#define AFE_CONN131_5                     (0x0a3c)
#define AFE_CONN132_5                     (0x0a40)
#define AFE_CONN133_5                     (0x0a44)
#define AFE_CONN134_5                     (0x0a48)
#define AFE_CONN135_5                     (0x0a4c)
#define AFE_CONN136_5                     (0x0a50)
#define AFE_CONN137_5                     (0x0a54)
#define AFE_CONN138_5                     (0x0a58)
#define AFE_CONN139_5                     (0x0a5c)
#define AFE_CONN_RS_5                     (0x0a60)
#define AFE_CONN_DI_5                     (0x0a64)
#define AFE_CONN_16BIT_5                  (0x0a68)
#define AFE_CONN_24BIT_5                  (0x0a6c)
#define AFE_SECURE_MASK_CONN53_5          (0x0a70)
#define AFE_SECURE_MASK_CONN54_5          (0x0a74)
#define AFE_SECURE_MASK_CONN55_5          (0x0a78)
#define AFE_SECURE_MASK_CONN56_5          (0x0a7c)
#define AFE_SECURE_MASK_CONN57_5          (0x0a80)
#define AFE_SECURE_MASK_CONN58_5          (0x0a84)
#define AFE_SECURE_MASK_CONN59_5          (0x0a88)
#define AFE_SECURE_MASK_CONN60_5          (0x0a8c)
#define AFE_SECURE_MASK_CONN61_5          (0x0a90)
#define AFE_SECURE_MASK_CONN62_5          (0x0a94)
#define AFE_SECURE_MASK_CONN63_5          (0x0a98)
#define AFE_SECURE_MASK_CONN64_5          (0x0a9c)
#define AFE_SECURE_MASK_CONN65_5          (0x0aa0)
#define AFE_SECURE_MASK_CONN66_5          (0x0aa4)
#define AFE_SECURE_MASK_CONN67_5          (0x0aa8)
#define AFE_SECURE_MASK_CONN68_5          (0x0aac)
#define AFE_SECURE_MASK_CONN69_5          (0x0ab0)
#define AFE_SECURE_MASK_CONN70_5          (0x0ab4)
#define AFE_SECURE_MASK_CONN71_5          (0x0ab8)
#define AFE_SECURE_MASK_CONN72_5          (0x0abc)
#define AFE_SECURE_MASK_CONN73_5          (0x0ac0)
#define AFE_SECURE_MASK_CONN74_5          (0x0ac4)
#define AFE_SECURE_MASK_CONN75_5          (0x0ac8)
#define AFE_SECURE_MASK_CONN76_5          (0x0acc)
#define AFE_SECURE_MASK_CONN77_5          (0x0ad0)
#define AFE_SECURE_MASK_CONN78_5          (0x0ad4)
#define AFE_SECURE_MASK_CONN79_5          (0x0ad8)
#define AFE_SECURE_MASK_CONN80_5          (0x0adc)
#define AFE_SECURE_MASK_CONN81_5          (0x0ae0)
#define AFE_SECURE_MASK_CONN82_5          (0x0ae4)
#define AFE_SECURE_MASK_CONN83_5          (0x0ae8)
#define AFE_SECURE_MASK_CONN84_5          (0x0aec)
#define AFE_SECURE_MASK_CONN85_5          (0x0af0)
#define AFE_SECURE_MASK_CONN86_5          (0x0af4)
#define AFE_SECURE_MASK_CONN87_5          (0x0af8)
#define AFE_SECURE_MASK_CONN88_5          (0x0afc)
#define AFE_SECURE_MASK_CONN89_5          (0x0b00)
#define AFE_SECURE_MASK_CONN90_5          (0x0b04)
#define AFE_SECURE_MASK_CONN91_5          (0x0b08)
#define AFE_SECURE_MASK_CONN92_5          (0x0b0c)
#define AFE_SECURE_MASK_CONN93_5          (0x0b10)
#define AFE_SECURE_MASK_CONN94_5          (0x0b14)
#define AFE_SECURE_MASK_CONN95_5          (0x0b18)
#define AFE_SECURE_MASK_CONN96_5          (0x0b1c)
#define AFE_SECURE_MASK_CONN97_5          (0x0b20)
#define AFE_SECURE_MASK_CONN98_5          (0x0b24)
#define AFE_SECURE_MASK_CONN99_5          (0x0b28)
#define AFE_SECURE_MASK_CONN100_5         (0x0b2c)
#define AFE_SECURE_MASK_CONN101_5         (0x0b30)
#define AFE_SECURE_MASK_CONN102_5         (0x0b34)
#define AFE_SECURE_MASK_CONN103_5         (0x0b38)
#define AFE_SECURE_MASK_CONN104_5         (0x0b3c)
#define AFE_SECURE_MASK_CONN105_5         (0x0b40)
#define AFE_SECURE_MASK_CONN106_5         (0x0b44)
#define AFE_SECURE_MASK_CONN107_5         (0x0b48)
#define AFE_SECURE_MASK_CONN108_5         (0x0b4c)
#define AFE_SECURE_MASK_CONN109_5         (0x0b50)
#define AFE_SECURE_MASK_CONN110_5         (0x0b54)
#define AFE_SECURE_MASK_CONN111_5         (0x0b58)
#define AFE_SECURE_MASK_CONN112_5         (0x0b5c)
#define AFE_SECURE_MASK_CONN113_5         (0x0b60)
#define AFE_SECURE_MASK_CONN114_5         (0x0b64)
#define AFE_SECURE_MASK_CONN115_5         (0x0b68)
#define AFE_SECURE_MASK_CONN116_5         (0x0b6c)
#define AFE_SECURE_MASK_CONN117_5         (0x0b70)
#define AFE_SECURE_MASK_CONN118_5         (0x0b74)
#define AFE_SECURE_MASK_CONN119_5         (0x0b78)
#define AFE_SECURE_MASK_CONN120_5         (0x0b7c)
#define AFE_SECURE_MASK_CONN121_5         (0x0b80)
#define AFE_SECURE_MASK_CONN122_5         (0x0b84)
#define AFE_SECURE_MASK_CONN123_5         (0x0b88)
#define AFE_SECURE_MASK_CONN124_5         (0x0b8c)
#define AFE_SECURE_MASK_CONN125_5         (0x0b90)
#define AFE_SECURE_MASK_CONN126_5         (0x0b94)
#define AFE_SECURE_MASK_CONN127_5         (0x0b98)
#define AFE_SECURE_MASK_CONN128_5         (0x0b9c)
#define AFE_SECURE_MASK_CONN129_5         (0x0ba0)
#define AFE_SECURE_MASK_CONN130_5         (0x0ba4)
#define AFE_SECURE_MASK_CONN131_5         (0x0ba8)
#define AFE_SECURE_MASK_CONN132_5         (0x0bac)
#define AFE_SECURE_MASK_CONN133_5         (0x0bb0)
#define AFE_SECURE_MASK_CONN134_5         (0x0bb4)
#define AFE_SECURE_MASK_CONN135_5         (0x0bb8)
#define AFE_SECURE_MASK_CONN136_5         (0x0bbc)
#define AFE_SECURE_MASK_CONN137_5         (0x0bc0)
#define AFE_SECURE_MASK_CONN138_5         (0x0bc4)
#define AFE_SECURE_MASK_CONN139_5         (0x0bc8)
#define AFE_SECURE_MASK_CONN_RS_5         (0x0bcc)
#define AFE_SECURE_MASK_CONN_16BIT_5      (0x0bd0)
#define AFE_SECURE_MASK_CONN_24BIT_5      (0x0bd4)
#define AFE_ASRC11_NEW_CON0               (0x0d80)
#define AFE_ASRC11_NEW_CON1               (0x0d84)
#define AFE_ASRC11_NEW_CON2               (0x0d88)
#define AFE_ASRC11_NEW_CON3               (0x0d8c)
#define AFE_ASRC11_NEW_CON4               (0x0d90)
#define AFE_ASRC11_NEW_CON5               (0x0d94)
#define AFE_ASRC11_NEW_CON6               (0x0d98)
#define AFE_ASRC11_NEW_CON7               (0x0d9c)
#define AFE_ASRC11_NEW_CON8               (0x0da0)
#define AFE_ASRC11_NEW_CON9               (0x0da4)
#define AFE_ASRC11_NEW_CON10              (0x0da8)
#define AFE_ASRC11_NEW_CON11              (0x0dac)
#define AFE_ASRC11_NEW_CON13              (0x0db4)
#define AFE_ASRC11_NEW_CON14              (0x0db8)
#define AFE_ASRC12_NEW_CON0               (0x0dc0)
#define AFE_ASRC12_NEW_CON1               (0x0dc4)
#define AFE_ASRC12_NEW_CON2               (0x0dc8)
#define AFE_ASRC12_NEW_CON3               (0x0dcc)
#define AFE_ASRC12_NEW_CON4               (0x0dd0)
#define AFE_ASRC12_NEW_CON5               (0x0dd4)
#define AFE_ASRC12_NEW_CON6               (0x0dd8)
#define AFE_ASRC12_NEW_CON7               (0x0ddc)
#define AFE_ASRC12_NEW_CON8               (0x0de0)
#define AFE_ASRC12_NEW_CON9               (0x0de4)
#define AFE_ASRC12_NEW_CON10              (0x0de8)
#define AFE_ASRC12_NEW_CON11              (0x0dec)
#define AFE_ASRC12_NEW_CON13              (0x0df4)
#define AFE_ASRC12_NEW_CON14              (0x0df8)
#define AFE_SECURE_MASK_CONN176           (0x0fe0)
#define AFE_SECURE_MASK_CONN176_1         (0x0fe4)
#define AFE_SECURE_MASK_CONN176_2         (0x0fe8)
#define AFE_SECURE_MASK_CONN176_3         (0x0fec)
#define AFE_SECURE_MASK_CONN176_4         (0x0ff0)
#define AFE_SECURE_MASK_CONN176_5         (0x0ff4)
#define AFE_SECURE_MASK_CONN177           (0x0ff8)
#define AFE_SECURE_MASK_CONN177_1         (0x0ffc)
#define AFE_LRCK_CNT                      (0x1018)
#define AFE_SECURE_MASK_CONN177_2         (0x1020)
#define AFE_SECURE_MASK_CONN177_3         (0x1024)
#define AFE_SECURE_MASK_CONN177_4         (0x1028)
#define AFE_SECURE_MASK_CONN177_5         (0x102c)
#define AFE_SECURE_MASK_CONN182           (0x1090)
#define AFE_SECURE_MASK_CONN182_1         (0x1094)
#define AFE_SECURE_MASK_CONN182_2         (0x1098)
#define AFE_SECURE_MASK_CONN182_3         (0x109c)
#define AFE_SECURE_MASK_CONN182_4         (0x10a0)
#define AFE_SECURE_MASK_CONN182_5         (0x10a4)
#define AFE_SECURE_MASK_CONN183           (0x10a8)
#define AFE_SECURE_MASK_CONN183_1         (0x10ac)
#define AFE_SECURE_MASK_CONN183_2         (0x10b0)
#define AFE_SECURE_MASK_CONN183_3         (0x10b4)
#define AFE_SECURE_MASK_CONN183_4         (0x10b8)
#define AFE_SECURE_MASK_CONN183_5         (0x10bc)
#define AFE_DAC_CON0                      (0x1200)
#define AFE_DAC_CON1                      (0x1204)
#define AFE_DAC_CON2                      (0x1208)
#define AFE_DAC_MON0                      (0x1218)
#define AFE_DL1_BASE                      (0x1240)
#define AFE_DL1_CUR                       (0x1244)
#define AFE_DL1_END                       (0x1248)
#define AFE_DL1_CON0                      (0x124c)
#define AFE_DL2_BASE                      (0x1250)
#define AFE_DL2_CUR                       (0x1254)
#define AFE_DL2_END                       (0x1258)
#define AFE_DL2_CON0                      (0x125c)
#define AFE_DL3_BASE                      (0x1260)
#define AFE_DL3_CUR                       (0x1264)
#define AFE_DL3_END                       (0x1268)
#define AFE_DL3_CON0                      (0x126c)
#define AFE_DL6_BASE                      (0x1290)
#define AFE_DL6_CUR                       (0x1294)
#define AFE_DL6_END                       (0x1298)
#define AFE_DL6_CON0                      (0x129c)
#define AFE_DL7_BASE                      (0x12a0)
#define AFE_DL7_CUR                       (0x12a4)
#define AFE_DL7_END                       (0x12a8)
#define AFE_DL7_CON0                      (0x12ac)
#define AFE_DL8_BASE                      (0x12b0)
#define AFE_DL8_CUR                       (0x12b4)
#define AFE_DL8_END                       (0x12b8)
#define AFE_DL8_CON0                      (0x12bc)
#define AFE_DL10_BASE                     (0x12d0)
#define AFE_DL10_CUR                      (0x12d4)
#define AFE_DL10_END                      (0x12d8)
#define AFE_DL10_CON0                     (0x12dc)
#define AFE_DL11_BASE                     (0x12e0)
#define AFE_DL11_CUR                      (0x12e4)
#define AFE_DL11_END                      (0x12e8)
#define AFE_DL11_CON0                     (0x12ec)
#define AFE_UL1_BASE                      (0x1300)
#define AFE_UL1_CUR                       (0x1304)
#define AFE_UL1_END                       (0x1308)
#define AFE_UL1_CON0                      (0x130c)
#define AFE_UL2_BASE                      (0x1310)
#define AFE_UL2_CUR                       (0x1314)
#define AFE_UL2_END                       (0x1318)
#define AFE_UL2_CON0                      (0x131c)
#define AFE_UL3_BASE                      (0x1320)
#define AFE_UL3_CUR                       (0x1324)
#define AFE_UL3_END                       (0x1328)
#define AFE_UL3_CON0                      (0x132c)
#define AFE_UL4_BASE                      (0x1330)
#define AFE_UL4_CUR                       (0x1334)
#define AFE_UL4_END                       (0x1338)
#define AFE_UL4_CON0                      (0x133c)
#define AFE_UL5_BASE                      (0x1340)
#define AFE_UL5_CUR                       (0x1344)
#define AFE_UL5_END                       (0x1348)
#define AFE_UL5_CON0                      (0x134c)
#define AFE_UL6_BASE                      (0x1350)
#define AFE_UL6_CUR                       (0x1354)
#define AFE_UL6_END                       (0x1358)
#define AFE_UL6_CON0                      (0x135c)
#define AFE_UL8_BASE                      (0x1370)
#define AFE_UL8_CUR                       (0x1374)
#define AFE_UL8_END                       (0x1378)
#define AFE_UL8_CON0                      (0x137c)
#define AFE_UL9_BASE                      (0x1380)
#define AFE_UL9_CUR                       (0x1384)
#define AFE_UL9_END                       (0x1388)
#define AFE_UL9_CON0                      (0x138c)
#define AFE_UL10_BASE                     (0x13d0)
#define AFE_UL10_CUR                      (0x13d4)
#define AFE_UL10_END                      (0x13d8)
#define AFE_UL10_CON0                     (0x13dc)
#define AFE_DL8_CHK_SUM1                  (0x1400)
#define AFE_DL8_CHK_SUM2                  (0x1404)
#define AFE_DL8_CHK_SUM3                  (0x1408)
#define AFE_DL8_CHK_SUM4                  (0x140c)
#define AFE_DL8_CHK_SUM5                  (0x1410)
#define AFE_DL8_CHK_SUM6                  (0x1414)
#define AFE_DL10_CHK_SUM1                 (0x1418)
#define AFE_DL10_CHK_SUM2                 (0x141c)
#define AFE_DL10_CHK_SUM3                 (0x1420)
#define AFE_DL10_CHK_SUM4                 (0x1424)
#define AFE_DL10_CHK_SUM5                 (0x1428)
#define AFE_DL10_CHK_SUM6                 (0x142c)
#define AFE_DL11_CHK_SUM1                 (0x1430)
#define AFE_DL11_CHK_SUM2                 (0x1434)
#define AFE_DL11_CHK_SUM3                 (0x1438)
#define AFE_DL11_CHK_SUM4                 (0x143c)
#define AFE_DL11_CHK_SUM5                 (0x1440)
#define AFE_DL11_CHK_SUM6                 (0x1444)
#define AFE_UL1_CHK_SUM1                  (0x1450)
#define AFE_UL1_CHK_SUM2                  (0x1454)
#define AFE_UL2_CHK_SUM1                  (0x1458)
#define AFE_UL2_CHK_SUM2                  (0x145c)
#define AFE_UL3_CHK_SUM1                  (0x1460)
#define AFE_UL3_CHK_SUM2                  (0x1464)
#define AFE_UL4_CHK_SUM1                  (0x1468)
#define AFE_UL4_CHK_SUM2                  (0x146c)
#define AFE_UL5_CHK_SUM1                  (0x1470)
#define AFE_UL5_CHK_SUM2                  (0x1474)
#define AFE_UL6_CHK_SUM1                  (0x1478)
#define AFE_UL6_CHK_SUM2                  (0x147c)
#define AFE_UL8_CHK_SUM1                  (0x1488)
#define AFE_UL8_CHK_SUM2                  (0x148c)
#define AFE_DL1_CHK_SUM1                  (0x1490)
#define AFE_DL1_CHK_SUM2                  (0x1494)
#define AFE_DL2_CHK_SUM1                  (0x14a0)
#define AFE_DL2_CHK_SUM2                  (0x14a4)
#define AFE_DL3_CHK_SUM1                  (0x14b0)
#define AFE_DL3_CHK_SUM2                  (0x14b4)
#define AFE_DL6_CHK_SUM1                  (0x14e0)
#define AFE_DL6_CHK_SUM2                  (0x14e4)
#define AFE_DL7_CHK_SUM1                  (0x14f0)
#define AFE_DL7_CHK_SUM2                  (0x14f4)
#define AFE_UL9_CHK_SUM1                  (0x1528)
#define AFE_UL9_CHK_SUM2                  (0x152c)
#define AFE_BUS_MON1                      (0x1540)
#define AFE_UL10_CHK_SUM1                 (0x1550)
#define AFE_UL10_CHK_SUM2                 (0x1554)
#define UL1_MOD2AGT_CNT_LAT               (0x1568)
#define UL2_MOD2AGT_CNT_LAT               (0x156c)
#define UL3_MOD2AGT_CNT_LAT               (0x1570)
#define UL4_MOD2AGT_CNT_LAT               (0x1574)
#define UL5_MOD2AGT_CNT_LAT               (0x1578)
#define UL6_MOD2AGT_CNT_LAT               (0x157c)
#define UL8_MOD2AGT_CNT_LAT               (0x1588)
#define UL9_MOD2AGT_CNT_LAT               (0x158c)
#define UL10_MOD2AGT_CNT_LAT              (0x1590)
#define AFE_MEMIF_AGENT_FS_CON0           (0x15a0)
#define AFE_MEMIF_AGENT_FS_CON1           (0x15a4)
#define AFE_MEMIF_AGENT_FS_CON2           (0x15a8)
#define AFE_MEMIF_AGENT_FS_CON3           (0x15ac)
#define AFE_MEMIF_BURST_CFG               (0x1600)
#define AFE_MEMIF_BUF_FULL_MON            (0x1610)
#define AFE_MEMIF_BUF_MON0                (0x1618)
#define AFE_MEMIF_BUF_MON1                (0x161c)
#define AFE_MEMIF_BUF_MON3                (0x1624)
#define AFE_MEMIF_BUF_MON4                (0x1628)
#define AFE_MEMIF_BUF_MON5                (0x162c)
#define AFE_MEMIF_BUF_MON6                (0x1630)
#define AFE_MEMIF_BUF_MON7                (0x1634)
#define AFE_MEMIF_BUF_MON8                (0x1638)
#define AFE_MEMIF_BUF_MON9                (0x163c)
#define AFE_MEMIF_BUF_MON10               (0x1640)
#define DL1_AGENT2MODULE_CNT              (0x1674)
#define DL2_AGENT2MODULE_CNT              (0x1678)
#define DL3_AGENT2MODULE_CNT              (0x167c)
#define DL6_AGENT2MODULE_CNT              (0x1688)
#define DL7_AGENT2MODULE_CNT              (0x168c)
#define DL8_AGENT2MODULE_CNT              (0x1690)
#define DL10_AGENT2MODULE_CNT             (0x1698)
#define DL11_AGENT2MODULE_CNT             (0x169c)
#define UL1_MODULE2AGENT_CNT              (0x16a0)
#define UL2_MODULE2AGENT_CNT              (0x16a4)
#define UL3_MODULE2AGENT_CNT              (0x16a8)
#define UL4_MODULE2AGENT_CNT              (0x16ac)
#define UL5_MODULE2AGENT_CNT              (0x16b0)
#define UL6_MODULE2AGENT_CNT              (0x16b4)
#define UL8_MODULE2AGENT_CNT              (0x16bc)
#define UL9_MODULE2AGENT_CNT              (0x16c0)
#define UL10_MODULE2AGENT_CNT             (0x16c4)
#define AFE_SECURE_CON2                   (0x1798)
#define AFE_SECURE_CON1                   (0x179c)
#define AFE_SECURE_CON                    (0x17a0)
#define AFE_SRAM_BOUND                    (0x17a4)
#define AFE_SE_SECURE_CON                 (0x17a8)
#define AFE_SECURE_MASK_LOOPBACK          (0x17bc)
#define AFE_SRAM_SECURE_CON               (0x1800)
#define AFE_SRAM_SECURE_CON1              (0x1804)
#define AFE_SRAM_SECURE_CON2              (0x1808)
#define AFE_SECURE_SIDEBAND0              (0x1908)
#define AFE_SECURE_SIDEBAND1              (0x190c)
#define AFE_SECURE_SIDEBAND2              (0x1910)
#define AFE_SECURE_SIDEBAND3              (0x1914)
#define AFE_SECURE_MASK_BASE_ADR_MSB      (0x1920)
#define AFE_SECURE_MASK_END_ADR_MSB       (0x1924)
#define AFE_NORMAL_BASE_ADR_MSB           (0x192c)
#define AFE_NORMAL_END_ADR_MSB            (0x1930)
#define AFE_SECURE_MASK_LOOPBACK0         (0x1940)
#define AFE_SECURE_MASK_LOOPBACK1         (0x1944)
#define AFE_SECURE_MASK_LOOPBACK2         (0x1948)
#define AFE_LOOPBACK_CFG0                 (0x1950)
#define AFE_LOOPBACK_CFG1                 (0x1954)
#define AFE_LOOPBACK_CFG2                 (0x1958)
#define AFE_DMIC0_UL_SRC_CON0             (0x1a00)
#define AFE_DMIC0_UL_SRC_CON1             (0x1a04)
#define AFE_DMIC0_SRC_DEBUG               (0x1a08)
#define AFE_DMIC0_SRC_DEBUG_MON0          (0x1a0c)
#define AFE_DMIC0_UL_SRC_MON0             (0x1a10)
#define AFE_DMIC0_UL_SRC_MON1             (0x1a14)
#define AFE_DMIC0_IIR_COEF_02_01          (0x1a18)
#define AFE_DMIC0_IIR_COEF_04_03          (0x1a1c)
#define AFE_DMIC0_IIR_COEF_06_05          (0x1a20)
#define AFE_DMIC0_IIR_COEF_08_07          (0x1a24)
#define AFE_DMIC0_IIR_COEF_10_09          (0x1a28)
#define AFE_DMIC1_UL_SRC_CON0             (0x1a68)
#define AFE_DMIC1_UL_SRC_CON1             (0x1a6c)
#define AFE_DMIC1_SRC_DEBUG               (0x1a70)
#define AFE_DMIC1_SRC_DEBUG_MON0          (0x1a74)
#define AFE_DMIC1_UL_SRC_MON0             (0x1a78)
#define AFE_DMIC1_UL_SRC_MON1             (0x1a7c)
#define AFE_DMIC1_IIR_COEF_02_01          (0x1a80)
#define AFE_DMIC1_IIR_COEF_04_03          (0x1a84)
#define AFE_DMIC1_IIR_COEF_06_05          (0x1a88)
#define AFE_DMIC1_IIR_COEF_08_07          (0x1a8c)
#define AFE_DMIC1_IIR_COEF_10_09          (0x1a90)
#define AFE_DMIC2_UL_SRC_CON0             (0x1ad0)
#define AFE_DMIC2_UL_SRC_CON1             (0x1ad4)
#define AFE_DMIC2_SRC_DEBUG               (0x1ad8)
#define AFE_DMIC2_SRC_DEBUG_MON0          (0x1adc)
#define AFE_DMIC2_UL_SRC_MON0             (0x1ae0)
#define AFE_DMIC2_UL_SRC_MON1             (0x1ae4)
#define AFE_DMIC2_IIR_COEF_02_01          (0x1ae8)
#define AFE_DMIC2_IIR_COEF_04_03          (0x1aec)
#define AFE_DMIC2_IIR_COEF_06_05          (0x1af0)
#define AFE_DMIC2_IIR_COEF_08_07          (0x1af4)
#define AFE_DMIC2_IIR_COEF_10_09          (0x1af8)
#define AFE_DMIC3_UL_SRC_CON0             (0x1b38)
#define AFE_DMIC3_UL_SRC_CON1             (0x1b3c)
#define AFE_DMIC3_SRC_DEBUG               (0x1b40)
#define AFE_DMIC3_SRC_DEBUG_MON0          (0x1b44)
#define AFE_DMIC3_UL_SRC_MON0             (0x1b48)
#define AFE_DMIC3_UL_SRC_MON1             (0x1b4c)
#define AFE_DMIC3_IIR_COEF_02_01          (0x1b50)
#define AFE_DMIC3_IIR_COEF_04_03          (0x1b54)
#define AFE_DMIC3_IIR_COEF_06_05          (0x1b58)
#define AFE_DMIC3_IIR_COEF_08_07          (0x1b5c)
#define AFE_DMIC3_IIR_COEF_10_09          (0x1b60)
#define DMIC_BYPASS_HW_GAIN               (0x1bf0)
#define DMIC_GAIN1_CON0                   (0x1c00)
#define DMIC_GAIN1_CON1                   (0x1c04)
#define DMIC_GAIN1_CON2                   (0x1c08)
#define DMIC_GAIN1_CON3                   (0x1c0c)
#define DMIC_GAIN1_CUR                    (0x1c10)
#define DMIC_GAIN2_CON0                   (0x1c20)
#define DMIC_GAIN2_CON1                   (0x1c24)
#define DMIC_GAIN2_CON2                   (0x1c28)
#define DMIC_GAIN2_CON3                   (0x1c2c)
#define DMIC_GAIN2_CUR                    (0x1c30)
#define DMIC_GAIN3_CON0                   (0x1c40)
#define DMIC_GAIN3_CON1                   (0x1c44)
#define DMIC_GAIN3_CON2                   (0x1c48)
#define DMIC_GAIN3_CON3                   (0x1c4c)
#define DMIC_GAIN3_CUR                    (0x1c50)
#define DMIC_GAIN4_CON0                   (0x1c60)
#define DMIC_GAIN4_CON1                   (0x1c64)
#define DMIC_GAIN4_CON2                   (0x1c68)
#define DMIC_GAIN4_CON3                   (0x1c6c)
#define DMIC_GAIN4_CUR                    (0x1c70)
#define ETDM_OUT1_DSD_FADE_CON            (0x2260)
#define ETDM_OUT1_DSD_FADE_CON1           (0x2264)
#define ETDM_OUT3_DSD_FADE_CON            (0x2280)
#define ETDM_OUT3_DSD_FADE_CON1           (0x2284)
#define ETDM_IN1_AFIFO_CON                (0x2294)
#define ETDM_IN2_AFIFO_CON                (0x2298)
#define ETDM_IN1_MONITOR                  (0x22c0)
#define ETDM_IN2_MONITOR                  (0x22c4)
#define ETDM_OUT1_MONITOR                 (0x22d0)
#define ETDM_OUT2_MONITOR                 (0x22d4)
#define ETDM_OUT3_MONITOR                 (0x22d8)
#define ETDM_COWORK_SEC_CON0              (0x22e0)
#define ETDM_COWORK_SEC_CON1              (0x22e4)
#define ETDM_COWORK_SEC_CON2              (0x22e8)
#define ETDM_COWORK_SEC_CON3              (0x22ec)
#define ETDM_COWORK_CON0                  (0x22f0)
#define ETDM_COWORK_CON1                  (0x22f4)
#define ETDM_COWORK_CON2                  (0x22f8)
#define ETDM_COWORK_CON3                  (0x22fc)
#define ETDM_IN1_CON0                     (0x2300)
#define ETDM_IN1_CON1                     (0x2304)
#define ETDM_IN1_CON2                     (0x2308)
#define ETDM_IN1_CON3                     (0x230c)
#define ETDM_IN1_CON4                     (0x2310)
#define ETDM_IN1_CON5                     (0x2314)
#define ETDM_IN1_CON6                     (0x2318)
#define ETDM_IN1_CON7                     (0x231c)
#define ETDM_IN2_CON0                     (0x2320)
#define ETDM_IN2_CON1                     (0x2324)
#define ETDM_IN2_CON2                     (0x2328)
#define ETDM_IN2_CON3                     (0x232c)
#define ETDM_IN2_CON4                     (0x2330)
#define ETDM_IN2_CON5                     (0x2334)
#define ETDM_IN2_CON6                     (0x2338)
#define ETDM_IN2_CON7                     (0x233c)
#define ETDM_OUT1_CON0                    (0x2380)
#define ETDM_OUT1_CON1                    (0x2384)
#define ETDM_OUT1_CON2                    (0x2388)
#define ETDM_OUT1_CON3                    (0x238c)
#define ETDM_OUT1_CON4                    (0x2390)
#define ETDM_OUT1_CON5                    (0x2394)
#define ETDM_OUT1_CON6                    (0x2398)
#define ETDM_OUT1_CON7                    (0x239c)
#define ETDM_OUT2_CON0                    (0x23a0)
#define ETDM_OUT2_CON1                    (0x23a4)
#define ETDM_OUT2_CON2                    (0x23a8)
#define ETDM_OUT2_CON3                    (0x23ac)
#define ETDM_OUT2_CON4                    (0x23b0)
#define ETDM_OUT2_CON5                    (0x23b4)
#define ETDM_OUT2_CON6                    (0x23b8)
#define ETDM_OUT2_CON7                    (0x23bc)
#define ETDM_OUT3_CON0                    (0x23c0)
#define ETDM_OUT3_CON1                    (0x23c4)
#define ETDM_OUT3_CON2                    (0x23c8)
#define ETDM_OUT3_CON3                    (0x23cc)
#define ETDM_OUT3_CON4                    (0x23d0)
#define ETDM_OUT3_CON5                    (0x23d4)
#define ETDM_OUT3_CON6                    (0x23d8)
#define ETDM_OUT3_CON7                    (0x23dc)
#define ETDM_OUT3_CON8                    (0x23e0)
#define ETDM_OUT1_CON8                    (0x23e4)
#define ETDM_OUT2_CON8                    (0x23e8)
#define GASRC_TIMING_CON0                 (0x2414)
#define GASRC_TIMING_CON1                 (0x2418)
#define GASRC_TIMING_CON2                 (0x241c)
#define GASRC_TIMING_CON3                 (0x2420)
#define GASRC_TIMING_CON4                 (0x2424)
#define GASRC_TIMING_CON5                 (0x2428)
#define A3_A4_TIMING_SEL0                 (0x2440)
#define A3_A4_TIMING_SEL1                 (0x2444)
#define A3_A4_TIMING_SEL2                 (0x2448)
#define A3_A4_TIMING_SEL3                 (0x244c)
#define A3_A4_TIMING_SEL4                 (0x2450)
#define A3_A4_TIMING_SEL5                 (0x2454)
#define A3_A4_TIMING_SEL6                 (0x2458)
#define ASYS_TOP_DEBUG                    (0x2500)
#define AFE_DPTX_CON                      (0x2558)
#define AFE_DPTX_MON                      (0x255c)
#define AFE_ADDA_DL_SRC2_CON0             (0x2d00)
#define AFE_ADDA_DL_SRC2_CON1             (0x2d04)
#define AFE_ADDA_TOP_CON0                 (0x2d0c)
#define AFE_ADDA_UL_DL_CON0               (0x2d10)
#define AFE_ADDA_SRC_DEBUG                (0x2d14)
#define AFE_ADDA_SRC_DEBUG_MON0           (0x2d18)
#define AFE_ADDA_SRC_DEBUG_MON1           (0x2d20)
#define AFE_ADDA_PREDIS_CON0              (0x2d24)
#define AFE_ADDA_PREDIS_CON1              (0x2d28)
#define AFE_ADDA_PREDIS_CON2              (0x2d2c)
#define AFE_ADDA_PREDIS_CON3              (0x2d30)
#define AFE_ADDA_DL_SDM_DCCOMP_CON        (0x2d34)
#define AFE_ADDA_DL_SDM_TEST              (0x2d38)
#define AFE_ADDA_DL_DC_COMP_CFG0          (0x2d3c)
#define AFE_ADDA_DL_DC_COMP_CFG1          (0x2d40)
#define AFE_ADDA_DL_SDM_FIFO_MON          (0x2d44)
#define AFE_ADDA_DL_SRC_LCH_MON           (0x2d50)
#define AFE_ADDA_DL_SRC_RCH_MON           (0x2d54)
#define AFE_ADDA_DL_SDM_OUT_MON           (0x2d58)
#define AFE_ADDA_DL_SDM_DITHER_CON        (0x2d5c)
#define AFE_ADDA_DL_SDM_AUTO_RESET_CON    (0x2d60)
#define AFE_ADDA_UL_SRC_CON0              (0x2e3c)
#define AFE_ADDA_UL_SRC_CON1              (0x2e40)
#define AFE_CONN0                         (0x3000)
#define AFE_CONN0_1                       (0x3004)
#define AFE_CONN0_2                       (0x3008)
#define AFE_CONN0_3                       (0x300c)
#define AFE_CONN0_4                       (0x3010)
#define AFE_CONN1                         (0x3014)
#define AFE_CONN1_1                       (0x3018)
#define AFE_CONN1_2                       (0x301c)
#define AFE_CONN1_3                       (0x3020)
#define AFE_CONN1_4                       (0x3024)
#define AFE_CONN2                         (0x3028)
#define AFE_CONN2_1                       (0x302c)
#define AFE_CONN2_2                       (0x3030)
#define AFE_CONN2_3                       (0x3034)
#define AFE_CONN2_4                       (0x3038)
#define AFE_CONN3                         (0x303c)
#define AFE_CONN3_1                       (0x3040)
#define AFE_CONN3_2                       (0x3044)
#define AFE_CONN3_3                       (0x3048)
#define AFE_CONN3_4                       (0x304c)
#define AFE_CONN4                         (0x3050)
#define AFE_CONN4_1                       (0x3054)
#define AFE_CONN4_2                       (0x3058)
#define AFE_CONN4_3                       (0x305c)
#define AFE_CONN4_4                       (0x3060)
#define AFE_CONN5                         (0x3064)
#define AFE_CONN5_1                       (0x3068)
#define AFE_CONN5_2                       (0x306c)
#define AFE_CONN5_3                       (0x3070)
#define AFE_CONN5_4                       (0x3074)
#define AFE_CONN6                         (0x3078)
#define AFE_CONN6_1                       (0x307c)
#define AFE_CONN6_2                       (0x3080)
#define AFE_CONN6_3                       (0x3084)
#define AFE_CONN6_4                       (0x3088)
#define AFE_CONN7                         (0x308c)
#define AFE_CONN7_1                       (0x3090)
#define AFE_CONN7_2                       (0x3094)
#define AFE_CONN7_3                       (0x3098)
#define AFE_CONN7_4                       (0x309c)
#define AFE_CONN8                         (0x30a0)
#define AFE_CONN8_1                       (0x30a4)
#define AFE_CONN8_2                       (0x30a8)
#define AFE_CONN8_3                       (0x30ac)
#define AFE_CONN8_4                       (0x30b0)
#define AFE_CONN9                         (0x30b4)
#define AFE_CONN9_1                       (0x30b8)
#define AFE_CONN9_2                       (0x30bc)
#define AFE_CONN9_3                       (0x30c0)
#define AFE_CONN9_4                       (0x30c4)
#define AFE_CONN10                        (0x30c8)
#define AFE_CONN10_1                      (0x30cc)
#define AFE_CONN10_2                      (0x30d0)
#define AFE_CONN10_3                      (0x30d4)
#define AFE_CONN10_4                      (0x30d8)
#define AFE_CONN11                        (0x30dc)
#define AFE_CONN11_1                      (0x30e0)
#define AFE_CONN11_2                      (0x30e4)
#define AFE_CONN11_3                      (0x30e8)
#define AFE_CONN11_4                      (0x30ec)
#define AFE_CONN12                        (0x30f0)
#define AFE_CONN12_1                      (0x30f4)
#define AFE_CONN12_2                      (0x30f8)
#define AFE_CONN12_3                      (0x30fc)
#define AFE_CONN12_4                      (0x3100)
#define AFE_CONN13                        (0x3104)
#define AFE_CONN13_1                      (0x3108)
#define AFE_CONN13_2                      (0x310c)
#define AFE_CONN13_3                      (0x3110)
#define AFE_CONN13_4                      (0x3114)
#define AFE_CONN14                        (0x3118)
#define AFE_CONN14_1                      (0x311c)
#define AFE_CONN14_2                      (0x3120)
#define AFE_CONN14_3                      (0x3124)
#define AFE_CONN14_4                      (0x3128)
#define AFE_CONN15                        (0x312c)
#define AFE_CONN15_1                      (0x3130)
#define AFE_CONN15_2                      (0x3134)
#define AFE_CONN15_3                      (0x3138)
#define AFE_CONN15_4                      (0x313c)
#define AFE_CONN16                        (0x3140)
#define AFE_CONN16_1                      (0x3144)
#define AFE_CONN16_2                      (0x3148)
#define AFE_CONN16_3                      (0x314c)
#define AFE_CONN16_4                      (0x3150)
#define AFE_CONN17                        (0x3154)
#define AFE_CONN17_1                      (0x3158)
#define AFE_CONN17_2                      (0x315c)
#define AFE_CONN17_3                      (0x3160)
#define AFE_CONN17_4                      (0x3164)
#define AFE_CONN18                        (0x3168)
#define AFE_CONN18_1                      (0x316c)
#define AFE_CONN18_2                      (0x3170)
#define AFE_CONN18_3                      (0x3174)
#define AFE_CONN18_4                      (0x3178)
#define AFE_CONN19                        (0x317c)
#define AFE_CONN19_1                      (0x3180)
#define AFE_CONN19_2                      (0x3184)
#define AFE_CONN19_3                      (0x3188)
#define AFE_CONN19_4                      (0x318c)
#define AFE_CONN20                        (0x3190)
#define AFE_CONN20_1                      (0x3194)
#define AFE_CONN20_2                      (0x3198)
#define AFE_CONN20_3                      (0x319c)
#define AFE_CONN20_4                      (0x31a0)
#define AFE_CONN21                        (0x31a4)
#define AFE_CONN21_1                      (0x31a8)
#define AFE_CONN21_2                      (0x31ac)
#define AFE_CONN21_3                      (0x31b0)
#define AFE_CONN21_4                      (0x31b4)
#define AFE_CONN22                        (0x31b8)
#define AFE_CONN22_1                      (0x31bc)
#define AFE_CONN22_2                      (0x31c0)
#define AFE_CONN22_3                      (0x31c4)
#define AFE_CONN22_4                      (0x31c8)
#define AFE_CONN23                        (0x31cc)
#define AFE_CONN23_1                      (0x31d0)
#define AFE_CONN23_2                      (0x31d4)
#define AFE_CONN23_3                      (0x31d8)
#define AFE_CONN23_4                      (0x31dc)
#define AFE_CONN24                        (0x31e0)
#define AFE_CONN24_1                      (0x31e4)
#define AFE_CONN24_2                      (0x31e8)
#define AFE_CONN24_3                      (0x31ec)
#define AFE_CONN24_4                      (0x31f0)
#define AFE_CONN25                        (0x31f4)
#define AFE_CONN25_1                      (0x31f8)
#define AFE_CONN25_2                      (0x31fc)
#define AFE_CONN25_3                      (0x3200)
#define AFE_CONN25_4                      (0x3204)
#define AFE_CONN26                        (0x3208)
#define AFE_CONN26_1                      (0x320c)
#define AFE_CONN26_2                      (0x3210)
#define AFE_CONN26_3                      (0x3214)
#define AFE_CONN26_4                      (0x3218)
#define AFE_CONN27                        (0x321c)
#define AFE_CONN27_1                      (0x3220)
#define AFE_CONN27_2                      (0x3224)
#define AFE_CONN27_3                      (0x3228)
#define AFE_CONN27_4                      (0x322c)
#define AFE_CONN28                        (0x3230)
#define AFE_CONN28_1                      (0x3234)
#define AFE_CONN28_2                      (0x3238)
#define AFE_CONN28_3                      (0x323c)
#define AFE_CONN28_4                      (0x3240)
#define AFE_CONN29                        (0x3244)
#define AFE_CONN29_1                      (0x3248)
#define AFE_CONN29_2                      (0x324c)
#define AFE_CONN29_3                      (0x3250)
#define AFE_CONN29_4                      (0x3254)
#define AFE_CONN30                        (0x3258)
#define AFE_CONN30_1                      (0x325c)
#define AFE_CONN30_2                      (0x3260)
#define AFE_CONN30_3                      (0x3264)
#define AFE_CONN30_4                      (0x3268)
#define AFE_CONN31                        (0x326c)
#define AFE_CONN31_1                      (0x3270)
#define AFE_CONN31_2                      (0x3274)
#define AFE_CONN31_3                      (0x3278)
#define AFE_CONN31_4                      (0x327c)
#define AFE_CONN32                        (0x3280)
#define AFE_CONN32_1                      (0x3284)
#define AFE_CONN32_2                      (0x3288)
#define AFE_CONN32_3                      (0x328c)
#define AFE_CONN32_4                      (0x3290)
#define AFE_CONN33                        (0x3294)
#define AFE_CONN33_1                      (0x3298)
#define AFE_CONN33_2                      (0x329c)
#define AFE_CONN33_3                      (0x32a0)
#define AFE_CONN33_4                      (0x32a4)
#define AFE_CONN34                        (0x32a8)
#define AFE_CONN34_1                      (0x32ac)
#define AFE_CONN34_2                      (0x32b0)
#define AFE_CONN34_3                      (0x32b4)
#define AFE_CONN34_4                      (0x32b8)
#define AFE_CONN35                        (0x32bc)
#define AFE_CONN35_1                      (0x32c0)
#define AFE_CONN35_2                      (0x32c4)
#define AFE_CONN35_3                      (0x32c8)
#define AFE_CONN35_4                      (0x32cc)
#define AFE_CONN36                        (0x32d0)
#define AFE_CONN36_1                      (0x32d4)
#define AFE_CONN36_2                      (0x32d8)
#define AFE_CONN36_3                      (0x32dc)
#define AFE_CONN36_4                      (0x32e0)
#define AFE_CONN37                        (0x32e4)
#define AFE_CONN37_1                      (0x32e8)
#define AFE_CONN37_2                      (0x32ec)
#define AFE_CONN37_3                      (0x32f0)
#define AFE_CONN37_4                      (0x32f4)
#define AFE_CONN38                        (0x32f8)
#define AFE_CONN38_1                      (0x32fc)
#define AFE_CONN38_2                      (0x3300)
#define AFE_CONN38_3                      (0x3304)
#define AFE_CONN38_4                      (0x3308)
#define AFE_CONN39                        (0x330c)
#define AFE_CONN39_1                      (0x3310)
#define AFE_CONN39_2                      (0x3314)
#define AFE_CONN39_3                      (0x3318)
#define AFE_CONN39_4                      (0x331c)
#define AFE_CONN40                        (0x3320)
#define AFE_CONN40_1                      (0x3324)
#define AFE_CONN40_2                      (0x3328)
#define AFE_CONN40_3                      (0x332c)
#define AFE_CONN40_4                      (0x3330)
#define AFE_CONN41                        (0x3334)
#define AFE_CONN41_1                      (0x3338)
#define AFE_CONN41_2                      (0x333c)
#define AFE_CONN41_3                      (0x3340)
#define AFE_CONN41_4                      (0x3344)
#define AFE_CONN42                        (0x3348)
#define AFE_CONN42_1                      (0x334c)
#define AFE_CONN42_2                      (0x3350)
#define AFE_CONN42_3                      (0x3354)
#define AFE_CONN42_4                      (0x3358)
#define AFE_CONN43                        (0x335c)
#define AFE_CONN43_1                      (0x3360)
#define AFE_CONN43_2                      (0x3364)
#define AFE_CONN43_3                      (0x3368)
#define AFE_CONN43_4                      (0x336c)
#define AFE_CONN44                        (0x3370)
#define AFE_CONN44_1                      (0x3374)
#define AFE_CONN44_2                      (0x3378)
#define AFE_CONN44_3                      (0x337c)
#define AFE_CONN44_4                      (0x3380)
#define AFE_CONN45                        (0x3384)
#define AFE_CONN45_1                      (0x3388)
#define AFE_CONN45_2                      (0x338c)
#define AFE_CONN45_3                      (0x3390)
#define AFE_CONN45_4                      (0x3394)
#define AFE_CONN46                        (0x3398)
#define AFE_CONN46_1                      (0x339c)
#define AFE_CONN46_2                      (0x33a0)
#define AFE_CONN46_3                      (0x33a4)
#define AFE_CONN46_4                      (0x33a8)
#define AFE_CONN47                        (0x33ac)
#define AFE_CONN47_1                      (0x33b0)
#define AFE_CONN47_2                      (0x33b4)
#define AFE_CONN47_3                      (0x33b8)
#define AFE_CONN47_4                      (0x33bc)
#define AFE_CONN48                        (0x33c0)
#define AFE_CONN48_1                      (0x33c4)
#define AFE_CONN48_2                      (0x33c8)
#define AFE_CONN48_3                      (0x33cc)
#define AFE_CONN48_4                      (0x33d0)
#define AFE_CONN49                        (0x33d4)
#define AFE_CONN49_1                      (0x33d8)
#define AFE_CONN49_2                      (0x33dc)
#define AFE_CONN49_3                      (0x33e0)
#define AFE_CONN49_4                      (0x33e4)
#define AFE_CONN50                        (0x33e8)
#define AFE_CONN50_1                      (0x33ec)
#define AFE_CONN50_2                      (0x33f0)
#define AFE_CONN50_3                      (0x33f4)
#define AFE_CONN50_4                      (0x33f8)
#define AFE_CONN51                        (0x33fc)
#define AFE_CONN51_1                      (0x3400)
#define AFE_CONN51_2                      (0x3404)
#define AFE_CONN51_3                      (0x3408)
#define AFE_CONN51_4                      (0x340c)
#define AFE_CONN52                        (0x3410)
#define AFE_CONN52_1                      (0x3414)
#define AFE_CONN52_2                      (0x3418)
#define AFE_CONN52_3                      (0x341c)
#define AFE_CONN52_4                      (0x3420)
#define AFE_CONN53                        (0x3424)
#define AFE_CONN53_1                      (0x3428)
#define AFE_CONN53_2                      (0x342c)
#define AFE_CONN53_3                      (0x3430)
#define AFE_CONN53_4                      (0x3434)
#define AFE_CONN54                        (0x3438)
#define AFE_CONN54_1                      (0x343c)
#define AFE_CONN54_2                      (0x3440)
#define AFE_CONN54_3                      (0x3444)
#define AFE_CONN54_4                      (0x3448)
#define AFE_CONN55                        (0x344c)
#define AFE_CONN55_1                      (0x3450)
#define AFE_CONN55_2                      (0x3454)
#define AFE_CONN55_3                      (0x3458)
#define AFE_CONN55_4                      (0x345c)
#define AFE_CONN56                        (0x3460)
#define AFE_CONN56_1                      (0x3464)
#define AFE_CONN56_2                      (0x3468)
#define AFE_CONN56_3                      (0x346c)
#define AFE_CONN56_4                      (0x3470)
#define AFE_CONN57                        (0x3474)
#define AFE_CONN57_1                      (0x3478)
#define AFE_CONN57_2                      (0x347c)
#define AFE_CONN57_3                      (0x3480)
#define AFE_CONN57_4                      (0x3484)
#define AFE_CONN58                        (0x3488)
#define AFE_CONN58_1                      (0x348c)
#define AFE_CONN58_2                      (0x3490)
#define AFE_CONN58_3                      (0x3494)
#define AFE_CONN58_4                      (0x3498)
#define AFE_CONN59                        (0x349c)
#define AFE_CONN59_1                      (0x34a0)
#define AFE_CONN59_2                      (0x34a4)
#define AFE_CONN59_3                      (0x34a8)
#define AFE_CONN59_4                      (0x34ac)
#define AFE_CONN60                        (0x34b0)
#define AFE_CONN60_1                      (0x34b4)
#define AFE_CONN60_2                      (0x34b8)
#define AFE_CONN60_3                      (0x34bc)
#define AFE_CONN60_4                      (0x34c0)
#define AFE_CONN61                        (0x34c4)
#define AFE_CONN61_1                      (0x34c8)
#define AFE_CONN61_2                      (0x34cc)
#define AFE_CONN61_3                      (0x34d0)
#define AFE_CONN61_4                      (0x34d4)
#define AFE_CONN62                        (0x34d8)
#define AFE_CONN62_1                      (0x34dc)
#define AFE_CONN62_2                      (0x34e0)
#define AFE_CONN62_3                      (0x34e4)
#define AFE_CONN62_4                      (0x34e8)
#define AFE_CONN63                        (0x34ec)
#define AFE_CONN63_1                      (0x34f0)
#define AFE_CONN63_2                      (0x34f4)
#define AFE_CONN63_3                      (0x34f8)
#define AFE_CONN63_4                      (0x34fc)
#define AFE_CONN64                        (0x3500)
#define AFE_CONN64_1                      (0x3504)
#define AFE_CONN64_2                      (0x3508)
#define AFE_CONN64_3                      (0x350c)
#define AFE_CONN64_4                      (0x3510)
#define AFE_CONN65                        (0x3514)
#define AFE_CONN65_1                      (0x3518)
#define AFE_CONN65_2                      (0x351c)
#define AFE_CONN65_3                      (0x3520)
#define AFE_CONN65_4                      (0x3524)
#define AFE_CONN66                        (0x3528)
#define AFE_CONN66_1                      (0x352c)
#define AFE_CONN66_2                      (0x3530)
#define AFE_CONN66_3                      (0x3534)
#define AFE_CONN66_4                      (0x3538)
#define AFE_CONN67                        (0x353c)
#define AFE_CONN67_1                      (0x3540)
#define AFE_CONN67_2                      (0x3544)
#define AFE_CONN67_3                      (0x3548)
#define AFE_CONN67_4                      (0x354c)
#define AFE_CONN68                        (0x3550)
#define AFE_CONN68_1                      (0x3554)
#define AFE_CONN68_2                      (0x3558)
#define AFE_CONN68_3                      (0x355c)
#define AFE_CONN68_4                      (0x3560)
#define AFE_CONN69                        (0x3564)
#define AFE_CONN69_1                      (0x3568)
#define AFE_CONN69_2                      (0x356c)
#define AFE_CONN69_3                      (0x3570)
#define AFE_CONN69_4                      (0x3574)
#define AFE_CONN70                        (0x3578)
#define AFE_CONN70_1                      (0x357c)
#define AFE_CONN70_2                      (0x3580)
#define AFE_CONN70_3                      (0x3584)
#define AFE_CONN70_4                      (0x3588)
#define AFE_CONN71                        (0x358c)
#define AFE_CONN71_1                      (0x3590)
#define AFE_CONN71_2                      (0x3594)
#define AFE_CONN71_3                      (0x3598)
#define AFE_CONN71_4                      (0x359c)
#define AFE_CONN72                        (0x35a0)
#define AFE_CONN72_1                      (0x35a4)
#define AFE_CONN72_2                      (0x35a8)
#define AFE_CONN72_3                      (0x35ac)
#define AFE_CONN72_4                      (0x35b0)
#define AFE_CONN73                        (0x35b4)
#define AFE_CONN73_1                      (0x35b8)
#define AFE_CONN73_2                      (0x35bc)
#define AFE_CONN73_3                      (0x35c0)
#define AFE_CONN73_4                      (0x35c4)
#define AFE_CONN74                        (0x35c8)
#define AFE_CONN74_1                      (0x35cc)
#define AFE_CONN74_2                      (0x35d0)
#define AFE_CONN74_3                      (0x35d4)
#define AFE_CONN74_4                      (0x35d8)
#define AFE_CONN75                        (0x35dc)
#define AFE_CONN75_1                      (0x35e0)
#define AFE_CONN75_2                      (0x35e4)
#define AFE_CONN75_3                      (0x35e8)
#define AFE_CONN75_4                      (0x35ec)
#define AFE_CONN76                        (0x35f0)
#define AFE_CONN76_1                      (0x35f4)
#define AFE_CONN76_2                      (0x35f8)
#define AFE_CONN76_3                      (0x35fc)
#define AFE_CONN76_4                      (0x3600)
#define AFE_CONN77                        (0x3604)
#define AFE_CONN77_1                      (0x3608)
#define AFE_CONN77_2                      (0x360c)
#define AFE_CONN77_3                      (0x3610)
#define AFE_CONN77_4                      (0x3614)
#define AFE_CONN78                        (0x3618)
#define AFE_CONN78_1                      (0x361c)
#define AFE_CONN78_2                      (0x3620)
#define AFE_CONN78_3                      (0x3624)
#define AFE_CONN78_4                      (0x3628)
#define AFE_CONN79                        (0x362c)
#define AFE_CONN79_1                      (0x3630)
#define AFE_CONN79_2                      (0x3634)
#define AFE_CONN79_3                      (0x3638)
#define AFE_CONN79_4                      (0x363c)
#define AFE_CONN80                        (0x3640)
#define AFE_CONN80_1                      (0x3644)
#define AFE_CONN80_2                      (0x3648)
#define AFE_CONN80_3                      (0x364c)
#define AFE_CONN80_4                      (0x3650)
#define AFE_CONN81                        (0x3654)
#define AFE_CONN81_1                      (0x3658)
#define AFE_CONN81_2                      (0x365c)
#define AFE_CONN81_3                      (0x3660)
#define AFE_CONN81_4                      (0x3664)
#define AFE_CONN82                        (0x3668)
#define AFE_CONN82_1                      (0x366c)
#define AFE_CONN82_2                      (0x3670)
#define AFE_CONN82_3                      (0x3674)
#define AFE_CONN82_4                      (0x3678)
#define AFE_CONN83                        (0x367c)
#define AFE_CONN83_1                      (0x3680)
#define AFE_CONN83_2                      (0x3684)
#define AFE_CONN83_3                      (0x3688)
#define AFE_CONN83_4                      (0x368c)
#define AFE_CONN84                        (0x3690)
#define AFE_CONN84_1                      (0x3694)
#define AFE_CONN84_2                      (0x3698)
#define AFE_CONN84_3                      (0x369c)
#define AFE_CONN84_4                      (0x36a0)
#define AFE_CONN85                        (0x36a4)
#define AFE_CONN85_1                      (0x36a8)
#define AFE_CONN85_2                      (0x36ac)
#define AFE_CONN85_3                      (0x36b0)
#define AFE_CONN85_4                      (0x36b4)
#define AFE_CONN86                        (0x36b8)
#define AFE_CONN86_1                      (0x36bc)
#define AFE_CONN86_2                      (0x36c0)
#define AFE_CONN86_3                      (0x36c4)
#define AFE_CONN86_4                      (0x36c8)
#define AFE_CONN87                        (0x36cc)
#define AFE_CONN87_1                      (0x36d0)
#define AFE_CONN87_2                      (0x36d4)
#define AFE_CONN87_3                      (0x36d8)
#define AFE_CONN87_4                      (0x36dc)
#define AFE_CONN88                        (0x36e0)
#define AFE_CONN88_1                      (0x36e4)
#define AFE_CONN88_2                      (0x36e8)
#define AFE_CONN88_3                      (0x36ec)
#define AFE_CONN88_4                      (0x36f0)
#define AFE_CONN89                        (0x36f4)
#define AFE_CONN89_1                      (0x36f8)
#define AFE_CONN89_2                      (0x36fc)
#define AFE_CONN89_3                      (0x3700)
#define AFE_CONN89_4                      (0x3704)
#define AFE_CONN90                        (0x3708)
#define AFE_CONN90_1                      (0x370c)
#define AFE_CONN90_2                      (0x3710)
#define AFE_CONN90_3                      (0x3714)
#define AFE_CONN90_4                      (0x3718)
#define AFE_CONN91                        (0x371c)
#define AFE_CONN91_1                      (0x3720)
#define AFE_CONN91_2                      (0x3724)
#define AFE_CONN91_3                      (0x3728)
#define AFE_CONN91_4                      (0x372c)
#define AFE_CONN92                        (0x3730)
#define AFE_CONN92_1                      (0x3734)
#define AFE_CONN92_2                      (0x3738)
#define AFE_CONN92_3                      (0x373c)
#define AFE_CONN92_4                      (0x3740)
#define AFE_CONN93                        (0x3744)
#define AFE_CONN93_1                      (0x3748)
#define AFE_CONN93_2                      (0x374c)
#define AFE_CONN93_3                      (0x3750)
#define AFE_CONN93_4                      (0x3754)
#define AFE_CONN94                        (0x3758)
#define AFE_CONN94_1                      (0x375c)
#define AFE_CONN94_2                      (0x3760)
#define AFE_CONN94_3                      (0x3764)
#define AFE_CONN94_4                      (0x3768)
#define AFE_CONN95                        (0x376c)
#define AFE_CONN95_1                      (0x3770)
#define AFE_CONN95_2                      (0x3774)
#define AFE_CONN95_3                      (0x3778)
#define AFE_CONN95_4                      (0x377c)
#define AFE_CONN96                        (0x3780)
#define AFE_CONN96_1                      (0x3784)
#define AFE_CONN96_2                      (0x3788)
#define AFE_CONN96_3                      (0x378c)
#define AFE_CONN96_4                      (0x3790)
#define AFE_CONN97                        (0x3794)
#define AFE_CONN97_1                      (0x3798)
#define AFE_CONN97_2                      (0x379c)
#define AFE_CONN97_3                      (0x37a0)
#define AFE_CONN97_4                      (0x37a4)
#define AFE_CONN98                        (0x37a8)
#define AFE_CONN98_1                      (0x37ac)
#define AFE_CONN98_2                      (0x37b0)
#define AFE_CONN98_3                      (0x37b4)
#define AFE_CONN98_4                      (0x37b8)
#define AFE_CONN99                        (0x37bc)
#define AFE_CONN99_1                      (0x37c0)
#define AFE_CONN99_2                      (0x37c4)
#define AFE_CONN99_3                      (0x37c8)
#define AFE_CONN99_4                      (0x37cc)
#define AFE_CONN100                       (0x37d0)
#define AFE_CONN100_1                     (0x37d4)
#define AFE_CONN100_2                     (0x37d8)
#define AFE_CONN100_3                     (0x37dc)
#define AFE_CONN100_4                     (0x37e0)
#define AFE_CONN101                       (0x37e4)
#define AFE_CONN101_1                     (0x37e8)
#define AFE_CONN101_2                     (0x37ec)
#define AFE_CONN101_3                     (0x37f0)
#define AFE_CONN101_4                     (0x37f4)
#define AFE_CONN102                       (0x37f8)
#define AFE_CONN102_1                     (0x37fc)
#define AFE_CONN102_2                     (0x3800)
#define AFE_CONN102_3                     (0x3804)
#define AFE_CONN102_4                     (0x3808)
#define AFE_CONN103                       (0x380c)
#define AFE_CONN103_1                     (0x3810)
#define AFE_CONN103_2                     (0x3814)
#define AFE_CONN103_3                     (0x3818)
#define AFE_CONN103_4                     (0x381c)
#define AFE_CONN104                       (0x3820)
#define AFE_CONN104_1                     (0x3824)
#define AFE_CONN104_2                     (0x3828)
#define AFE_CONN104_3                     (0x382c)
#define AFE_CONN104_4                     (0x3830)
#define AFE_CONN105                       (0x3834)
#define AFE_CONN105_1                     (0x3838)
#define AFE_CONN105_2                     (0x383c)
#define AFE_CONN105_3                     (0x3840)
#define AFE_CONN105_4                     (0x3844)
#define AFE_CONN106                       (0x3848)
#define AFE_CONN106_1                     (0x384c)
#define AFE_CONN106_2                     (0x3850)
#define AFE_CONN106_3                     (0x3854)
#define AFE_CONN106_4                     (0x3858)
#define AFE_CONN107                       (0x385c)
#define AFE_CONN107_1                     (0x3860)
#define AFE_CONN107_2                     (0x3864)
#define AFE_CONN107_3                     (0x3868)
#define AFE_CONN107_4                     (0x386c)
#define AFE_CONN108                       (0x3870)
#define AFE_CONN108_1                     (0x3874)
#define AFE_CONN108_2                     (0x3878)
#define AFE_CONN108_3                     (0x387c)
#define AFE_CONN108_4                     (0x3880)
#define AFE_CONN109                       (0x3884)
#define AFE_CONN109_1                     (0x3888)
#define AFE_CONN109_2                     (0x388c)
#define AFE_CONN109_3                     (0x3890)
#define AFE_CONN109_4                     (0x3894)
#define AFE_CONN110                       (0x3898)
#define AFE_CONN110_1                     (0x389c)
#define AFE_CONN110_2                     (0x38a0)
#define AFE_CONN110_3                     (0x38a4)
#define AFE_CONN110_4                     (0x38a8)
#define AFE_CONN111                       (0x38ac)
#define AFE_CONN111_1                     (0x38b0)
#define AFE_CONN111_2                     (0x38b4)
#define AFE_CONN111_3                     (0x38b8)
#define AFE_CONN111_4                     (0x38bc)
#define AFE_CONN112                       (0x38c0)
#define AFE_CONN112_1                     (0x38c4)
#define AFE_CONN112_2                     (0x38c8)
#define AFE_CONN112_3                     (0x38cc)
#define AFE_CONN112_4                     (0x38d0)
#define AFE_CONN113                       (0x38d4)
#define AFE_CONN113_1                     (0x38d8)
#define AFE_CONN113_2                     (0x38dc)
#define AFE_CONN113_3                     (0x38e0)
#define AFE_CONN113_4                     (0x38e4)
#define AFE_CONN114                       (0x38e8)
#define AFE_CONN114_1                     (0x38ec)
#define AFE_CONN114_2                     (0x38f0)
#define AFE_CONN114_3                     (0x38f4)
#define AFE_CONN114_4                     (0x38f8)
#define AFE_CONN115                       (0x38fc)
#define AFE_CONN115_1                     (0x3900)
#define AFE_CONN115_2                     (0x3904)
#define AFE_CONN115_3                     (0x3908)
#define AFE_CONN115_4                     (0x390c)
#define AFE_CONN116                       (0x3910)
#define AFE_CONN116_1                     (0x3914)
#define AFE_CONN116_2                     (0x3918)
#define AFE_CONN116_3                     (0x391c)
#define AFE_CONN116_4                     (0x3920)
#define AFE_CONN117                       (0x3924)
#define AFE_CONN117_1                     (0x3928)
#define AFE_CONN117_2                     (0x392c)
#define AFE_CONN117_3                     (0x3930)
#define AFE_CONN117_4                     (0x3934)
#define AFE_CONN118                       (0x3938)
#define AFE_CONN118_1                     (0x393c)
#define AFE_CONN118_2                     (0x3940)
#define AFE_CONN118_3                     (0x3944)
#define AFE_CONN118_4                     (0x3948)
#define AFE_CONN119                       (0x394c)
#define AFE_CONN119_1                     (0x3950)
#define AFE_CONN119_2                     (0x3954)
#define AFE_CONN119_3                     (0x3958)
#define AFE_CONN119_4                     (0x395c)
#define AFE_CONN120                       (0x3960)
#define AFE_CONN120_1                     (0x3964)
#define AFE_CONN120_2                     (0x3968)
#define AFE_CONN120_3                     (0x396c)
#define AFE_CONN120_4                     (0x3970)
#define AFE_CONN121                       (0x3974)
#define AFE_CONN121_1                     (0x3978)
#define AFE_CONN121_2                     (0x397c)
#define AFE_CONN121_3                     (0x3980)
#define AFE_CONN121_4                     (0x3984)
#define AFE_CONN122                       (0x3988)
#define AFE_CONN122_1                     (0x398c)
#define AFE_CONN122_2                     (0x3990)
#define AFE_CONN122_3                     (0x3994)
#define AFE_CONN122_4                     (0x3998)
#define AFE_CONN123                       (0x399c)
#define AFE_CONN123_1                     (0x39a0)
#define AFE_CONN123_2                     (0x39a4)
#define AFE_CONN123_3                     (0x39a8)
#define AFE_CONN123_4                     (0x39ac)
#define AFE_CONN124                       (0x39b0)
#define AFE_CONN124_1                     (0x39b4)
#define AFE_CONN124_2                     (0x39b8)
#define AFE_CONN124_3                     (0x39bc)
#define AFE_CONN124_4                     (0x39c0)
#define AFE_CONN125                       (0x39c4)
#define AFE_CONN125_1                     (0x39c8)
#define AFE_CONN125_2                     (0x39cc)
#define AFE_CONN125_3                     (0x39d0)
#define AFE_CONN125_4                     (0x39d4)
#define AFE_CONN126                       (0x39d8)
#define AFE_CONN126_1                     (0x39dc)
#define AFE_CONN126_2                     (0x39e0)
#define AFE_CONN126_3                     (0x39e4)
#define AFE_CONN126_4                     (0x39e8)
#define AFE_CONN127                       (0x39ec)
#define AFE_CONN127_1                     (0x39f0)
#define AFE_CONN127_2                     (0x39f4)
#define AFE_CONN127_3                     (0x39f8)
#define AFE_CONN127_4                     (0x39fc)
#define AFE_CONN128                       (0x3a00)
#define AFE_CONN128_1                     (0x3a04)
#define AFE_CONN128_2                     (0x3a08)
#define AFE_CONN128_3                     (0x3a0c)
#define AFE_CONN128_4                     (0x3a10)
#define AFE_CONN129                       (0x3a14)
#define AFE_CONN129_1                     (0x3a18)
#define AFE_CONN129_2                     (0x3a1c)
#define AFE_CONN129_3                     (0x3a20)
#define AFE_CONN129_4                     (0x3a24)
#define AFE_CONN130                       (0x3a28)
#define AFE_CONN130_1                     (0x3a2c)
#define AFE_CONN130_2                     (0x3a30)
#define AFE_CONN130_3                     (0x3a34)
#define AFE_CONN130_4                     (0x3a38)
#define AFE_CONN131                       (0x3a3c)
#define AFE_CONN131_1                     (0x3a40)
#define AFE_CONN131_2                     (0x3a44)
#define AFE_CONN131_3                     (0x3a48)
#define AFE_CONN131_4                     (0x3a4c)
#define AFE_CONN132                       (0x3a50)
#define AFE_CONN132_1                     (0x3a54)
#define AFE_CONN132_2                     (0x3a58)
#define AFE_CONN132_3                     (0x3a5c)
#define AFE_CONN132_4                     (0x3a60)
#define AFE_CONN133                       (0x3a64)
#define AFE_CONN133_1                     (0x3a68)
#define AFE_CONN133_2                     (0x3a6c)
#define AFE_CONN133_3                     (0x3a70)
#define AFE_CONN133_4                     (0x3a74)
#define AFE_CONN134                       (0x3a78)
#define AFE_CONN134_1                     (0x3a7c)
#define AFE_CONN134_2                     (0x3a80)
#define AFE_CONN134_3                     (0x3a84)
#define AFE_CONN134_4                     (0x3a88)
#define AFE_CONN135                       (0x3a8c)
#define AFE_CONN135_1                     (0x3a90)
#define AFE_CONN135_2                     (0x3a94)
#define AFE_CONN135_3                     (0x3a98)
#define AFE_CONN135_4                     (0x3a9c)
#define AFE_CONN136                       (0x3aa0)
#define AFE_CONN136_1                     (0x3aa4)
#define AFE_CONN136_2                     (0x3aa8)
#define AFE_CONN136_3                     (0x3aac)
#define AFE_CONN136_4                     (0x3ab0)
#define AFE_CONN137                       (0x3ab4)
#define AFE_CONN137_1                     (0x3ab8)
#define AFE_CONN137_2                     (0x3abc)
#define AFE_CONN137_3                     (0x3ac0)
#define AFE_CONN137_4                     (0x3ac4)
#define AFE_CONN138                       (0x3ac8)
#define AFE_CONN138_1                     (0x3acc)
#define AFE_CONN138_2                     (0x3ad0)
#define AFE_CONN138_3                     (0x3ad4)
#define AFE_CONN138_4                     (0x3ad8)
#define AFE_CONN139                       (0x3adc)
#define AFE_CONN139_1                     (0x3ae0)
#define AFE_CONN139_2                     (0x3ae4)
#define AFE_CONN139_3                     (0x3ae8)
#define AFE_CONN139_4                     (0x3aec)
#define AFE_CONN_RS                       (0x3af0)
#define AFE_CONN_RS_1                     (0x3af4)
#define AFE_CONN_RS_2                     (0x3af8)
#define AFE_CONN_RS_3                     (0x3afc)
#define AFE_CONN_RS_4                     (0x3b00)
#define AFE_CONN_16BIT                    (0x3b04)
#define AFE_CONN_16BIT_1                  (0x3b08)
#define AFE_CONN_16BIT_2                  (0x3b0c)
#define AFE_CONN_16BIT_3                  (0x3b10)
#define AFE_CONN_16BIT_4                  (0x3b14)
#define AFE_CONN_24BIT                    (0x3b18)
#define AFE_CONN_24BIT_1                  (0x3b1c)
#define AFE_CONN_24BIT_2                  (0x3b20)
#define AFE_CONN_24BIT_3                  (0x3b24)
#define AFE_CONN_24BIT_4                  (0x3b28)
#define AFE_CONN_DI                       (0x3b2c)
#define AFE_CONN_DI_1                     (0x3b30)
#define AFE_CONN_DI_2                     (0x3b34)
#define AFE_CONN_DI_3                     (0x3b38)
#define AFE_CONN_DI_4                     (0x3b3c)
#define AFE_CONN176                       (0x3ea0)
#define AFE_CONN176_1                     (0x3ea4)
#define AFE_CONN176_2                     (0x3ea8)
#define AFE_CONN176_3                     (0x3eac)
#define AFE_CONN176_4                     (0x3eb0)
#define AFE_CONN176_5                     (0x3eb4)
#define AFE_CONN177                       (0x3eb8)
#define AFE_CONN177_1                     (0x3ebc)
#define AFE_CONN177_2                     (0x3ec0)
#define AFE_CONN177_3                     (0x3ec4)
#define AFE_CONN177_4                     (0x3ec8)
#define AFE_CONN177_5                     (0x3ecc)
#define AFE_CONN182                       (0x3f30)
#define AFE_CONN182_1                     (0x3f34)
#define AFE_CONN182_2                     (0x3f38)
#define AFE_CONN182_3                     (0x3f3c)
#define AFE_CONN182_4                     (0x3f40)
#define AFE_CONN182_5                     (0x3f44)
#define AFE_CONN183                       (0x3f48)
#define AFE_CONN183_1                     (0x3f4c)
#define AFE_CONN183_2                     (0x3f50)
#define AFE_CONN183_3                     (0x3f54)
#define AFE_CONN183_4                     (0x3f58)
#define AFE_CONN183_5                     (0x3f5c)
#define AFE_SECURE_MASK_CONN0             (0x4000)
#define AFE_SECURE_MASK_CONN0_1           (0x4004)
#define AFE_SECURE_MASK_CONN0_2           (0x4008)
#define AFE_SECURE_MASK_CONN0_3           (0x400c)
#define AFE_SECURE_MASK_CONN0_4           (0x4010)
#define AFE_SECURE_MASK_CONN1             (0x4014)
#define AFE_SECURE_MASK_CONN1_1           (0x4018)
#define AFE_SECURE_MASK_CONN1_2           (0x401c)
#define AFE_SECURE_MASK_CONN1_3           (0x4020)
#define AFE_SECURE_MASK_CONN1_4           (0x4024)
#define AFE_SECURE_MASK_CONN2             (0x4028)
#define AFE_SECURE_MASK_CONN2_1           (0x402c)
#define AFE_SECURE_MASK_CONN2_2           (0x4030)
#define AFE_SECURE_MASK_CONN2_3           (0x4034)
#define AFE_SECURE_MASK_CONN2_4           (0x4038)
#define AFE_SECURE_MASK_CONN3             (0x403c)
#define AFE_SECURE_MASK_CONN3_1           (0x4040)
#define AFE_SECURE_MASK_CONN3_2           (0x4044)
#define AFE_SECURE_MASK_CONN3_3           (0x4048)
#define AFE_SECURE_MASK_CONN3_4           (0x404c)
#define AFE_SECURE_MASK_CONN4             (0x4050)
#define AFE_SECURE_MASK_CONN4_1           (0x4054)
#define AFE_SECURE_MASK_CONN4_2           (0x4058)
#define AFE_SECURE_MASK_CONN4_3           (0x405c)
#define AFE_SECURE_MASK_CONN4_4           (0x4060)
#define AFE_SECURE_MASK_CONN5             (0x4064)
#define AFE_SECURE_MASK_CONN5_1           (0x4068)
#define AFE_SECURE_MASK_CONN5_2           (0x406c)
#define AFE_SECURE_MASK_CONN5_3           (0x4070)
#define AFE_SECURE_MASK_CONN5_4           (0x4074)
#define AFE_SECURE_MASK_CONN6             (0x4078)
#define AFE_SECURE_MASK_CONN6_1           (0x407c)
#define AFE_SECURE_MASK_CONN6_2           (0x4080)
#define AFE_SECURE_MASK_CONN6_3           (0x4084)
#define AFE_SECURE_MASK_CONN6_4           (0x4088)
#define AFE_SECURE_MASK_CONN7             (0x408c)
#define AFE_SECURE_MASK_CONN7_1           (0x4090)
#define AFE_SECURE_MASK_CONN7_2           (0x4094)
#define AFE_SECURE_MASK_CONN7_3           (0x4098)
#define AFE_SECURE_MASK_CONN7_4           (0x409c)
#define AFE_SECURE_MASK_CONN8             (0x40a0)
#define AFE_SECURE_MASK_CONN8_1           (0x40a4)
#define AFE_SECURE_MASK_CONN8_2           (0x40a8)
#define AFE_SECURE_MASK_CONN8_3           (0x40ac)
#define AFE_SECURE_MASK_CONN8_4           (0x40b0)
#define AFE_SECURE_MASK_CONN9             (0x40b4)
#define AFE_SECURE_MASK_CONN9_1           (0x40b8)
#define AFE_SECURE_MASK_CONN9_2           (0x40bc)
#define AFE_SECURE_MASK_CONN9_3           (0x40c0)
#define AFE_SECURE_MASK_CONN9_4           (0x40c4)
#define AFE_SECURE_MASK_CONN10            (0x40c8)
#define AFE_SECURE_MASK_CONN10_1          (0x40cc)
#define AFE_SECURE_MASK_CONN10_2          (0x40d0)
#define AFE_SECURE_MASK_CONN10_3          (0x40d4)
#define AFE_SECURE_MASK_CONN10_4          (0x40d8)
#define AFE_SECURE_MASK_CONN11            (0x40dc)
#define AFE_SECURE_MASK_CONN11_1          (0x40e0)
#define AFE_SECURE_MASK_CONN11_2          (0x40e4)
#define AFE_SECURE_MASK_CONN11_3          (0x40e8)
#define AFE_SECURE_MASK_CONN11_4          (0x40ec)
#define AFE_SECURE_MASK_CONN12            (0x40f0)
#define AFE_SECURE_MASK_CONN12_1          (0x40f4)
#define AFE_SECURE_MASK_CONN12_2          (0x40f8)
#define AFE_SECURE_MASK_CONN12_3          (0x40fc)
#define AFE_SECURE_MASK_CONN12_4          (0x4100)
#define AFE_SECURE_MASK_CONN13            (0x4104)
#define AFE_SECURE_MASK_CONN13_1          (0x4108)
#define AFE_SECURE_MASK_CONN13_2          (0x410c)
#define AFE_SECURE_MASK_CONN13_3          (0x4110)
#define AFE_SECURE_MASK_CONN13_4          (0x4114)
#define AFE_SECURE_MASK_CONN14            (0x4118)
#define AFE_SECURE_MASK_CONN14_1          (0x411c)
#define AFE_SECURE_MASK_CONN14_2          (0x4120)
#define AFE_SECURE_MASK_CONN14_3          (0x4124)
#define AFE_SECURE_MASK_CONN14_4          (0x4128)
#define AFE_SECURE_MASK_CONN15            (0x412c)
#define AFE_SECURE_MASK_CONN15_1          (0x4130)
#define AFE_SECURE_MASK_CONN15_2          (0x4134)
#define AFE_SECURE_MASK_CONN15_3          (0x4138)
#define AFE_SECURE_MASK_CONN15_4          (0x413c)
#define AFE_SECURE_MASK_CONN16            (0x4140)
#define AFE_SECURE_MASK_CONN16_1          (0x4144)
#define AFE_SECURE_MASK_CONN16_2          (0x4148)
#define AFE_SECURE_MASK_CONN16_3          (0x414c)
#define AFE_SECURE_MASK_CONN16_4          (0x4150)
#define AFE_SECURE_MASK_CONN17            (0x4154)
#define AFE_SECURE_MASK_CONN17_1          (0x4158)
#define AFE_SECURE_MASK_CONN17_2          (0x415c)
#define AFE_SECURE_MASK_CONN17_3          (0x4160)
#define AFE_SECURE_MASK_CONN17_4          (0x4164)
#define AFE_SECURE_MASK_CONN18            (0x4168)
#define AFE_SECURE_MASK_CONN18_1          (0x416c)
#define AFE_SECURE_MASK_CONN18_2          (0x4170)
#define AFE_SECURE_MASK_CONN18_3          (0x4174)
#define AFE_SECURE_MASK_CONN18_4          (0x4178)
#define AFE_SECURE_MASK_CONN19            (0x417c)
#define AFE_SECURE_MASK_CONN19_1          (0x4180)
#define AFE_SECURE_MASK_CONN19_2          (0x4184)
#define AFE_SECURE_MASK_CONN19_3          (0x4188)
#define AFE_SECURE_MASK_CONN19_4          (0x418c)
#define AFE_SECURE_MASK_CONN20            (0x4190)
#define AFE_SECURE_MASK_CONN20_1          (0x4194)
#define AFE_SECURE_MASK_CONN20_2          (0x4198)
#define AFE_SECURE_MASK_CONN20_3          (0x419c)
#define AFE_SECURE_MASK_CONN20_4          (0x41a0)
#define AFE_SECURE_MASK_CONN21            (0x41a4)
#define AFE_SECURE_MASK_CONN21_1          (0x41a8)
#define AFE_SECURE_MASK_CONN21_2          (0x41ac)
#define AFE_SECURE_MASK_CONN21_3          (0x41b0)
#define AFE_SECURE_MASK_CONN21_4          (0x41b4)
#define AFE_SECURE_MASK_CONN22            (0x41b8)
#define AFE_SECURE_MASK_CONN22_1          (0x41bc)
#define AFE_SECURE_MASK_CONN22_2          (0x41c0)
#define AFE_SECURE_MASK_CONN22_3          (0x41c4)
#define AFE_SECURE_MASK_CONN22_4          (0x41c8)
#define AFE_SECURE_MASK_CONN23            (0x41cc)
#define AFE_SECURE_MASK_CONN23_1          (0x41d0)
#define AFE_SECURE_MASK_CONN23_2          (0x41d4)
#define AFE_SECURE_MASK_CONN23_3          (0x41d8)
#define AFE_SECURE_MASK_CONN23_4          (0x41dc)
#define AFE_SECURE_MASK_CONN24            (0x41e0)
#define AFE_SECURE_MASK_CONN24_1          (0x41e4)
#define AFE_SECURE_MASK_CONN24_2          (0x41e8)
#define AFE_SECURE_MASK_CONN24_3          (0x41ec)
#define AFE_SECURE_MASK_CONN24_4          (0x41f0)
#define AFE_SECURE_MASK_CONN25            (0x41f4)
#define AFE_SECURE_MASK_CONN25_1          (0x41f8)
#define AFE_SECURE_MASK_CONN25_2          (0x41fc)
#define AFE_SECURE_MASK_CONN25_3          (0x4200)
#define AFE_SECURE_MASK_CONN25_4          (0x4204)
#define AFE_SECURE_MASK_CONN26            (0x4208)
#define AFE_SECURE_MASK_CONN26_1          (0x420c)
#define AFE_SECURE_MASK_CONN26_2          (0x4210)
#define AFE_SECURE_MASK_CONN26_3          (0x4214)
#define AFE_SECURE_MASK_CONN26_4          (0x4218)
#define AFE_SECURE_MASK_CONN27            (0x421c)
#define AFE_SECURE_MASK_CONN27_1          (0x4220)
#define AFE_SECURE_MASK_CONN27_2          (0x4224)
#define AFE_SECURE_MASK_CONN27_3          (0x4228)
#define AFE_SECURE_MASK_CONN27_4          (0x422c)
#define AFE_SECURE_MASK_CONN28            (0x4230)
#define AFE_SECURE_MASK_CONN28_1          (0x4234)
#define AFE_SECURE_MASK_CONN28_2          (0x4238)
#define AFE_SECURE_MASK_CONN28_3          (0x423c)
#define AFE_SECURE_MASK_CONN28_4          (0x4240)
#define AFE_SECURE_MASK_CONN29            (0x4244)
#define AFE_SECURE_MASK_CONN29_1          (0x4248)
#define AFE_SECURE_MASK_CONN29_2          (0x424c)
#define AFE_SECURE_MASK_CONN29_3          (0x4250)
#define AFE_SECURE_MASK_CONN29_4          (0x4254)
#define AFE_SECURE_MASK_CONN30            (0x4258)
#define AFE_SECURE_MASK_CONN30_1          (0x425c)
#define AFE_SECURE_MASK_CONN30_2          (0x4260)
#define AFE_SECURE_MASK_CONN30_3          (0x4264)
#define AFE_SECURE_MASK_CONN30_4          (0x4268)
#define AFE_SECURE_MASK_CONN31            (0x426c)
#define AFE_SECURE_MASK_CONN31_1          (0x4270)
#define AFE_SECURE_MASK_CONN31_2          (0x4274)
#define AFE_SECURE_MASK_CONN31_3          (0x4278)
#define AFE_SECURE_MASK_CONN31_4          (0x427c)
#define AFE_SECURE_MASK_CONN32            (0x4280)
#define AFE_SECURE_MASK_CONN32_1          (0x4284)
#define AFE_SECURE_MASK_CONN32_2          (0x4288)
#define AFE_SECURE_MASK_CONN32_3          (0x428c)
#define AFE_SECURE_MASK_CONN32_4          (0x4290)
#define AFE_SECURE_MASK_CONN33            (0x4294)
#define AFE_SECURE_MASK_CONN33_1          (0x4298)
#define AFE_SECURE_MASK_CONN33_2          (0x429c)
#define AFE_SECURE_MASK_CONN33_3          (0x42a0)
#define AFE_SECURE_MASK_CONN33_4          (0x42a4)
#define AFE_SECURE_MASK_CONN34            (0x42a8)
#define AFE_SECURE_MASK_CONN34_1          (0x42ac)
#define AFE_SECURE_MASK_CONN34_2          (0x42b0)
#define AFE_SECURE_MASK_CONN34_3          (0x42b4)
#define AFE_SECURE_MASK_CONN34_4          (0x42b8)
#define AFE_SECURE_MASK_CONN35            (0x42bc)
#define AFE_SECURE_MASK_CONN35_1          (0x42c0)
#define AFE_SECURE_MASK_CONN35_2          (0x42c4)
#define AFE_SECURE_MASK_CONN35_3          (0x42c8)
#define AFE_SECURE_MASK_CONN35_4          (0x42cc)
#define AFE_SECURE_MASK_CONN36            (0x42d0)
#define AFE_SECURE_MASK_CONN36_1          (0x42d4)
#define AFE_SECURE_MASK_CONN36_2          (0x42d8)
#define AFE_SECURE_MASK_CONN36_3          (0x42dc)
#define AFE_SECURE_MASK_CONN36_4          (0x42e0)
#define AFE_SECURE_MASK_CONN37            (0x42e4)
#define AFE_SECURE_MASK_CONN37_1          (0x42e8)
#define AFE_SECURE_MASK_CONN37_2          (0x42ec)
#define AFE_SECURE_MASK_CONN37_3          (0x42f0)
#define AFE_SECURE_MASK_CONN37_4          (0x42f4)
#define AFE_SECURE_MASK_CONN38            (0x42f8)
#define AFE_SECURE_MASK_CONN38_1          (0x42fc)
#define AFE_SECURE_MASK_CONN38_2          (0x4300)
#define AFE_SECURE_MASK_CONN38_3          (0x4304)
#define AFE_SECURE_MASK_CONN38_4          (0x4308)
#define AFE_SECURE_MASK_CONN39            (0x430c)
#define AFE_SECURE_MASK_CONN39_1          (0x4310)
#define AFE_SECURE_MASK_CONN39_2          (0x4314)
#define AFE_SECURE_MASK_CONN39_3          (0x4318)
#define AFE_SECURE_MASK_CONN39_4          (0x431c)
#define AFE_SECURE_MASK_CONN40            (0x4320)
#define AFE_SECURE_MASK_CONN40_1          (0x4324)
#define AFE_SECURE_MASK_CONN40_2          (0x4328)
#define AFE_SECURE_MASK_CONN40_3          (0x432c)
#define AFE_SECURE_MASK_CONN40_4          (0x4330)
#define AFE_SECURE_MASK_CONN41            (0x4334)
#define AFE_SECURE_MASK_CONN41_1          (0x4338)
#define AFE_SECURE_MASK_CONN41_2          (0x433c)
#define AFE_SECURE_MASK_CONN41_3          (0x4340)
#define AFE_SECURE_MASK_CONN41_4          (0x4344)
#define AFE_SECURE_MASK_CONN42            (0x4348)
#define AFE_SECURE_MASK_CONN42_1          (0x434c)
#define AFE_SECURE_MASK_CONN42_2          (0x4350)
#define AFE_SECURE_MASK_CONN42_3          (0x4354)
#define AFE_SECURE_MASK_CONN42_4          (0x4358)
#define AFE_SECURE_MASK_CONN43            (0x435c)
#define AFE_SECURE_MASK_CONN43_1          (0x4360)
#define AFE_SECURE_MASK_CONN43_2          (0x4364)
#define AFE_SECURE_MASK_CONN43_3          (0x4368)
#define AFE_SECURE_MASK_CONN43_4          (0x436c)
#define AFE_SECURE_MASK_CONN44            (0x4370)
#define AFE_SECURE_MASK_CONN44_1          (0x4374)
#define AFE_SECURE_MASK_CONN44_2          (0x4378)
#define AFE_SECURE_MASK_CONN44_3          (0x437c)
#define AFE_SECURE_MASK_CONN44_4          (0x4380)
#define AFE_SECURE_MASK_CONN45            (0x4384)
#define AFE_SECURE_MASK_CONN45_1          (0x4388)
#define AFE_SECURE_MASK_CONN45_2          (0x438c)
#define AFE_SECURE_MASK_CONN45_3          (0x4390)
#define AFE_SECURE_MASK_CONN45_4          (0x4394)
#define AFE_SECURE_MASK_CONN46            (0x4398)
#define AFE_SECURE_MASK_CONN46_1          (0x439c)
#define AFE_SECURE_MASK_CONN46_2          (0x43a0)
#define AFE_SECURE_MASK_CONN46_3          (0x43a4)
#define AFE_SECURE_MASK_CONN46_4          (0x43a8)
#define AFE_SECURE_MASK_CONN47            (0x43ac)
#define AFE_SECURE_MASK_CONN47_1          (0x43b0)
#define AFE_SECURE_MASK_CONN47_2          (0x43b4)
#define AFE_SECURE_MASK_CONN47_3          (0x43b8)
#define AFE_SECURE_MASK_CONN47_4          (0x43bc)
#define AFE_SECURE_MASK_CONN48            (0x43c0)
#define AFE_SECURE_MASK_CONN48_1          (0x43c4)
#define AFE_SECURE_MASK_CONN48_2          (0x43c8)
#define AFE_SECURE_MASK_CONN48_3          (0x43cc)
#define AFE_SECURE_MASK_CONN48_4          (0x43d0)
#define AFE_SECURE_MASK_CONN49            (0x43d4)
#define AFE_SECURE_MASK_CONN49_1          (0x43d8)
#define AFE_SECURE_MASK_CONN49_2          (0x43dc)
#define AFE_SECURE_MASK_CONN49_3          (0x43e0)
#define AFE_SECURE_MASK_CONN49_4          (0x43e4)
#define AFE_SECURE_MASK_CONN50            (0x43e8)
#define AFE_SECURE_MASK_CONN50_1          (0x43ec)
#define AFE_SECURE_MASK_CONN50_2          (0x43f0)
#define AFE_SECURE_MASK_CONN50_3          (0x43f4)
#define AFE_SECURE_MASK_CONN50_4          (0x43f8)
#define AFE_SECURE_MASK_CONN51            (0x43fc)
#define AFE_SECURE_MASK_CONN51_1          (0x4400)
#define AFE_SECURE_MASK_CONN51_2          (0x4404)
#define AFE_SECURE_MASK_CONN51_3          (0x4408)
#define AFE_SECURE_MASK_CONN51_4          (0x440c)
#define AFE_SECURE_MASK_CONN52            (0x4410)
#define AFE_SECURE_MASK_CONN52_1          (0x4414)
#define AFE_SECURE_MASK_CONN52_2          (0x4418)
#define AFE_SECURE_MASK_CONN52_3          (0x441c)
#define AFE_SECURE_MASK_CONN52_4          (0x4420)
#define AFE_SECURE_MASK_CONN53            (0x4424)
#define AFE_SECURE_MASK_CONN53_1          (0x4428)
#define AFE_SECURE_MASK_CONN53_2          (0x442c)
#define AFE_SECURE_MASK_CONN53_3          (0x4430)
#define AFE_SECURE_MASK_CONN53_4          (0x4434)
#define AFE_SECURE_MASK_CONN54            (0x4438)
#define AFE_SECURE_MASK_CONN54_1          (0x443c)
#define AFE_SECURE_MASK_CONN54_2          (0x4440)
#define AFE_SECURE_MASK_CONN54_3          (0x4444)
#define AFE_SECURE_MASK_CONN54_4          (0x4448)
#define AFE_SECURE_MASK_CONN55            (0x444c)
#define AFE_SECURE_MASK_CONN55_1          (0x4450)
#define AFE_SECURE_MASK_CONN55_2          (0x4454)
#define AFE_SECURE_MASK_CONN55_3          (0x4458)
#define AFE_SECURE_MASK_CONN55_4          (0x445c)
#define AFE_SECURE_MASK_CONN56            (0x4460)
#define AFE_SECURE_MASK_CONN56_1          (0x4464)
#define AFE_SECURE_MASK_CONN56_2          (0x4468)
#define AFE_SECURE_MASK_CONN56_3          (0x446c)
#define AFE_SECURE_MASK_CONN56_4          (0x4470)
#define AFE_SECURE_MASK_CONN57            (0x4474)
#define AFE_SECURE_MASK_CONN57_1          (0x4478)
#define AFE_SECURE_MASK_CONN57_2          (0x447c)
#define AFE_SECURE_MASK_CONN57_3          (0x4480)
#define AFE_SECURE_MASK_CONN57_4          (0x4484)
#define AFE_SECURE_MASK_CONN58            (0x4488)
#define AFE_SECURE_MASK_CONN58_1          (0x448c)
#define AFE_SECURE_MASK_CONN58_2          (0x4490)
#define AFE_SECURE_MASK_CONN58_3          (0x4494)
#define AFE_SECURE_MASK_CONN58_4          (0x4498)
#define AFE_SECURE_MASK_CONN59            (0x449c)
#define AFE_SECURE_MASK_CONN59_1          (0x44a0)
#define AFE_SECURE_MASK_CONN59_2          (0x44a4)
#define AFE_SECURE_MASK_CONN59_3          (0x44a8)
#define AFE_SECURE_MASK_CONN59_4          (0x44ac)
#define AFE_SECURE_MASK_CONN60            (0x44b0)
#define AFE_SECURE_MASK_CONN60_1          (0x44b4)
#define AFE_SECURE_MASK_CONN60_2          (0x44b8)
#define AFE_SECURE_MASK_CONN60_3          (0x44bc)
#define AFE_SECURE_MASK_CONN60_4          (0x44c0)
#define AFE_SECURE_MASK_CONN61            (0x44c4)
#define AFE_SECURE_MASK_CONN61_1          (0x44c8)
#define AFE_SECURE_MASK_CONN61_2          (0x44cc)
#define AFE_SECURE_MASK_CONN61_3          (0x44d0)
#define AFE_SECURE_MASK_CONN61_4          (0x44d4)
#define AFE_SECURE_MASK_CONN62            (0x44d8)
#define AFE_SECURE_MASK_CONN62_1          (0x44dc)
#define AFE_SECURE_MASK_CONN62_2          (0x44e0)
#define AFE_SECURE_MASK_CONN62_3          (0x44e4)
#define AFE_SECURE_MASK_CONN62_4          (0x44e8)
#define AFE_SECURE_MASK_CONN63            (0x44ec)
#define AFE_SECURE_MASK_CONN63_1          (0x44f0)
#define AFE_SECURE_MASK_CONN63_2          (0x44f4)
#define AFE_SECURE_MASK_CONN63_3          (0x44f8)
#define AFE_SECURE_MASK_CONN63_4          (0x44fc)
#define AFE_SECURE_MASK_CONN64            (0x4500)
#define AFE_SECURE_MASK_CONN64_1          (0x4504)
#define AFE_SECURE_MASK_CONN64_2          (0x4508)
#define AFE_SECURE_MASK_CONN64_3          (0x450c)
#define AFE_SECURE_MASK_CONN64_4          (0x4510)
#define AFE_SECURE_MASK_CONN65            (0x4514)
#define AFE_SECURE_MASK_CONN65_1          (0x4518)
#define AFE_SECURE_MASK_CONN65_2          (0x451c)
#define AFE_SECURE_MASK_CONN65_3          (0x4520)
#define AFE_SECURE_MASK_CONN65_4          (0x4524)
#define AFE_SECURE_MASK_CONN66            (0x4528)
#define AFE_SECURE_MASK_CONN66_1          (0x452c)
#define AFE_SECURE_MASK_CONN66_2          (0x4530)
#define AFE_SECURE_MASK_CONN66_3          (0x4534)
#define AFE_SECURE_MASK_CONN66_4          (0x4538)
#define AFE_SECURE_MASK_CONN67            (0x453c)
#define AFE_SECURE_MASK_CONN67_1          (0x4540)
#define AFE_SECURE_MASK_CONN67_2          (0x4544)
#define AFE_SECURE_MASK_CONN67_3          (0x4548)
#define AFE_SECURE_MASK_CONN67_4          (0x454c)
#define AFE_SECURE_MASK_CONN68            (0x4550)
#define AFE_SECURE_MASK_CONN68_1          (0x4554)
#define AFE_SECURE_MASK_CONN68_2          (0x4558)
#define AFE_SECURE_MASK_CONN68_3          (0x455c)
#define AFE_SECURE_MASK_CONN68_4          (0x4560)
#define AFE_SECURE_MASK_CONN69            (0x4564)
#define AFE_SECURE_MASK_CONN69_1          (0x4568)
#define AFE_SECURE_MASK_CONN69_2          (0x456c)
#define AFE_SECURE_MASK_CONN69_3          (0x4570)
#define AFE_SECURE_MASK_CONN69_4          (0x4574)
#define AFE_SECURE_MASK_CONN70            (0x4578)
#define AFE_SECURE_MASK_CONN70_1          (0x457c)
#define AFE_SECURE_MASK_CONN70_2          (0x4580)
#define AFE_SECURE_MASK_CONN70_3          (0x4584)
#define AFE_SECURE_MASK_CONN70_4          (0x4588)
#define AFE_SECURE_MASK_CONN71            (0x458c)
#define AFE_SECURE_MASK_CONN71_1          (0x4590)
#define AFE_SECURE_MASK_CONN71_2          (0x4594)
#define AFE_SECURE_MASK_CONN71_3          (0x4598)
#define AFE_SECURE_MASK_CONN71_4          (0x459c)
#define AFE_SECURE_MASK_CONN72            (0x45a0)
#define AFE_SECURE_MASK_CONN72_1          (0x45a4)
#define AFE_SECURE_MASK_CONN72_2          (0x45a8)
#define AFE_SECURE_MASK_CONN72_3          (0x45ac)
#define AFE_SECURE_MASK_CONN72_4          (0x45b0)
#define AFE_SECURE_MASK_CONN73            (0x45b4)
#define AFE_SECURE_MASK_CONN73_1          (0x45b8)
#define AFE_SECURE_MASK_CONN73_2          (0x45bc)
#define AFE_SECURE_MASK_CONN73_3          (0x45c0)
#define AFE_SECURE_MASK_CONN73_4          (0x45c4)
#define AFE_SECURE_MASK_CONN74            (0x45c8)
#define AFE_SECURE_MASK_CONN74_1          (0x45cc)
#define AFE_SECURE_MASK_CONN74_2          (0x45d0)
#define AFE_SECURE_MASK_CONN74_3          (0x45d4)
#define AFE_SECURE_MASK_CONN74_4          (0x45d8)
#define AFE_SECURE_MASK_CONN75            (0x45dc)
#define AFE_SECURE_MASK_CONN75_1          (0x45e0)
#define AFE_SECURE_MASK_CONN75_2          (0x45e4)
#define AFE_SECURE_MASK_CONN75_3          (0x45e8)
#define AFE_SECURE_MASK_CONN75_4          (0x45ec)
#define AFE_SECURE_MASK_CONN76            (0x45f0)
#define AFE_SECURE_MASK_CONN76_1          (0x45f4)
#define AFE_SECURE_MASK_CONN76_2          (0x45f8)
#define AFE_SECURE_MASK_CONN76_3          (0x45fc)
#define AFE_SECURE_MASK_CONN76_4          (0x4600)
#define AFE_SECURE_MASK_CONN77            (0x4604)
#define AFE_SECURE_MASK_CONN77_1          (0x4608)
#define AFE_SECURE_MASK_CONN77_2          (0x460c)
#define AFE_SECURE_MASK_CONN77_3          (0x4610)
#define AFE_SECURE_MASK_CONN77_4          (0x4614)
#define AFE_SECURE_MASK_CONN78            (0x4618)
#define AFE_SECURE_MASK_CONN78_1          (0x461c)
#define AFE_SECURE_MASK_CONN78_2          (0x4620)
#define AFE_SECURE_MASK_CONN78_3          (0x4624)
#define AFE_SECURE_MASK_CONN78_4          (0x4628)
#define AFE_SECURE_MASK_CONN79            (0x462c)
#define AFE_SECURE_MASK_CONN79_1          (0x4630)
#define AFE_SECURE_MASK_CONN79_2          (0x4634)
#define AFE_SECURE_MASK_CONN79_3          (0x4638)
#define AFE_SECURE_MASK_CONN79_4          (0x463c)
#define AFE_SECURE_MASK_CONN80            (0x4640)
#define AFE_SECURE_MASK_CONN80_1          (0x4644)
#define AFE_SECURE_MASK_CONN80_2          (0x4648)
#define AFE_SECURE_MASK_CONN80_3          (0x464c)
#define AFE_SECURE_MASK_CONN80_4          (0x4650)
#define AFE_SECURE_MASK_CONN81            (0x4654)
#define AFE_SECURE_MASK_CONN81_1          (0x4658)
#define AFE_SECURE_MASK_CONN81_2          (0x465c)
#define AFE_SECURE_MASK_CONN81_3          (0x4660)
#define AFE_SECURE_MASK_CONN81_4          (0x4664)
#define AFE_SECURE_MASK_CONN82            (0x4668)
#define AFE_SECURE_MASK_CONN82_1          (0x466c)
#define AFE_SECURE_MASK_CONN82_2          (0x4670)
#define AFE_SECURE_MASK_CONN82_3          (0x4674)
#define AFE_SECURE_MASK_CONN82_4          (0x4678)
#define AFE_SECURE_MASK_CONN83            (0x467c)
#define AFE_SECURE_MASK_CONN83_1          (0x4680)
#define AFE_SECURE_MASK_CONN83_2          (0x4684)
#define AFE_SECURE_MASK_CONN83_3          (0x4688)
#define AFE_SECURE_MASK_CONN83_4          (0x468c)
#define AFE_SECURE_MASK_CONN84            (0x4690)
#define AFE_SECURE_MASK_CONN84_1          (0x4694)
#define AFE_SECURE_MASK_CONN84_2          (0x4698)
#define AFE_SECURE_MASK_CONN84_3          (0x469c)
#define AFE_SECURE_MASK_CONN84_4          (0x46a0)
#define AFE_SECURE_MASK_CONN85            (0x46a4)
#define AFE_SECURE_MASK_CONN85_1          (0x46a8)
#define AFE_SECURE_MASK_CONN85_2          (0x46ac)
#define AFE_SECURE_MASK_CONN85_3          (0x46b0)
#define AFE_SECURE_MASK_CONN85_4          (0x46b4)
#define AFE_SECURE_MASK_CONN86            (0x46b8)
#define AFE_SECURE_MASK_CONN86_1          (0x46bc)
#define AFE_SECURE_MASK_CONN86_2          (0x46c0)
#define AFE_SECURE_MASK_CONN86_3          (0x46c4)
#define AFE_SECURE_MASK_CONN86_4          (0x46c8)
#define AFE_SECURE_MASK_CONN87            (0x46cc)
#define AFE_SECURE_MASK_CONN87_1          (0x46d0)
#define AFE_SECURE_MASK_CONN87_2          (0x46d4)
#define AFE_SECURE_MASK_CONN87_3          (0x46d8)
#define AFE_SECURE_MASK_CONN87_4          (0x46dc)
#define AFE_SECURE_MASK_CONN88            (0x46e0)
#define AFE_SECURE_MASK_CONN88_1          (0x46e4)
#define AFE_SECURE_MASK_CONN88_2          (0x46e8)
#define AFE_SECURE_MASK_CONN88_3          (0x46ec)
#define AFE_SECURE_MASK_CONN88_4          (0x46f0)
#define AFE_SECURE_MASK_CONN89            (0x46f4)
#define AFE_SECURE_MASK_CONN89_1          (0x46f8)
#define AFE_SECURE_MASK_CONN89_2          (0x46fc)
#define AFE_SECURE_MASK_CONN89_3          (0x4700)
#define AFE_SECURE_MASK_CONN89_4          (0x4704)
#define AFE_SECURE_MASK_CONN90            (0x4708)
#define AFE_SECURE_MASK_CONN90_1          (0x470c)
#define AFE_SECURE_MASK_CONN90_2          (0x4710)
#define AFE_SECURE_MASK_CONN90_3          (0x4714)
#define AFE_SECURE_MASK_CONN90_4          (0x4718)
#define AFE_SECURE_MASK_CONN91            (0x471c)
#define AFE_SECURE_MASK_CONN91_1          (0x4720)
#define AFE_SECURE_MASK_CONN91_2          (0x4724)
#define AFE_SECURE_MASK_CONN91_3          (0x4728)
#define AFE_SECURE_MASK_CONN91_4          (0x472c)
#define AFE_SECURE_MASK_CONN92            (0x4730)
#define AFE_SECURE_MASK_CONN92_1          (0x4734)
#define AFE_SECURE_MASK_CONN92_2          (0x4738)
#define AFE_SECURE_MASK_CONN92_3          (0x473c)
#define AFE_SECURE_MASK_CONN92_4          (0x4740)
#define AFE_SECURE_MASK_CONN93            (0x4744)
#define AFE_SECURE_MASK_CONN93_1          (0x4748)
#define AFE_SECURE_MASK_CONN93_2          (0x474c)
#define AFE_SECURE_MASK_CONN93_3          (0x4750)
#define AFE_SECURE_MASK_CONN93_4          (0x4754)
#define AFE_SECURE_MASK_CONN94            (0x4758)
#define AFE_SECURE_MASK_CONN94_1          (0x475c)
#define AFE_SECURE_MASK_CONN94_2          (0x4760)
#define AFE_SECURE_MASK_CONN94_3          (0x4764)
#define AFE_SECURE_MASK_CONN94_4          (0x4768)
#define AFE_SECURE_MASK_CONN95            (0x476c)
#define AFE_SECURE_MASK_CONN95_1          (0x4770)
#define AFE_SECURE_MASK_CONN95_2          (0x4774)
#define AFE_SECURE_MASK_CONN95_3          (0x4778)
#define AFE_SECURE_MASK_CONN95_4          (0x477c)
#define AFE_SECURE_MASK_CONN96            (0x4780)
#define AFE_SECURE_MASK_CONN96_1          (0x4784)
#define AFE_SECURE_MASK_CONN96_2          (0x4788)
#define AFE_SECURE_MASK_CONN96_3          (0x478c)
#define AFE_SECURE_MASK_CONN96_4          (0x4790)
#define AFE_SECURE_MASK_CONN97            (0x4794)
#define AFE_SECURE_MASK_CONN97_1          (0x4798)
#define AFE_SECURE_MASK_CONN97_2          (0x479c)
#define AFE_SECURE_MASK_CONN97_3          (0x47a0)
#define AFE_SECURE_MASK_CONN97_4          (0x47a4)
#define AFE_SECURE_MASK_CONN98            (0x47a8)
#define AFE_SECURE_MASK_CONN98_1          (0x47ac)
#define AFE_SECURE_MASK_CONN98_2          (0x47b0)
#define AFE_SECURE_MASK_CONN98_3          (0x47b4)
#define AFE_SECURE_MASK_CONN98_4          (0x47b8)
#define AFE_SECURE_MASK_CONN99            (0x47bc)
#define AFE_SECURE_MASK_CONN99_1          (0x47c0)
#define AFE_SECURE_MASK_CONN99_2          (0x47c4)
#define AFE_SECURE_MASK_CONN99_3          (0x47c8)
#define AFE_SECURE_MASK_CONN99_4          (0x47cc)
#define AFE_SECURE_MASK_CONN100           (0x47d0)
#define AFE_SECURE_MASK_CONN100_1         (0x47d4)
#define AFE_SECURE_MASK_CONN100_2         (0x47d8)
#define AFE_SECURE_MASK_CONN100_3         (0x47dc)
#define AFE_SECURE_MASK_CONN100_4         (0x47e0)
#define AFE_SECURE_MASK_CONN101           (0x47e4)
#define AFE_SECURE_MASK_CONN101_1         (0x47e8)
#define AFE_SECURE_MASK_CONN101_2         (0x47ec)
#define AFE_SECURE_MASK_CONN101_3         (0x47f0)
#define AFE_SECURE_MASK_CONN101_4         (0x47f4)
#define AFE_SECURE_MASK_CONN102           (0x47f8)
#define AFE_SECURE_MASK_CONN102_1         (0x47fc)
#define AFE_SECURE_MASK_CONN102_2         (0x4800)
#define AFE_SECURE_MASK_CONN102_3         (0x4804)
#define AFE_SECURE_MASK_CONN102_4         (0x4808)
#define AFE_SECURE_MASK_CONN103           (0x480c)
#define AFE_SECURE_MASK_CONN103_1         (0x4810)
#define AFE_SECURE_MASK_CONN103_2         (0x4814)
#define AFE_SECURE_MASK_CONN103_3         (0x4818)
#define AFE_SECURE_MASK_CONN103_4         (0x481c)
#define AFE_SECURE_MASK_CONN104           (0x4820)
#define AFE_SECURE_MASK_CONN104_1         (0x4824)
#define AFE_SECURE_MASK_CONN104_2         (0x4828)
#define AFE_SECURE_MASK_CONN104_3         (0x482c)
#define AFE_SECURE_MASK_CONN104_4         (0x4830)
#define AFE_SECURE_MASK_CONN105           (0x4834)
#define AFE_SECURE_MASK_CONN105_1         (0x4838)
#define AFE_SECURE_MASK_CONN105_2         (0x483c)
#define AFE_SECURE_MASK_CONN105_3         (0x4840)
#define AFE_SECURE_MASK_CONN105_4         (0x4844)
#define AFE_SECURE_MASK_CONN106           (0x4848)
#define AFE_SECURE_MASK_CONN106_1         (0x484c)
#define AFE_SECURE_MASK_CONN106_2         (0x4850)
#define AFE_SECURE_MASK_CONN106_3         (0x4854)
#define AFE_SECURE_MASK_CONN106_4         (0x4858)
#define AFE_SECURE_MASK_CONN107           (0x485c)
#define AFE_SECURE_MASK_CONN107_1         (0x4860)
#define AFE_SECURE_MASK_CONN107_2         (0x4864)
#define AFE_SECURE_MASK_CONN107_3         (0x4868)
#define AFE_SECURE_MASK_CONN107_4         (0x486c)
#define AFE_SECURE_MASK_CONN108           (0x4870)
#define AFE_SECURE_MASK_CONN108_1         (0x4874)
#define AFE_SECURE_MASK_CONN108_2         (0x4878)
#define AFE_SECURE_MASK_CONN108_3         (0x487c)
#define AFE_SECURE_MASK_CONN108_4         (0x4880)
#define AFE_SECURE_MASK_CONN109           (0x4884)
#define AFE_SECURE_MASK_CONN109_1         (0x4888)
#define AFE_SECURE_MASK_CONN109_2         (0x488c)
#define AFE_SECURE_MASK_CONN109_3         (0x4890)
#define AFE_SECURE_MASK_CONN109_4         (0x4894)
#define AFE_SECURE_MASK_CONN110           (0x4898)
#define AFE_SECURE_MASK_CONN110_1         (0x489c)
#define AFE_SECURE_MASK_CONN110_2         (0x48a0)
#define AFE_SECURE_MASK_CONN110_3         (0x48a4)
#define AFE_SECURE_MASK_CONN110_4         (0x48a8)
#define AFE_SECURE_MASK_CONN111           (0x48ac)
#define AFE_SECURE_MASK_CONN111_1         (0x48b0)
#define AFE_SECURE_MASK_CONN111_2         (0x48b4)
#define AFE_SECURE_MASK_CONN111_3         (0x48b8)
#define AFE_SECURE_MASK_CONN111_4         (0x48bc)
#define AFE_SECURE_MASK_CONN112           (0x48c0)
#define AFE_SECURE_MASK_CONN112_1         (0x48c4)
#define AFE_SECURE_MASK_CONN112_2         (0x48c8)
#define AFE_SECURE_MASK_CONN112_3         (0x48cc)
#define AFE_SECURE_MASK_CONN112_4         (0x48d0)
#define AFE_SECURE_MASK_CONN113           (0x48d4)
#define AFE_SECURE_MASK_CONN113_1         (0x48d8)
#define AFE_SECURE_MASK_CONN113_2         (0x48dc)
#define AFE_SECURE_MASK_CONN113_3         (0x48e0)
#define AFE_SECURE_MASK_CONN113_4         (0x48e4)
#define AFE_SECURE_MASK_CONN114           (0x48e8)
#define AFE_SECURE_MASK_CONN114_1         (0x48ec)
#define AFE_SECURE_MASK_CONN114_2         (0x48f0)
#define AFE_SECURE_MASK_CONN114_3         (0x48f4)
#define AFE_SECURE_MASK_CONN114_4         (0x48f8)
#define AFE_SECURE_MASK_CONN115           (0x48fc)
#define AFE_SECURE_MASK_CONN115_1         (0x4900)
#define AFE_SECURE_MASK_CONN115_2         (0x4904)
#define AFE_SECURE_MASK_CONN115_3         (0x4908)
#define AFE_SECURE_MASK_CONN115_4         (0x490c)
#define AFE_SECURE_MASK_CONN116           (0x4910)
#define AFE_SECURE_MASK_CONN116_1         (0x4914)
#define AFE_SECURE_MASK_CONN116_2         (0x4918)
#define AFE_SECURE_MASK_CONN116_3         (0x491c)
#define AFE_SECURE_MASK_CONN116_4         (0x4920)
#define AFE_SECURE_MASK_CONN117           (0x4924)
#define AFE_SECURE_MASK_CONN117_1         (0x4928)
#define AFE_SECURE_MASK_CONN117_2         (0x492c)
#define AFE_SECURE_MASK_CONN117_3         (0x4930)
#define AFE_SECURE_MASK_CONN117_4         (0x4934)
#define AFE_SECURE_MASK_CONN118           (0x4938)
#define AFE_SECURE_MASK_CONN118_1         (0x493c)
#define AFE_SECURE_MASK_CONN118_2         (0x4940)
#define AFE_SECURE_MASK_CONN118_3         (0x4944)
#define AFE_SECURE_MASK_CONN118_4         (0x4948)
#define AFE_SECURE_MASK_CONN119           (0x494c)
#define AFE_SECURE_MASK_CONN119_1         (0x4950)
#define AFE_SECURE_MASK_CONN119_2         (0x4954)
#define AFE_SECURE_MASK_CONN119_3         (0x4958)
#define AFE_SECURE_MASK_CONN119_4         (0x495c)
#define AFE_SECURE_MASK_CONN120           (0x4960)
#define AFE_SECURE_MASK_CONN120_1         (0x4964)
#define AFE_SECURE_MASK_CONN120_2         (0x4968)
#define AFE_SECURE_MASK_CONN120_3         (0x496c)
#define AFE_SECURE_MASK_CONN120_4         (0x4970)
#define AFE_SECURE_MASK_CONN121           (0x4974)
#define AFE_SECURE_MASK_CONN121_1         (0x4978)
#define AFE_SECURE_MASK_CONN121_2         (0x497c)
#define AFE_SECURE_MASK_CONN121_3         (0x4980)
#define AFE_SECURE_MASK_CONN121_4         (0x4984)
#define AFE_SECURE_MASK_CONN122           (0x4988)
#define AFE_SECURE_MASK_CONN122_1         (0x498c)
#define AFE_SECURE_MASK_CONN122_2         (0x4990)
#define AFE_SECURE_MASK_CONN122_3         (0x4994)
#define AFE_SECURE_MASK_CONN122_4         (0x4998)
#define AFE_SECURE_MASK_CONN123           (0x499c)
#define AFE_SECURE_MASK_CONN123_1         (0x49a0)
#define AFE_SECURE_MASK_CONN123_2         (0x49a4)
#define AFE_SECURE_MASK_CONN123_3         (0x49a8)
#define AFE_SECURE_MASK_CONN123_4         (0x49ac)
#define AFE_SECURE_MASK_CONN124           (0x49b0)
#define AFE_SECURE_MASK_CONN124_1         (0x49b4)
#define AFE_SECURE_MASK_CONN124_2         (0x49b8)
#define AFE_SECURE_MASK_CONN124_3         (0x49bc)
#define AFE_SECURE_MASK_CONN124_4         (0x49c0)
#define AFE_SECURE_MASK_CONN125           (0x49c4)
#define AFE_SECURE_MASK_CONN125_1         (0x49c8)
#define AFE_SECURE_MASK_CONN125_2         (0x49cc)
#define AFE_SECURE_MASK_CONN125_3         (0x49d0)
#define AFE_SECURE_MASK_CONN125_4         (0x49d4)
#define AFE_SECURE_MASK_CONN126           (0x49d8)
#define AFE_SECURE_MASK_CONN126_1         (0x49dc)
#define AFE_SECURE_MASK_CONN126_2         (0x49e0)
#define AFE_SECURE_MASK_CONN126_3         (0x49e4)
#define AFE_SECURE_MASK_CONN126_4         (0x49e8)
#define AFE_SECURE_MASK_CONN127           (0x49ec)
#define AFE_SECURE_MASK_CONN127_1         (0x49f0)
#define AFE_SECURE_MASK_CONN127_2         (0x49f4)
#define AFE_SECURE_MASK_CONN127_3         (0x49f8)
#define AFE_SECURE_MASK_CONN127_4         (0x49fc)
#define AFE_SECURE_MASK_CONN128           (0x4a00)
#define AFE_SECURE_MASK_CONN128_1         (0x4a04)
#define AFE_SECURE_MASK_CONN128_2         (0x4a08)
#define AFE_SECURE_MASK_CONN128_3         (0x4a0c)
#define AFE_SECURE_MASK_CONN128_4         (0x4a10)
#define AFE_SECURE_MASK_CONN129           (0x4a14)
#define AFE_SECURE_MASK_CONN129_1         (0x4a18)
#define AFE_SECURE_MASK_CONN129_2         (0x4a1c)
#define AFE_SECURE_MASK_CONN129_3         (0x4a20)
#define AFE_SECURE_MASK_CONN129_4         (0x4a24)
#define AFE_SECURE_MASK_CONN130           (0x4a28)
#define AFE_SECURE_MASK_CONN130_1         (0x4a2c)
#define AFE_SECURE_MASK_CONN130_2         (0x4a30)
#define AFE_SECURE_MASK_CONN130_3         (0x4a34)
#define AFE_SECURE_MASK_CONN130_4         (0x4a38)
#define AFE_SECURE_MASK_CONN131           (0x4a3c)
#define AFE_SECURE_MASK_CONN131_1         (0x4a40)
#define AFE_SECURE_MASK_CONN131_2         (0x4a44)
#define AFE_SECURE_MASK_CONN131_3         (0x4a48)
#define AFE_SECURE_MASK_CONN131_4         (0x4a4c)
#define AFE_SECURE_MASK_CONN132           (0x4a50)
#define AFE_SECURE_MASK_CONN132_1         (0x4a54)
#define AFE_SECURE_MASK_CONN132_2         (0x4a58)
#define AFE_SECURE_MASK_CONN132_3         (0x4a5c)
#define AFE_SECURE_MASK_CONN132_4         (0x4a60)
#define AFE_SECURE_MASK_CONN133           (0x4a64)
#define AFE_SECURE_MASK_CONN133_1         (0x4a68)
#define AFE_SECURE_MASK_CONN133_2         (0x4a6c)
#define AFE_SECURE_MASK_CONN133_3         (0x4a70)
#define AFE_SECURE_MASK_CONN133_4         (0x4a74)
#define AFE_SECURE_MASK_CONN134           (0x4a78)
#define AFE_SECURE_MASK_CONN134_1         (0x4a7c)
#define AFE_SECURE_MASK_CONN134_2         (0x4a80)
#define AFE_SECURE_MASK_CONN134_3         (0x4a84)
#define AFE_SECURE_MASK_CONN134_4         (0x4a88)
#define AFE_SECURE_MASK_CONN135           (0x4a8c)
#define AFE_SECURE_MASK_CONN135_1         (0x4a90)
#define AFE_SECURE_MASK_CONN135_2         (0x4a94)
#define AFE_SECURE_MASK_CONN135_3         (0x4a98)
#define AFE_SECURE_MASK_CONN135_4         (0x4a9c)
#define AFE_SECURE_MASK_CONN136           (0x4aa0)
#define AFE_SECURE_MASK_CONN136_1         (0x4aa4)
#define AFE_SECURE_MASK_CONN136_2         (0x4aa8)
#define AFE_SECURE_MASK_CONN136_3         (0x4aac)
#define AFE_SECURE_MASK_CONN136_4         (0x4ab0)
#define AFE_SECURE_MASK_CONN137           (0x4ab4)
#define AFE_SECURE_MASK_CONN137_1         (0x4ab8)
#define AFE_SECURE_MASK_CONN137_2         (0x4abc)
#define AFE_SECURE_MASK_CONN137_3         (0x4ac0)
#define AFE_SECURE_MASK_CONN137_4         (0x4ac4)
#define AFE_SECURE_MASK_CONN138           (0x4ac8)
#define AFE_SECURE_MASK_CONN138_1         (0x4acc)
#define AFE_SECURE_MASK_CONN138_2         (0x4ad0)
#define AFE_SECURE_MASK_CONN138_3         (0x4ad4)
#define AFE_SECURE_MASK_CONN138_4         (0x4ad8)
#define AFE_SECURE_MASK_CONN139           (0x4adc)
#define AFE_SECURE_MASK_CONN139_1         (0x4ae0)
#define AFE_SECURE_MASK_CONN139_2         (0x4ae4)
#define AFE_SECURE_MASK_CONN139_3         (0x4ae8)
#define AFE_SECURE_MASK_CONN139_4         (0x4aec)
#define AFE_SECURE_MASK_CONN_RS           (0x4af0)
#define AFE_SECURE_MASK_CONN_RS_1         (0x4af4)
#define AFE_SECURE_MASK_CONN_RS_2         (0x4af8)
#define AFE_SECURE_MASK_CONN_RS_3         (0x4afc)
#define AFE_SECURE_MASK_CONN_RS_4         (0x4b00)
#define AFE_SECURE_MASK_CONN_16BIT        (0x4b04)
#define AFE_SECURE_MASK_CONN_16BIT_1      (0x4b08)
#define AFE_SECURE_MASK_CONN_16BIT_2      (0x4b0c)
#define AFE_SECURE_MASK_CONN_16BIT_3      (0x4b10)
#define AFE_SECURE_MASK_CONN_16BIT_4      (0x4b14)
#define AFE_SECURE_MASK_CONN_24BIT        (0x4b18)
#define AFE_SECURE_MASK_CONN_24BIT_1      (0x4b1c)
#define AFE_SECURE_MASK_CONN_24BIT_2      (0x4b20)
#define AFE_SECURE_MASK_CONN_24BIT_3      (0x4b24)
#define AFE_SECURE_MASK_CONN_24BIT_4      (0x4b28)
#define AFE_SECURE_MASK_CONN0_5           (0x4b2c)
#define AFE_SECURE_MASK_CONN1_5           (0x4b30)
#define AFE_SECURE_MASK_CONN2_5           (0x4b34)
#define AFE_SECURE_MASK_CONN3_5           (0x4b38)
#define AFE_SECURE_MASK_CONN4_5           (0x4b3c)
#define AFE_SECURE_MASK_CONN5_5           (0x4b40)
#define AFE_SECURE_MASK_CONN6_5           (0x4b44)
#define AFE_SECURE_MASK_CONN7_5           (0x4b48)
#define AFE_SECURE_MASK_CONN8_5           (0x4b4c)
#define AFE_SECURE_MASK_CONN9_5           (0x4b50)
#define AFE_SECURE_MASK_CONN10_5          (0x4b54)
#define AFE_SECURE_MASK_CONN11_5          (0x4b58)
#define AFE_SECURE_MASK_CONN12_5          (0x4b5c)
#define AFE_SECURE_MASK_CONN13_5          (0x4b60)
#define AFE_SECURE_MASK_CONN14_5          (0x4b64)
#define AFE_SECURE_MASK_CONN15_5          (0x4b68)
#define AFE_SECURE_MASK_CONN16_5          (0x4b6c)
#define AFE_SECURE_MASK_CONN17_5          (0x4b70)
#define AFE_SECURE_MASK_CONN18_5          (0x4b74)
#define AFE_SECURE_MASK_CONN19_5          (0x4b78)
#define AFE_SECURE_MASK_CONN20_5          (0x4b7c)
#define AFE_SECURE_MASK_CONN21_5          (0x4b80)
#define AFE_SECURE_MASK_CONN22_5          (0x4b84)
#define AFE_SECURE_MASK_CONN23_5          (0x4b88)
#define AFE_SECURE_MASK_CONN24_5          (0x4b8c)
#define AFE_SECURE_MASK_CONN25_5          (0x4b90)
#define AFE_SECURE_MASK_CONN26_5          (0x4b94)
#define AFE_SECURE_MASK_CONN27_5          (0x4b98)
#define AFE_SECURE_MASK_CONN28_5          (0x4b9c)
#define AFE_SECURE_MASK_CONN29_5          (0x4ba0)
#define AFE_SECURE_MASK_CONN30_5          (0x4ba4)
#define AFE_SECURE_MASK_CONN31_5          (0x4ba8)
#define AFE_SECURE_MASK_CONN32_5          (0x4bac)
#define AFE_SECURE_MASK_CONN33_5          (0x4bb0)
#define AFE_SECURE_MASK_CONN34_5          (0x4bb4)
#define AFE_SECURE_MASK_CONN35_5          (0x4bb8)
#define AFE_SECURE_MASK_CONN36_5          (0x4bbc)
#define AFE_SECURE_MASK_CONN37_5          (0x4bc0)
#define AFE_SECURE_MASK_CONN38_5          (0x4bc4)
#define AFE_SECURE_MASK_CONN39_5          (0x4bc8)
#define AFE_SECURE_MASK_CONN40_5          (0x4bcc)
#define AFE_SECURE_MASK_CONN41_5          (0x4bd0)
#define AFE_SECURE_MASK_CONN42_5          (0x4bd4)
#define AFE_SECURE_MASK_CONN43_5          (0x4bd8)
#define AFE_SECURE_MASK_CONN44_5          (0x4bdc)
#define AFE_SECURE_MASK_CONN45_5          (0x4be0)
#define AFE_SECURE_MASK_CONN46_5          (0x4be4)
#define AFE_SECURE_MASK_CONN47_5          (0x4be8)
#define AFE_SECURE_MASK_CONN48_5          (0x4bec)
#define AFE_SECURE_MASK_CONN49_5          (0x4bf0)
#define AFE_SECURE_MASK_CONN50_5          (0x4bf4)
#define AFE_SECURE_MASK_CONN51_5          (0x4bf8)
#define AFE_SECURE_MASK_CONN52_5          (0x4bfc)
#define AFE_GASRC0_NEW_CON0               (0x4c40)
#define AFE_GASRC0_NEW_CON1               (0x4c44)
#define AFE_GASRC0_NEW_CON2               (0x4c48)
#define AFE_GASRC0_NEW_CON3               (0x4c4c)
#define AFE_GASRC0_NEW_CON4               (0x4c50)
#define AFE_GASRC0_NEW_CON5               (0x4c54)
#define AFE_GASRC0_NEW_CON6               (0x4c58)
#define AFE_GASRC0_NEW_CON7               (0x4c5c)
#define AFE_GASRC0_NEW_CON8               (0x4c60)
#define AFE_GASRC0_NEW_CON9               (0x4c64)
#define AFE_GASRC0_NEW_CON10              (0x4c68)
#define AFE_GASRC0_NEW_CON11              (0x4c6c)
#define AFE_GASRC0_NEW_CON12              (0x4c70)
#define AFE_GASRC0_NEW_CON13              (0x4c74)
#define AFE_GASRC0_NEW_CON14              (0x4c78)
#define AFE_GASRC1_NEW_CON0               (0x4c80)
#define AFE_GASRC1_NEW_CON1               (0x4c84)
#define AFE_GASRC1_NEW_CON2               (0x4c88)
#define AFE_GASRC1_NEW_CON3               (0x4c8c)
#define AFE_GASRC1_NEW_CON4               (0x4c90)
#define AFE_GASRC1_NEW_CON5               (0x4c94)
#define AFE_GASRC1_NEW_CON6               (0x4c98)
#define AFE_GASRC1_NEW_CON7               (0x4c9c)
#define AFE_GASRC1_NEW_CON8               (0x4ca0)
#define AFE_GASRC1_NEW_CON9               (0x4ca4)
#define AFE_GASRC1_NEW_CON10              (0x4ca8)
#define AFE_GASRC1_NEW_CON11              (0x4cac)
#define AFE_GASRC1_NEW_CON12              (0x4cb0)
#define AFE_GASRC1_NEW_CON13              (0x4cb4)
#define AFE_GASRC1_NEW_CON14              (0x4cb8)
#define AFE_GASRC2_NEW_CON0               (0x4cc0)
#define AFE_GASRC2_NEW_CON1               (0x4cc4)
#define AFE_GASRC2_NEW_CON2               (0x4cc8)
#define AFE_GASRC2_NEW_CON3               (0x4ccc)
#define AFE_GASRC2_NEW_CON4               (0x4cd0)
#define AFE_GASRC2_NEW_CON5               (0x4cd4)
#define AFE_GASRC2_NEW_CON6               (0x4cd8)
#define AFE_GASRC2_NEW_CON7               (0x4cdc)
#define AFE_GASRC2_NEW_CON8               (0x4ce0)
#define AFE_GASRC2_NEW_CON9               (0x4ce4)
#define AFE_GASRC2_NEW_CON10              (0x4ce8)
#define AFE_GASRC2_NEW_CON11              (0x4cec)
#define AFE_GASRC2_NEW_CON12              (0x4cf0)
#define AFE_GASRC2_NEW_CON13              (0x4cf4)
#define AFE_GASRC2_NEW_CON14              (0x4cf8)
#define AFE_GASRC3_NEW_CON0               (0x4d00)
#define AFE_GASRC3_NEW_CON1               (0x4d04)
#define AFE_GASRC3_NEW_CON2               (0x4d08)
#define AFE_GASRC3_NEW_CON3               (0x4d0c)
#define AFE_GASRC3_NEW_CON4               (0x4d10)
#define AFE_GASRC3_NEW_CON5               (0x4d14)
#define AFE_GASRC3_NEW_CON6               (0x4d18)
#define AFE_GASRC3_NEW_CON7               (0x4d1c)
#define AFE_GASRC3_NEW_CON8               (0x4d20)
#define AFE_GASRC3_NEW_CON9               (0x4d24)
#define AFE_GASRC3_NEW_CON10              (0x4d28)
#define AFE_GASRC3_NEW_CON11              (0x4d2c)
#define AFE_GASRC3_NEW_CON12              (0x4d30)
#define AFE_GASRC3_NEW_CON13              (0x4d34)
#define AFE_GASRC3_NEW_CON14              (0x4d38)
#define AFE_GASRC4_NEW_CON0               (0x4d40)
#define AFE_GASRC4_NEW_CON1               (0x4d44)
#define AFE_GASRC4_NEW_CON2               (0x4d48)
#define AFE_GASRC4_NEW_CON3               (0x4d4c)
#define AFE_GASRC4_NEW_CON4               (0x4d50)
#define AFE_GASRC4_NEW_CON5               (0x4d54)
#define AFE_GASRC4_NEW_CON6               (0x4d58)
#define AFE_GASRC4_NEW_CON7               (0x4d5c)
#define AFE_GASRC4_NEW_CON8               (0x4d60)
#define AFE_GASRC4_NEW_CON9               (0x4d64)
#define AFE_GASRC4_NEW_CON10              (0x4d68)
#define AFE_GASRC4_NEW_CON11              (0x4d6c)
#define AFE_GASRC4_NEW_CON12              (0x4d70)
#define AFE_GASRC4_NEW_CON13              (0x4d74)
#define AFE_GASRC4_NEW_CON14              (0x4d78)
#define AFE_GASRC5_NEW_CON0               (0x4d80)
#define AFE_GASRC5_NEW_CON1               (0x4d84)
#define AFE_GASRC5_NEW_CON2               (0x4d88)
#define AFE_GASRC5_NEW_CON3               (0x4d8c)
#define AFE_GASRC5_NEW_CON4               (0x4d90)
#define AFE_GASRC5_NEW_CON5               (0x4d94)
#define AFE_GASRC5_NEW_CON6               (0x4d98)
#define AFE_GASRC5_NEW_CON7               (0x4d9c)
#define AFE_GASRC5_NEW_CON8               (0x4da0)
#define AFE_GASRC5_NEW_CON9               (0x4da4)
#define AFE_GASRC5_NEW_CON10              (0x4da8)
#define AFE_GASRC5_NEW_CON11              (0x4dac)
#define AFE_GASRC5_NEW_CON12              (0x4db0)
#define AFE_GASRC5_NEW_CON13              (0x4db4)
#define AFE_GASRC5_NEW_CON14              (0x4db8)
#define AFE_GASRC6_NEW_CON0               (0x4dc0)
#define AFE_GASRC6_NEW_CON1               (0x4dc4)
#define AFE_GASRC6_NEW_CON2               (0x4dc8)
#define AFE_GASRC6_NEW_CON3               (0x4dcc)
#define AFE_GASRC6_NEW_CON4               (0x4dd0)
#define AFE_GASRC6_NEW_CON5               (0x4dd4)
#define AFE_GASRC6_NEW_CON6               (0x4dd8)
#define AFE_GASRC6_NEW_CON7               (0x4ddc)
#define AFE_GASRC6_NEW_CON8               (0x4de0)
#define AFE_GASRC6_NEW_CON9               (0x4de4)
#define AFE_GASRC6_NEW_CON10              (0x4de8)
#define AFE_GASRC6_NEW_CON11              (0x4dec)
#define AFE_GASRC6_NEW_CON12              (0x4df0)
#define AFE_GASRC6_NEW_CON13              (0x4df4)
#define AFE_GASRC6_NEW_CON14              (0x4df8)
#define AFE_GASRC7_NEW_CON0               (0x4e00)
#define AFE_GASRC7_NEW_CON1               (0x4e04)
#define AFE_GASRC7_NEW_CON2               (0x4e08)
#define AFE_GASRC7_NEW_CON3               (0x4e0c)
#define AFE_GASRC7_NEW_CON4               (0x4e10)
#define AFE_GASRC7_NEW_CON5               (0x4e14)
#define AFE_GASRC7_NEW_CON6               (0x4e18)
#define AFE_GASRC7_NEW_CON7               (0x4e1c)
#define AFE_GASRC7_NEW_CON8               (0x4e20)
#define AFE_GASRC7_NEW_CON9               (0x4e24)
#define AFE_GASRC7_NEW_CON10              (0x4e28)
#define AFE_GASRC7_NEW_CON11              (0x4e2c)
#define AFE_GASRC7_NEW_CON12              (0x4e30)
#define AFE_GASRC7_NEW_CON13              (0x4e34)
#define AFE_GASRC7_NEW_CON14              (0x4e38)
#define AFE_GASRC8_NEW_CON0               (0x4e40)
#define AFE_GASRC8_NEW_CON1               (0x4e44)
#define AFE_GASRC8_NEW_CON2               (0x4e48)
#define AFE_GASRC8_NEW_CON3               (0x4e4c)
#define AFE_GASRC8_NEW_CON4               (0x4e50)
#define AFE_GASRC8_NEW_CON5               (0x4e54)
#define AFE_GASRC8_NEW_CON6               (0x4e58)
#define AFE_GASRC8_NEW_CON7               (0x4e5c)
#define AFE_GASRC8_NEW_CON8               (0x4e60)
#define AFE_GASRC8_NEW_CON9               (0x4e64)
#define AFE_GASRC8_NEW_CON10              (0x4e68)
#define AFE_GASRC8_NEW_CON11              (0x4e6c)
#define AFE_GASRC8_NEW_CON12              (0x4e70)
#define AFE_GASRC8_NEW_CON13              (0x4e74)
#define AFE_GASRC8_NEW_CON14              (0x4e78)
#define AFE_GASRC9_NEW_CON0               (0x4e80)
#define AFE_GASRC9_NEW_CON1               (0x4e84)
#define AFE_GASRC9_NEW_CON2               (0x4e88)
#define AFE_GASRC9_NEW_CON3               (0x4e8c)
#define AFE_GASRC9_NEW_CON4               (0x4e90)
#define AFE_GASRC9_NEW_CON5               (0x4e94)
#define AFE_GASRC9_NEW_CON6               (0x4e98)
#define AFE_GASRC9_NEW_CON7               (0x4e9c)
#define AFE_GASRC9_NEW_CON8               (0x4ea0)
#define AFE_GASRC9_NEW_CON9               (0x4ea4)
#define AFE_GASRC9_NEW_CON10              (0x4ea8)
#define AFE_GASRC9_NEW_CON11              (0x4eac)
#define AFE_GASRC9_NEW_CON12              (0x4eb0)
#define AFE_GASRC9_NEW_CON13              (0x4eb4)
#define AFE_GASRC9_NEW_CON14              (0x4eb8)
#define AFE_GASRC10_NEW_CON0              (0x4ec0)
#define AFE_GASRC10_NEW_CON1              (0x4ec4)
#define AFE_GASRC10_NEW_CON2              (0x4ec8)
#define AFE_GASRC10_NEW_CON3              (0x4ecc)
#define AFE_GASRC10_NEW_CON4              (0x4ed0)
#define AFE_GASRC10_NEW_CON5              (0x4ed4)
#define AFE_GASRC10_NEW_CON6              (0x4ed8)
#define AFE_GASRC10_NEW_CON7              (0x4edc)
#define AFE_GASRC10_NEW_CON8              (0x4ee0)
#define AFE_GASRC10_NEW_CON9              (0x4ee4)
#define AFE_GASRC10_NEW_CON10             (0x4ee8)
#define AFE_GASRC10_NEW_CON11             (0x4eec)
#define AFE_GASRC10_NEW_CON12             (0x4ef0)
#define AFE_GASRC10_NEW_CON13             (0x4ef4)
#define AFE_GASRC10_NEW_CON14             (0x4ef8)
#define AFE_GASRC11_NEW_CON0              (0x4f00)
#define AFE_GASRC11_NEW_CON1              (0x4f04)
#define AFE_GASRC11_NEW_CON2              (0x4f08)
#define AFE_GASRC11_NEW_CON3              (0x4f0c)
#define AFE_GASRC11_NEW_CON4              (0x4f10)
#define AFE_GASRC11_NEW_CON5              (0x4f14)
#define AFE_GASRC11_NEW_CON6              (0x4f18)
#define AFE_GASRC11_NEW_CON7              (0x4f1c)
#define AFE_GASRC11_NEW_CON8              (0x4f20)
#define AFE_GASRC11_NEW_CON9              (0x4f24)
#define AFE_GASRC11_NEW_CON10             (0x4f28)
#define AFE_GASRC11_NEW_CON11             (0x4f2c)
#define AFE_GASRC11_NEW_CON12             (0x4f30)
#define AFE_GASRC11_NEW_CON13             (0x4f34)
#define AFE_GASRC11_NEW_CON14             (0x4f38)

#define AFE_IEC_BURST_INFO_MON            (0x64b0)
#define AFE_SPDIFOUT_IP_VERSION           (0x64b4)
#define AFE_SPDIF_OUT_CFG0                (0x64b8)
#define AFE_SPDIF_OUT_CFG1                (0x64bc)
#define AFE_SPDIF_OUT_CHSTS1              (0x64c0)
#define AFE_SPDIF_OUT_CHSTS2              (0x64c4)
#define AFE_SPDIF_OUT_CHSTS3              (0x64c8)
#define AFE_SPDIF_OUT_CHSTS4              (0x64cc)
#define AFE_SPDIF_OUT_CHSTS5              (0x64d0)
#define AFE_SPDIF_OUT_CHSTS6              (0x64d4)
#define AFE_SPDIF_OUT_USERCODE1           (0x64d8)
#define AFE_SPDIF_OUT_USERCODE2           (0x64dc)
#define AFE_SPDIF_OUT_USERCODE3           (0x64e0)
#define AFE_SPDIF_OUT_USERCODE4           (0x64e4)
#define AFE_SPDIF_OUT_USERCODE5           (0x64e8)
#define AFE_SPDIF_OUT_USERCODE6           (0x64ec)
#define AFE_SPDIF_OUT_BURST_PRE0          (0x64f0)
#define AFE_SPDIF_OUT_BURST_PRE1          (0x64f4)
#define AFE_SPDIF_OUT_MON0                (0x64f8)
#define AFE_SPDIF_OUT_MON1                (0x64fc)
#define AFE_SPDIF_OUT_MON2                (0x6500)
#define AFE_SPDIF_OUT_MON3                (0x6504)
#define AFE_SPDIF_OUT_MON4                (0x6508)
#define AFE_SPDIF_OUT_MON5                (0x650c)
#define AFE_CONN0_6                       (0x7000)
#define AFE_CONN1_6                       (0x7004)
#define AFE_CONN2_6                       (0x7008)
#define AFE_CONN3_6                       (0x700c)
#define AFE_CONN4_6                       (0x7010)
#define AFE_CONN5_6                       (0x7014)
#define AFE_CONN6_6                       (0x7018)
#define AFE_CONN7_6                       (0x701c)
#define AFE_CONN8_6                       (0x7020)
#define AFE_CONN9_6                       (0x7024)
#define AFE_CONN10_6                      (0x7028)
#define AFE_CONN11_6                      (0x702c)
#define AFE_CONN12_6                      (0x7030)
#define AFE_CONN13_6                      (0x7034)
#define AFE_CONN14_6                      (0x7038)
#define AFE_CONN15_6                      (0x703c)
#define AFE_CONN16_6                      (0x7040)
#define AFE_CONN17_6                      (0x7044)
#define AFE_CONN18_6                      (0x7048)
#define AFE_CONN19_6                      (0x704c)
#define AFE_CONN20_6                      (0x7050)
#define AFE_CONN21_6                      (0x7054)
#define AFE_CONN22_6                      (0x7058)
#define AFE_CONN23_6                      (0x705c)
#define AFE_CONN24_6                      (0x7060)
#define AFE_CONN25_6                      (0x7064)
#define AFE_CONN26_6                      (0x7068)
#define AFE_CONN27_6                      (0x706c)
#define AFE_CONN28_6                      (0x7070)
#define AFE_CONN29_6                      (0x7074)
#define AFE_CONN30_6                      (0x7078)
#define AFE_CONN31_6                      (0x707c)
#define AFE_CONN32_6                      (0x7080)
#define AFE_CONN33_6                      (0x7084)
#define AFE_CONN34_6                      (0x7088)
#define AFE_CONN35_6                      (0x708c)
#define AFE_CONN36_6                      (0x7090)
#define AFE_CONN37_6                      (0x7094)
#define AFE_CONN38_6                      (0x7098)
#define AFE_CONN39_6                      (0x709c)
#define AFE_CONN40_6                      (0x70a0)
#define AFE_CONN41_6                      (0x70a4)
#define AFE_CONN42_6                      (0x70a8)
#define AFE_CONN43_6                      (0x70ac)
#define AFE_CONN44_6                      (0x70b0)
#define AFE_CONN45_6                      (0x70b4)
#define AFE_CONN46_6                      (0x70b8)
#define AFE_CONN47_6                      (0x70bc)
#define AFE_CONN48_6                      (0x70c0)
#define AFE_CONN49_6                      (0x70c4)
#define AFE_CONN50_6                      (0x70c8)
#define AFE_CONN51_6                      (0x70cc)
#define AFE_CONN52_6                      (0x70d0)
#define AFE_CONN53_6                      (0x70d4)
#define AFE_CONN54_6                      (0x70d8)
#define AFE_CONN55_6                      (0x70dc)
#define AFE_CONN56_6                      (0x70e0)
#define AFE_CONN57_6                      (0x70e4)
#define AFE_CONN58_6                      (0x70e8)
#define AFE_CONN59_6                      (0x70ec)
#define AFE_CONN60_6                      (0x70f0)
#define AFE_CONN61_6                      (0x70f4)
#define AFE_CONN62_6                      (0x70f8)
#define AFE_CONN63_6                      (0x70fc)
#define AFE_CONN64_6                      (0x7100)
#define AFE_CONN65_6                      (0x7104)
#define AFE_CONN66_6                      (0x7108)
#define AFE_CONN67_6                      (0x710c)
#define AFE_CONN68_6                      (0x7110)
#define AFE_CONN69_6                      (0x7114)
#define AFE_CONN70_6                      (0x7118)
#define AFE_CONN71_6                      (0x711c)
#define AFE_CONN72_6                      (0x7120)
#define AFE_CONN73_6                      (0x7124)
#define AFE_CONN74_6                      (0x7128)
#define AFE_CONN75_6                      (0x712c)
#define AFE_CONN76_6                      (0x7130)
#define AFE_CONN77_6                      (0x7134)
#define AFE_CONN78_6                      (0x7138)
#define AFE_CONN79_6                      (0x713c)
#define AFE_CONN80_6                      (0x7140)
#define AFE_CONN81_6                      (0x7144)
#define AFE_CONN82_6                      (0x7148)
#define AFE_CONN83_6                      (0x714c)
#define AFE_CONN84_6                      (0x7150)
#define AFE_CONN85_6                      (0x7154)
#define AFE_CONN86_6                      (0x7158)
#define AFE_CONN87_6                      (0x715c)
#define AFE_CONN88_6                      (0x7160)
#define AFE_CONN89_6                      (0x7164)
#define AFE_CONN90_6                      (0x7168)
#define AFE_CONN91_6                      (0x716c)
#define AFE_CONN92_6                      (0x7170)
#define AFE_CONN93_6                      (0x7174)
#define AFE_CONN94_6                      (0x7178)
#define AFE_CONN95_6                      (0x717c)
#define AFE_CONN96_6                      (0x7180)
#define AFE_CONN97_6                      (0x7184)
#define AFE_CONN98_6                      (0x7188)
#define AFE_CONN99_6                      (0x718c)
#define AFE_CONN100_6                     (0x7190)
#define AFE_CONN101_6                     (0x7194)
#define AFE_CONN102_6                     (0x7198)
#define AFE_CONN103_6                     (0x719c)
#define AFE_CONN104_6                     (0x71a0)
#define AFE_CONN105_6                     (0x71a4)
#define AFE_CONN106_6                     (0x71a8)
#define AFE_CONN107_6                     (0x71ac)
#define AFE_CONN108_6                     (0x71b0)
#define AFE_CONN109_6                     (0x71b4)
#define AFE_CONN110_6                     (0x71b8)
#define AFE_CONN111_6                     (0x71bc)
#define AFE_CONN112_6                     (0x71c0)
#define AFE_CONN113_6                     (0x71c4)
#define AFE_CONN114_6                     (0x71c8)
#define AFE_CONN115_6                     (0x71cc)
#define AFE_CONN116_6                     (0x71d0)
#define AFE_CONN117_6                     (0x71d4)
#define AFE_CONN118_6                     (0x71d8)
#define AFE_CONN119_6                     (0x71dc)
#define AFE_CONN120_6                     (0x71e0)
#define AFE_CONN121_6                     (0x71e4)
#define AFE_CONN122_6                     (0x71e8)
#define AFE_CONN123_6                     (0x71ec)
#define AFE_CONN124_6                     (0x71f0)
#define AFE_CONN125_6                     (0x71f4)
#define AFE_CONN126_6                     (0x71f8)
#define AFE_CONN127_6                     (0x71fc)
#define AFE_CONN128_6                     (0x7200)
#define AFE_CONN129_6                     (0x7204)
#define AFE_CONN130_6                     (0x7208)
#define AFE_CONN131_6                     (0x720c)
#define AFE_CONN132_6                     (0x7210)
#define AFE_CONN133_6                     (0x7214)
#define AFE_CONN134_6                     (0x7218)
#define AFE_CONN135_6                     (0x721c)
#define AFE_CONN136_6                     (0x7220)
#define AFE_CONN137_6                     (0x7224)
#define AFE_CONN138_6                     (0x7228)
#define AFE_CONN139_6                     (0x722c)
#define AFE_CONN176_6                     (0x72c0)
#define AFE_CONN177_6                     (0x72c4)
#define AFE_CONN182_6                     (0x72d8)
#define AFE_CONN183_6                     (0x72dc)

#define AFE_MAX_REGISTER                  (AFE_CONN183_6)

/* PWR1_ASM_CON1 */
#define PWR1_ASM_CON1_GASRC0_CALI_CK_SEL_MASK   BIT(2)
#define PWR1_ASM_CON1_GASRC1_CALI_CK_SEL_MASK   BIT(5)
#define PWR1_ASM_CON1_GASRC2_CALI_CK_SEL_MASK   BIT(20)
#define PWR1_ASM_CON1_GASRC3_CALI_CK_SEL_MASK   BIT(23)

/* PWR1_ASM_CON2 */
#define PWR1_ASM_CON2_GASRC4_CALI_CK_SEL_MASK   BIT(2)
#define PWR1_ASM_CON2_GASRC5_CALI_CK_SEL_MASK   BIT(7)
#define PWR1_ASM_CON2_GASRC6_CALI_CK_SEL_MASK   BIT(12)
#define PWR1_ASM_CON2_GASRC7_CALI_CK_SEL_MASK   BIT(17)
#define PWR1_ASM_CON2_GASRC8_CALI_CK_SEL_MASK   BIT(22)
#define PWR1_ASM_CON2_GASRC9_CALI_CK_SEL_MASK   BIT(27)

/* PWR1_ASM_CON3 */
#define PWR1_ASM_CON3_GASRC10_CALI_CK_SEL_MASK   BIT(2)
#define PWR1_ASM_CON3_GASRC11_CALI_CK_SEL_MASK   BIT(7)

/* AUDIO_TOP_CON0 */
#define AUDIO_TOP_CON0_PDN_AFE            BIT(2)
#define AUDIO_TOP_CON0_PDN_APLL           BIT(23)
#define AUDIO_TOP_CON0_PDN_APLL_TUNER     BIT(19)
#define AUDIO_TOP_CON0_PDN_APLL2          BIT(24)
#define AUDIO_TOP_CON0_PDN_APLL2_TUNER    BIT(20)
#define AUDIO_TOP_CON0_PDN_DAC            BIT(25)
#define AUDIO_TOP_CON0_PDN_DAC_HIRES      BIT(31)
#define AUDIO_TOP_CON0_PDN_DAC_PREDIS     BIT(26)
#define AUDIO_TOP_CON0_PDN_SPDIFIN_TUNER  BIT(10)
#define AUDIO_TOP_CON0_PDN_ADC            BIT(28)
#define AUDIO_TOP_CON0_PDN_SPDF           BIT(21)
#define AUDIO_TOP_CON0_PDN_TML            BIT(27)
#define AUDIO_TOP_CON0_PDN_UL_TML         BIT(18)

/* AUDIO_TOP_CON1 */
#define AUDIO_TOP_CON1_PDN_ADC_HIRES      BIT(17)
#define AUDIO_TOP_CON1_PDN_ADDA6_ADC      BIT(18)
#define AUDIO_TOP_CON1_PDN_ADDA6_HIRES    BIT(19)
#define AUDIO_TOP_CON1_PDN_UL_TML_HIRES   BIT(16)
#define AUDIO_TOP_CON1_PDN_DMIC_TML       BIT(14)
#define AUDIO_TOP_CON1_PDN_A1SYS_HOPING   BIT(2)
#define AUDIO_TOP_CON1_PDN_DMIC0          BIT(10)
#define AUDIO_TOP_CON1_PDN_DMIC1          BIT(11)
#define AUDIO_TOP_CON1_PDN_DMIC2          BIT(12)
#define AUDIO_TOP_CON1_PDN_DMIC3          BIT(13)

/* AUDIO_TOP_CON3 */
#define AUDIO_TOP_CON3_PDN_EARC_TUNER     BIT(7)
#define AUDIO_TOP_CON3_PDN_LINEIN_TUNER   BIT(5)

/* AUDIO_TOP_CON4 */
#define AUDIO_TOP_CON4_PDN_I2S_IN          BIT(0)
#define AUDIO_TOP_CON4_PDN_TDM_IN          BIT(1)
#define AUDIO_TOP_CON4_PDN_I2S_OUT         BIT(6)
#define AUDIO_TOP_CON4_PDN_TDM_OUT         BIT(7)
#define AUDIO_TOP_CON4_PDN_HDMI_OUT        BIT(8)
#define AUDIO_TOP_CON4_PDN_ASRC11          BIT(16)
#define AUDIO_TOP_CON4_PDN_ASRC12          BIT(17)
#define AUDIO_TOP_CON4_PDN_A1SYS           BIT(21)
#define AUDIO_TOP_CON4_PDN_A2SYS           BIT(22)
#define AUDIO_TOP_CON4_PDN_A3SYS           BIT(30)
#define AUDIO_TOP_CON4_PDN_A4SYS           BIT(31)
#define AUDIO_TOP_CON4_PDN_PCMIF           BIT(24)
#define AUDIO_TOP_CON4_PDN_INTDIR          BIT(20)
#define AUDIO_TOP_CON4_PDN_MULTI_IN        BIT(19)

/* AUDIO_TOP_CON6 */
#define AUDIO_TOP_CON6_PDN_GASRC11         BIT(11)
#define AUDIO_TOP_CON6_PDN_GASRC10         BIT(10)
#define AUDIO_TOP_CON6_PDN_GASRC9          BIT(9)
#define AUDIO_TOP_CON6_PDN_GASRC8          BIT(8)
#define AUDIO_TOP_CON6_PDN_GASRC7          BIT(7)
#define AUDIO_TOP_CON6_PDN_GASRC6          BIT(6)
#define AUDIO_TOP_CON6_PDN_GASRC5          BIT(5)
#define AUDIO_TOP_CON6_PDN_GASRC4          BIT(4)
#define AUDIO_TOP_CON6_PDN_GASRC3          BIT(3)
#define AUDIO_TOP_CON6_PDN_GASRC2          BIT(2)
#define AUDIO_TOP_CON6_PDN_GASRC1          BIT(1)
#define AUDIO_TOP_CON6_PDN_GASRC0          BIT(0)

/* AFE_GAINx_CON0 */
#define AFE_GAIN_CON0_SAMPLE_PER_STEP_MASK  GENMASK(15, 8)
#define AFE_GAIN_CON0_GAIN_MODE_MASK        GENMASK(7, 3)
#define AFE_GAIN_CON0_GAIN_ON_MASK          BIT(0)

/* AFE_GAINx_CON1 */
#define AFE_GAIN_CON1_TARGET_MASK           GENMASK(19, 0)

/* AFE_GAINx_CON2 */
#define AFE_GAIN_CON2_DOWN_STEP_MASK        GENMASK(19, 0)

/* AFE_GAINx_CON3 */
#define AFE_GAIN_CON3_UP_STEP_MASK          GENMASK(19, 0)

/* AFE_GAINx_CUR */
#define AFE_GAIN_CUR_GAIN_MASK              GENMASK(19, 0)

/* ASYS_TOP_CON */
#define ASYS_TOP_CON_A1SYS_TIMING_ON       BIT(0)
#define ASYS_TOP_CON_A2SYS_TIMING_ON       BIT(1)
#define ASYS_TOP_CON_A3SYS_TIMING_ON       BIT(4)
#define ASYS_TOP_CON_A4SYS_TIMING_ON       BIT(5)
#define ASYS_TOP_CON_26M_TIMING_ON         BIT(2)

/* PWR2_TOP_CON0 */
#define PWR2_TOP_CON_DMIC8_SRC_SEL_MASK     GENMASK(31, 29)
#define PWR2_TOP_CON_DMIC7_SRC_SEL_MASK     GENMASK(28, 26)
#define PWR2_TOP_CON_DMIC6_SRC_SEL_MASK     GENMASK(25, 23)
#define PWR2_TOP_CON_DMIC5_SRC_SEL_MASK     GENMASK(22, 20)
#define PWR2_TOP_CON_DMIC4_SRC_SEL_MASK     GENMASK(19, 17)
#define PWR2_TOP_CON_DMIC3_SRC_SEL_MASK     GENMASK(16, 14)
#define PWR2_TOP_CON_DMIC2_SRC_SEL_MASK     GENMASK(13, 11)
#define PWR2_TOP_CON_DMIC1_SRC_SEL_MASK     GENMASK(10, 8)
#define PWR2_TOP_CON_DMIC8_SRC_SEL_VAL(x)   ((x) << 29)
#define PWR2_TOP_CON_DMIC7_SRC_SEL_VAL(x)   ((x) << 26)
#define PWR2_TOP_CON_DMIC6_SRC_SEL_VAL(x)   ((x) << 23)
#define PWR2_TOP_CON_DMIC5_SRC_SEL_VAL(x)   ((x) << 20)
#define PWR2_TOP_CON_DMIC4_SRC_SEL_VAL(x)   ((x) << 17)
#define PWR2_TOP_CON_DMIC3_SRC_SEL_VAL(x)   ((x) << 14)
#define PWR2_TOP_CON_DMIC2_SRC_SEL_VAL(x)   ((x) << 11)
#define PWR2_TOP_CON_DMIC1_SRC_SEL_VAL(x)   ((x) << 8)

/* PWR2_TOP_CON1 */
#define PWR2_TOP_CON1_DMIC_FIFO_SOFT_RST_EN(x)	BIT(5 + 6 * (x))
#define PWR2_TOP_CON1_DMIC_CKDIV_ON             BIT(1)
#define PWR2_TOP_CON1_DMIC_CKDIV_ON_SHIFT       1


/* PCM_INTF_CON1 */
#define PCM_INTF_CON1_SYNC_OUT_INV     BIT(23)
#define PCM_INTF_CON1_BCLK_OUT_INV     BIT(22)
#define PCM_INTF_CON1_CLK_OUT_INV_MASK GENMASK(23, 22)
#define PCM_INTF_CON1_SYNC_IN_INV      BIT(21)
#define PCM_INTF_CON1_BCLK_IN_INV      BIT(20)
#define PCM_INTF_CON1_CLK_IN_INV_MASK  GENMASK(21, 20)
#define PCM_INTF_CON1_PCM_24BIT        BIT(16)
#define PCM_INTF_CON1_PCM_16BIT        (0 << 16)
#define PCM_INTF_CON1_PCM_BIT_MASK     BIT(16)
#define PCM_INTF_CON1_PCM_WLEN_32BCK   (0 << 14)
#define PCM_INTF_CON1_PCM_WLEN_64BCK   BIT(14)
#define PCM_INTF_CON1_PCM_WLEN_MASK    BIT(14)
#define PCM_INTF_CON1_SYNC_LENGTH_MASK GENMASK(13, 9)
#define PCM_INTF_CON1_PCM_SLAVE        BIT(5)
#define PCM_INTF_CON1_PCM_MASTER       (0 << 5)
#define PCM_INTF_CON1_PCM_M_S_MASK     BIT(5)
#define PCM_INTF_CON1_PCM_MODE_MASK    GENMASK(4, 3)
#define PCM_INTF_CON1_PCM_FMT_MASK     GENMASK(2, 1)
#define PCM_INTF_CON1_PCM_EN           BIT(0)

/* PCM_INTF_CON2 */
#define PCM_INTF_CON2_CLK_DOMAIN_SEL_MASK GENMASK(24, 23)
#define PCM_INTF_CON2_SYNC_FREQ_MODE_MASK GENMASK(16, 12)
#define PCM_INTF_CON2_PCM_TX2RX_LPBK      BIT(8)

/* AFE_MPHONE_MULTIx_CON0 */
#define AFE_MPHONE_MULTI_CON0_16BIT_SWAP       BIT(3)
#define AFE_MPHONE_MULTI_CON0_16BIT_SWAP_MASK  BIT(3)
#define AFE_MPHONE_MULTI_CON0_24BIT_DATA       (0x1 << 1)
#define AFE_MPHONE_MULTI_CON0_16BIT_DATA       (0x0 << 1)
#define AFE_MPHONE_MULIT_CON0_24BIT_DATA_MASK  BIT(1)
#define AFE_MPHONE_MULTI_CON0_EN               BIT(0)

/* AFE_MPHONE_MULTIx_CON1 */
#define AFE_MPHONE_MULTI_CON1_SYNC_ON                BIT(24)
#define AFE_MPHONE_MULTI_CON1_24BIT_SWAP_BYPASS      BIT(22)
#define AFE_MPHONE_MULTI_CON1_NON_COMPACT_MODE       (0x1 << 19)
#define AFE_MPHONE_MULTI_CON1_COMPACT_MODE           (0x0 << 19)
#define AFE_MPHONE_MULTI_CON1_NON_COMPACT_MODE_MASK  BIT(19)
#define AFE_MPHONE_MULTI_CON1_HBR_MODE               BIT(18)
#define AFE_MPHONE_MULTI_CON1_LRCK_32_CYCLE          (0x2 << 16)
#define AFE_MPHONE_MULTI_CON1_LRCK_24_CYCLE          (0x1 << 16)
#define AFE_MPHONE_MULTI_CON1_LRCK_16_CYCLE          (0x0 << 16)
#define AFE_MPHONE_MULTI_CON1_LRCK_CYCLE_SEL_MASK    GENMASK(17, 16)
#define AFE_MPHONE_MULTI_CON1_LRCK_INV               BIT(15)
#define AFE_MPHONE_MULTI_CON1_DELAY_DATA             BIT(14)
#define AFE_MPHONE_MULTI_CON1_LEFT_ALIGN             BIT(13)
#define AFE_MPHONE_MULTI_CON1_BIT_NUM_MASK           GENMASK(12, 8)
#define AFE_MPHONE_MULTI_CON1_BCK_INV                BIT(6)
#define AFE_MPHONE_MULTI_CON1_CH_NUM_MASK            GENMASK(1, 0)

/* AFE_MPHONE_MULTIx_CON2 */
#define AFE_MPHONE_MULTI_CON2_SEL_SPDIFIN        BIT(19)
/* AFE_AUD_PAD_TOP */
#define RG_RX_PROTOCOL2			BIT(3)
#define RG_RX_FIFO_ON			BIT(0)

/* AFE_ADDA_MTKAIF_CFG0 */
#define MTKAIF_RXIF_CLKINV_ADC		BIT(31)
#define MTKAIF_RXIF_PROTOCOL2		BIT(16)
#define MTKAIF_TXIF_PROTOCOL2		BIT(4)
#define MTKAIF_TXIF_8TO5		BIT(2)
#define MTKAIF_RXIF_8TO5		BIT(1)
#define MTKAIF_IF_LOOPBACK1		BIT(0)

/* AFE_ADDA_MTKAIF_RX_CFG2 */
#define MTKAIF_RXIF_DELAY_CYCLE_MASK	GENMASK(15, 12)
#define MTKAIF_RXIF_DELAY_DATA		BIT(8)

/* AFE_ADDA_MTKAIF_SYNCWORD_CFG */
#define ADDA6_MTKAIF_RX_SYNC_WORD2_DISABLE	BIT(23)

/* AFE_DMICx_UL_SRC_CON0 */
#define AFE_DMIC_UL_SRC_CON0_UL_PHASE_SEL_CH1(x)	(((x) & 0x7) << 27)
#define AFE_DMIC_UL_SRC_CON0_UL_PHASE_SEL_CH2(x)	(((x) & 0x7) << 24)
#define AFE_DMIC_UL_SRC_CON0_UL_PHASE_SEL_MASK		GENMASK(29, 24)
#define AFE_DMIC_UL_SRC_CON0_UL_TWO_WIRE_MODE_CTL	BIT(23)
#define AFE_DMIC_UL_SRC_CON0_UL_MODE_3P25M_CH2_CTL	BIT(22)
#define AFE_DMIC_UL_SRC_CON0_UL_MODE_3P25M_CH1_CTL	BIT(21)
#define AFE_DMIC_UL_VOICE_MODE(x)			(((x) & GENMASK(2, 0)) << 17)
#define AFE_DMIC_UL_VOICE_MODE_MASK			GENMASK(19, 17)
#define AFE_DMIC_UL_CON0_VOCIE_MODE_8K			AFE_DMIC_UL_VOICE_MODE(0)
#define AFE_DMIC_UL_CON0_VOCIE_MODE_16K			AFE_DMIC_UL_VOICE_MODE(1)
#define AFE_DMIC_UL_CON0_VOCIE_MODE_32K			AFE_DMIC_UL_VOICE_MODE(2)
#define AFE_DMIC_UL_CON0_VOCIE_MODE_48K			AFE_DMIC_UL_VOICE_MODE(3)
#define AFE_DMIC_UL_CON0_VOCIE_MODE_96K			AFE_DMIC_UL_VOICE_MODE(4)
#define AFE_DMIC_UL_SRC_CON0_UL_IIR_MODE_CTL(x)		(((x) & GENMASK(2, 0)) << 7)
#define AFE_DMIC_UL_SRC_CON0_UL_IIR_MODE_CTL_MASK	GENMASK(9, 7)
#define AFE_DMIC_UL_SRC_CON0_UL_IIR_ON_TMP_CTL		BIT(10)
#define AFE_DMIC_UL_SRC_CON0_UL_SDM_3_LEVEL_CTL		BIT(1)
#define AFE_DMIC_UL_SRC_CON0_UL_SRC_ON_TMP_CTL		BIT(0)

/* DMIC_BYPASS_HW_GAIN */
#define DMIC_BYPASS_HW_GAIN4_ONE_HEART		BIT(10)
#define DMIC_BYPASS_HW_GAIN3_ONE_HEART		BIT(9)
#define DMIC_BYPASS_HW_GAIN2_ONE_HEART		BIT(8)
#define DMIC_BYPASS_HW_GAIN_DMIC4_BYPASS	BIT(4)
#define DMIC_BYPASS_HW_GAIN_DMIC3_BYPASS	BIT(3)
#define DMIC_BYPASS_HW_GAIN_DMIC2_BYPASS	BIT(2)
#define DMIC_BYPASS_HW_GAIN_DMIC1_BYPASS	BIT(1)

/* DMIC_GAINx_CON0 */
#define DMIC_GAIN_CON0_GAIN_ON			BIT(0)
#define DMIC_GAIN_CON0_SAMPLE_PER_STEP_SHIFT	8
#define DMIC_GAIN_CON0_SAMPLE_PER_STEP_MASK	GENMASK(15, 8)

/* DMIC_GAINx_CON1 */
#define DMIC_GAIN_CON1_TARGET_MASK	GENMASK(27, 0)

/* DMIC_GAINx_CON2 */
#define DMIC_GAIN_CON2_DOWN_STEP	GENMASK(19, 0)

/* DMIC_GAINx_CON3 */
#define DMIC_GAIN_CON3_UP_STEP		GENMASK(19, 0)

/* DMIC_GAINx_CUR */
#define DMIC_GAIN_CUR_GAIN_MASK		GENMASK(27, 0)

/* ETDM_INx_AFIFO_CON */
#define ETDM_IN_USE_AFIFO		BIT(8)
#define ETDM_IN_AFIFO_CLOCK_MASK	GENMASK(7, 5)
#define ETDM_IN_AFIFO_MODE_MASK		GENMASK(4, 0)

/* ETDM_COWORK_CON0 */
#define ETDM_OUT1_SLAVE_SEL_MASK	GENMASK(23, 20)
#define ETDM_OUT1_SLAVE_SEL_SHIFT	20
#define ETDM_OUT1_SYNC_SEL_MASK		GENMASK(19, 16)
#define ETDM_OUT1_SYNC_SEL_SHIFT	16

/* ETDM_COWORK_CON1 */
#define ETDM_IN1_SDATA_SEL_MASK		GENMASK(23, 20)
#define ETDM_IN1_SDATA_SEL_SHIFT	20
#define ETDM_IN1_SDATA0_SEL_MASK	GENMASK(19, 16)
#define ETDM_IN1_SDATA0_SEL_SHIFT	16
#define ETDM_IN1_SYNC_SEL_MASK		GENMASK(15, 12)
#define ETDM_IN1_SYNC_SEL_SHIFT		12
#define ETDM_IN1_SLAVE_SEL_MASK		GENMASK(11, 8)
#define ETDM_IN1_SLAVE_SEL_SHIFT	8

/* ETDM_COWORK_CON2 */
#define ETDM_IN2_SYNC_SEL_MASK		GENMASK(31, 28)
#define ETDM_IN2_SYNC_SEL_SHIFT		28
#define ETDM_IN2_SLAVE_SEL_MASK		GENMASK(27, 24)
#define ETDM_IN2_SLAVE_SEL_SHIFT	24
#define ETDM_OUT3_SLAVE_SEL_MASK	GENMASK(23, 20)
#define ETDM_OUT3_SLAVE_SEL_SHIFT	20
#define ETDM_OUT3_SYNC_SEL_MASK		GENMASK(19, 16)
#define ETDM_OUT3_SYNC_SEL_SHIFT	16
#define ETDM_OUT2_SLAVE_SEL_MASK	GENMASK(11, 8)
#define ETDM_OUT2_SLAVE_SEL_SHIFT	8
#define ETDM_OUT2_SYNC_SEL_MASK		GENMASK(7, 4)
#define ETDM_OUT2_SYNC_SEL_SHIFT	4

/* ETDM_COWORK_CON3 */
#define ETDM_IN2_SDATA_SEL_MASK		GENMASK(7, 4)
#define ETDM_IN2_SDATA_SEL_SHIFT	4
#define ETDM_IN2_SDATA0_SEL_MASK	GENMASK(3, 0)
#define ETDM_IN2_SDATA0_SEL_SHIFT	0

/* ETDM_x_CONx */
#define ETDM_CON0_CH_NUM_MASK		GENMASK(27, 23)
#define ETDM_CON0_WORD_LEN_MASK		GENMASK(20, 16)
#define ETDM_CON0_BIT_LEN_MASK		GENMASK(15, 11)
#define ETDM_CON0_FORMAT_MASK		GENMASK(8, 6)
#define ETDM_CON0_SLAVE_MODE		BIT(5)
#define ETDM_CON0_SYNC_MODE		BIT(1)
#define ETDM_CON0_EN			BIT(0)
#define ETDM_CON0_EN_SHIFT		0

#define ETDM_OUT_CON0_RELATCH_DOMAIN_MASK	GENMASK(29, 28)

#define ETDM_CON1_MCLK_OUTPUT			BIT(16)

#define ETDM_IN_CON1_LRCK_AUTO_MODE		BIT(31)
#define ETDM_IN_CON1_LRCK_WIDTH_MASK		GENMASK(29, 20)

#define ETDM_OUT_CON1_LRCK_AUTO_MODE		BIT(29)
#define ETDM_OUT_CON1_LRCK_WIDTH_MASK		GENMASK(28, 19)

#define ETDM_IN_CON2_MULTI_IP_2CH_MODE		BIT(31)
#define ETDM_IN_CON2_MULTI_IP_TOTAL_CH_MASK	GENMASK(19, 15)
#define ETDM_IN_CON2_CLOCK_MASK			GENMASK(12, 10)
#define ETDM_IN_CON2_CLOCK_SHIFT		10
#define ETDM_IN_CON2_UPDATE_GAP_MASK		GENMASK(9, 5)

#define ETDM_OUT_CON2_LRCK_DELAY_BCK_INV	BIT(30)
#define ETDM_OUT_CON2_LRCK_DELAY_0P5T_EN	BIT(29)

#define ETDM_IN_CON3_FS_MASK			GENMASK(30, 26)
#define ETDM_IN_CON3_DISABLE_OUT(x)		BIT(((x) & 0xffff))
#define ETDM_IN_CON3_DISABLE_OUT_MASK		GENMASK(15, 0)

#define ETDM_IN_CON4_MASTER_LRCK_INV		BIT(19)
#define ETDM_IN_CON4_MASTER_BCK_INV		BIT(18)
#define ETDM_IN_CON4_SLAVE_LRCK_INV		BIT(17)
#define ETDM_IN_CON4_SLAVE_BCK_INV		BIT(16)

#define ETDM_OUT_CON4_RELATCH_EN_MASK		GENMASK(28, 24)
#define ETDM_OUT_CON4_CLOCK_MASK		GENMASK(8, 6)
#define ETDM_OUT_CON4_CLOCK_SHIFT		6
#define ETDM_OUT_CON4_FS_MASK			GENMASK(4, 0)

#define ETDM_IN_CON5_LR_SWAP(x)			BIT(((x) & 0xffff) + 16)
#define ETDM_IN_CON5_LR_SWAP_MASK		GENMASK(31, 16)
#define ETDM_IN_CON5_ENABLE_ODD(x)		BIT(((x) & 0xffff))
#define ETDM_IN_CON5_ENABLE_ODD_MASK		GENMASK(15, 0)

#define ETDM_OUT_CON5_MASTER_LRCK_INV		BIT(10)
#define ETDM_OUT_CON5_MASTER_BCK_INV		BIT(9)
#define ETDM_OUT_CON5_SLAVE_LRCK_INV		BIT(8)
#define ETDM_OUT_CON5_SLAVE_BCK_INV		BIT(7)

/* GASRC_TIMING_CON0 */
#define GASRC_TIMING_CON0_GASRC0_IN_MODE_MASK   GENMASK(4, 0)
#define GASRC_TIMING_CON0_GASRC1_IN_MODE_MASK   GENMASK(9, 5)
#define GASRC_TIMING_CON0_GASRC2_IN_MODE_MASK   GENMASK(14, 10)
#define GASRC_TIMING_CON0_GASRC3_IN_MODE_MASK   GENMASK(19, 15)
#define GASRC_TIMING_CON0_GASRC4_IN_MODE_MASK   GENMASK(24, 20)
#define GASRC_TIMING_CON0_GASRC5_IN_MODE_MASK   GENMASK(29, 25)

/* GASRC_TIMING_CON1 */
#define GASRC_TIMING_CON1_GASRC6_IN_MODE_MASK   GENMASK(4, 0)
#define GASRC_TIMING_CON1_GASRC7_IN_MODE_MASK   GENMASK(9, 5)
#define GASRC_TIMING_CON1_GASRC8_IN_MODE_MASK   GENMASK(14, 10)
#define GASRC_TIMING_CON1_GASRC9_IN_MODE_MASK   GENMASK(19, 15)
#define GASRC_TIMING_CON1_GASRC10_IN_MODE_MASK  GENMASK(24, 20)
#define GASRC_TIMING_CON1_GASRC11_IN_MODE_MASK  GENMASK(29, 25)

/* GASRC_TIMING_CON2 */
#define GASRC_TIMING_CON2_GASRC12_IN_MODE_MASK  GENMASK(4, 0)
#define GASRC_TIMING_CON2_GASRC13_IN_MODE_MASK  GENMASK(9, 5)
#define GASRC_TIMING_CON2_GASRC14_IN_MODE_MASK  GENMASK(14, 10)
#define GASRC_TIMING_CON2_GASRC15_IN_MODE_MASK  GENMASK(19, 15)
#define GASRC_TIMING_CON2_GASRC16_IN_MODE_MASK  GENMASK(24, 20)
#define GASRC_TIMING_CON2_GASRC17_IN_MODE_MASK  GENMASK(29, 25)

/* GASRC_TIMING_CON3 */
#define GASRC_TIMING_CON3_GASRC18_IN_MODE_MASK  GENMASK(4, 0)
#define GASRC_TIMING_CON3_GASRC19_IN_MODE_MASK  GENMASK(9, 5)

/* GASRC_TIMING_CON4 */
#define GASRC_TIMING_CON4_GASRC0_OUT_MODE_MASK   GENMASK(4, 0)
#define GASRC_TIMING_CON4_GASRC1_OUT_MODE_MASK   GENMASK(9, 5)
#define GASRC_TIMING_CON4_GASRC2_OUT_MODE_MASK   GENMASK(14, 10)
#define GASRC_TIMING_CON4_GASRC3_OUT_MODE_MASK   GENMASK(19, 15)
#define GASRC_TIMING_CON4_GASRC4_OUT_MODE_MASK   GENMASK(24, 20)
#define GASRC_TIMING_CON4_GASRC5_OUT_MODE_MASK   GENMASK(29, 25)

/* GASRC_TIMING_CON5 */
#define GASRC_TIMING_CON5_GASRC6_OUT_MODE_MASK   GENMASK(4, 0)
#define GASRC_TIMING_CON5_GASRC7_OUT_MODE_MASK   GENMASK(9, 5)
#define GASRC_TIMING_CON5_GASRC8_OUT_MODE_MASK   GENMASK(14, 10)
#define GASRC_TIMING_CON5_GASRC9_OUT_MODE_MASK   GENMASK(19, 15)
#define GASRC_TIMING_CON5_GASRC10_OUT_MODE_MASK  GENMASK(24, 20)
#define GASRC_TIMING_CON5_GASRC11_OUT_MODE_MASK  GENMASK(29, 25)

/* AFE_DPTX_CON */
#define AFE_DPTX_CON_CH_EN_2CH		GENMASK(9, 8)
#define AFE_DPTX_CON_CH_EN_4CH		GENMASK(11, 8)
#define AFE_DPTX_CON_CH_EN_6CH		GENMASK(13, 8)
#define AFE_DPTX_CON_CH_EN_8CH		GENMASK(15, 8)
#define AFE_DPTX_CON_CH_EN_MASK		GENMASK(15, 8)
#define AFE_DPTX_CON_16BIT		(0x1 << 2)
#define AFE_DPTX_CON_24BIT		(0x0 << 2)
#define AFE_DPTX_CON_16BIT_MASK		BIT(2)
#define AFE_DPTX_CON_CH_NUM_2CH		(0x0 << 1)
#define AFE_DPTX_CON_CH_NUM_8CH		(0x1 << 1)
#define AFE_DPTX_CON_CH_NUM_MASK	BIT(1)
#define AFE_DPTX_CON_ON			BIT(0)
#define AFE_DPTX_CON_ON_SHIFT		0

/* AFE_ADDA_DL_SRC2_CON0 */
#define DL_2_INPUT_MODE_CTL_MASK	GENMASK(31, 28)
#define DL_2_CH1_SATURATION_EN_CTL	BIT(27)
#define DL_2_CH2_SATURATION_EN_CTL	BIT(26)
#define DL_2_MUTE_CH1_OFF_CTL_PRE	BIT(12)
#define DL_2_MUTE_CH2_OFF_CTL_PRE	BIT(11)
#define DL_2_VOICE_MODE_CTL_PRE		BIT(5)
#define DL_2_GAIN_ON_CTL_PRE_SHIFT	1
#define DL_2_SRC_ON_TMP_CTRL_PRE_SHIFT	0

/* AFE_ADDA_DL_SRC2_CON1 */
#define DL_2_GAIN_CTL_PRE_MASK		GENMASK(31, 16)
#define DL_2_GAIN_CTL_PRE_SHIFT		16

/* AFE_ADDA_TOP_CON0 */
#define C_LOOPBACK_MODE_CTL_MASK	GENMASK(15, 12)
#define DL_INPUT_FROM_SINEGEN		(4 << 12)

/* AFE_ADDA_UL_DL_CON0 */
#define ADDA_AFE_ON_SHIFT		0

/* AFE_ADDA_DL_SDM_DCCOMP_CON */
#define DL_USE_NEW_2ND_SDM		BIT(30)
#define ATTGAIN_CTL_MASK		GENMASK(5, 0)

/* AFE_ADDA_UL_SRC_CON0 */
#define UL_MODE_3P25M_CH2_CTL		BIT(22)
#define UL_MODE_3P25M_CH1_CTL		BIT(21)
#define UL_VOICE_MODE_CTL_MASK		GENMASK(19, 17)
#define UL_LOOPBACK_MODE_CTL		BIT(2)
#define UL_SDM3_LEVEL_CTL		BIT(1)
#define UL_SRC_ON_TMP_CTL_SHIFT		0

/* AFE_GASRCx_NEW_CON0 */
#define AFE_GASRC_NEW_CON0_ONE_HEART                BIT(31)
#define AFE_GASRC_NEW_CON0_CHSET0_CLR_IIR_HISTORY   BIT(17)
#define AFE_GASRC_NEW_CON0_CHSET0_OFS_SEL_MASK      GENMASK(15, 14)
#define AFE_GASRC_NEW_CON0_CHSET0_OFS_SEL_TX        (0 << 14)
#define AFE_GASRC_NEW_CON0_CHSET0_OFS_SEL_RX        BIT(14)
#define AFE_GASRC_NEW_CON0_CHSET0_IFS_SEL_MASK      GENMASK(13, 12)
#define AFE_GASRC_NEW_CON0_CHSET0_IFS_SEL_TX        (3 << 12)
#define AFE_GASRC_NEW_CON0_CHSET0_IFS_SEL_RX        (2 << 12)
#define AFE_GASRC_NEW_CON0_CHSET0_IIR_EN            BIT(11)
#define AFE_GASRC_NEW_CON0_CHSET0_IIR_STAGE_MASK    GENMASK(10, 8)
#define AFE_GASRC_NEW_CON0_CHSET_STR_CLR            BIT(4)
#define AFE_GASRC_NEW_CON0_COEFF_SRAM_CTRL          BIT(1)
#define AFE_GASRC_NEW_CON0_ASM_ON                   BIT(0)

/* AFE_GASRCx_NEW_CON5 */
#define AFE_GASRC_NEW_CON5_CALI_LRCK_SEL_MASK   GENMASK(3, 1)
#define AFE_GASRC_NEW_CON5_SOFT_RESET           BIT(0)

/* AFE_GASRCx_NEW_CON6 */
#define AFE_GASRC_NEW_CON6_FREQ_CALI_CYCLE_MASK     GENMASK(31, 16)
#define AFE_GASRC_NEW_CON6_AUTO_TUNE_FREQ3          BIT(12)
#define AFE_GASRC_NEW_CON6_COMP_FREQ_RES_EN         BIT(11)
#define AFE_GASRC_NEW_CON6_CALI_SIG_MUX_SEL_MASK    GENMASK(9, 8)
#define AFE_GASRC_NEW_CON6_FREQ_CALI_BP_DGL         BIT(7)
#define AFE_GASRC_NEW_CON6_AUTO_TUNE_FREQ2          BIT(3)
#define AFE_GASRC_NEW_CON6_FREQ_CALI_AUTO_RESTART   BIT(2)
#define AFE_GASRC_NEW_CON6_CALI_USE_FREQ_OUT        BIT(1)
#define AFE_GASRC_NEW_CON6_CALI_EN                  BIT(0)

/* AFE_GASRCx_NEW_CON7 */
#define AFE_GASRC_NEW_CON7_FREQ_CALC_DENOMINATOR_MASK    GENMASK(23, 0)
#define AFE_GASRC_NEW_CON7_FREQ_CALC_DENOMINATOR_49M     (0x3c00)
#define AFE_GASRC_NEW_CON7_FREQ_CALC_DENOMINATOR_45M     (0x3720)

#endif
