/*  Gringotts - a small utility to safe-keep sensitive data
 *  (c) 2002, Germano Rizzo <mano78@users.sourceforge.net>
 *
 *  grg_pix.c - various pixmaps used in the application
 *  Author: Germano Rizzo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

char *red_xpm[58] = {
"20 24 33 1",
"       c None",
".      c #1F1313", "+      c #7F0A0A", "@      c #ACA6A6", "#      c #7A7A7A",
"$      c #CF0404", "%      c #9D7676", "&      c #461010", "*      c #7E5E5E",
"=      c #DE7070", "-      c #A00808", ";      c #675F5F", ">      c #AF5A5A",
",      c #630E0E", "'      c #D65656", ")      c #E1A2A2", "!      c #BB0606",
"~      c #F10202", "{      c #472E2E", "]      c #363232", "^      c #8F0A0A",
"/      c #E10202", "(      c #560E0E", "_      c #AA2626", ":      c #D02222",
"<      c #6A2A2A", "[      c #301212", "}      c #710D0D", "|      c #AE0606",
"1      c #862A2A", "2      c #962A2A", "3      c #BA2626", "4      c #C3A6A6",
"                    ",
"                    ",
"      4>1+^2>)      ",
"    4<,}+^--||3)    ",
"   %&,}}+^-||!!$=   ",
"  #&(,}+^-||!$$$$=  ",
" @&((}++^-|!$$///$) ",
" {&&,,+^^|!!$//~~/: ",
"@[&&,}}^--!$$/~~~//)",
";[&((}+^^||$$/~~~/$'",
"][&&(,++--|!$//~//$:",
".[[((,++^-|!!$/$$$!!",
".[[&(,}+^--|!!$$$!!|",
"][[&((,++^-|||!!!!|_",
";.[&&(,}++^--|-|-|->",
"@..[&((,}++^^^----^)",
" ].[[&((,}++^+^^^^2 ",
" @.[[[&((,,}++++++4 ",
"  #..[&&((,,,}}}}%  ",
"   *.[[[&&((((,,%   ",
"    @][[[&&&((<4    ",
"      @;{[&{*@      ",
"                    ",
"                    "
};

const char *yellow_xpm[58] = {
"20 24 33 1",
"       c None",
".      c #1F1E18", "+      c #A1984B", "@      c #514D2C", "#      c #716B36",
"$      c #E0D45E", "%      c #CABE55", "&      c #8D863F", "*      c #ACACA9",
"=      c #2C2B1C", "-      c #E4E1BD", ";      c #BFB452", ">      c #C5C3B3",
",      c #3B3825", "'      c #5D582E", ")      c #7E783B", "!      c #ABA24A",
"~      c #DCD6AA", "{      c #7A7A7A", "]      c #F3E463", "^      c #474427",
"/      c #BEBAAE", "(      c #929082", "_      c #A8A688", ":      c #B7AC4E",
"<      c #6B6634", "[      c #898240", "}      c #DAD69A", "|      c #D5C958",
"1      c #BAB682", "2      c #6A6A64", "3      c #978F42", "4      c #656034",
"                    ",
"                    ",
"      >(&)&+1~      ",
"    /#4#)&3+!!;-    ",
"   (@4#)[&+!::;;}   ",
"  (@@4#)&++:;%%|%~  ",
" *,@'4#[&!!:%|$$$|- ",
" @,^'#)[3+:%|$$]$$| ",
"*=^@'<)[3!:;|$]]]$|-",
"2=,@'4)[3+:%|$]]]$|}",
",=^^'4)[3+!;||$]$$%%",
"==,@'<#)&+!:;||||%;:",
".=,^@4#)&3!!:;%%%%;!",
"=.=^@'4)[&3!!::;:!!:",
"2.=,^''<)[&3+!!!!!+1",
"_.==^@'4<)[&333+33&~",
" =.=,^@'4<#)[[[&&&3 ",
" *..=,^@'4<##)))))> ",
"  {.==,^@''4<###<_  ",
"   ).==,^^@'''4'_   ",
"    _,.=,,^^^@</    ",
"      *<^=,@)/      ",
"                    ",
"                    "
};

const char *green_xpm[58] = {
"20 24 33 1",
"       c None",
".      c #131F13", "+      c #0A7A0A", "@      c #A6ACA6", "#      c #07CC07",
"$      c #104310", "%      c #A2E1A2", "&      c #06A606", "*      c #7A7A7A",
"=      c #105010", "-      c #76A876", ";      c #769276", ">      c #70DE70",
",      c #0B8E0B", "'      c #0F5F0F", ")      c #5F675F", "!      c #02F102",
"~      c #5ABA5A", "{      c #0E700E", "]      c #56D656", "^      c #08BD08",
"/      c #5A9A5A", "(      c #02E102", "_      c #5E7E5E", ":      c #122612",
"<      c #A6C3A6", "[      c #0C9A0C", "}      c #323632", "|      c #05D705",
"1      c #0B850B", "2      c #2E432E", "3      c #123312", "4      c #08B108",
"                    ",
"                    ",
"      </11,[~%      ",
"    <{'{1,,&&&^%    ",
"   ;='{+1[[44^^#>   ",
"  ;=''{1,[&4^####>  ",
" @3='{+1[&4^#||((|% ",
" 2$=''+1[&4##|!!((| ",
"@3$='{+,[&4#|(!!!(|%",
"):$=={+1[&^^|(!!!(|]",
"233='{+1[&4^#|(!(|##",
"::$=='{1,[&^#||||##^",
".:3$''{1,[&44^###^44",
"}:3$=''+1,[&44^4^444",
").33=='{+1,[&&&4&&&~",
"@.:3$=''{+1,,[[[[[[<",
" }:33$=''{+11,,,,,[ ",
" @.:3$==''{{+++1++< ",
"  *.:33===''{{{{{-  ",
"   ).:33$===''''-   ",
"    @}:33$$==={<    ",
"      @)23$2_@      ",
"                    ",
"                    "
};


const char *optimal_xpm[94] = {
"20 24 69 1",
" 	c None",
".	c #A6C3A6", "+	c #5A9A5A", "@	c #0B850B", "#	c #0B8E0B",
"$	c #0C9A0C", "%	c #5ABA5A", "&	c #A2E1A2", "*	c #0E700E",
"=	c #0F5F0F", "-	c #06A606", ";	c #08BD08", ">	c #769276",
",	c #105010", "'	c #0A7A0A", ")	c #08B108", "!	c #07CC07",
"~	c #70DE70", "{	c #3D9F05", "]	c #AC4402", "^	c #A6ACA6",
"/	c #123312", "(	c #05D705", "_	c #8F6002", ":	c #AA4B00",
"<	c #1DC801", "[	c #2E432E", "}	c #104310", "|	c #22B506",
"1	c #AB4701", "2	c #AA5000", "3	c #02F102", "4	c #02E102",
"5	c #E21800", "6	c #E21900", "7	c #1DD601", "8	c #5F675F",
"9	c #122612", "0	c #23A807", "a	c #E21500", "b	c #56D656",
"c	c #AC3B02", "d	c #FF0000", "e	c #598804", "f	c #2A470E",
"g	c #434A0B", "h	c #AE3304", "i	c #905403", "j	c #131F13",
"k	c #5F2C0A", "l	c #E30A01", "m	c #5E4A09", "n	c #5C5E07",
"o	c #C72501", "p	c #323632", "q	c #AF1A05", "r	c #246C08",
"s	c #E30F01", "t	c #26890A", "u	c #E30901", "v	c #E30C01",
"w	c #913B04", "x	c #792C08", "y	c #5F3F0A", "z	c #942307",
"A	c #443E0C", "B	c #7A7A7A", "C	c #76A876", "D	c #5E7E5E",
"                    ",
"                    ",
"      .+@@#$%&      ",
"    .*=*@##---;&    ",
"   >,=*'@$$));;!~   ",
"  >,==*@#$-);!!{]~  ",
" ^/,=*'@$-);!(_:<(& ",
" [},=='@$-)!|12344( ",
"^/},=*'#$-)|567334(&",
"89},,*'@$-0a5<3334(b",
"[//,=*'@$-cde(434(!!",
"99},fg*@#hdi!((((!!;",
"j9/kldm@ndo));!!!;))",
"p9/}qdlrsdt-)););)))",
"8j//,udvdw#$---)---%",
"^j9/}xddvr@##$$$$$$.",
" p9//}ddy*'@@#####$ ",
" ^j9/}zA==**'''@''. ",
"  Bj9//,,,==*****C  ",
"   8j9//},,,====C   ",
"    ^p9//}},,,*.    ",
"      ^8[/}[D^      ",
"                    ",
"                    "
};

const char *splash_xpm[180] = {
  "349 146 33 1",
  " 	c None",
  ".	c #563202", "+	c #644110", "@	c #7A705E", "#	c #9B8A6E",
    "$	c #BDAC90", "%	c #D0BC9E", "&	c #DCCCAC", "*	c #EDDAB8",
  "=	c #EFE2B8", "-	c #7D5E31", ";	c #958670", ">	c #E4CEAD",
    ",	c #886A3C", "'	c #FAE3C2", ")	c #F2DAAE", "!	c #AB9068",
  "~	c #704F1F", "{	c #9A815D", "]	c #F0D6B9", "^	c #C7B696",
    "/	c #F2E2C2", "(	c #A99C84", "_	c #5D3A09", ":	c #F2DAB6",
  "<	c #B69D77", "[	c #D6C3A3", "}	c #F2DEC0", "|	c #E8D4B4",
    "1	c #EEDEC2", "2	c #C8B08D", "3	c #917449", "4	c #FADEBE",
  "$2^^^^^^^^^^^^^^^^^^2^2^$22^2^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^2^222^2222^^^22^2^22^^^222^^^^^^^^^^^^2^^^^2^^^^22^22^^^^^^^^^^^^^22^^^^^^^^^^^^^^^^^^^^^^^^^^^2^2^$22^2^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^2^222^2222^^^22^2^22^^^222^^^^^^^^^^^^2^^^^2^^^^22^22^^^^^^^^^^^^^22^^^^^^^^^^^^^^^^^^^^^^^^^^^2^2^$22^2^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^2^222^2222^^^22^2^(",
  "(^%%%%[%[%%[%%[%%[%[[%%%%%%^[%[%%%%%%%%%%%[%%[%%%%[%%[%[%[%%[^%%%%%%[%%%[%%%%%%[%%%%[%%%[^%%[%[%%%&%%%%%%%[%%[^%[%%[%%[%[[[[%%[%%%%[%%[%%%%%%[%[%%[%%[%%[%[[%%%%%%^[%[%%%%%%%%%%%[%%[%%%%[%%[%[%[%%[^%%%%%%[%%%[%%%%%%[%%%%[%%%[^%%[%[%%%&%%%%%%%[%%[^%[%%[%%[%[[[[%%[%%%%[%%[%%%%%%[%[%%[%%[%%[%[[%%%%%%^[%[%%%%%%%%%%%[%%[%%%%[%%[%[%[%%[^%%%%%%[%%%[%%%%$;",
  "$$%&&&&&&&[&&&&&&&&&&&&&&&[&&[&&&&&&&&&&&[&&&&&&&[&&[&[&[&&&&&&&&&&&&&[[&[&[&&&&&&&&&&&[[[&[&&&&&&&|&&&&&[&&[&[&&&&&&&&&&&&&&&&&&&&&&[&&&&&&&&&&&[&&&&&&&&&&&&&&&[&&[&&&&&&&&&&&[&&&&&&&[&&[&[&[&&&&&&&&&&&&&[[&[&[&&&&&&&&&&&[[[&[&&&&&&&|&&&&&[&&[&[&&&&&&&&&&&&&&&&&&&&&&[&&&&&&&&&&&[&&&&&&&&&&&&&&&[&&[&&&&&&&&&&&[&&&&&&&[&&[&[&[&&&&&&&&&&&&&[[&[[&^(;",
  "(^%&>&||&||&||&|||||||&|&&||&|||&&&|&&&&&||*|*||>>>|&>&&>|>||&|||&|>>>>>>&>||1=1||>&>>>|&&&||&|||||||&&||||||||>|||||||****|||&&&||||||&&&&>&||&||&||&|||||||&|&&||&|||&&&|&&&&&||*|*||>>>|&>&&>|>||&|||&|>>>>>>&>||1=1||>&>>>|&&&||&|||||||&&||||||||>|||||||****|||&&&||||||&&&&>&||&||&||&|||||||&|&&||&|||&&&|&&&&&||*|*||>>>|&>&&>|>||&|||&|>>>>>&|>[$(;",
  "$$%&&*****1***|||****1||]||1|1*1||*1|11|111==1****|1>|||||*1*|||*]|]}}]]*]]*/1*111||*111***1111*|||||*||||||]|*:]|||*1*111****]]|*11**1*****|****1***|||****1||]||1|1*1||*1|11|111==1****|1>|||||*1*|||*]|]}}]]*]]*/1*111||*111***1111*|||||*||||||]|*:]|||*1*111****]]|*11**1*****|****1***|||****1||]||1|1*1||*1|11|111==1****|1>|||||*1*|||*]|]}}]]]]>%^(;",
  "(^[&>|*111//1*1*1*111111111111==111=1=1=1111==*|*|1********/*1****1*''}}:4}4'1)1/=1||*}/====}1*1**||1*1*****1}4}***1}/}1/1/*111111*1=11*****1*111//1*1*1*111111111111==111=1=1=1111==*|*|1********/*1****1*''}}:4}4'1)1/=1||*}/====}1*1**||1*1*****1}4}***1}/}1/1/*111111*1=11*****1*111//1*1*1*111111111111==111=1=1=1111==*|*|1********/*1****1*''}}:]>%$(;",
  "$^%&||*==}/'}}}}}//'/}}}}}//////1*1===11==/4/=1*1)=/=***111/}11*1}}}''''}4:4/=:)/=11)=/=/:}='44*****}***|*|]]}4'}}*}/}}///1*}****1*////111=111==}/'}}}}}//'/}}}}}//////1*1===11==/4/=1*1)=/=***111/}11*1}}}''''}4:4/=:)/=11)=/=/:}='44*****}***|*|]]}4'}}*}/}}///1*}****1*////111=111==}/'}}}}}//'/}}}}}//////1*1===11==/4/=1*1)=/=***111/}11*1}}}''''4]>%$(;",
  "(^[&|11////'//}}}}}'}/}}}/}/////=1/////=1///'=}**}'''/}1**/}//}}}}/}''''444}4'//]|)}=/4)**}}'4}1114/::)})]:]|}4''}}/}}}}}}*1:}}}}*|}/}}}}}}===////'//}}}}}'}/}}}/}/////=1/////=1///'=}**}'''/}1**/}//}}}}/}''''444}4'//]|)}=/4)**}}'4}1114/::)})]:]|}4''}}/}}}}}}*1:}}}}*|}/}}}}}}===////'//}}}}}'}/}}}/}/////=1/////=1///'=}**}'''/}1**/}//}}}}/}''/'}]&%$(;",
  "$^%&111=//'''/}/////}}//}///'''/////'///////'/}}=/=):*)//''''''''/}}'/'44''/'/)|)**}'=}]**///'4}:*4/44*)*)*]]]]}}}}}}*:}//}}}}''//}/''//}//'/}///'''/}/////}}//}///'''/////'///////'/}}=/=):*)//''''''''/}}'/'44''/'/)|)**}'=}]**///'4}:*4/44*)*)*]]]]}}}}}}*:}//}}}}''//}/''//}//'/}///'''/}/////}}//}///'''/////'///////'/}}=/=):*)//''''''''/}}'''4}]>[^(;",
  "$^[&|*=4/}}///////}///}}}/''////////''//}}1'''}*44/}/}})/''''''''}}}//4}}4''/}|*)/=''//1*4//'44:}44''4:=}*)]]]}:}}}}}}*1/}}1:/}//::///'/////4=4/}}///////}///}}}/''////////''//}}1'''}*44/}/}})/''''''''}}}//4}}4''/}|*)/=''//1*4//'44:}44''4:=}*)]]]}:}}}}}}*1/}}1:/}//::///'/////4=4/}}///////}///}}}/''////////''//}}1'''}*44/}/}})/''''''''}}}//4}}]>%$(;",
  "$^[&>*=}411*}/}///}}/}:}}/''1/1/////////}=}}''===/4=41}:1/''////'/}}}}}}}4''/}11/'''/4=/=/=/4}}:}}''''''41})]]}}}}}}}1**}}*1}}}}}1}///}}'}}1==}411*}/}///}}/}:}}/''1/1/////////}=}}''===/4=41}:1/''////'/}}}}}}}4''/}11/'''/4=/=/=/4}}:}}''''''41})]]}}}}}}}1**}}*1}}}}}1}///}}'}}1==}411*}/}///}}/}:}}/''1/1/////////}=}}''===/4=41}:1/''////'/}}}}}}}]|%$({",
  "(^[&|*1=/:**:}}}}}}}/}}:}///||1*1/////}/11==''///4//'/:*1=/'//////}}}}}}}'''4}:='''/4/4'}44}//}/4'''/''==::*]::}}}}}}:*}1}**}///::://}}}/}=*1/=/:**:}}}}}}}/}}:}///||1*1/////}/11==''///4//'/:*1=/'//////}}}}}}}'''4}:='''/4/4'}44}//}/4'''/''==::*]::}}}}}}:*}1}**}///::://}}}/}=*1/=/:**:}}}}}}}/}}:}///||1*1/////}/11==''///4//'/:*1=/'//////}}}}}}}*&[$(;",
  "$^%&>1=''/}1}}}}}}}}}}}}}/}11*1=/1////1*1*1=/4'''/}''/}*11/'==1//1}}}}/'''''//4''''}1/'''=}:///}}}/''''//}}*}1}}}}*:}}::}}::}///}}}//***}*}/}/''/}1}}}}}}}}}}}}}/}11*1=/1////1*1*1=/4'''/}''/}*11/'==1//1}}}}/'''''//4''''}1/'''=}:///}}}/''''//}}*}1}}}}*:}}::}}::}///}}}//***}*}/}/''/}1}}}}}}}}}}}}}/}11*1=/1////1*1*1=/4'''/}''/}*11/'==1//1}}}}/'/1&%$(;",
  "($%&|1='/4}:}}}}}}}}}//}}:*|[$<{,3333333333<%|''///''/}:*1//1/////}/}}/'/''''/''''/}}}///}}14=}//=44=}4}4::}:::}:}**}:1}}/}}4///}}:/}*****1/=''/4}:}}}}}}}}}//}}:1*11111***/*****11}}''///''/}:*1//1/////}/}}/'/''''/''''/}}}///}}14=}//=44=}4}4::}:::}:}**}:1}}/}}4///}}:/}*****1/=''/4}:}}}}}}}}}//}}:1*11111***/*****11}}''///''/}:*1//1/////}/}}/''}>[^(;",
  "$^%&|*=/=//}}}}}}/}'}}}:*[#-+.._............_~{^|4=/'/}1::|$;{$*}111**}}/'''''///'/}}}}}}}:1}======1===1==111]:}:]1]1:}}///=}::/''/}=11****/==/=//}}}}}}/}'}}}:}:**/===1**|1=***|111}/'}}//'/}1::11///}}111**}}/'''''///'/}}}}}}}:1}======1===1==111]:}:]1]1:}}///=}::/''/}=11****/==/=//}}}}}}/}'}}}:}:**/===1**|1=***|111}/'}}//'/}1::11///}}11/*1}}}*&%$(;",
  "(^%&|*}}4//:}}}//}//}}*%{+..................._.+~!%:'//}12-_...{//=1]]1}}///''/4/'//=}/}}:})==)1)1*****1*%!3$]]*]]*]:*:}}//*}}}/''}**//=}*)=//}4//:}}}//}//}}*1]*}/=11*|***|**|*))1*}}//}}/'//}11**//////=1]]1}}///''/4/'//=}/}}:})==)1)1*****1**}:]]]*]]*]:*:}}//*}}}/''}**//=}*)=//}4//:}}}//}//}}*1]*}/=11*|***|**|*))1*}}//}}/'//}11**///////*]|*}1]&%^(;",
  "$^[&*1}4}:}}}}}}}}}}}&!+_._..~~~~..._.............+-$|*12~.....+[:*|||}/}//}/''/:///1)}}/}}**/''=11}*1}|#+.._3|}}***//}}:}}/}*}////}}4}'''/''/4}:}}}}}}}}}}}1**1*}}==1=*|*|=*||)*)*|/'/4/}:'/*1*1////'}***|||}/}//}/''/:///1)}}/}}**/''=11}*1}}}:}}]**}}***//}}:}}/}*}////}}4}'''/''/4}:}}}}}}}}}}}1**1*}}==1=*|*|=*||)*)*|/'/4/}:'/*1*1////'}***||*://]&%$(;",
  "(^[&|:}}:}::}}}}}/}}2~.....~!&>>$_.~2{-_.............-$$~..+..__2:**]*:///}}/''/14'4)/=''=}))4''=})*1::<.~3.._!/'/**//}:}:}4}/}1'//}}}}}}=//'/}:}::}}}}}/}}1/***1}=1*=||*|*)))|]]])]/'}}//1'//1/111/''*]:**]*:///}}/''/14'4)/=''=}))4''=})*1:}}*}}/1}[&//**//}:}:}4}/}1'//}*[&}}=//'/}:}::}}}}}/}}1/***1}=1*=||*|*)))|]]])]/'}}//1'//1/111/'':|:**]]:/11[%$(;",
  "$^[&|1}}:}}:}1}/}}/2~.....-%}=|*^_.~|4]2,_..,-+........_..3<....$)**1}//}}:1/''/1}=////'''/=}///41}}}}|-.3%_..+>'}**/////}*}/}//'}/}/}}})4/4/}}*}}:}1}/}}//1=***=}/==*|*|***))))))4)/}1:}}1////////''/}*:**1}//}}:1/''/1}=////'''/=}///41}}}*}}*}}}%,~<'}**/////}*}/}//'}}%,~<})4/4/}}*}}:}1}/}}//1=***=}/==*|*|***))))))4)/}1:}}1////////''/}*}**1///}|[%$(#",
  "($[&|**}1*:****}//2~.....-[4=**|%_.~>)1)|!+_+<[!+........(/&+..+[)1)4=4///1:1''))/'4)='4'=4}///}*:}}*4%_.!>+.._$)))]/4/}//}}''///'//'/==/=4=4}}}*:****}////=11**1/===**&|***))1)]):4}**1}1*|1'/''///'/**}1)4=4///1:1''))/'4)='4'=4}///}*:}}:}}}}}&{+_2})})]/4/}//}}''///>{++2///=4=4}}}*:****}////=11**1/===**&|***))1)]):4}**1}1*|1'/''//'//}*)})}}}}/*&%$(;",
  "$^[&|**:}::**11}/^~.....-&///=*|^_.~[|))))$~._!:[{~...._#://<--!))=='='///}:/'/}}''/):=}=/)}=//41}}/}}|~.{[+.._2***]=//}}/}}///////}/44/==}*}*:}::**11}/}}/=1===}//==|*|***&**))|4*/}]*}}}1*/'//''//}}*:)=='='///}:/'/}}''/):=}=/)}=//41}}/}}}}|<~..,|]|**]=//}}/}}///1$~..,4}=/=}*}*:}::**11}/}}/=1===}//==|*|***&**))|4*/}]*}}}1*/'//'///}::**=='''/}|&%$(;",
  "(^[&|1}/4/=/=1}4%+.....~[4='===)^_.~>*}*)))2~.+!::%-.._!:1}|:||//)))''4'/4}}}/})}''/*14=4}})//4}::}/}}]3.~3...~&*))1}://}/}}/}////}}}111***}///4/=/=1}}///}1=11*}}====*|*==>*)11}*)4:*}}:*/''//1/11}:://)))''4'/4}}}/})}''/*14=4}})//4}::}/}}]2,__._<)))))1}://}/}}/:2,....$*}}***}///4/=/=1}}///}1=11*}}====*|*==>*)11}*)4:*}}:*/''////11}:}//))4'''//|&%$(;",
  "$$%&&*///4}}//}&-....._<}}//'===%__~>*)14}))2+__<:|{..{&}1}|}*:'/)4)/''4=//}//}:}''/)*//'=):}//}}}4}/}:>{~___~<))1))*:4/4}}}}}/}}}}}::****:}/=//4}}///}'///1=1=}}//====)**)***))=)111}'/}*/'//1111|11}'/)4)/''4=//}//}:}''/)*//'=):}//}}}}//[{+,_..~>})11))*:4/4}}:[{+,_..~>)****:}/=//4}}///}'///1=1=}}//====)**)***))=)111}'/}*/'/11111|}*}'')*)/''//]&%$(;",
  "(^[&|*}/}/''//*,......31}}=='''4[_.~>|*)'/4)4$_._!{_.,|'///1*]}''})=''/'///'//}}=''4/=''''//////1*}14}::4>%%%|))*]**1}}///1}//}}:1*}}}11}//}}4/}/''////}///=}}}14/='=======|*|=''=)::/''}/''/////11*]:''})=''/'///'//}}=''4/=''''//////}*:[{+_{|~..~|)*]]**1}}//1[{+_{|~..~]}11}//}}4/}/''////}///=}}}14/='=======|*|=''=)::/''}/''/////111|:''14='4''/|&[$(;",
  "$^[&*}//}}/'/'!_.....~%=**1}')))%_.~*==/'==/*}<.....+['//'''/}:/'''))'='4//''''}/////4'''=:*/}/}}*}}}1*}44::])})*>*'}=///}:*::}***}/}*)*/'//'//}}/'/''/}*}'/**11*1='=)))*)===4='=4=*}''}}/'/////''//}*/'''))'='4//''''}/////4'''=:*/}/}}[{+..3:]~._~|==*>*'}=//[{+..{||~..~|*)*/'//'//}}/'/''/}*}'/**11*1='=)))*)===4='=4=*}''}}/'/////''/'1:/''')=//'/]&[$(;",
  "(^[||*}/}}/''%+......!1*=1*====]$..~)'''''/}:4:3....('//'///'////'=1))'''''''///////4==''//}}}4}:*}/*:}11}}*]===|*|}'''''/}11}}}*}}]*1*}4'''/'/}}/''''/}=}/11*111*4'==)))==)'''''//}/''//''///////''////'=1))'''''''///////4==''//}}}4}){_...3[]~..~|=)|*|}''''{_...3[]~..~|1*}4'''/'/}}/''''/}=}/11*111*4'==)))==)'''''//}/''//''////////'//}/'=*)4'//1&[$(;",
  "$$[||1//}//'=,._....+[**1*=/=)')!_.~>'''''==//'>~..~|}111///''}/''))))/''/'''//}}}}}}}}''//41}}}11}/}:}}}}}1)==)**)=''''''}:}//}::1**1:}}''////}//'''''/}//**|*1)==))=)=='=''''''=//''////''/111///''//''))))/''/'''//}}}}}}}}''//41}}:*[%${+.<:~..~|=)*))=''''>[${_.<]~..~|**}}''////}//'''''/}//**|*1)==))=)=='=''''''=//''////''/111'//''//''))*)''/1&[$(;",
  "$^[&|1}'///'$.+{_...3*|*=1)/))4'3...^'''='==/''[+..!///1///'''/'')****4/}////'/}}}4}::}}4/4=*1:***}/}}:}14}))))))1=/'''/'/}}/}}}11**/}}}////'/'//'''''/''/=1*|1=1*=))4='4'=''''''=}/'''///'///1///'''4'=1)***4/}////'/}}}4}::}}4/4=*1*})4)4:{.<]~..~|)1))=='''''4:4{.<*~..~|=4}////'/'//'''''/''/=1*|1=1*=))4='4'=''''''=}/''''//'//11///'''/'=1)||*}//|&[$(;",
  "$^[&|1////'=-.{!..._2******4)]44,...{='''==}'':,...~,#2|1////'//'')=**)**1}/////}}}/}}}}}//=*}}:**4//}}}////)**1)='=''/}/}}}}}}}*1}////}////'////'''''/'''/=1|****}*]4''='=='='===='''''//'/''////////''')=**)**1}/////}}}/}}}}}///*}:}*1}/4<.<]~._~|))1/''''//=4}4<.<]~..~*//}////'////'''''/'''/=1|****}*]4''='=='='===='''''//'/''//////'}''===|})]1>[[$(;",
  "$^[&|1'/'/'$_~>,...-*=|*}=1*]]=|~...-==''==='/#.....__.~(1////)'=''=)=1*]]1/'///}}//}}}}}}//}}}}*1}/'/}}/'//***))/4}4/}//}}}}}}:}}//////}/}//////'''//''''//1**1=1)])=='''='='''==1''''/////''/1/////=''='=)=1*]]1/'///}}//}}}}}}/=}}}:**}/'<.<]~..~>|*)=}}}}4//}1}<.<*~._~]///}/}//////'''//''''//1**1=1)])=='''='='''==1''''/////''/1////}=''''/=}:*||&%$(;",
  "(^[&|1////*-.!&+...{/1*11}=}]))^_...+&='='=='$_...~<%%3_.#/1}//'='''=)=}*:/'''////}//}}}}4::}}/}**}/'}}}/''/*))***)1}//4}/}/::1}}/}}}}}//}}/'/////'///'''=/'=*1=}=}]]))))'===''='=='''///////'////1}}}''=''=)=}*:/'''////}//}}}}4::}}/}:*4/'<.<]~..~|))*))}==4}}4}/<.!|~..~|}}//}}/'/////'///'''=/'=*1=}=}]]))))'===''='=='/'///////'/1///1}}'''''==/**|&[$(;",
  "$$%&|1////$_+[2_...$=*|1'/4})))$....+*'''''4[~..+!>}[#,_.+&114/'==}=)=//''''''////'///}}}*}}}/}/}*}/''}/4''':=*)]||)/4/}}}}'}}**}}}}1}}///1///'////=''''//==*|1'/=4)))'4===''''=''/''/////////1///1}4/'==4=)=//''''''////'///}}}*}}}///1}}/'<.<*~..~)1}|||*'4=}1}}'<.<|~..~|}}///1///'////=''''//==*|1'/=4)))'4===''''=''/''///'/////////*}4='==)/)4/'/1&[$(;",
  "$^[&*1}}}:,.,/3...+&//==)1=//4)>-...,|=====|-..-2}*|3..._.$/}*)=''')*])=/'''////}////1///||}:/''}*4'''//*}}'/}*||11/''}}//}}:::**1}}}}}}}}/''/////'''===//=///}):='//))4=)====='==//11//11|/1111///}**1''=**])=/'''////}////1///||}}}''**/''<.<]~._~|*|*)1/''}}//4}<.<|~._~|}}}}}/''/////'''===//=///}):='//))4=)====='==//}1//11|/1111///}**}''/)*]1=}1&&$(;",
  "(^%&*}}}:%_.<]~...-)/=44)))'41}:<...(=='==4{__-&//}>~....+[/**1='/=======//////}//'//=/'/1)1*}=}*1='''}}}=//4)**))://}}}//}}11}**:/}}}}}}/'''/////''=/==''//=}=}))'/:)4)=))|===////1}}}/}11111]11}/**1=''/=/====//////}//'//=/'/1*=|}=}*1'''<.<|~..~]|1|1:}//}}//}}!.<|~..~|}}}}/'''/////''=/==''//=}=}))'/:)4)=))|===////11}1/}11111]11}/**1=''=1===11*&%$(;",
  "$^%&|1}/}!.+&%_.._3'4==&$<<<$[*}%_._^*==''$_.{>4/}}*,....{:}||1=//=4=//===///}////'////}}*11]*}:|11''=})}4==}111*}:/}}}}}}}}}}}}}}''/}}:}}/'//////'//=/''''4=4)*)*=/4*}41)*|*==''//}}1}'11]/111]:}}||1==//4=//===///}////'////}}**/**}}|1}''<.<]~..~|)1)}}=}}}}//4}<.<|~._~]}}:}}/'//////'//=/''''4=4)*)*=/4*}41)*|*==''//}}}1/}11}111]1}}||1==/=/=//==|&[$(;",
  "(^[&*1}/:,_,)<....</='<~.....+{%%_._%**'=[+.,|}}4//}%~_+,[:*|1=/==1=111===''/'//}/'/////111=****]|*1=/}}*:}}*)**1:}:}}}}}/}}}}}:}/''/}}}1/////////////=/''}=/=='==4=1***1***11'///:1}}}}/}}}}}**1:*|11/====111===''/'//}/'/////11}=|**)||*1'<.<|~..~|****:::}:}}/}}<.<*~..~|}}}1/////////////=/''}=/=='==4=1***1***11'//}:}}}}//}}/}}***}1|11/===}11===1&[$(;",
  "$$[&|*//>+.!43....$4=%_..++_...+,_._%}=/],.~[4://}'//>%[]*1:*1=/=11=//1===''//}/}//''//*}=/=}}1*|>||):*:***1**})1:}::*:}}}}///}}}//}}}}}11/////////'//'''=/'''/''==)**)*1*|))===4}*:}}/////}1}*]*}**==/=*1=/=1===''//}'}//''//*}///4}**|>||}<.!|~..~|}}}1}}*1:}}}}/<.<]~._~]}}}11/////////'//'''=/'''/''==)**)*1*|))===/}*:}}}'/}}}1}*]**:*==/=11=/}===||[$(;",
  "$^[[|1}/%_.$:-..._[='3._3|>23+_...._%)='{._2}}//}}}}}4*]|1:1=/'/1/}=''/1*1=//'////'//'/1///}=:)**>||}1}11***|1:}:}:}1}}}}}}}}}1::}}}::}}11*////////'''''=/='''4''4'}*|**)*|1}////*1}}}/}}}}}:*]|1*}=/'/1/}=''/1*1=///////'//'/}/=/=}*})||>|:<.<|~..~>):::::}:1}}}}}<.<|~..~|:}}11*////////'''''=/='''4''4'}*|**)*|1}////:1}}//1}}}}}*]]*}1=/'/1//='/=11&&%$(;",
  "$$[&|1/'<._[[+..._[4>+.+!2)/4$~...._%):$_.{:''''}*:}*}*]]1}}1///////'''=1|=////////////}4'/|}}*|1*|*:]||||||>|>**1*:}:1]||]]|||||>1}}}}}/11*$$$<$2&1/'=//'''==)=')=}1||1**||||)**]|}}}1]||]]|||&||}1///////'''=1|='//]*|11////}/'/1})*****|)<.!*~_._<|||||||]}}}}}}<.<|~.__<||]]|||1////'/'''=//'''=>%|))}11||1**||*)&'}}:''''}1}}}1*|]*1}1///}///'''=1&&[$(;",
  "$^[&|*''!.+[%_..._['2_..._{/**<_..._%]%~.+[/''''}*1:}*|||*}}}///}//'/'/*^$<$<<<$[&'/1//}[!,~,!%*|*}*4{~~~~~~~~~$1:}/}4#~~~~~~~~~~-%:/}}}//[,_....._-%///4'''=4))='=**]|*1|]{~~~~~~~~~~~~~~~~~~~~~3|}///////''/=*1/|<3-~~~-{2}//''/|:1***1*}:<.<]~..._~~~~~~~{}}}}}:<.!|~..._~~~~~~~#''////'''//4''2,~_~~-3333333,333--|''/''''}]}}:*]*|*}}}///////'/==1&&[$(;",
  "$^[&*1/'3.~*<....~]'$.....-|)|>,..._2[-..+333{33333333333,33333#}1//'=[-_......._{/''/1<+_._..+,21}1){.........<):/}}:<-__..__..._%::}}}'^~.........+<41}=''==''=4)1|)|1}*2+...._............._._<'//}//1/////=1&{~_......__3%/'''/*1*}}=41|<.<*~...._._.__.341}}}*<.<|~.........._{///////'/}}}*!+................._~}''''''/1}}}*1*}1:}'//}/}1//'//==1&%$(;",
  "$^[&|1/'3.~:<....~|4|~....~|*]|2_...<{_.._._.........._.._.....~]////=>{...+3,...3/''}{_.......__3|**&3__+~_...<:}:}}}4|!_._+<_.._[}}}//<~...........+%/}4/'4==4'=1**|]}}|,_....................,}'}'/}}////=/=2~............+!=/=1*)})1****<.<*{33333333+..<}}}}}}<.<]#33333333~..$'//////'''=*3_...................,1'''''/}}}}}}}//}}/'}/'///////==1&&%$(;",
  "$^[&11//3_~|<..._~])/<+.._{'*]||,...-_.........................-*/////}*3..~][_..3/'/!.........._.{|]]>3.<&~...</}1*:}}/}$+.~^_.._[}}}}<_.............,//}}=/}=}'==)||*//$.....................->''*}/'//'///}<+.~!<<<{3~_.._._-[1)*}=:*||*|<.<*:}}}}/'4}3.+[}//}}}<.<4}}/}}}///3.+&////////'''!_.-!<<<<<<!<!<<<~...+^}//'/1}1*}*1//'}}/'':}}'////////1&&^$(;",
  "(^[&|1'/3.~}<....~|:':[{3!4/*|]:^+............................_$'//////}[~.~:[_..3/'2_...3<3~__...-||||<.<]~...</:*11}}//4{.~^_.._[/}](_.+~~~+_......_+>=})/4)=='4'|]*}4>~.-<<<<<<<<<<<<<<#_..-[*//1}///'///}<_..-{<$|**&%,.....~%*|*/}||]*]!_!**=/=''/=[~.{}}}/'//<.<}}}//}}/'&~.#///////'/''$_.~|:)'/'''*]]:/:~...<:}1//]]]]|*:}}}}}}:}/11//'//////=1|&%$(;",
  "$^[&|1//3.~|<..._~]}}44)44'/}*}4|~....._________________....._!1//}}////*,.~*[_..3/1~....,2&[%$_._<)*||<.!*~.._</:*:}}}/'/<.~%_.._[:%,...+3!%[[$,~_..._^'/4=/::4'''1**})3.+%//}//':]|]|*:[-..+[}}}}1}////}}}<_..__._.+,$>/1(+....-&|*=}|>|)*<.<*]])*)})|3.+[4}/''/'<.</1*:]|]*|{.+['//////'''>~._#[[%%[[[[%%%[[<_..,]///11]|]]1}}}'/}}}}}}*}}///}1/1111&&^$(;",
  "$^[&11'/3_~|$....~1/'/:}='/'*}}}[+....![[[%%%%%%%[%[[[[^~....{}1}}}}}//}*3.~][_..3/!......_~3<<_.,>**)|<.<]~...</}://}}}/'<.~%_.._{3+_......_~{&1|,....</'/'/}}=//'*}4/!_.~<<<<<<<<(<(<!3~...,}''//1*1}}}}*<_..-!$<!~_._-$:'2+..._{|*::)|***!.<|,~~~~---+_3}}}}/'''<.<:,~~~~---__3/////1//'/}3_.._______________..+%}/''/1]|]**}}/''''''//1111}}}}///1*&[%$(;",
  "$^[&|1//3.~|$...__&''/:}=///}}//{....-[]:}]|||]]|])4'4':~...-|}*}}}/}}41*3.~*[_..3&~._,!3-+....._2}11**<.<]~...<*}/''/}}4/<.~%_......_+~~~~~+_.~2/[+_..#''''/:}/4=/}}}2_......_..............3'''}}1111}}}2+.+!>**:/*%,_..3/'!...._$)1*1:}}}<.<)~._.#%%%%%]//}}}/''<.<1~_..#%%[[[|/'//1///''%_.___________+___..._!}}}''}1111:}/''''''''/}11*1}}}////}1|&%$(;",
  "$^[&*1//{.~][_..._^'''/:)44/}/'[+...._~~~~~~~~~~~~~~~,]]~..+^*}}}//'//}:*3_~][_..+~._<|1**^-....{='4::*<.<|~...<*:/''/}**'<.~%_.....-$>///=1%!+_~&}-...3'''''/:)///}/>~_.-!<<<<<<<<<<!+......3/}}}*:1:}}/>-.+^}**://}/}<-._{1*,....->)}/='/:<.<*~.._%4)))'''/}11}''<_<:~..+['''''/'/'/////'1,.~%[[[[[%%[%[%[[%~..,*:}}}/}:4}}/4'''''//}/:**1}}}//'//}11&[[$(;",
  "$%&&|111<.~|[_....<'==}//=41''4{....__+_+______+_+__.~]]~.._%]]:}:}}}}}*|,.~>%_...._#)***))^_..~[)]]}44<.<>~...<}}/}}}}1:}<.~%_....3>4/'''/}'/2+.#}3...3'''/=}///4)'4#._!]4444}44]4]4)~..+~..34}:]|]]]*:]3._<:*]*}}*}/}:>3._3|[~..._<))))]]:<.<:~.._%41}}=4}}:*:1/'<_<*~.._[//'''/////111//%_.-'''4}4=4'))4{33_.~[444}}}4}::/}'''''''}::]|]]]:}:}:}}}*]|&%$(;",
  "$^[&|*//2_~|&+....{//11====]'42+....3%%[%%%[%[[%[[^~.~])~.._%]]}:}::}}}::3_~|[_....->:))*:)>~..<})]]:}4<.<>~...<}}}}::}}//<_~%_...-|///'///=//={.-*3...3'//}11=)1=*'%+.-|44]44:]]44)]|~.~23..3::*]]]]]}}$_.3*}1*|*}]}/}}}:!__#|$_...-*:)*]]:<.<]~.._2*4}1}}::}}///'<.<]~.._%//'//////11*1*/{..+['/}==)===))~...~24444:]]:4:*://///4}44}}]]]]]:}:}:}}111&&^$(;",
  "$$&&||1/[++%)~....-*1=**1)*|)|-.....<))]]]))]]))44)~.~]:~..+%]]}:}}}1}}1*3.~>%_...+%)::})})2_.,|)}}}*:}<.<>~...<}}:}1:}///<.~%_...<'/////}1111}$.~|3.._3///1=*1=1||),..#):4:::]||]))]|~_2/,..344*}:]]]:>-.+%}411**=]}}*1:/:!.+<],.._~>}):}}:<.<:~...<:}}}1}*}}///1/<_<*~...<///////1///***[+...#}/*11*1=*|4{__-2:::*:]|]]:])::4}4:4:44:}::]]]1:}:}:}}*1&&^((;",
  "$^%&|*=}|-_%},...._[/111==**)!..._.+%)))]|]|))>)))|~_~|]~.._%]]:1*:::}}}13.~>[_...3:*}})})]{.+%)}*4:}}4<.<>~...<::}:]1}}''<.~%_.._[//1=///1111'%_~|3...3//'/}==*=*)$_.+2)}4]:})]|]]])|~~|]~..3444*:]]]}<_.~|}}}1***|}/}*}/4|3.-|^+.._%)}4:4:<.<]~...<}:}::*]*}}'//'<.<|~...</////1111//1/1!...._,%]11==)|*]]%2&::4]:}:]|]])])*14::::]44:}:]]]}}*}:}*111|[%$(;",
  "$^%&&|1//3_<'!.....!//===1=*^+..,2$<])44))][!-~32)|~.~|]~.._%]]:}1}}*}:*13.~|[_.._2*|*)*})[~.!])})44}}4<.<]~...<}:1*|*}}}/<_~^_.._[}/1==111*11/>+-]3...31/////===*&-..-]::4|)4')]]])]|~~|]~..,::}11]]]:,..~|**1==/*]}/:*}*:)|,.<){..+%)*4:4}<.<]~...<*:1}}1|*}}////<.<|~...</111111111/1/1-......_-3333333,33333{<^>4':]]])|4)1)}:]:*:}:1}]]]*}*}:}*}1=|&^((;",
  "(^%&&*=//<.{/^_....-}//===)|-_.~[4]]])'')]!~.._.+<>~.~>|~.._%]]}::::}*11=3.~>[_.._%}1|))=)<.~[)::/44}44<.<]~...<}}:}*::}/'<.~%_.._%1//1}}11*1/4*~~*3...31/''/}''==<...<4}:*]*4'4)]]))]~~|>~..3}}:]]]]]%+..~|***111/*/}}*:}1*)2+-][~._%:}}444<.<|~...<}}}}::1}*}}//'<.<|~...(////1111/////>+......................._~{&4*]])))*))])]]::::]]]]]}:}:}:***1|&%$(;",
  "$^[&|*1}/[+-|>+....+['//''=!..+2'[,->):)2,_..__..-[~.~>|~..+%]]}}11:}*]**3_~|%_.._[))*):=|-.!44///'''}}<.<]~...<}}:}}}}}}/<.~%_..+[==/////}11/}]~~|3...3*///'=/'')-...<4}]]]1):)]]))))~~>>~..3|]]]|]]]<_._~|}]1*}}}:'/}*:/1**]{_2],._%4//'''<.<]~...<*4}}}:}}}}}///<.<|~.._<///11111/}//=[_.+~~~~~~~~~~~~~~~~~+......~<*])444}1)]|]]]]]]]|]]]}:1*}}*]11|&%$(;",
  "$%[&|11}**,.$/,.....!//''=%+..!'4{__[:|!+...~!+..+2~.~>>~.._%]]::::}}*||*3.~][_.._%)**}}4<._^*}/}/''''4<.<]~...<44}:}//'/'<.~%_.._[/''''///*}}1|~~|3...31/////='=$_...%/)|>):)]||])'')~~>|~..3]]]||]]:!...~]*||*}//}''/}14)|))%+,)3._[///'''<.<]~...!}}4}}}}//'////$.<*~...<'/'//}1}}1**1[+.-%|||1***11=**]]]]><3+....+$]1/'=4)]||]]]]]]|]]]]:}:}:11||*|&%$(;",
  "$^[&|11}::<.,:!.....-|==/*-_.,>])<__[[,....3>!..._2~_~>>~.._%]}}4}*|1}}}*,_~|[_.._[4=:)))-..3|4}}}}'''}<.<]~...<}}11}/////<.~%_.._[====/'/}}//1|~~|3...3*/'/////=,..._%)')]4''4})14'')~~>>~..3|]]]>]]/3...~|}}}*|*1}''/41=/=})),+[,._%4}}}''<_<|~.._344}:**}///////<.<}~...3=//'/1}//}1*11{..~$1/'/}}=/==))]]]4'4%{_...,])'4))|||]]]||]]|>]]}}4}1]*111*&&^$(;",
  "(^[&|*}}/4&+_2[+.....$}==!_.+%))42._!~...+<]&+...~%~.~>>~.._%]}4}}:**:}}}3.~)[_.._%1}*)}[+.._3|}}}/''''<.<]~...<}:**}}}//'<_~%_.._%===//'/}}//4}~~>3...3/''//1'/[+....<)'}|*4/4)1)))))~~>>-..,]]]|]]]}3.._+[}}}11*1}/4/1*}4/)))<_<3.+[}}}/''<.<]~...3}}}}**}}}'//}'<.$*~...3///'}}}}/14/1)[-.._3%///14}41*)]]4]]|>]2~..+%4)44]|||]]]]*]]]|]]}44}*|*1111|[%$(;",
  "$%%&&1}//}/3_,}{_....-]/%+._<]]]43.._.._,%))]{333<>~.~>]~.._%]}44}:**}}}13.~][_.._%)}))4|~..._[/}}/'/4:<.<]~...<}::*::}}//<.~%_..+%}===/}}1}}//*~~|3...3'''//}//<...._!'4]|)})})]}4):]~~>],._,]]}]]]]}3..._$4}}1=///}*****]1}})%_,-.~]/}}/'/<.<|~...3:}*}}*::}}}/''<.<]~...3=///}1}////=}=12~...+,3333333333,3-~~~-3~.._%4)))]||||]]||]*]]]]}}44}**1111|&%$(;",
  "(^[&||}}///2_+2[+...._<&-..{]])4[+....+!]]]))]4]]]>~.~>>~.._%]}444}}1:}}=3.~4%_.._%****)){..._[}}}/'}1]<.<|~...<}1}}1}:::'<.~%_.._%*11*/}}:*}}}}~~|3...{'/////=4#.....3))]|))}*]]])}))~~>]3..3]]:*}]]}3....,|}1=}/''}*]1*|*)]])[__..,}}}}}'}<.!|~...31}}*:}1}::}//'<.<|~...31*/}}:1:}}4/=1=}&#3333333333,3,33333,~+...._%**)4])|]:]]]]]}:}]]}44}}1*:111|&&$(;",
  "$$[&||*}/4=]3_-4{_....~-..->])]4<....-%]]]|])4)4]]>~.~]>~.._%:}}44}}1:}}13_~}[_.._%)1*)1'>{33{>/11/'=1*<.<*~...<4}:::}*1:}<.~%_..+%*=*|1}}}*::}|~~*3...3//'//4/43.....~>)]|):})]||])))~~>]3..3]]}}4]}:3._.._$411=/''/**1)1)1*)4|~.._<//}}/'}<.<|~...3444}:::1*1:}/'<.<*~...3***:}:}:1}//=114''=:}///}=//)4)])):)]>%-_.._%]})4))]]]*}]]]}}}]}}444}}*}}/1|&[$(;",
  "(^%[|***)})=>-_{|,....._.+^))]]|-..._%)]||||:)444]]~.~]>~.._%}:4}'}}:}}*1,.~)[_.._%=))*)'4'/4}/}11//1*]!.!>~...<4}}}}:1*:4<.~^_.._%)****:::}1}**~~|3...3*/'//}113......!]]|}})]||||}4]~~>]3..3}]:44]:}3.~...~%***//'/1*:=/=))}))~..+['}11//1<_!>~...3}44}}}}:1*1}}/<.<|~...,*]1}:}:*:1*4)=*='=:1/'//}====1)]]:)]]])>,.._^|):44:)]}}}}1]:}4]}}}4'//}11*1&&%$(;",
  "$^%&&|1**1)11^+_![-....._!)))]]|-...+[)]]>>>]])*]]>~.~]]~.._%:}4}''/}}:*|3.~][_..+%')})}''4=}///}*}/1**<_<|~...<}4}*}:*1*}<.~%_.._%)|)*111*}11*|~~>3...31////=1)3......+%)):4}]|>>>|]]~~>]3..3}]}}']::3_{~...-[||*11}/=4:/'1)*4)~._{=/}}:}/1!_<|~...3}}4}}*}:***}}/<.<|~...3***1**}1**|1)==*<-!|1/'/}**=|*)]]]]]))44[+.+%>]])}]]]]444}]:4']:}}4'''}}11|&[^$(;",
  "(^%[|1*1**))=)!_+2>-....+[|*])|]<_..{))]>&>>>|]]]]]~.~]]~.._%}:}4'''//1]|,.~>%_.._['1)}='=/}*1/}}====1*!.!>~...<}}}}:}**1:<_~2_.._%**1}/:*]}}*1|~~|3...3//''})*|3......_->*4)))>&&>>|[~~>]#..3}]]}']}}!.3!....~$&||]*4/*})/:*}/^_.~[1//}==/=<.!&~...3]}}}}}:}**1*:}<.<*~...,**/:*]}}**)*1)*{_..3>''/1*1|)*)]||]]):]4)-.-[>>|]]]|]]}'}}]]}']*}}}''///*||&[^((;",
  "$^%[||**]]1}=)>-_+2%~....3>*|>>>>~._%4)4)]>||)))|>>~.~>|~.._%}}///''/'/**3.~|%_.._%44*414'4}**}*11/}}''<.<>~...<**}1:}*:]*<.~%_.._%))=41**|*}**>~~|3...3*//}}:**3......._,%4/:4]]>]>%-_~[]!..3|]:44*:}&+-[-....+!>*)1)4:'444:4}{._<}:**11/4}<_<>~...3:}**}1:]**]*::<_<|~...3//}1****11]])1<.....-2::}*****|||>|*]])']~_<]>]))*|>]]':]]]:}4}}]/}/'/'//1*&[^$(;",
  "($%[|]}}*1)}4*)^~.~22+..._3%])|]>~._%}*|)|]|])4))>%~.~>>~.._[::///''4'/}:,_~>[_.._[)1}}4''4}:***==}===}!.<>~...<**::1:}1|]<.~2_.._%1:)1)*|*})}}%_~|,...3}}}}*1*|3.~~......-<|)|)|][!+_.~>]<..3*]:}}}}44{_<[~.....,%1)})}:)4}142+.,:**1*==1==<.!>~...,}***::[{[}|1}:<.<*~...,}:*]|*[{%)**}%~......_3[)|**))|]||)**|:)<.,>|]])4))|]:':]]*:}:}:}//}''/'/**&[^$!;",
  "$$[[||:})}*1))*]2+.~<<+..._+{>)4|~._^]]|]])])4)4]%-..+<[~.._[}}///}='4'**3.~]%_.._[4)1}4'/'4}*}11=/='/'<.<]~...#]*}:}::}1*<.~%_.._%4*))))})}):)$_~]3...~>}}1|***!_~<+.......-{!<!3~....~|)<..3))*}441=4[~->2~...._~![]]]::4:>!~._^4}:111=/}'<_<]~...~>1]*}%-_%}**}:<.<|~.._~&:1})%-_[4}}}{..~_.....~!&*==='=4)1)}*|%~+%))|)}4)]))*4*1)]:}}4}}/'}4}'//**|[^$!;",
  "(^[>|]*:}]<,-{&**!_._{#_.....~![>~._%|>|*1)144'|!+.....+..._[//44///)''/)3.~]%_.._%4::*4'''':}/==/'='''<.<]-...+<>2<[}}}*:<.~%_.._%*})1)}}/:}}}<.~|,..._2}%32]*:^_.,2~.........._......~>]<..3]]]*/4//=)<_{)%-......~{2>]]><-_..<4'*}/==//='<.<4-....-3!<#+._%}*:::<.<1-....-3!<!+._%*))%+._<!_......~![)'''==}/:&!~.!]**}44/4)]*)*))]*]:'}'////=/}''/*|[^$(;",
  "<^%&||1*[,_...,)1>~...-3_......+~_._^]|||)}*)>!-_...~-....._['}1:}})=/'=)3.~]%_.._%4]]]}''/4:://4====1*2_{43.._..~_.~[}:::<.~%_..+[]})}*}/=:*::<_~>3....~{+.!]*:)3..{$+................~])<..,)]))/'4}4:*3_!/&3_......_~,,~....{]'4::///'===<.#){........_..+[}}1}}<.!}{...........+[}}}{...~<!~......_+,<^[[%[${~..-[]}}*)'=)))})}))*]])''/}}}}}}////*>[%$(;",
  "$$[[|**4{.....+[]{_+~..~_...........-$[>[%$!3~...._3>>3_..._[}11**}}/4'':3.~][_.._[4]]]14}4}}}//=/=1)*|>~-)[+......._%}}}4<.~2_.._%}'/*)*))1}})$._23...._.._<]*}4[~._<%-.............,+~|)!..31))''41111:|3+!**2,_....._......-|44}1}//4==}]2_-4[~..........,*:*:}}2_-][~..........,]:)>~...._3<3+......_._____....-%|*)*14444))*)])*)**''}}:***)*44'':|[^$(;",
  "($%[>|}43._++_-&{__<[{+............_._+~+__....._,2]])>3_.._[:*|]]*)1}'443.~)%_.._[]]]]:}4}]::4//)**/)]/<_2'%-......~[}}:4<.~%_.._[])}})||]:*::%_.,3.......~[]*144%~__!2#~_____...._{>~~>)<..3))''/4}*|]]1[-_-$&|2,_........_-[44}]::4=4:**'&~_2'&3_.......+^}}}}}/>~_$)%,_.......+2}::<_-<-._.~!$3+..............-[||)/}))::1})]]]]])4/''}}*]]|}11='//|&^$(;",
  "<2%[|1**!.~[%%$-_.{]]]%,_............._......._,<>]]]]]]<_._%}**||1})='/43.~]<..._%]]]]]}}]|]}==41**:||)|~~<>>3_...~24}}}4<.~2_.._[)})|||]]}/}4>~.+3_......{***)=''[,_.+-,++~+_...~<]]~~>]!..,}''''1**]||*4&,..+,!<<3-+_..._{>:}}]]]}===1*)]]$_~<%]$-~+..._{*}}}}/})$+~![|<-~+....{}:}|,_2)>$~.._~#<,............,[]||1''/}:}))]]]]]]}'''':}*||**:)4/'}|[%$!;",
  "(^%[|*}*2_.-<!+..!|))]]|<-_................_~!%>])]]]44'42~_[)]1/}}]/}/=43.+!-..._%]>>|]]]]]:}:}:*]|***]'<_.+~~...+2:}}}//<.~2_.._%]4)*]||])/}}]{.._......+[****://4]!+....._..._-[)]>~~>]<._3'''''4*|1//}]/)$~.._._+~+_..~<>|]]]]]:}:4:*]|]])!_.+~~__+...-|}}}//'/:]!_.+~~___...-]=}:%_-]]**&!~..._+_.........+{|)]})*}):]]|||]]]]4'=''''}1]14=}|/4//}|&^$(;",
  "($^&>]}']3_...._{]:}*)||]>${~___.......~33<%>]]]]]]])''4'4[!>}}/'''/4////3._....._[]>>]]]]]]]]***)]])*)}//<+._...-^:::}}}'<._+..._%}*)||||]}:}/:%~......._<))||]14'}:)[{+..._+~32]]])>~~>]<..3''''44}//''''/'4|<-+.._.__~!&>>]]]]]]]]1**)])})])$-_.......,[::}}}}'41})$-_.......,[:://!.{*]*}*4[!3+........._~3%)***:}}:}}]]]|])]])''''''}4}1/''''/////][^$!;",
  "<^^[&]}'4|<333{24=/==)||>]4'>%%%<-..+{$&:::)]])]]]]]4''44)44:}}//''/////4%<<<<<<<<>]>>>>]]]]]*]]]])}*)*)'''%<<<<<>:}}:}}}/[{-+__+,>=)*||||||]4')]2,+___+,$]=)|>>|='}:]]}&$<<2[]):):]]>-~>]<..3///4/1}4/'''/}/44/:&$<<<<%>4]>>>>]]]]]|]]]]))*}*)')%<<<!<<$:}}}}}}}/}/}))>2<<<<<<$>]]]/'3.<:}***/'})>$!!!<<<<<2>)::****)1::}]]]]]]]]4/''4'4'}}}//''//4///|&%$(;",
  "$$%[&|1=)|]:)])4='4)=)|>||144)):)<._2]::}}*)]]]]]]]:4''4]]4''//}1=}}/4444])]4]]):44]]>>>>]]]1)]||])])]*}='=4|]||]::/}}}}}4::]>%%%|]:*||)]|]|]=/}|]|>%%%[)/)})|>|]}})1**))]]|]}:::}]]]>~~>]<..34]]:''//1111://///:):::)])44]]>>>>|]]1)]||]]])]*4=''4***]]::4}}}}}}}}}/*|]]|)]>|]|]||]//3.<}:*14/'=4)]]|||:':]*]*}}***}}:1*)]]}]]]]14''4]]4'/'/}1/}}//}//*[^$!;",
  "$$%%>|)}]]]:4**:*=4))*|||]1*}*]**<.+&*}::**]]4))]])4/'4:]|}'''''1}}}//11}::4:]]]):]]]]>>]|]]}1))|||||||)=/==|)***}}}}}}}}}/4':]]]||||1*1)|||]):]|]}}**::4=)**|||]1}:***:}})**}}}**]])]~~>:<._3:]]}''''//}}///4}}::::]]]):]]|]>>]|]]}1))|||||||*===1])**11}}}}}}}}/}'}*||]|]|]])*|||]):3.!}1**)*/}))*|||]*:}***:*1|**:}:1|*])})]])4/4}}||:''''/}}}}//}}}|&^$#;",
  "(2%[&]]:]]:}1*}}})1)*])|]||]**1*4<..$**}**|*]:}:|]4}:**}]]:''/111}////}}1:**))]]::]]]]]]|:]]44}]]]|||||*===***}11::}}}}/}/}14)1]||]|)|))*|]*]1}]:}:}}4}11)))))|*|||11*:=/*****:**)*]4]~~>4<..~>]|}''/111}//4/}}1*}:)]]]::]|]]]]]:]]44}]]]||||||==1****1*:1}}}}////}}:1]||]|)*))|]|]]}:3.3*}*}}}))1)])|]]]]:**:=/)****:1|1|]}}}||14:1}*]]1'//111}////}**|[%$(;",
  "$$%[|]]::}::}}}/1]*)*)**]]|]**:/'<..{)*1***|]}}:]|]}4}:}*]1/}|||]***/}:*|]*1:)]]4:]]]]]:]]]|11*)]]]|||||====**}}}*:}}}}////}}:***|***1))*|*)]*:::1:}}}}*)*****|)]]]**1/'/*|*******|]:]~~>][___<4]1'}]|||**1}1:*]|11:}]]::]]]]]]]]]|11)1]])||)||==1=*14=}*::}}}////41:***|||*1))***)]::{.,]41/}**))*|)*||||11}/'=}|*11*1|)|])}}*|]}4:}}*]}'}]|||***/}}*]&[%$!;",
  "($%&||]}}}}}}/'})|*)***|||11**}/'<..3***1*|]|:}}||]}'4}44}}4'/||*}1]}}1]*|]*4:):4}**|]]:*]]]*)}1*))]|]*}=11=|}//}11*}}}////}}1**}})*)*)*|)11*]}}}:}}/'/)|*))***||*****4'4}|**11*|||]}]~+&][+..->*}}'}||141|}}*]|]|*4))}44::||]*:]]**)1)))]]||*}===1|*/'}}11}}/}}}/}}}11}}}}*)1)||1**]42_~>}/'=}||))***|*11]**4'/*|****)1|]|}}:]|]}'4:44::4'1]|1}1]}}*|]|[$$(;",
  "$2%[||:*||:1}/'/=)**))*)|2<)*1'''<._<***}*>}}}:]]]}/'/}1::4'}}|||**|*|||]|**}:}*:*]|||]*1*]]|]=/4)}))**)/=11|4''/*]]]}}::}/}}*1***|*******)*}:*|]**=''/=)**))*]|**}*='''}}1]|*1}*=1)4|-_%)]-...{|4'/}|||**|1||*|]**}}::**]]||]*1*]]|]=/4))))*)*}==1|)''/*]]]:}}4}/}}*****|*)***)|111*1|,.</'''=*^#{&])|*)=|='''4}1||1**1==:}}|]|41''}1}}}'/1|||**]*|*||&&%$(;",
  "($%&|**1]]*)|>''=******%3_.,$>=//<.~|111&{~32]1|||]:'/:**}}//}1**]1*1]]]|***:}**]***||*1:/1*|*)/:})}*|*1}=1*]*//:****}}]]*}}*||*1**1*****|*}}}1*|**4/''=1*|****)1)=>${$//111111==1=1*|~.!|:!..._<}//}1]*]11***|]|**::*1***|]|*1:/:*|*)/*}}}****}})**}}/:****}}]|*}}*|**)***1****)*)}4:|2+~[''='<_._3***))=|*=///11111==111***]|||}'/}**:}//}1]]]****|]]>[^$!;",
  "$$%&>|*||||$~~{^|>>[2<,+...._-#%|{.+$|%!~_.._-333,333333,3$:/}}*||1**11*]1**:}**]**}**|*}/**||:1:***)|*]))**]**1111**}1|||:}*||]**|1*|*****:**]|||1=/=4)**|****|)=){.._<=///}/}1=)*1*|,.~[:[~...+[:/}}*||*:***|*1**}}|****1**|*}/1*||:}:***|*)*11*]|***1**11}*]||::]||************:*}]||{_-^4)|-..._%)*14=>**1/////}/}===1**|*|||1/}:*]*}}/}}1|**}***]||[%$(;",
  "$$%[|*1}11]-..._~~~~_.._......._~_.._~_...~+._.........._.~]//}:*]*41*****11/**||||**|||])}1|*}:*|**|*|*)**|||]|]*:}]**|>]1:|>|***))*1|***|}}}*111)'/))*|))*)|)1))>~..._2///}111*==*::<_.{]'2+...<}/}/:]]*}::}1**11}**|||*]*|||]:)1|*}:*|**||*|*)*|]|]|]*}:|11|>|11||>****)**|**|*141::)|-._{[2+..._[||)='|*>*}'///}*1***1111|||]|'}}1*}}}}//**]*}:1111|[^$(;",
  "$^%[&]}}}}]-.._-,3,3-~_.......__...._~+_.._.........._____{}}//}||}}}}}}:::*//1||||||]||**|)****|||||)***||]|]]**}*|>|||||*}*||1*111*)11*||1}//})**:/}**|*|)*|||)=>+....,:11*****11}}4],._!'/!..~&:}//}|]}}}}}}***1//)||||||]||**|***1*|||||**|*|*|]|**1:1]>|||||**|||***11**11)||1}//}:4[-..+~....->||)==**|*=/}111**1*=1))}1]|]*'/}}}}}}}//}|]*}}}111|[%$(;",
  "($%[>|}'=})$33$|)||||&^!~...+3$<_...{[|<3_.._~,<<!<<<^%%[%|}}}}:11}}}///}}11/4*1||||||||***|***||>&||****|)|||**}:|]>|]||*})*|**)***1**)*|]|4/'4/}*)}1)*||**)||*)/=3....,1**|*|*1==*}}:[-.+{%<._<}}}}}111}}}///}4}*//**||||||||***|***||>>||*11*||||***}}]|&|]||*}}1|*1****1****|||}/'}/})&,......_<|]|*'=**1=}/=**|**|1==1}}:|*]*'/}}}}}}}}}**1}}}}}}1|&^$!;",
  "$^%&||}41}*]))*1))|))])*&{~3%]}!._..~-%*]2<<^]*:*||]4/4:4:::}}***}}}/}'//}**1*|1|||]||||}}*|||]||||||*1**||1*|1}}}|||||||}}*1||1****1|**1|**:}}}:1**)1*1*|*)*|**14*&!-..!//==1*|*=/:}}:]%-.__+.3]}}}}***}}}}}'//}**:1**|||*|||*1}**||]||>>|||)*)||*]]1:}*]|||||]}:*1||11****|)11]**:}}::*]}]<3~~~,$]|)*1)=1=1=/}///1*1**141}}}|||]1}1:*:}:}:*1*}}}//'}}|[%$(;",
  "($[[|*}**|]|**)=1*1|***}}}|*]=]-.<,...,|1*=}1*}}||||***]||]]}:|]}}/}}'///}}*||)]**)***1}}=}1||||>>|****}*|)|:1*:1}*]|*|]*}}|*]|*1*1**|**)11}}*1*]||**)=*)*|*|1)1**)|1|-_^'/'1111*1/1}}}]|%-.._+%]]]}*]]*}/}/''//}}*|||*)*1|**1*}=}*>|||>||))1}}*||****}*}||]|]*|}}]*]|*)***1|**|11}1*11|||**}*||>||*)11*1*|1=''/''/==***==*:1}||||***]]]]]}}]]*}/}/''//|&^$#;",
  "$$%&&||]]*1***:*1*||*****)}}|/$.+&3_{_.#11}}}}}]|>|*}}}}}11}|*|**}}/}}}}}}}:|*1*|*11)*}=4=})1*|**|**>)*==}}*]]|}}}}}:1|]|*}||)|]|*11)**||]||]]||*111*:111||)******/]}&~+|''''=1==41*}}|||][~._<}**}]||1*}}/}}}}}}41]****|)=**}=4==}**|*|***>**=//}*|]|}}/4*}*|*|1*||*||*111)**||]|]|]]*11***:*:1|])*****1=|//11//'''=1=1}/}}}*||*1}}}11*1}]]|11}}/}}}}1|[^$#;",
  "($%[&|]*****11}})*)|*11**|*}}%+.,)3+%!__<*1=:}1*||*}/}}}}:}}}*1:}4}}}:::::}1)*)****}**)}1:)1|**||||***)//=}1||1:}}}:|]||1}}1*|||)*))1*1|||1]||111***1}))|*|**1**|*}*4!.,==='===***=}}}*||]>~.{*:}}}111:}}}}}:::::}:|)1*|11)***}1:)***)|||*|**)'=/*1*|1:}}}}]||]**}1*|]*|***1**)||1|*|*****1*}}*])||11**|*4141*1='='/==*1*1:}}*|||:/}}}:}}1*1*::}}}}1}11|&%$(;",
  "$$[[>||11*}::::1*11**)1*1*}}&-.+2}3_%|3_+2**:}}|%&:}//}:}:}/}}}:*}}}11}*}}:*|*11**)1****}}*1*)**)***11::4*:1}:*:}}}}|]|]*)}:1)]]1*1*1*]]]||*]*))):*::}111**1)1*11)}1[~.{=====******:}4*||%3.->::}}}}}}:}}}}11}*}1}}||11]*1})***}}1*********11*}4})*}:1:}}:1*]|]*:})*]]]**}*1*|]]]]]]*:}}}*}::}1*1***)*1*1}111|1=====***11*:}}*|]*}//}1::}/}}}}}:}}**}*1|[^$#;",
  "(^%&>|1::}*}}1}***)2!#%***)>3__!1=,_%)|3.-[1}}>-+~2}'/}1*}/'//}1}:}}]*:}**1}}*****==***})=})***|****=:****1:}}}}}}:**|]||*:}:*]**1)}*||**]*]1:}}}}}1}*))1)1**)***}1],..-3333333333333333,+.+%}}*:}'//}}::}}|**1***}}}*)1*4=***})}))****|)1*=)****}:}}:}}}1*]|||]1:}}1]**1)}*|]1*]||111)**}:11)*)1*1*1**1)}}1|1===|****1**1}}}}**1}'/}:11/'}/}::}}}]]111|[%$(;",
  "$$%[>|1}:}:*:}}**}|~..,*1*2~._!*/1-.<*1>-.-[}}$.._{}}}}*:}/''/}}}}:}*1:::*:}///=//4=*1}=/}=}***1)*1)}1****}}/}*}}}}:11*]|***:}]]]***)*|11]||1:***::*}}**=/*111}*)}/!_.................._...<:}1}}/''//}}::}*}:1}1*}//=/==4=*}}=///}***1)*1)}1)***1}/}:}}}}*111||]***)]]]**1)||1*)]|*:}}}:}:}}*11=*1)11*)}}/1|*=/==**1=1}*1}}}}1:}}}}}*:}/''//}1:*}1:*1]|&^$(;",
  "(^%[>||*1]**}/=14/[+..~|*<+._!*}'^_.{1*1&,.~!%,...{}//}}}}'''''}*:}}*:}}}}4/''=/4'=/}4//4//=1*====//*:**}:*}//}:}}}}:*}1*]|1}*]]*1}}]]*]]]]]|1*1]1*}//1*'=})}}*}14$+......................,*}}}}}'''''}*}}}*:}}}}4'''=4/'/=}4///===1*=/===/*:****:}//1:}}}}:::}*||*}}]]*}}:]*]]]]|]]1**]**14=1*'/})=})}/}=111/'/==***1}}11}}}}}}}}//}}}}'''''}}:}1*1}11|&[$(;",
  "<^%[&|||||]**4/}}'|~...,,_.~$}1/*-..+2**=|{_.+..._24}}}}}/'''''/}**}}}''//''''41}//)1}==/==4=/4'''''//=}////}}}*1}}}}}}:*]**}***::::]]|]|||||]]||]**/'41''}:}4}}}<+.__________________...~[}}}}}/'''''/}:}}}}''}/''''=)=//:1}4////}=//'''''///////4/}}1:}}}}}}:1]1::}1***}:]]|||*||||]|||*1/'4}''}:}}}}}/'/11=//=1**1*=11*}}}}//}}}}}}}/'''''}}:}}:}'/1|&[$(;",
  "(^%&>||]||||*/':}'/<-___+-#>/=1/!_...~$**1:^,+_++#**}}}//''''''}}}}}:1'''/''')1}}/41**)}4:)}=/'''''''''''//}/}}}}/}}}}}}*|*}:}}1}}}1|]]|]**|]|||||]*4/1:'/*}}//|!_+!%%[[%%^%^^%%%%%[%$+.+24}}}//'''''/}}}}}:}'''/'''}}}4/41**1)4:)}'='''''''''''///}}}*}}4}}}}}*|*}1:)}}4:}|]]*]]*||]||*|]*}/1*'}*}}//}//'/11//=*=**|**111}}}}}}}:}}}//'''''/}}}}}}}''/1&&$(;",
  "$^%[>>||]|]||*}}}:}1|[%[>|)'///<_.....~2**|}:[[[|''':}::}/''''//4}}]}}}/4''''//=////1}*1}}//)=}/''''//}/4/4**1111=/}111==1}1:}}11}}]]]}1:]]||||]||||*}}}*}=}/*}{..<'///1|*|**|****1})!._!/':*:}//'''''/}}}]}}4/4''''}/}////111*}}/})}}/'''///4///}111}===//==1=/:}*}}}1111]]]:1*]]]>|||]|||:4}}1}=//:}/*}/////1|*||****|*1*}}/}/''}*:://'''''/4}1]:}4/}]&[$(;",
  "(^%[>||*||||]1}:11}/=1==4=/}/'2+.......3||*1/}::4}:}}*1*}//'}'}}}}}}:}}4}//'//4/////11/1}}}4}=='''''//}1=111}*1111=411=1=:1:1::**:*]]]]:}]]]|]*||*|*1:}*1=}/1=}{_+,{{{3{{3{33{3{33333++<1}}1}**:}/'/'}}}}}}:}141//'////////111=}}4=}=/'''''/}}1}}1***1*11/}**=1=1*:*}:**}*]]]]:}]]]]|*]|||***}11=4/1==4}=//'/=1*|**|**|*|*}}}:}}}}:}1**//'/'/}}}}}}1141|&%$(;",
  "<^%[|||****|**1**1/41)}'//=}//^~.......{1*1*/}**:}}:}*1*:///44}}}}}'1}}}::1}}}::}/1=///4/}1:*1/'''''/}}*}1}}=111/*1*||**}:}}}}:]11*]]]|]:]]:]]**|*|*1*1**//**='>[[[[[[[%%^%[%%%%[[[[%%%:}}::1**}}/}4}}}}4}'*:}}*:1}4}}:1=1=='/}/}}:**/'''''/}}*1)}}=11*/**1||**:}}}:1:]*1*|]|]]*]]*:]|**]|11****/4**='//}///1}11|*==**1111/:11:}}1::1**//}4}}}}4}'}}}}}|[%$(;",
  "(^%&||]]]|]1}***1)1=|*=''/1=14*2-....~{[1}*14*1*/''':}***:}}/4'44''']:**1]]}}}1111/1/=///}*||*=='=//}}}1):}11=11111*****|*1:::1||*1]|||]]]]}]]]|]]*:*:*1*==)*=''}1=)}*)1=))')))}4**4:)1}'''}:*1*}}}'4'44''']}1:}]]1}}*111/1//}//}*||1=='=//=}}}:1}}1=//111*******}11:}||*1:|]|]]]]}]]]|]|***:***==**=''/==}}111=*===*11111}1**/'''}1*1*11}'4'}4''4]}}}1&&^$(;",
  "(^%[>|]*]|]*}}1***1=*|1=/=***]|*&<<<$[)*///}1*|*/'''}:11*:}}4/'//}}:]*}:1**:}}}}////11/1}}*|||1=///}})}}}:}1}////}1*|||**]*1*)*]|||*]|>||]]]:**||]1}1**1**=||1===)**]|*}==='=**}//}1*]1/'''/}***:}}4}'}/}}}|*}:***1}}}}////1//1}:*|||1=///:1:}}}*}1/1///}**||||*******]||]*||>||]]]:**|*]*}1111**=*|1=/=***||11=1=/=|*///}**]*/'''}:*1*:}}4/'11}}}]]}:1&[%$(;",
  "$$%[>]**]]||}********|*=/*****]*}4}4'}***}}/**11}//}}}**1}:}}}/::**||1:}:11}///'''/'=1*1}:]|]***11***1}/}1:*////}**|*|*|*||||*|>||||||>|*]||]:}:]||}1}**|***|*==1*1****}//='1|*1}}/11**}//1}:*1*1:}}//}:1||]*:}}1::}//'''//=1*1}}||]***11:**1}/}}:*}/}/}****|**|||]|*|>||||]|>]*|]|]}}]]|]}1)**|1**|*=/*******1==='1***:}}1***}//1}}***}}}}}/}}1]||*}]}|&^$(;",
  "(^%[&|111111}}11*|1*1|*==1=//1]*}///'=)*||:/1}*1*]]]1}***}}}///}1]*]*}}/:**}///''''///1*/}}|*11***:}::}}}}*}/4}}}1|*|*|||||||||>>|]|||]||]||1::}1**:*}*1**11**=111==:]*4}///=)||]*/*1***]]|}}*1*}}}///}**]|*1}/:1}}//'''''///1*//}|*1****}::*}}}}*}//}}}1||||*||||||||>>|||||||*|]|*:}*11*:1**1|**1|*==1=//*]*1}///=**||}/}}}**]]]1}**1]}}/}}:*]]]*1}}1>[%$(;",
  "$$%[>|:}}))**1*********11//'/:*://})//)*||1':}/}1*|]'/1**:}}'''}}**1:}}/}*1*/'/'/'''/111//}}}:*1]11*}}:}:*}**=::)||||*|*)|||||)|||]]*]|*1*|]*}}}:}**=*1||****|1==/'/}1://41'/})||}'}}//1*]]'/***:}}'''}/:*1}}}41**:/'//''''/111}/}}::}1]1:}}}:}:*}**=**:|*|*||*)||]||)|||)|)|]*:|||*}}4:***111|******11//'/}**//}1//}|||:':}//1*|]'/}**}}}'''//***1}//1|[^$(;",
  "$$%[||:}*****11**|111*1*='/''/1*:}*|:}*)4://///111}}/}}**:/''//''/}'//}}}:}*///'''''///1}/}}}}*}''/}:}:***}:/=///=1)|*|)|||]||)||||)|)]***|**}}1*11|1111|1111**='''/}1*}]*|))1)})}}///}*111'/:*1*/''//''/}'}/}}*:1*///'''''////}/}/}*:}/'/}:}:1**}}}////}1*|*|)||>]||)|||)*]*]*1]*1*}}1*11**11*|111*1*='''//1*}}*|))})}}///}/}*}}}'}}**1}'''/''//'}}}}1|&^$(;",
  "(^%&>]}:11*1**1=***1=1*1/='''/:1}}1]}*)1*///::}}}}}}'/*11}}/'////}}'}}}*:}}}//'///'///|[[>/=}4/4''/}1}}}1}:}}//}/)1**|**)|]|||>>>|))||]*****}}*****1111*1*1111*'='''=*1[#||}*)=:///::}}}}}}'/11*}}}'//}/}}'}}}:}1}}*^!^//'///11}}/////4''}}}}}:1}::/=/}}=***)**))||)|>>>|])||***1|]}*1*1***11111*1=1*1=='''/:*}})]}*)=[!]/:}}}}}}}'/:**://'/}}/}}'}}}}1|&%$(;",
  "<^%[&|**|***111=1*1=/11}=/==/=*}}41*)==/=44/**:}}}}}/}***1}///4//1}}}}}}}}}1}//'//'/&#-++$4=//=}''/}}}}}}/=/1=/}|11))))*)*)*|||>>>|)*|**:1***1*]****1=/**1=}111=/=/'/)^-{4*111=////1*:}}}}}/}***1}/4/}}/}}/}}1}}}}|{3(~1///'//*}}/4=///''/}}}}}}///}//}}1)1)*)*|)*||||>>>|*)|***11*1**|****1=1**1//1*}//=='/}:}/}*}=/&-{//**:}}}}}/}1**1}1//}//:}/}}1}}|[^$(;",
  "$$[&>|*****1*1//11}/}}:=////=}}}//}}11//}///}}}*}1::}}***:}/}}/}}}}//}}}}/}1///'//&;,!-.{:}=}:4}}}}}}1}}}=4/=}}2<)1=*)****|)|))))))|***1*|*|*]**|***1/=}14/=})1=/===*2+_^=})==/4///:}11:}}*}:***:}/=4///}}///}}//}!+,-~|//////1}}}/::}4}}}}}}}}}///=141)1)=))*|***)|)))))]|***1))*|]***|*111/=11}/}}}===//=}:}//}}:)$-_%}/}}}1*1:*}}*1*:]<>}/}}}}//}11/|&%$(;",
  "(^%[&||**|***1}}}}4//}}====/1*:1'///11//==4//}}**11****1*}/'/}/'////'//'}/}1/////$-{&*-_2}4}**}*:::*:::::}:*=*$~2)11*******||)))*|)|**|1)**||*******141}1}//}}=1%[/=[{+~)'/1}4=44/=}}:***1*1*1**}/'//////////////[~{%<[//'////1}}}/***1}:::*1:::4)*=111*11)1****|)|*|))**)||*|*|***|*)**|**14}}}}//}}==/==11}1'///*>{+~)/}}}:1*11****1*[3,///'/}//'////1&%$(;",
  "$$%[&>*)|1|=*:1}1}}/4}*===11111///'41=4////1}}*******11*1}/'///////}//'///1////1!,%11[_~>///|1*}}}}}}1**}1}}1!_~>1})**|*|***1*))|)|*||*|**>**|)*|*=*:*}}}}/4}}1%~-**)2.{///*=====4}/}11*****1*11}///'[^/}}}'/'/}}<_$////////111}4/}]1*:*}11}:1*}*}}1==111)**|****1***)*)||*|||**|||*|)*|*=*:1}}}}/}}*===11*1*///'/}/&+{=4=/}**********],.<'/////}}//'/1|&%$(;",
  "(^[[&**=)*)=1***:}}}1111111)==1////=*=/44===:****:}****:}}//'////'////''/}}11/|{@&//}<.3}}}/|**::::}:|1*:}}}=!.{**11|****>**)1*)>|>>*||****&*)=1|)=*11*)}411|1)13-*=1{.$'/11=///==/:**]|:}****:}}///<+_^'///'''/*,+|///////1*1///=/|11}*:*|}:1*}}}}=1/1*11*********1)*>>||)**|)**||**=)*)=**1*:}}:|11111*===1////*1}<.$=1=*1]|*:}*1**1},+[/'///'11/''//|&^$(;",
  "$^%&&|*******11}1*1***1111/=*11////}/14==/1*1]|1*1*}}}}}}}//'//'/}///'/}}&<33--~&}/}13.</=}1]1}1**|<#33!|}}|$-_321*2$=)23-!|=11|<{--{&****%#**[{-3^1**}1*|$!3{#2-$/*|~~>[{-3^4///1**2{,-3$*}}}[<<%}:{-_2///'//}%!+~<|////|(3-3<*}4*|<2:]<,-<1}}}}}}}14*$[1=$<<%)1==*^{,-3^|*****|[$|*>$<<>1|<[1|<,-$*11}/=*11/*$3-{&,~>/=*|$3-{[*}}}}%!+~<>///&!,,$///1&&[$(;",
  "(^%&&*********1//11*111=}}//1}///////1}/4/}*11*}}}**}}}}}}}//////}}////1<-{^]{~~-%/}>~+[4}}1|**11%,!%2$+#)}>!+~<21$+~^!,{~.$412,~--_.-&*=[~_^$~~+_~&11//2-3&2<-+!)=}%_,<-~~_~24/=}&!~--~__<*}}2_+^//|!+>}}}''/}^,.{<|//|<--,~._3|}*#_-%33{++&::})*:}&!,{|1)#.-%)}}>3~-,~_~$**=*$,~$)*&~.3||{_3&{,{_~&=}/}/1}/2,32[3~+,:/}2{2[2~->*}}}%{_-<&}/<(%%{+<//1|&%$(;",
  "$^[&>|****|1|1}///11111}////}}//''/'}1}///}*]*://}}}}}}}}///}//////1///!_!1}2-[[3-%/2_-|1}}}**:4%~$]<+3_!4:)%_3**)[~.~{&>,+2)!-!&)>2~.3*=|,.,,2>2~.<*}}<~!*)[{3_,//}!.-3[}|-.3}//[,3[*}|3.+%}}:~~]}4[~!}/1/////*,+[///|;-$]1|(__<})2+_~!)[-~>}}:4}})>~->1*){.211}%,3[||[3.~&*==2+!*11|~~&**2+_-!][+-|}///}}}2-<}/'>~.</}:-!{[/%+#}}}}}!.$/}}%-<3}13~[/1&&%$(;",
  "$^%&||***|*1*}}//}1*111}}///}}//////11}///}**|1/'}//}/}}}}/''//'}/////1-+<^>-<}4],-|{.!*1}}4*}}/{~>|!~~,|)}}!.$|*11!.#))#-!*<,%||1**$_+[)=#.,||)|!.3}/[+,|1=}})~~>/},.,:///!.~]/|,!||}/'],_!/}*-~:/>-{|///////}&+-11/1{{|**1*]#.3}}*-_!*>3-<::}::*}:[,%)11|~~|))[-!))))*>,_$)1)!,*1))%+,)*11,_21>3-^11}///}%~<////*-+['/]~~+2}},-|}/}}-~>''/<+~,}1^+#/1|&%$(;",
  "(^%&|*1*|1|*}}/4:**1=111}}}}}}}////':1}//'/1***}//}}///}}}}/'}}1/1///}]-_-&!-]/'/2+<-_^**}}}}*}]-_{^]>|]]]]],+[1**),~>1)]]=[-%)1)***>-.$=4,_2*1**<.!}'{_$*1=11&+~>4&++[///'%_,}/{!1***}/}$.{/}:3~|&-{:/1/1///}}$_{11'<-]}}1:*)[+~|4>~+&})||)}:]]]]]&-<1)*4%+3*})3<}}}1***!.{*)^-[=1*1<.$**)>~,****1*114///*,,}///'>~-1/'}^<{!#^<+&/}/[+,}/''|<!!#<[~3/1&&%$(;",
  "$^[&|&11*))*}}}}***1*1**}}}}//1/}///}}}//'/}***/////'}/}}}//''/1/}/'///&%>&~<'/''/,-_->*:}}/}}}){+._-<[]]]][+,])=}>+,)1*)}}{{))1*1*1*!_%=>+~>***|!.$:1-+&**11*<_{14$_{1:///2_{}^->}***//}>~{4/}!_!,{*//1//1''//3_211>-$'/}*=**},-|/2_3:}:)))1]]]]]|3->4}}/!_$)*^,]}1)1*}:2_!1&-{)11*|,+[)142_!***111***}}}$+24:}//%_!//'/%,-33~-_['/'<.<////*!-33,~_3/1|&^$(;",
  "$^[&|****1**:}*11*1*1**11}}}=1=11//}}}}//'///}}//}}}''/}}}//////1/}1''}//*!-]//'/}<..{*=}}/}}}}4]2!,+.~2]]]<_!:}:*2_<=*|*)&~<===}}1*1!+>4$_{1*1}1,~>})-~|&!2:[~~%}:3_21=}/:<.$}33///14//=>+</}:$.~<}//1//}//'}]-+&1}!_[//}/****,3//{.<}:}::):)]]]]2+<)*}}},+[*|,3}))=4/}/%_$*!+[111*&+,**|*{_^**1*****}}}|-~>==//}!_2/''2~!&44%~_['}},+[///]{-^1}}#.{11&&^$(;",
  "$^%&&*11****|***1***|*|]1}}:})**|*}}}}}//'''}}}4'}//'/}}}}///11////'/////|-!///1}}2__2:1}///}}*]&>]]%-.,]]}3_^]4}}{_%41*])2+^=44}})**3-}/{.$))):[~!|:4$+$3~[^-~2:}>~~|]*):|-~>|~<''}}}/'/%_2//|!.-*}1/1///'///^_3}1/3~|}}*:11:>~#4:-+[}:1*14:1]]]]3~>]:*}[+,1}|~!1}}==}}/^~[|-3=*11:$_<)1*|-~|1**1|*|]*:}[_,*]**:*,-|/'[~!]:}/',~|'/&+,://*{~&4}}'%_(/1|&^$(;",
  "(^[&||]*)***}1}}}1**1|||::}*)***}}}}}}11////::''11/}:}'/}}/'////////////1$~&11111*2_~>=4}1}}}:23+~{>'2_,]]>~~>}*}>-~>})*|)<_^)11*:1*&~<4|-+&***]!~[:**)<-+--~{[}::2_3|**}}^+!:&+<//:1'')){-|/]{,++&//}/}/////}{.<}/]-~|}:1}|:}$+%}%+,::}:}:}4:}:][+-|}14)<_!4)[+!::::::)]{3*<.$//**)3+[**]^+31}1**1|||}4:2_!**:}}&+3*11,+>}}'':,-*}4$_!}}'^_!}}///%_$11|&%$(;",
  "$^%&&|||**|**1}}/}1*]]**1:111*|}}}}}**1111//1*/'**}/}}/}}:1}//}}/////}}'/3-]*11**1<.,:}}**141[-{<~_[)%+<))%_3:}}=%_3=)=)|]{.!::*1*1]<,|:%_3]*||%~<}*/}4*{!^%%)*1}}#_$]})}|-~>*[_,*/**4'*%~$]|{3|,.<}////1/////-+[//|~+%1**}}}|-{}=<.<:*}::]*}:})42_3):}/}3+%)=%+,**1}1*1%~2]!_%4111>~-]|)1!_<//}**|**|*::<.#)1}}}!_$*1[+-:*1/'%+{41:3_%}:}{_2///}}{+[//1[%$(;",
  "(^%&>|||*|1*}///4}***1***1)})***:}}}}}}1/11:*|}/**}}}::::}:1/1///1/1//'/*-{=/1*1}*3.<}}}:*11]{!)[~3]]!-|})<.$*}/:!_<)=)||]<.~[11*]|2-%|*!.<1|||,3]1}/}[,~3,!2)**)>~+[**14{+<}}>+_$**]}/|,!:){-|:$.,}///}//1/'%+-*//13.#*1}*|4{{|*|,_%}}:}}1]]:):)<.3}}/:2+-|=)[+_$}::*1[-!|],_<*1*|!_3***|,+&}4}1*1**1**:<.-|*:4^~_%}1<_,**|4]3.$}}|~-]:}>~_2/}}/2+~1//&&^((;",
  "$$%&&|*|**1*/}}/1**||}1**1}=)**1:}}}//}}11=1]|:}}}}}}}}}}}:*1//}/1/}////&+<///111|-+%|}'/*||]3242<[)<-2)}:3_2)4/*-+[4)**|]&~_3%||>!3^)*|-+%}1|!32&1}/$~,<2!,+3|:|!.~>))|!+<:/}},.~$&||23<:}!~%:}&+~[}///}/}1/<.!11=/^+_![|>2{{)=*[+-|:1:]]})})}}:2_~%/|<~.{)))],.~$|*|$-<]*1#.,[][{~.-|1*[~-1/1**|*}:1}1}%_.{[><,+_$:/$_+!&&23~_%:}%_,*}}]-_-%*&!-.,1//1&%$(;",
  "($%&|*****]|4//}}*|||*4//:::)**]}}}}/}}11*11|1}}}}}:}}:}}/}}111///11*1==2+%}/1*|[{++%]}/1**|]<-<%%%{,%::)43.{*=/2+~&*)*||})2+.+-,-,[:}:<+~[)4<+~~[|=/%2|1]||,_</%+--3$<,+<}//}/&-._~,--$:42+-]}4[~_{*}///11||,_^////:{..~--~{]/4]#+-]}:]]::**}:)}>-.+,-,,_$)))|[-._~3~-<|*})%+.~,-{$_-&*|3_,1}}*|||*//}:)]3__++-23_$/}]-._+++!-_%4}[_+%}}*$_.+~+-3_,1==&&%$(;",
  "$$%&&]1)1*1|}=}:11||||}=/=}**||*:}//'//}}11}]**:}}1}}}}/}/}}1}/1111*|***<_[/'/1/&2%<[]|**1)*]><{3{32]4::*}${[44*^[$[))*|))}1%{3,32|=*/]$2$[}122$!)]*>|4**||]!.{')!%[333{[}}//}}4[!333!>:}[~~#]/}[$^$|1}1111*%+,*/}///]<333#%|]**[2%<>41]}}4'}1::)*2333$>~->**||][!333<&))*=:1<3,32)>{%))&$%2|)*1|||]:///:}|!33![4%^4}}/>#33!2>22&:}|{<4}}}*233{<|%$$*111&%$(;",
  "($%&||*14/)1:**1**1*|]*)//}})**|*}/}////}1=}*}:1}}]:*}}//}}}}11111111***3_</'//''''']|*|1*=44)]]4)444/}}))))}*=/44)]**|**})]]*)1)]*1}11]*)}*)})4/)|{~,>*11||!_<='=4))])}:}/'//}141}*4}*}4{3%4}}/:4}:11111=1*<+211//'//''''']]]|1144'4]]*::/=/:})}:::)'4$_!]**))14})]))****1}1**}}/)}4:4/))}**11**|]|*}=//))]|]*4/'/}/}}4}}*}:*:4]}:}}//}}}}*}1*1111*1|11&%$(;",
  "$^%&||**}//}11***1*1||]])=/=}]||*}//////////*}**}*]1]*//}}}}}}11*1*1****,.-['/}/''/]]]***}=4'44])4)=):*}}}4})*/'/=**|)***=}*)|******11)1*1}1)1*}//2~{,&*1**%++%)4=/))||*}///'////}/*}*1}*<>]}/}}}:}}}11***1|-,|*=//////''4]||***==4/}:]}4444}:1)}}/:*/4,~&*|**|1}**|*|*|*)*}}***1}**11}//}1=*::=1*|||]:/=/1]||*}//'//}////*}*1}1]1]}}}}}:}}}11*1*1***|1&&%$(;",
  "(^[&||**}/}1}===411*)1==/}4=}=**1:}}}}*}}}1*11*}*1]|}}}}}}}}1}}*1*11///*~-$*//}}:1}}]*:*}=/=44))])4'//}:::}/}1*11*)**11*}}**)==*=1*=1==11**)1|*4/4!,/*=4}=[-_<4=}//==**1}}}}1}}/}=*1**:*:]|}}'//}//*}1***1|#~^}/}/}}/}}}114]}:)}///44}}]*4/}}1:*:][%*}<+<)|)**})}}1)=====*11=1=***11|*}/}1}1==}}11*}/=/:/)4=**1}}}}11}}/}****:**||}}//////}11*1*11=1==1|&%$(;",
  "$$%&>*11}}}11111}=11=4//41)}'=*]1}}}}}}//}=1***}}}||}}///}}}}:}*1::111=|$>}:}1}}**:}}}}:}//=4))]]}4'4)44///):********)}=4=}**)=*==)=*==*=1=1111}/4<-%|11>$~~!=/=::}'})|*:}}/}}//}11*1*}}:]|}}//'}}}}:}1}*$~+</:/:/}:1}:***}}}1::/==}:)]]*4'4)44//!+$>!-!)1|1}1===}}))1=1===*=1=1=1}1*14}}1=1*1}=*1=4///}}1'=*|*:}}/}}//}/=1**}}}||}}///}}}}:}*1::1///1=1&^$(;",
  "(^[&||**}//1//}}}1**'/'/1)})'4)1*:}}////}}1}*1*:***]}/}/}}}*}}}}}}}:}::1*:*}}}**}}}}:]]})4/:/}]]]))::4::=4//)}))}11**1}4///}}1=====**1==1=}}1*1}}}1<--3,--!|''4:}})'=*}1}:}}/}}}:=11*1:}1||}}}}}}}*}}}:1:<-<::1*}:}}}**}14})]])}4/}/1]]]4)4:}4)/4!_~~3^1**}**4/}4}1*==*==***1===1/}11*}//1///}}1}*'/'/))14=4)}*}}}////}}1:*11:}:]|}/}/}::*}}}}:}1:1*1*1&&^$(;",
  "$^%&|*11}}/=///}1}*:'}4=}**|==):}:}}//'/:**=***1}*1*}}::}:}*}/}}}}}}}}***11*:*]]:}}4:]]]14=**})]]]44]}4:4}/=41}):*}}4===/}}}1*=1*=***)==/==}111}///}>[[[[)*'/=/:**|4)}):}}}}/'/1**1**1*:}1*}:}*::}*///}}}>>}}**|1:1:*|]:114:]]]14)*)::]]]*4]:}44/|[[[))41}}==//=}}}*1=1*=***)===}=}111}4/1///}1*::'44=}**]=))}*:}}}//}:**1****}11*::::}}}*//}}}}}}}*1**|&^$#;",
  "$^%&|**}/}}14//111/}}}1)***]*):}}}}/}}/}11*1***::}***:}}*}:1''/}//}}}**|*]:}1*||}:4:4)]))=)]}:)})4::*::4=4)}=::11}}=}///4}}=)======**='=}1*=}*}/}/1==41*11}}}}:}*)|*}):}}}/}//1***=**|*}}}|*}:}}}:}''/}/}}}::****}:1**]})4:4)]])=})}1))*}4:)}:)=4))4:)}*)}=4/4//}}/}======*1=/4}=*=}1}/}}/}//*11=}}11}*)*|*)1:}}/}}//=111=***:*::*1}}}:::}''//}}}}11*|1&&%$(;",
  "$^%&&11}}}}111=1**}/}**1***|)**}}}/}}*1****==**}:/*:*]:}:}:}///}}}}/}******:11**}:]]::])})1]))]]*}44}}://}))**)):}414}4=//4=1*1=*=**11===**11}}}41}==111*}=:*1****|]*1/}}//}1111**=1)**)}})]*:}:/::////////}***|*1:1***}:]]:4])}))])1*]::44:}444):))*))1}4*}}///4/=)*====***1==1***1}}}}}}}1/1**}/}**1*|1|)*1/}}//:}1****=1**::/::]]:/}/:://///}}}*****&&^$#;",
  "(^%&||1}1111==**|*4//}1|***||*/'/}}/11***11****|}4/*:1}//}:*}}}}}}}}**1|*****:}:]]]]44)}))*)}})*4:4':)/'::]|}1*)}**:1/'//4/')==1=1=1*=4}11*1==}1111111*|14//}*****|*)/'}}//*11|*1*)1**)4==11)///:*}}}}}}}}}****1****:1:]]]]4)1))1*)))))14'/::}=4}]|}}*}::*}4='////'1=*11*=*1=/==1*=1=}11*1/=1***}//}*|*)||*)4'/}//1***********=}=)1}=}}::}}}}}}}}}1*1|1|[%$(;",
  "$^^&|*1==1*1*111**/''/1***)*)1/''}}}11||*****|)**4=}4=4}}}:|:*1}}}:}]:}11:}]1:}:]]]])4)})]*|))}}=/}'}4}4}}]|)*}*}}}:}//'////:*1**1)**===1*=11=111*11111|*/''/*******)/''}}}**||***|1|]*)44)=4)}}}*]*::}}}}}]:::1:}]1:}:]]]]4)4})]|**::41}4/4//41}*|)*)*1}**}}/'/4}'*11*111*)1}11*1=11===****1***/'''1|1****=='/}}}1*||*1**)|)*)4=})4==}1*****}}}1*]*1**|[^$(;",
  "(^[&>*=1}//}}}**1}}/}})|||||1=/=***11******1=)1*)=4==4===}/}1]]||]]]]}}444]]}*||**)]|])}=))}==))]*)}|11}}}14:*|*)}}}}}}}'//411*1111*=1=1==1*=1==//}}}}*=}//}:*|||*|1=/=*]*/=*1***1=))1))========}41*]|]]]]]]1}444]]}*||*))]|)})=1)1/=1*)*1}|***:}}4:*|1:}4}4}}/'//}})*1)}**1======*==1}//}11*11}//}1*)||*|*1/=]**//****|*=1}*))=)===)4=}4**]]]||]]]1}}1|&$$(;",
  "$^^&&*===}:=1}1:}}}/:1*||**|*===**1=*=*|**=1=4=))1))=)=)=4=:1*1]]]:}]}:::]]]**}}))/4*)}))|*)41==1=}/|)**1=1}1]|]}4}}}}}/}//}}1*)})1*=1=1*1**=1}=):=**}:14//11*|*|||11==1**1*1*|*|===)=)))=)4=4)==4111*|]]:1]11*:]]]**}}))/)))})])|)4)=*=)=/)*1111111]|]}}}1}}4=///}}1*1)}11)=111***1==1}}/}}*:}}}/:1*|*|||1)==***11=****1=)=41)}=)='=)==/411*]]]}1]1}}}>&^$#;",
  "(^%&|*11****:}:}*}}/})11*]|1*1111******1**}===4}))})*))4)=41:}:1*}}}]]]]]]]]*}4'=*4=)1))|||)==}====/1**)***}*]*}}}}}}}}//}/}})***1:******|*11==)11*}4:1:}}/})11|])**=11*|*111*1*1==/==1)))))]*4)4=::}*}*:}}]]]]]]]]*)4'=)=/*)))||))======//*1*)1**}*]]}}}}}}}}}//}}})**1})*1*****|1=11****:}}}*}}/})*1|])11==1*|******1*=/===))))))*))4)4*:}*1}:}}]]]]]>[^$(;",
  "$$%&&*=11}**:}*}}}4=}}:****1}==1***=*1**==//'=))})1))||)|1)}*}:}*}}}}1]]]]]]''''=))*))=)))*))=4=//'=1*11***:1:::}}:}/}}/''/}/1**:}/=/11*****1111***11:}*}4/}})***1**===1**1***11=/''')}}))**)|)*)=}:}:}}1}}}:]]]]]]''''=)))1=))])*)}1=//4/=****1*:}11):}}}}}}/}''/}/1***}/==1)**1**===11*1*::}:}}/}}:1****11==1*11*11*==//'')}):}*|))|*1=}*}::}:}}}:]]]>[^$(;",
  "(^%&>||||||]||||||||]||||||||||||&||>|>||*|))*)>>|||&>>&|||||||||>||*]]>>|||1*1*)|>&>|]||||||||]||>>>>|>|||||]||||||]]*111||]|||||]]]|>||>|&|>||]||||||||||]|||>||||||||&>|>|>||||*)]]>>|>]&&>&>||||||>|>||*]]>>|||=11**|>&>|||||||||]]]>|>||>|>||>|]||]|>|]|]111*|]||>||]]|*||>>|&>|||||]||||||]|]|||>|||||*||&>||&|||||)*)||||||>&&|>>||||||||||*]]>>]&%^(;",
  "$^%&|&&[&&&>&&&[&&&&&&[[&&[&&&&&&[&&[&&&[&&&>&&&[[&&&[[[[&&&[&[[&[&[>&>&>>>>>&&&>&&[[[&>&&&&>&&[[[[[&[&[[[[[&&|>&[[[&&&&&&[&&&[&&&&&&&&&&&&&[&[&&&>&&[&[&&&&&&&&[&&&&&&&&&&&&&&&&&&>&&&[&&&&[[[[[&&[&&[[[&&>>>&>>>>>&&&>>&[[&&>&&&&>&&&[[[%[&&[[[[[&&|>&[[[&&&&&&&&&&&&&&[&&&&&&&&&[[&[&&|&&&&&[&&&&[&&&&[&&&&&&&&&[&[&&&&&&[[[[&&[&[[[[&&[&[[[[&[>>>&&>>%$(;",
  "$$[&&%^[^[[[%%^%%%%[%%%%%^[%%%[%%%^%[%^^%%%%[%%^%%%%%%%^^%%%%^%^^%%%[[[%%%%%%%%^[%^%%%%%%%%[%%%%%%%^%%%^^%^^^%%[%%%%%%%%%[%^^%%^%^^%%[%%^^%^%^[^[[[%^%%%%%[%%^%^%%%%%%%^%^%%^^%^%%%[%^^%%^%%%%^%%%%%^^%%%^%[[[%%%%%%%^%%%^^^%%%%%%%[%%%%%%%%^%^^%^^^%%[%%%%%%%[^%^^^%^%^%%%%%%^^^%^%%%%[[%^%^^^[%[%%%^^^%[%%%%%^^%%%^%%%%%[[%%%%%%%%^^%%%%[^%%%%%%[[%%%%%%$(;",
  "$^%%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$^$$$$$$$$$$$2$$$$$$$$$$$$$$$$$$$$$$$2$$$$$<$$$$$$$$$$$2$$$$$$$$$<$$<$<$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$^$^$$$$$$$$$$$$^$$$$$$2$$$$$$$$$$$$$$$$$$$$$$$$$2$$$$$$$$$$$$$$$$$$$$$$$$$$<$$$<$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$^$$$$$$$$$$$$$$$$$^$$$$$$$$^$$$$$$$$$$$$2$$$$$$$$$$$$$$$$$$$$2$$$$(;",
  "(^$((((((((((((((((((((((((((($(((((((((((((((((((((((((((((($((((((((((((((((((#((((((#(!((((!(!(((!(((!((((!((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((($((((((((((((((((((((((((((((((((((((<((((((#!((((((!((((((!(!(((!((!(!!(!((((((((((((((((((((((((((((((((((((((((((((((((((((((($(((((((((((((((((((((((((((((((((((((((((((((((;",
  "$(;;;;;;;;;;;;;;;;;;;;;;;;;;#;;;;;;;##;;;;;;;;;{;;;;;;;;;;##;;;#;;;;;;;;;#;;;;;;;;;;#;;;;;;;;#;;;;;;;;{;;{{;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;#;#;#;;#;;;;;;;;;;;;;;;;;;;;;;;;######;;;;;;;;;;;;;;;;;;;;;;;;@;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;#;;##;;;;;;;;;;{;;;;;;;;;;#;#;#;;;;;#;;;;;##;;;",
  ";@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
};

//based on an icon of the GNOME project, by Jimmac
const char * wait_xpm[82] = {
"48 48 33 1",
" 	c None",
".	c #020202", "+	c #4C4236", "@	c #949494", "#	c #B8B8B8",
"$	c #654E30", "%	c #CACACA", "&	c #8B5216", "*	c #DCD9D5",
"=	c #8D6C42", "-	c #351A0B", ";	c #BD9056", ">	c #ECE4D9",
",	c #8D8275", "'	c #AAAAA9", ")	c #9E9E9E", "!	c #DBB385",
"~	c #EEEEEE", "{	c #AE7634", "]	c #7E7D7D", "^	c #A68253",
"/	c #C4C4C4", "(	c #C59B64", "_	c #D1A876", ":	c #F8F8F8",
"<	c #E4CDAF", "[	c #5C5B59", "}	c #4C321A", "|	c #A66823",
"1	c #726351", "2	c #E2C098", "3	c #342E27", "4	c #B88342",
"                                                ",
"                                                ",
"                                                ",
"                                                ",
"                     .......                    ",
"                   ..)%*~*/@..                  ",
"                  .#~~:~~>>>*).                 ",
"                .[>:~~>>>>*>**#+.               ",
"               .,~~~>*%//%****%#[.              ",
"               [~~~*#[....]/*>*//+              ",
"              .>:>*@..     .)***##.             ",
"              #~~*,.        .@**%#@.            ",
"             .~~*/.          .'~*##.            ",
"             .~~%].           .*~*'].           ",
"             %~*/3             ]~*#).           ",
"            .>~%/.             -~>#'.           ",
"            .~~%#.             .~>/'.           ",
"            .*~%'.             .*>%'.           ",
"          ---&{||---------------|{{&----        ",
"         -(>>><<<<<<<<22<222<222222!2!_|-       ",
"         -><<22!!______((__(_(((;;;44{|&-       ",
"         -><22!!___((4==1==;;((;;;444{|&-       ",
"         -><<2!!!__(1+]-.[[+=4(;;;44{{|&-       ",
"         -><<2____{+@*~~,~~*1+^;;;;44{|&-       ",
"         -><<2!!!;+)~/~~:~~%>@}^;44444|&-       ",
"         -><22__($#~:::::::~%~]$4;;44{|&-       ",
"         -><<2!_]1~~::::::~@'~*+=44444|&-       ",
"         -><<!__[#*>:::::~@#~%~,${44{||&-       ",
"         -><<2__+%~:::::~@#~~~~/}={44{|&-       ",
"         -><<2!_.1~::::'[#~:~~*3-|{4{{|&-       ",
"         -><22_(.1:::::'3)::~~*33=4{4{|&-       ",
"         -><<!!([%~~:::~~@'~~~~#3|{4{{{&-       ",
"         -><<2!_['**~::~~~,'~/~,+={4{{4&-       ",
"         -><<!__=]~~~~~:~~~>~~%+&{44{{4&-       ",
"         ->2<!_(;+#~~~~~~~~~~~]+={{4{{;&-       ",
"         -><2!__(,+'~/~~~~~/*,31|44{{|(&-       ",
"         -><<!___(1+@*~~]>>*131=44444{(&-       ",
"         -><<2___((^++13.[[3$={4;44{44(&-       ",
"         ->2<!____(;^=$+++$1=^^;444444_&-       ",
"         -><<!___((((;;^^^^;;(;;;;44(4(&-       ",
"         ->22!___(((;;;;;;;;(__(__!__4{&-       ",
"         -{((;{4{{{{{{|{|{|{{|||||||&|&}-       ",
"          ------------------------------        ",
"                                                ",
"                                                ",
"                                                ",
"                                                ",
"                                                "};

const char * clip_xpm[17] = {
"7 13 3 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
" ...   ",
".   . .",
". . . .",
". . . .",
". . . .",
". . . .",
". . . .",
". . . .",
". . . .",
".  .  .",
".     .",
" .   . ",
"  ...  "};
