// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package blob

import (
	"github.com/google/uuid"
)

const (
	// Label holds the string label denoting the blob type in the database.
	Label = "blob"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldUUID holds the string denoting the uuid field in the database.
	FieldUUID = "uuid"
	// FieldCount holds the string denoting the count field in the database.
	FieldCount = "count"
	// EdgeParent holds the string denoting the parent edge name in mutations.
	EdgeParent = "parent"
	// EdgeLinks holds the string denoting the links edge name in mutations.
	EdgeLinks = "links"
	// EdgeBlobLinks holds the string denoting the blob_links edge name in mutations.
	EdgeBlobLinks = "blob_links"
	// Table holds the table name of the blob in the database.
	Table = "blobs"
	// ParentTable is the table that holds the parent relation/edge.
	ParentTable = "blobs"
	// ParentColumn is the table column denoting the parent relation/edge.
	ParentColumn = "blob_parent"
	// LinksTable is the table that holds the links relation/edge. The primary key declared below.
	LinksTable = "blob_links"
	// BlobLinksTable is the table that holds the blob_links relation/edge.
	BlobLinksTable = "blob_links"
	// BlobLinksInverseTable is the table name for the BlobLink entity.
	// It exists in this package in order to avoid circular dependency with the "bloblink" package.
	BlobLinksInverseTable = "blob_links"
	// BlobLinksColumn is the table column denoting the blob_links relation/edge.
	BlobLinksColumn = "blob_id"
)

// Columns holds all SQL columns for blob fields.
var Columns = []string{
	FieldID,
	FieldUUID,
	FieldCount,
}

// ForeignKeys holds the SQL foreign-keys that are owned by the "blobs"
// table and are not defined as standalone fields in the schema.
var ForeignKeys = []string{
	"blob_parent",
}

var (
	// LinksPrimaryKey and LinksColumn2 are the table columns denoting the
	// primary key for the links relation (M2M).
	LinksPrimaryKey = []string{"blob_id", "link_id"}
)

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	for i := range ForeignKeys {
		if column == ForeignKeys[i] {
			return true
		}
	}
	return false
}

var (
	// DefaultUUID holds the default value on creation for the "uuid" field.
	DefaultUUID func() uuid.UUID
	// DefaultCount holds the default value on creation for the "count" field.
	DefaultCount int
	// DefaultID holds the default value on creation for the "id" field.
	DefaultID func() uuid.UUID
)
