// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

import (
	"fmt"
	"strings"

	"code.forgejo.org/f3/gof3/v3/tree/generic"
)

var forgeFactories = make(map[string]ForgeFactory, 10)

type ForgeFactory func(tree generic.TreeInterface, options any) generic.TreeDriverInterface

func RegisterForgeFactory(name string, factory ForgeFactory) {
	name = strings.ToLower(name)
	forgeFactories[name] = factory
}

func GetForgeFactory(name string) ForgeFactory {
	name = strings.ToLower(name)
	factory, ok := forgeFactories[name]
	if !ok {
		panic(fmt.Errorf("no forge registered for %s", name))
	}
	return factory
}
