// Code generated by smithy-go-codegen DO NOT EDIT.

package mailmanager

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mailmanager/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Fetch ingress endpoint resource attributes.
func (c *Client) GetIngressPoint(ctx context.Context, params *GetIngressPointInput, optFns ...func(*Options)) (*GetIngressPointOutput, error) {
	if params == nil {
		params = &GetIngressPointInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetIngressPoint", params, optFns, c.addOperationGetIngressPointMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetIngressPointOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetIngressPointInput struct {

	// The identifier of an ingress endpoint.
	//
	// This member is required.
	IngressPointId *string

	noSmithyDocumentSerde
}

type GetIngressPointOutput struct {

	// The identifier of an ingress endpoint resource.
	//
	// This member is required.
	IngressPointId *string

	// A user friendly name for the ingress endpoint.
	//
	// This member is required.
	IngressPointName *string

	//  The DNS A Record that identifies your ingress endpoint. Configure your DNS
	// Mail Exchange (MX) record with this value to route emails to Mail Manager.
	ARecord *string

	// The timestamp of when the ingress endpoint was created.
	CreatedTimestamp *time.Time

	// The Amazon Resource Name (ARN) of the ingress endpoint resource.
	IngressPointArn *string

	// The authentication configuration of the ingress endpoint resource.
	IngressPointAuthConfiguration *types.IngressPointAuthConfiguration

	// The timestamp of when the ingress endpoint was last updated.
	LastUpdatedTimestamp *time.Time

	// The identifier of a rule set resource associated with the ingress endpoint.
	RuleSetId *string

	// The status of the ingress endpoint resource.
	Status types.IngressPointStatus

	// The identifier of the traffic policy resource associated with the ingress
	// endpoint.
	TrafficPolicyId *string

	// The type of ingress endpoint.
	Type types.IngressPointType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetIngressPointMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetIngressPoint{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetIngressPoint{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetIngressPoint"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetIngressPointValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetIngressPoint(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetIngressPoint(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetIngressPoint",
	}
}
