{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetColor: TAbstractColorNode;
    procedure SetColor(const Value: TAbstractColorNode);
    function GetFogCoord: TFogCoordinateNode;
    procedure SetFogCoord(const Value: TFogCoordinateNode);
    function GetNormal: TAbstractNormalNode;
    procedure SetNormal(const Value: TAbstractNormalNode);
    function GetTexCoord: TAbstractTextureCoordinateNode;
    procedure SetTexCoord(const Value: TAbstractTextureCoordinateNode);
    function GetCcw: Boolean;
    procedure SetCcw(const Value: Boolean);
    function GetColorPerVertex: Boolean;
    procedure SetColorPerVertex(const Value: Boolean);
    function GetCreaseAngle: Single;
    procedure SetCreaseAngle(const Value: Single);
    function GetNormalPerVertex: Boolean;
    procedure SetNormalPerVertex(const Value: Boolean);
    function GetXDimension: Integer;
    procedure SetXDimension(const Value: Integer);
    function GetXSpacing: Single;
    procedure SetXSpacing(const Value: Single);
    function GetZDimension: Integer;
    procedure SetZDimension(const Value: Integer);
    function GetZSpacing: Single;
    procedure SetZSpacing(const Value: Single);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FEventSet_height: TMFFloatEvent;
    {  }
    public property EventSet_height: TMFFloatEvent read FEventSet_height;

    strict private FFdAttrib: TMFNode;
    { Internal wrapper for property @code(Attrib). This wrapper API may change, we advise to access simpler @code(Attrib) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAttrib: TMFNode read FFdAttrib;
    {  }
    procedure SetAttrib(const Value: array of TAbstractVertexAttributeNode);

    strict private FFdColor: TSFNode;
    { Internal wrapper for property @code(Color). This wrapper API may change, we advise to access simpler @code(Color) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdColor: TSFNode read FFdColor;
    {  }
    property Color: TAbstractColorNode read GetColor write SetColor;

    strict private FFdFogCoord: TSFNode;
    { Internal wrapper for property @code(FogCoord). This wrapper API may change, we advise to access simpler @code(FogCoord) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFogCoord: TSFNode read FFdFogCoord;
    {  }
    property FogCoord: TFogCoordinateNode read GetFogCoord write SetFogCoord;

    strict private FFdNormal: TSFNode;
    { Internal wrapper for property @code(Normal). This wrapper API may change, we advise to access simpler @code(Normal) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdNormal: TSFNode read FFdNormal;
    {  }
    property Normal: TAbstractNormalNode read GetNormal write SetNormal;

    strict private FFdTexCoord: TSFNode;
    { Internal wrapper for property @code(TexCoord). This wrapper API may change, we advise to access simpler @code(TexCoord) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTexCoord: TSFNode read FFdTexCoord;
    {  }
    property TexCoord: TAbstractTextureCoordinateNode read GetTexCoord write SetTexCoord;

    strict private FFdCcw: TSFBool;
    { Internal wrapper for property @code(Ccw). This wrapper API may change, we advise to access simpler @code(Ccw) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCcw: TSFBool read FFdCcw;
    {  }
    property Ccw: Boolean read GetCcw write SetCcw;

    strict private FFdColorPerVertex: TSFBool;
    { Internal wrapper for property @code(ColorPerVertex). This wrapper API may change, we advise to access simpler @code(ColorPerVertex) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdColorPerVertex: TSFBool read FFdColorPerVertex;
    {  }
    property ColorPerVertex: Boolean read GetColorPerVertex write SetColorPerVertex;

    strict private FFdCreaseAngle: TSFFloat;
    { Internal wrapper for property @code(CreaseAngle). This wrapper API may change, we advise to access simpler @code(CreaseAngle) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCreaseAngle: TSFFloat read FFdCreaseAngle;
    {  }
    property CreaseAngle: Single read GetCreaseAngle write SetCreaseAngle;

    strict private FFdHeight: TMFFloat;
    { Internal wrapper for property @code(Height). This wrapper API may change, we advise to access simpler @code(Height) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdHeight: TMFFloat read FFdHeight;
    {  }
    procedure SetHeight(const Value: array of Single); overload;
    {  }
    procedure SetHeight(const Value: TSingleList); overload;

    strict private FFdNormalPerVertex: TSFBool;
    { Internal wrapper for property @code(NormalPerVertex). This wrapper API may change, we advise to access simpler @code(NormalPerVertex) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdNormalPerVertex: TSFBool read FFdNormalPerVertex;
    {  }
    property NormalPerVertex: Boolean read GetNormalPerVertex write SetNormalPerVertex;

    strict private FFdSolid: TSFBool;
    { Internal wrapper for property @code(Solid). This wrapper API may change, we advise to access simpler @code(Solid) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSolid: TSFBool read FFdSolid;

    strict private FFdXDimension: TSFInt32;
    { Internal wrapper for property @code(XDimension). This wrapper API may change, we advise to access simpler @code(XDimension) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdXDimension: TSFInt32 read FFdXDimension;
    {  }
    property XDimension: Integer read GetXDimension write SetXDimension;

    strict private FFdXSpacing: TSFFloat;
    { Internal wrapper for property @code(XSpacing). This wrapper API may change, we advise to access simpler @code(XSpacing) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdXSpacing: TSFFloat read FFdXSpacing;
    {  }
    property XSpacing: Single read GetXSpacing write SetXSpacing;

    strict private FFdZDimension: TSFInt32;
    { Internal wrapper for property @code(ZDimension). This wrapper API may change, we advise to access simpler @code(ZDimension) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdZDimension: TSFInt32 read FFdZDimension;
    {  }
    property ZDimension: Integer read GetZDimension write SetZDimension;

    strict private FFdZSpacing: TSFFloat;
    { Internal wrapper for property @code(ZSpacing). This wrapper API may change, we advise to access simpler @code(ZSpacing) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdZSpacing: TSFFloat read FFdZSpacing;
    {  }
    property ZSpacing: Single read GetZSpacing write SetZSpacing;

{$endif read_interface}

{$ifdef read_implementation}

{ TElevationGridNode ----------------------------------------------- }

procedure TElevationGridNode.SetAttrib(const Value: array of TAbstractVertexAttributeNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractVertexAttributeNode));
  FdAttrib.Send(A);
end;

function TElevationGridNode.GetColor: TAbstractColorNode;
begin
  if FdColor.Value is TAbstractColorNode then
    Result := TAbstractColorNode(FdColor.Value)
  else
    Result := nil;
end;

procedure TElevationGridNode.SetColor(const Value: TAbstractColorNode);
begin
  FdColor.Send(Value);
end;

function TElevationGridNode.GetFogCoord: TFogCoordinateNode;
begin
  if FdFogCoord.Value is TFogCoordinateNode then
    Result := TFogCoordinateNode(FdFogCoord.Value)
  else
    Result := nil;
end;

procedure TElevationGridNode.SetFogCoord(const Value: TFogCoordinateNode);
begin
  FdFogCoord.Send(Value);
end;

function TElevationGridNode.GetNormal: TAbstractNormalNode;
begin
  if FdNormal.Value is TAbstractNormalNode then
    Result := TAbstractNormalNode(FdNormal.Value)
  else
    Result := nil;
end;

procedure TElevationGridNode.SetNormal(const Value: TAbstractNormalNode);
begin
  FdNormal.Send(Value);
end;

function TElevationGridNode.GetTexCoord: TAbstractTextureCoordinateNode;
begin
  if FdTexCoord.Value is TAbstractTextureCoordinateNode then
    Result := TAbstractTextureCoordinateNode(FdTexCoord.Value)
  else
    Result := nil;
end;

procedure TElevationGridNode.SetTexCoord(const Value: TAbstractTextureCoordinateNode);
begin
  FdTexCoord.Send(Value);
end;

function TElevationGridNode.GetCcw: Boolean;
begin
  Result := FdCcw.Value;
end;

procedure TElevationGridNode.SetCcw(const Value: Boolean);
begin
  FdCcw.Send(Value);
end;

function TElevationGridNode.GetColorPerVertex: Boolean;
begin
  Result := FdColorPerVertex.Value;
end;

procedure TElevationGridNode.SetColorPerVertex(const Value: Boolean);
begin
  FdColorPerVertex.Send(Value);
end;

function TElevationGridNode.GetCreaseAngle: Single;
begin
  Result := FdCreaseAngle.Value;
end;

procedure TElevationGridNode.SetCreaseAngle(const Value: Single);
begin
  FdCreaseAngle.Send(Value);
end;

procedure TElevationGridNode.SetHeight(const Value: array of Single);
begin
  FdHeight.Send(Value);
end;

procedure TElevationGridNode.SetHeight(const Value: TSingleList);
begin
  FdHeight.Send(Value);
end;

function TElevationGridNode.GetNormalPerVertex: Boolean;
begin
  Result := FdNormalPerVertex.Value;
end;

procedure TElevationGridNode.SetNormalPerVertex(const Value: Boolean);
begin
  FdNormalPerVertex.Send(Value);
end;

function TElevationGridNode.GetXDimension: Integer;
begin
  Result := FdXDimension.Value;
end;

procedure TElevationGridNode.SetXDimension(const Value: Integer);
begin
  FdXDimension.Send(Value);
end;

function TElevationGridNode.GetXSpacing: Single;
begin
  Result := FdXSpacing.Value;
end;

procedure TElevationGridNode.SetXSpacing(const Value: Single);
begin
  FdXSpacing.Send(Value);
end;

function TElevationGridNode.GetZDimension: Integer;
begin
  Result := FdZDimension.Value;
end;

procedure TElevationGridNode.SetZDimension(const Value: Integer);
begin
  FdZDimension.Send(Value);
end;

function TElevationGridNode.GetZSpacing: Single;
begin
  Result := FdZSpacing.Value;
end;

procedure TElevationGridNode.SetZSpacing(const Value: Single);
begin
  FdZSpacing.Send(Value);
end;

class function TElevationGridNode.ClassX3DType: String;
begin
  Result := 'ElevationGrid';
end;

procedure TElevationGridNode.CreateNode;
begin
  inherited;

  FEventSet_height := TMFFloatEvent.Create(Self, 'set_height', true);
  AddEvent(FEventSet_height);

  FFdAttrib := TMFNode.Create(Self, True, 'attrib', [TAbstractVertexAttributeNode]);
   FdAttrib.ChangeAlways := chGeometry;
  AddField(FFdAttrib);

  FFdColor := TSFNode.Create(Self, True, 'color', [TAbstractColorNode]);
   FdColor.ChangeAlways := chGeometry;
  AddField(FFdColor);

  FFdFogCoord := TSFNode.Create(Self, True, 'fogCoord', [TFogCoordinateNode]);
   FdFogCoord.ChangeAlways := chGeometry;
  AddField(FFdFogCoord);

  FFdNormal := TSFNode.Create(Self, True, 'normal', [TAbstractNormalNode]);
   FdNormal.ChangeAlways := chGeometry;
  AddField(FFdNormal);

  FFdTexCoord := TSFNode.Create(Self, True, 'texCoord', [TAbstractTextureCoordinateNode]);
   FdTexCoord.ChangeAlways := chGeometry;
   FdTexCoord.OnBeforeValueChange := {$ifdef FPC}@{$endif}MoveShapeAssociations;
  AddField(FFdTexCoord);

  FFdCcw := TSFBool.Create(Self, False, 'ccw', true);
   FdCcw.ChangeAlways := chGeometry;
  AddField(FFdCcw);

  FFdColorPerVertex := TSFBool.Create(Self, False, 'colorPerVertex', true);
   FdColorPerVertex.ChangeAlways := chGeometry;
  AddField(FFdColorPerVertex);

  FFdCreaseAngle := TSFFloat.Create(Self, False, 'creaseAngle', 0);
   FdCreaseAngle.ChangeAlways := chGeometry;
   FdCreaseAngle.Angle := true;
   FdCreaseAngle.MustBeNonnegative := true;
  AddField(FFdCreaseAngle);

  FFdHeight := TMFFloat.Create(Self, False, 'height', []);
   FdHeight.ChangeAlways := chGeometry;
  AddField(FFdHeight);

  FFdNormalPerVertex := TSFBool.Create(Self, False, 'normalPerVertex', true);
   FdNormalPerVertex.ChangeAlways := chGeometry;
  AddField(FFdNormalPerVertex);

  FFdSolid := TSFBool.Create(Self, False, 'solid', true);
   FdSolid.ChangeAlways := chGeometry;
  AddField(FFdSolid);

  FFdXDimension := TSFInt32.Create(Self, False, 'xDimension', 0);
   FdXDimension.ChangeAlways := chGeometry;
   FdXDimension.MustBeNonnegative := true;
  AddField(FFdXDimension);

  FFdXSpacing := TSFFloat.Create(Self, False, 'xSpacing', 1.0);
   FdXSpacing.ChangeAlways := chGeometry;
   FdXSpacing.MustBeNonnegative := true;
  AddField(FFdXSpacing);

  FFdZDimension := TSFInt32.Create(Self, False, 'zDimension', 0);
   FdZDimension.ChangeAlways := chGeometry;
   FdZDimension.MustBeNonnegative := true;
  AddField(FFdZDimension);

  FFdZSpacing := TSFFloat.Create(Self, False, 'zSpacing', 1.0);
   FdZSpacing.ChangeAlways := chGeometry;
   FdZSpacing.MustBeNonnegative := true;
  AddField(FFdZSpacing);
end;

{$endif read_implementation}
