/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.pe;

import com.kreative.ksfl.KSFLUtilities;
import com.kreative.pe.PEDLLImport;
import com.kreative.pe.PEDirectoryEntry;
import com.kreative.pe.PEResourceDirectory;
import com.kreative.pe.PESection;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PEImage
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final byte[] MSDOS_STUB_DEFAULT;
    public byte[] msdosStub;
    public static final int PE_SIGNATURE = 17744;
    public int peSignature;
    public static final short MACHINE_UNKNOWN = 0;
    public static final short MACHINE_AM33 = 467;
    public static final short MACHINE_AMD64 = -31132;
    public static final short MACHINE_ARM = 448;
    public static final short MACHINE_EBC = 3772;
    public static final short MACHINE_I386 = 332;
    public static final short MACHINE_IA64 = 512;
    public static final short MACHINE_M32R = -28607;
    public static final short MACHINE_MIPS16 = 614;
    public static final short MACHINE_MIPSFPU = 870;
    public static final short MACHINE_MIPSFPU16 = 1126;
    public static final short MACHINE_POWERPC = 496;
    public static final short MACHINE_POWERPCFP = 497;
    public static final short MACHINE_R4000 = 358;
    public static final short MACHINE_SH3 = 418;
    public static final short MACHINE_SH3DSP = 419;
    public static final short MACHINE_SH4 = 422;
    public static final short MACHINE_SH5 = 424;
    public static final short MACHINE_THUMB = 450;
    public static final short MACHINE_WCEMIPSV2 = 361;
    public short machine;
    public short numSections;
    public int creationDate;
    public int symbolTablePtr;
    public int numSymbols;
    public short optHeaderSize;
    public static final short CHARACTERISTICS_RELOCS_STRIPPED = 1;
    public static final short CHARACTERISTICS_EXECUTABLE_IMAGE = 2;
    public static final short CHARACTERISTICS_LINE_NUMS_STRIPPED = 4;
    public static final short CHARACTERISTICS_LOCAL_SYMS_STRIPPED = 8;
    public static final short CHARACTERISTICS_AGGRESSIVE_WS_TRIM = 16;
    public static final short CHARACTERISTICS_LARGE_ADDRESS_AWARE = 32;
    public static final short CHARACTERISTICS_RESERVED = 64;
    public static final short CHARACTERISTICS_BYTES_REVERSED_LO = 128;
    public static final short CHARACTERISTICS_32BIT_MACHINE = 256;
    public static final short CHARACTERISTICS_DEBUG_STRIPPED = 512;
    public static final short CHARACTERISTICS_REMOVABLE_RUN_FROM_SWAP = 1024;
    public static final short CHARACTERISTICS_NET_RUN_FROM_SWAP = 2048;
    public static final short CHARACTERISTICS_SYSTEM = 4096;
    public static final short CHARACTERISTICS_DLL = 8192;
    public static final short CHARACTERISTICS_UP_SYSTEM_ONLY = 16384;
    public static final short CHARACTERISTICS_BYTES_REVERSED_HI = Short.MIN_VALUE;
    public short characteristics;
    public static final short MAGIC_ROM_IMAGE = 263;
    public static final short MAGIC_PE32 = 267;
    public static final short MAGIC_PE32PLUS = 523;
    public short magic;
    public short linkerVersion;
    public int codeSize;
    public int dataSize;
    public int bssSize;
    public int entryPointOfst;
    public int codeOfst;
    public int dataOfst;
    public long base;
    public int sectionAlign;
    public int fileAlign;
    public int osVersion;
    public int imageVersion;
    public static final int SUBSYSTEM_VERSION_WIN32 = 262144;
    public int subsystemVersion;
    public int win32versionValue;
    public int sizeOfImage;
    public int sizeOfHeaders;
    public int checksum;
    public static final short SUBSYSTEM_UNKNOWN = 0;
    public static final short SUBSYSTEM_NATIVE = 1;
    public static final short SUBSYSTEM_WINDOWS_GUI = 2;
    public static final short SUBSYSTEM_WINDOWS_CUI = 3;
    public static final short SUBSYSTEM_OS2_CUI = 5;
    public static final short SUBSYSTEM_POSIX_CUI = 7;
    public static final short SUBSYSTEM_WINDOWS_CE_GUI = 9;
    public static final short SUBSYSTEM_EFI_APPLICATION = 10;
    public static final short SUBSYSTEM_EFI_BOOT_SERVICE_DRIVER = 11;
    public static final short SUBSYSTEM_EFI_RUNTIME_DRIVER = 12;
    public static final short SUBSYSTEM_EFI_ROM = 13;
    public static final short SUBSYSTEM_XBOX = 14;
    public short subsystem;
    public static final short DLL_CHARACTERISTICS_NOTIFY_PROC_ATTACH = 1;
    public static final short DLL_CHARACTERISTICS_NOTIFY_THREAD_DETACH = 2;
    public static final short DLL_CHARACTERISTICS_NOTIFY_THREAD_ATTACH = 4;
    public static final short DLL_CHARACTERISTICS_NOTIFY_PROC_DETACH = 8;
    public static final short DLL_CHARACTERISTICS_DYNAMIC_BASE = 64;
    public static final short DLL_CHARACTERISTICS_FORCE_INTEGRITY = 128;
    public static final short DLL_CHARACTERISTICS_NX_COMPAT = 256;
    public static final short DLL_CHARACTERISTICS_NO_ISOLATION = 512;
    public static final short DLL_CHARACTERISTICS_NO_SEH = 1024;
    public static final short DLL_CHARACTERISTICS_NO_BIND = 2048;
    public static final short DLL_CHARACTERISTICS_WDM_DRIVER = 8192;
    public static final short DLL_CHARACTERISTICS_TERMINAL_SERVER_AWARE = Short.MIN_VALUE;
    public short dllCharacteristics;
    public long stackReserveSize;
    public long stackCommitSize;
    public long heapReserveSize;
    public long heapCommitSize;
    public int loaderFlags;
    public int numberOfRvaAndSizes;
    public static final int DIR_ENTRY_EXPORTED_SYMBOLS = 0;
    public static final int DIR_ENTRY_IMPORTED_SYMBOLS = 1;
    public static final int DIR_ENTRY_RESOURCES = 2;
    public static final int DIR_ENTRY_EXCEPTIONS = 3;
    public static final int DIR_ENTRY_CERTIFICATES = 4;
    public static final int DIR_ENTRY_BASE_RELOCATION = 5;
    public static final int DIR_ENTRY_DEBUG = 6;
    public static final int DIR_ENTRY_ARCHITECTURE = 7;
    public static final int DIR_ENTRY_GLOBAL_POINTER = 8;
    public static final int DIR_ENTRY_THREAD_LOCAL_STORAGE = 9;
    public static final int DIR_ENTRY_LOAD_CONFIGURATION = 10;
    public static final int DIR_ENTRY_BOUND_IMPORT = 11;
    public static final int DIR_ENTRY_IMPORT_ADDRESS_TABLE = 12;
    public static final int DIR_ENTRY_DELAY_IMPORT_DESCRIPTOR = 13;
    public static final int DIR_ENTRY_CLR_RUNTIME_HEADER = 14;
    public static final int DIR_ENTRY_RESERVED = 15;
    public List<PEDirectoryEntry> dirEntries = new ArrayList<PEDirectoryEntry>();
    public List<PESection> sections = new ArrayList<PESection>();
    public List<PEDLLImport> dllImports = new ArrayList<PEDLLImport>();

    static {
        byte[] byArray = new byte[128];
        byArray[0] = 77;
        byArray[1] = 90;
        byArray[2] = -112;
        byArray[4] = 3;
        byArray[8] = 4;
        byArray[12] = -1;
        byArray[13] = -1;
        byArray[16] = -72;
        byArray[24] = 64;
        byArray[60] = -128;
        byArray[64] = 14;
        byArray[65] = 31;
        byArray[66] = -70;
        byArray[67] = 14;
        byArray[69] = -76;
        byArray[70] = 9;
        byArray[71] = -51;
        byArray[72] = 33;
        byArray[73] = -72;
        byArray[74] = 1;
        byArray[75] = 76;
        byArray[76] = -51;
        byArray[77] = 33;
        byArray[78] = 84;
        byArray[79] = 104;
        byArray[80] = 105;
        byArray[81] = 115;
        byArray[82] = 32;
        byArray[83] = 112;
        byArray[84] = 114;
        byArray[85] = 111;
        byArray[86] = 103;
        byArray[87] = 114;
        byArray[88] = 97;
        byArray[89] = 109;
        byArray[90] = 32;
        byArray[91] = 99;
        byArray[92] = 97;
        byArray[93] = 110;
        byArray[94] = 110;
        byArray[95] = 111;
        byArray[96] = 116;
        byArray[97] = 32;
        byArray[98] = 98;
        byArray[99] = 101;
        byArray[100] = 32;
        byArray[101] = 114;
        byArray[102] = 117;
        byArray[103] = 110;
        byArray[104] = 32;
        byArray[105] = 105;
        byArray[106] = 110;
        byArray[107] = 32;
        byArray[108] = 68;
        byArray[109] = 79;
        byArray[110] = 83;
        byArray[111] = 32;
        byArray[112] = 109;
        byArray[113] = 111;
        byArray[114] = 100;
        byArray[115] = 101;
        byArray[116] = 46;
        byArray[117] = 13;
        byArray[118] = 13;
        byArray[119] = 10;
        byArray[120] = 36;
        MSDOS_STUB_DEFAULT = byArray;
    }

    public PEImage clone() {
        PEImage img = new PEImage();
        img.msdosStub = KSFLUtilities.copy(this.msdosStub);
        img.peSignature = this.peSignature;
        img.machine = this.machine;
        img.numSections = this.numSections;
        img.creationDate = this.creationDate;
        img.symbolTablePtr = this.symbolTablePtr;
        img.numSymbols = this.numSymbols;
        img.optHeaderSize = this.optHeaderSize;
        img.characteristics = this.characteristics;
        img.magic = this.magic;
        img.linkerVersion = this.linkerVersion;
        img.codeSize = this.codeSize;
        img.dataSize = this.dataSize;
        img.bssSize = this.bssSize;
        img.entryPointOfst = this.entryPointOfst;
        img.codeOfst = this.codeOfst;
        img.dataOfst = this.dataOfst;
        img.base = this.base;
        img.sectionAlign = this.sectionAlign;
        img.fileAlign = this.fileAlign;
        img.osVersion = this.osVersion;
        img.imageVersion = this.imageVersion;
        img.subsystemVersion = this.subsystemVersion;
        img.win32versionValue = this.win32versionValue;
        img.sizeOfImage = this.sizeOfImage;
        img.sizeOfHeaders = this.sizeOfHeaders;
        img.checksum = this.checksum;
        img.subsystem = this.subsystem;
        img.dllCharacteristics = this.dllCharacteristics;
        img.stackReserveSize = this.stackReserveSize;
        img.stackCommitSize = this.stackCommitSize;
        img.heapReserveSize = this.heapReserveSize;
        img.heapCommitSize = this.heapCommitSize;
        img.loaderFlags = this.loaderFlags;
        img.numberOfRvaAndSizes = this.numberOfRvaAndSizes;
        for (PEDirectoryEntry de : this.dirEntries) {
            img.dirEntries.add(de.clone());
        }
        for (PESection s : this.sections) {
            img.sections.add(s.clone());
        }
        for (PEDLLImport i : this.dllImports) {
            img.dllImports.add(i.clone());
        }
        return img;
    }

    private static int verswap(int v) {
        short major = (short)(v >>> 16 & 0xFFFF);
        short minor = (short)(v & 0xFFFF);
        major = Short.reverseBytes(major);
        minor = Short.reverseBytes(minor);
        return (major & 0xFFFF) << 16 | minor & 0xFFFF;
    }

    private static int nonZeroSize(byte[] b) {
        int l = b.length;
        while (l > 0 && b[l - 1] == 0) {
            --l;
        }
        return l;
    }

    public int headerSize() {
        int hs = this.msdosStub.length + 24 + (this.magic != 523 ? 96 : 112) + this.dirEntries.size() * 8 + this.sections.size() * 40 + this.dllImports.size() * 9 + 8;
        Iterator<PEDLLImport> i = this.dllImports.iterator();
        while (i.hasNext()) {
            hs += i.next().name.length();
        }
        return hs;
    }

    private int alignInMemory(int a) {
        int m = a % this.sectionAlign;
        if (m == 0) {
            return a;
        }
        return a - m + this.sectionAlign;
    }

    private int alignInFile(int a) {
        int m = a % this.fileAlign;
        if (m == 0) {
            return a;
        }
        return a - m + this.fileAlign;
    }

    public int[] ofstToSNO(int ofst, int hs) {
        if (ofst < 0) {
            return null;
        }
        if (ofst >= 0 && ofst < this.alignInMemory(hs)) {
            return new int[]{-1, ofst};
        }
        Iterator<PESection> i = this.sections.iterator();
        int ii = 0;
        while (i.hasNext()) {
            PESection s = i.next();
            if (ofst >= s.virtualAddress && ofst < s.virtualAddress + s.virtualSize) {
                return new int[]{ii, ofst - s.virtualAddress};
            }
            ++ii;
        }
        return null;
    }

    public int snoToOfst(int[] sno) {
        if (sno == null) {
            return 0;
        }
        if (sno[0] < 0) {
            return sno[1];
        }
        return this.sections.get((int)sno[0]).virtualAddress + sno[1];
    }

    public void decompile(RandomAccessFile f) throws IOException {
        f.seek(0L);
        if (f.readShort() != 19802) {
            throw new IOException("Not a valid EXE file.");
        }
        f.seek(60L);
        int h = Integer.reverseBytes(f.readInt());
        f.seek(0L);
        this.msdosStub = new byte[h];
        f.read(this.msdosStub);
        this.peSignature = Integer.reverseBytes(f.readInt());
        if (this.peSignature != 17744) {
            throw new IOException("Not a valid PE file.");
        }
        this.machine = Short.reverseBytes(f.readShort());
        this.numSections = Short.reverseBytes(f.readShort());
        this.creationDate = Integer.reverseBytes(f.readInt());
        this.symbolTablePtr = Integer.reverseBytes(f.readInt());
        this.numSymbols = Integer.reverseBytes(f.readInt());
        this.optHeaderSize = Short.reverseBytes(f.readShort());
        this.characteristics = Short.reverseBytes(f.readShort());
        long oh = f.getFilePointer();
        this.magic = Short.reverseBytes(f.readShort());
        if (this.magic != 263 && this.magic != 267 && this.magic != 523) {
            throw new IOException("Not a valid PE file.");
        }
        this.linkerVersion = f.readShort();
        this.codeSize = Integer.reverseBytes(f.readInt());
        this.dataSize = Integer.reverseBytes(f.readInt());
        this.bssSize = Integer.reverseBytes(f.readInt());
        this.entryPointOfst = Integer.reverseBytes(f.readInt());
        this.codeOfst = Integer.reverseBytes(f.readInt());
        this.dataOfst = this.magic != 523 ? Integer.reverseBytes(f.readInt()) : 0;
        this.base = this.magic != 523 ? (long)Integer.reverseBytes(f.readInt()) : Long.reverseBytes(f.readLong());
        this.sectionAlign = Integer.reverseBytes(f.readInt());
        this.fileAlign = Integer.reverseBytes(f.readInt());
        this.osVersion = PEImage.verswap(f.readInt());
        this.imageVersion = PEImage.verswap(f.readInt());
        this.subsystemVersion = PEImage.verswap(f.readInt());
        this.win32versionValue = Integer.reverseBytes(f.readInt());
        this.sizeOfImage = Integer.reverseBytes(f.readInt());
        this.sizeOfHeaders = Integer.reverseBytes(f.readInt());
        this.checksum = Integer.reverseBytes(f.readInt());
        this.subsystem = Short.reverseBytes(f.readShort());
        this.dllCharacteristics = Short.reverseBytes(f.readShort());
        this.stackReserveSize = this.magic != 523 ? (long)Integer.reverseBytes(f.readInt()) : Long.reverseBytes(f.readLong());
        this.stackCommitSize = this.magic != 523 ? (long)Integer.reverseBytes(f.readInt()) : Long.reverseBytes(f.readLong());
        this.heapReserveSize = this.magic != 523 ? (long)Integer.reverseBytes(f.readInt()) : Long.reverseBytes(f.readLong());
        this.heapCommitSize = this.magic != 523 ? (long)Integer.reverseBytes(f.readInt()) : Long.reverseBytes(f.readLong());
        this.loaderFlags = Integer.reverseBytes(f.readInt());
        this.numberOfRvaAndSizes = Integer.reverseBytes(f.readInt());
        this.dirEntries.clear();
        int i = 0;
        while (i < this.numberOfRvaAndSizes) {
            PEDirectoryEntry de = new PEDirectoryEntry();
            de.virtualAddress = Integer.reverseBytes(f.readInt());
            de.size = Integer.reverseBytes(f.readInt());
            this.dirEntries.add(de);
            ++i;
        }
        f.seek(oh + (long)this.optHeaderSize);
        this.sections.clear();
        i = 0;
        while (i < this.numSections) {
            PESection s = new PESection();
            s.name = new byte[8];
            f.read(s.name);
            s.virtualSize = Integer.reverseBytes(f.readInt());
            s.virtualAddress = Integer.reverseBytes(f.readInt());
            s.rawDataSize = Integer.reverseBytes(f.readInt());
            s.rawDataOfst = Integer.reverseBytes(f.readInt());
            s.relocOfst = Integer.reverseBytes(f.readInt());
            s.lineNumOfst = Integer.reverseBytes(f.readInt());
            s.relocCnt = Short.reverseBytes(f.readShort());
            s.lineNumCnt = Short.reverseBytes(f.readShort());
            s.characteristics = Integer.reverseBytes(f.readInt());
            this.sections.add(s);
            ++i;
        }
        long dlli = f.getFilePointer();
        this.dllImports.clear();
        while (true) {
            int ts = Integer.reverseBytes(f.readInt());
            short no = Short.reverseBytes(f.readShort());
            short ch = Short.reverseBytes(f.readShort());
            if (ts == 0 && no == 0 && ch == 0) break;
            PEDLLImport di = new PEDLLImport();
            di.timeStamp = ts;
            di.nameOfst = no;
            di.characteristics = ch;
            this.dllImports.add(di);
        }
        for (PEDLLImport di : this.dllImports) {
            byte b;
            f.seek(dlli + (long)di.nameOfst);
            di.name = "";
            while ((b = f.readByte()) != 0) {
                di.name = String.valueOf(di.name) + (char)(b & 0xFF);
            }
        }
        int i2 = 0;
        while (i2 < this.numSections) {
            PESection s = this.sections.get(i2);
            s.data = new byte[s.virtualSize];
            f.seek(s.rawDataOfst);
            f.read(s.data, 0, Math.min(s.virtualSize, s.rawDataSize));
            ++i2;
        }
        if (this.dirEntries.size() > 2) {
            PEDirectoryEntry de = this.dirEntries.get(2);
            int[] sno = this.ofstToSNO(de.virtualAddress, this.sizeOfHeaders);
            if (sno[0] >= 0) {
                PESection s = this.sections.get(sno[0]);
                PEResourceDirectory.subtractVA(s.data, sno[1], s.virtualAddress);
            }
        }
    }

    public void recalculate() {
        int hs = this.headerSize();
        this.peSignature = 17744;
        this.numSections = (short)this.sections.size();
        this.symbolTablePtr = 0;
        this.numSymbols = 0;
        this.optHeaderSize = (short)((this.magic != 523 ? 96 : 112) + this.dirEntries.size() * 8);
        this.codeSize = 0;
        this.dataSize = 0;
        this.bssSize = 0;
        int[] entryPointSNO = this.ofstToSNO(this.entryPointOfst, hs);
        int[] codeSNO = this.ofstToSNO(this.codeOfst, hs);
        int[] dataSNO = this.ofstToSNO(this.dataOfst, hs);
        this.win32versionValue = 0;
        this.sizeOfImage = this.alignInMemory(hs);
        this.sizeOfHeaders = this.alignInFile(hs);
        this.checksum = 0;
        this.loaderFlags = 0;
        this.numberOfRvaAndSizes = this.dirEntries.size();
        int[][] dirEntrySNO = new int[this.dirEntries.size()][];
        int[] dirEntrySD = new int[this.dirEntries.size()];
        int i = 0;
        while (i < this.dirEntries.size()) {
            PEDirectoryEntry de = this.dirEntries.get(i);
            dirEntrySNO[i] = this.ofstToSNO(de.virtualAddress, hs);
            dirEntrySD[i] = dirEntrySNO[i] != null ? (dirEntrySNO[i][0] >= 0 ? this.sections.get((int)dirEntrySNO[i][0]).virtualSize - de.size : de.size) : 0;
            ++i;
        }
        int fa = this.sizeOfHeaders;
        for (PESection s : this.sections) {
            int ms = this.alignInMemory(s.data.length);
            int fs = this.alignInFile(PEImage.nonZeroSize(s.data));
            int fus = this.alignInFile(s.data.length);
            s.virtualSize = s.data.length;
            s.virtualAddress = this.sizeOfImage;
            s.rawDataSize = fs;
            s.rawDataOfst = fa;
            s.lineNumCnt = 0;
            s.relocCnt = 0;
            s.lineNumOfst = 0;
            s.relocOfst = 0;
            this.sizeOfImage += ms;
            fa += fs;
            if ((s.characteristics & 0x20) != 0) {
                this.codeSize += fus;
            }
            if ((s.characteristics & 0x40) != 0) {
                this.dataSize += fus;
            }
            if ((s.characteristics & 0x80) == 0) continue;
            this.bssSize += fus;
        }
        int da = this.dllImports.size() * 8 + 8;
        for (PEDLLImport d : this.dllImports) {
            d.nameOfst = (short)da;
            da += d.name.length() + 1;
        }
        this.entryPointOfst = this.snoToOfst(entryPointSNO);
        this.codeOfst = this.snoToOfst(codeSNO);
        this.dataOfst = this.snoToOfst(dataSNO);
        int i2 = 0;
        while (i2 < this.dirEntries.size()) {
            PEDirectoryEntry de = this.dirEntries.get(i2);
            de.virtualAddress = this.snoToOfst(dirEntrySNO[i2]);
            de.size = dirEntrySNO[i2] != null ? (dirEntrySNO[i2][0] >= 0 ? this.sections.get((int)dirEntrySNO[i2][0]).virtualSize - dirEntrySD[i2] : dirEntrySD[i2]) : 0;
            ++i2;
        }
    }

    public void recompile(RandomAccessFile f) throws IOException {
        f.seek(0L);
        f.write(this.msdosStub);
        f.seek(60L);
        f.writeInt(Integer.reverseBytes(this.msdosStub.length));
        f.seek(this.msdosStub.length);
        f.writeInt(Integer.reverseBytes(this.peSignature));
        f.writeShort(Short.reverseBytes(this.machine));
        f.writeShort(Short.reverseBytes(this.numSections));
        f.writeInt(Integer.reverseBytes(this.creationDate));
        f.writeInt(Integer.reverseBytes(this.symbolTablePtr));
        f.writeInt(Integer.reverseBytes(this.numSymbols));
        f.writeShort(Short.reverseBytes(this.optHeaderSize));
        f.writeShort(Short.reverseBytes(this.characteristics));
        long oh = f.getFilePointer();
        f.writeShort(Short.reverseBytes(this.magic));
        f.writeShort(this.linkerVersion);
        f.writeInt(Integer.reverseBytes(this.codeSize));
        f.writeInt(Integer.reverseBytes(this.dataSize));
        f.writeInt(Integer.reverseBytes(this.bssSize));
        f.writeInt(Integer.reverseBytes(this.entryPointOfst));
        f.writeInt(Integer.reverseBytes(this.codeOfst));
        if (this.magic != 523) {
            f.writeInt(Integer.reverseBytes(this.dataOfst));
            f.writeInt(Integer.reverseBytes((int)this.base));
        } else {
            f.writeLong(Long.reverseBytes(this.base));
        }
        f.writeInt(Integer.reverseBytes(this.sectionAlign));
        f.writeInt(Integer.reverseBytes(this.fileAlign));
        f.writeInt(PEImage.verswap(this.osVersion));
        f.writeInt(PEImage.verswap(this.imageVersion));
        f.writeInt(PEImage.verswap(this.subsystemVersion));
        f.writeInt(Integer.reverseBytes(this.win32versionValue));
        f.writeInt(Integer.reverseBytes(this.sizeOfImage));
        f.writeInt(Integer.reverseBytes(this.sizeOfHeaders));
        long cs = f.getFilePointer();
        f.writeInt(0);
        f.writeShort(Short.reverseBytes(this.subsystem));
        f.writeShort(Short.reverseBytes(this.dllCharacteristics));
        if (this.magic != 523) {
            f.writeInt(Integer.reverseBytes((int)this.stackReserveSize));
            f.writeInt(Integer.reverseBytes((int)this.stackCommitSize));
            f.writeInt(Integer.reverseBytes((int)this.heapReserveSize));
            f.writeInt(Integer.reverseBytes((int)this.heapCommitSize));
        } else {
            f.writeLong(Long.reverseBytes(this.stackReserveSize));
            f.writeLong(Long.reverseBytes(this.stackCommitSize));
            f.writeLong(Long.reverseBytes(this.heapReserveSize));
            f.writeLong(Long.reverseBytes(this.heapCommitSize));
        }
        f.writeInt(Integer.reverseBytes(this.loaderFlags));
        f.writeInt(Integer.reverseBytes(this.numberOfRvaAndSizes));
        int i = 0;
        while (i < this.numberOfRvaAndSizes) {
            PEDirectoryEntry de = i < this.dirEntries.size() ? this.dirEntries.get(i) : new PEDirectoryEntry();
            f.writeInt(Integer.reverseBytes(de.virtualAddress));
            f.writeInt(Integer.reverseBytes(de.size));
            ++i;
        }
        f.seek(oh + (long)this.optHeaderSize);
        i = 0;
        while (i < this.numSections) {
            PESection s = i < this.sections.size() ? this.sections.get(i) : new PESection();
            long tmp = f.getFilePointer();
            f.write(s.name);
            f.seek(tmp + 8L);
            f.writeInt(Integer.reverseBytes(s.virtualSize));
            f.writeInt(Integer.reverseBytes(s.virtualAddress));
            f.writeInt(Integer.reverseBytes(s.rawDataSize));
            f.writeInt(Integer.reverseBytes(s.rawDataOfst));
            f.writeInt(Integer.reverseBytes(s.relocOfst));
            f.writeInt(Integer.reverseBytes(s.lineNumOfst));
            f.writeShort(Short.reverseBytes(s.relocCnt));
            f.writeShort(Short.reverseBytes(s.lineNumCnt));
            f.writeInt(Integer.reverseBytes(s.characteristics));
            ++i;
        }
        long dlli = f.getFilePointer();
        for (PEDLLImport d : this.dllImports) {
            f.writeInt(Integer.reverseBytes(d.timeStamp));
            f.writeShort(Short.reverseBytes(d.nameOfst));
            f.writeShort(Short.reverseBytes(d.characteristics));
        }
        for (PEDLLImport d : this.dllImports) {
            int nl = d.name.length();
            byte[] nb = new byte[nl + 1];
            int k = 0;
            while (k < nl) {
                nb[k] = (byte)d.name.charAt(k);
                ++k;
            }
            nb[nl] = 0;
            f.seek(dlli + (long)d.nameOfst);
            f.write(nb);
        }
        int i2 = 0;
        while (i2 < this.numSections) {
            PESection s;
            PESection pESection = s = i2 < this.sections.size() ? this.sections.get(i2) : new PESection();
            if (s.rawDataSize > 0 && s.rawDataOfst > 0) {
                f.seek(s.rawDataOfst);
                f.write(new byte[s.rawDataSize]);
                f.seek(s.rawDataOfst);
                f.write(s.data, 0, Math.min(s.rawDataSize, s.data.length));
            }
            ++i2;
        }
        if (this.dirEntries.size() > 2) {
            PEDirectoryEntry de = this.dirEntries.get(2);
            int[] sno = this.ofstToSNO(de.virtualAddress, this.sizeOfHeaders);
            if (sno[0] >= 0) {
                PESection s = this.sections.get(sno[0]);
                PEResourceDirectory.addVA(s.data, sno[1], s.virtualAddress);
            }
        }
        this.checksum = 0;
        f.seek(0L);
        long len = f.length();
        int i3 = 0;
        while ((long)i3 < len) {
            this.checksum += Short.reverseBytes(f.readShort()) & 0xFFFF;
            if (this.checksum > 65535) {
                this.checksum = (this.checksum & 0xFFFF) + 1;
            }
            i3 += 2;
        }
        this.checksum += (int)len;
        f.seek(cs);
        f.writeInt(Integer.reverseBytes(this.checksum));
    }
}

