/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * $Log: string_tokenizer.hpp,v $
 * Revision 1.2  2005-03-13 12:17:44  cage
 * Miglior supporto al cml (array di: id  etichette  posizioni)
 *
 * Revision 1.1  2004/11/09 13:07:07  cage
 * string tokenizer.
 *
 * Revision 1.2  2003/02/03 16:09:47  cage
 *
 * Adesso ogni livello ha la sua introduzione.
 *
 * Revision 1.1  2002/11/30 13:47:18  cage
 * Initial revision
 *
 */


/*
 * My string tokenizer in c++.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA.
 *
 * Please report all bugs and problems to "cage@katamail.com".
 */

class string_tokenizer{

public:

/*
  st    = la stringa da splittare
  delim = il delimitatore di token. 
*/

  string_tokenizer(string &st , string &delim){
    tokenifica(st,delim);
    beg=ar.begin();
    fine=ar.end();
  }

  ~string_tokenizer(){
  }
  
/*
  Ritorna false se nonn vi sono piu' token.
*/  
  bool operator!(){
    return has_more_tokens();
  }

/*
  Ritorna un std::string corrispondente alla sottostringa
  delimitata da "delim" passato come argomento al costruttore.
*/
  
  string next_token() throw (string) {
    if(has_more_tokens()){
      string str=*beg;
      beg++;
      return str;
    }else{
      throw string("Non vi sono piu' sottostringhe!");
    }    
  }

/*
  Analogo a  string_tokenizer::bool operator!()
*/
  
  bool has_more_tokens(){
    return beg!=fine;
  }

  /*
    ritorna il numero di token
  */
  
  unsigned int count(){
    return ar.size();
  }

protected:

  void tokenifica(string &st , string &delim){
    for(string::size_type pos=0;pos<st.size();){
       string tok;
       string::size_type postmp=st.find_first_of(delim,pos);
         if( postmp!=string::npos ){
           tok=st.substr(pos,postmp-pos);
             if( ( tok !=  string("") ) && ( tok != string(" ") ) ){
             pos=postmp+1;
             ar.push_back(tok);
           }else{
             pos=postmp+1;
             continue; 
           }    
         }else{
           tok=st.substr(pos);
           ar.push_back(tok);
           break;
         }    
    }

  }


  vector<string> ar;
  vector<string>::iterator beg;
  vector<string>::iterator fine;

};

