use crate::ast_emitter::AstEmitter;
use crate::emitter::EmitError;
use ast::source_atom_set::SourceAtomSetIndex;
use stencil::function::{FunctionFlags, FunctionStencil};
use stencil::gcthings::GCThingIndex;

/// Create a dummy function with empty script, to implement
/// FunctionDeclarationEmitter without implementing FunctionScriptEmitter.
pub struct DummyFunctionScriptEmitter {
    pub name: SourceAtomSetIndex,
}

impl DummyFunctionScriptEmitter {
    pub fn emit(self, emitter: &mut AstEmitter) -> Result<GCThingIndex, EmitError> {
        let script = emitter.with_inner(|_emitter| {
            Err(EmitError::NotImplemented("TODO: FunctionDeclaration"))

            // The following implementing is just a dummy to pass the
            // emitter part.  The generated bytecode is completely wrong.
            //
            // Uncomment the following to check the behavior of
            // FunctionDeclarationEmitter in the enclosing script.
            /*
            let scope_data_map = &emitter.compilation_info.scope_data_map;
            emitter
            .scope_stack
            .enter_global(&mut emitter.emit, scope_data_map);

            emitter.emit.undefined();
            emitter.emit.set_rval();
            emitter.emit.ret_rval();

            emitter.scope_stack.leave_global(&mut emitter.emit);

            Ok(())
             */
        })?;

        let fun =
            FunctionStencil::non_lazy(Some(self.name), script, FunctionFlags::interpreted_normal());

        let index = emitter.compilation_info.functions.push(fun);

        Ok(emitter.emit.get_function_gcthing_index(index))
    }
}

pub struct FunctionDeclarationEmitter {
    pub fun: GCThingIndex,
}

impl FunctionDeclarationEmitter {
    pub fn emit(self, emitter: &mut AstEmitter) {
        emitter.emit.lambda(self.fun);
        emitter.emit.def_fun();
    }
}
