// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/analytics/management/v1alpha/resources.proto

package management

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The category selected for this property, used for industry benchmarking.
type IndustryCategory int32

const (
	// Industry category unspecified
	IndustryCategory_INDUSTRY_CATEGORY_UNSPECIFIED IndustryCategory = 0
	// Automotive
	IndustryCategory_AUTOMOTIVE IndustryCategory = 1
	// Business and industrial markets
	IndustryCategory_BUSINESS_AND_INDUSTRIAL_MARKETS IndustryCategory = 2
	// Finance
	IndustryCategory_FINANCE IndustryCategory = 3
	// Healthcare
	IndustryCategory_HEALTHCARE IndustryCategory = 4
	// Technology
	IndustryCategory_TECHNOLOGY IndustryCategory = 5
	// Travel
	IndustryCategory_TRAVEL IndustryCategory = 6
	// Other
	IndustryCategory_OTHER IndustryCategory = 7
	// Arts and entertainment
	IndustryCategory_ARTS_AND_ENTERTAINMENT IndustryCategory = 8
	// Beauty and fitness
	IndustryCategory_BEAUTY_AND_FITNESS IndustryCategory = 9
	// Books and literature
	IndustryCategory_BOOKS_AND_LITERATURE IndustryCategory = 10
	// Food and drink
	IndustryCategory_FOOD_AND_DRINK IndustryCategory = 11
	// Games
	IndustryCategory_GAMES IndustryCategory = 12
	// Hobbies and leisure
	IndustryCategory_HOBBIES_AND_LEISURE IndustryCategory = 13
	// Home and garden
	IndustryCategory_HOME_AND_GARDEN IndustryCategory = 14
	// Internet and telecom
	IndustryCategory_INTERNET_AND_TELECOM IndustryCategory = 15
	// Law and government
	IndustryCategory_LAW_AND_GOVERNMENT IndustryCategory = 16
	// News
	IndustryCategory_NEWS IndustryCategory = 17
	// Online communities
	IndustryCategory_ONLINE_COMMUNITIES IndustryCategory = 18
	// People and society
	IndustryCategory_PEOPLE_AND_SOCIETY IndustryCategory = 19
	// Pets and animals
	IndustryCategory_PETS_AND_ANIMALS IndustryCategory = 20
	// Real estate
	IndustryCategory_REAL_ESTATE IndustryCategory = 21
	// Reference
	IndustryCategory_REFERENCE IndustryCategory = 22
	// Science
	IndustryCategory_SCIENCE IndustryCategory = 23
	// Sports
	IndustryCategory_SPORTS IndustryCategory = 24
	// Jobs and education
	IndustryCategory_JOBS_AND_EDUCATION IndustryCategory = 25
	// Shopping
	IndustryCategory_SHOPPING IndustryCategory = 26
)

var IndustryCategory_name = map[int32]string{
	0:  "INDUSTRY_CATEGORY_UNSPECIFIED",
	1:  "AUTOMOTIVE",
	2:  "BUSINESS_AND_INDUSTRIAL_MARKETS",
	3:  "FINANCE",
	4:  "HEALTHCARE",
	5:  "TECHNOLOGY",
	6:  "TRAVEL",
	7:  "OTHER",
	8:  "ARTS_AND_ENTERTAINMENT",
	9:  "BEAUTY_AND_FITNESS",
	10: "BOOKS_AND_LITERATURE",
	11: "FOOD_AND_DRINK",
	12: "GAMES",
	13: "HOBBIES_AND_LEISURE",
	14: "HOME_AND_GARDEN",
	15: "INTERNET_AND_TELECOM",
	16: "LAW_AND_GOVERNMENT",
	17: "NEWS",
	18: "ONLINE_COMMUNITIES",
	19: "PEOPLE_AND_SOCIETY",
	20: "PETS_AND_ANIMALS",
	21: "REAL_ESTATE",
	22: "REFERENCE",
	23: "SCIENCE",
	24: "SPORTS",
	25: "JOBS_AND_EDUCATION",
	26: "SHOPPING",
}

var IndustryCategory_value = map[string]int32{
	"INDUSTRY_CATEGORY_UNSPECIFIED":   0,
	"AUTOMOTIVE":                      1,
	"BUSINESS_AND_INDUSTRIAL_MARKETS": 2,
	"FINANCE":                         3,
	"HEALTHCARE":                      4,
	"TECHNOLOGY":                      5,
	"TRAVEL":                          6,
	"OTHER":                           7,
	"ARTS_AND_ENTERTAINMENT":          8,
	"BEAUTY_AND_FITNESS":              9,
	"BOOKS_AND_LITERATURE":            10,
	"FOOD_AND_DRINK":                  11,
	"GAMES":                           12,
	"HOBBIES_AND_LEISURE":             13,
	"HOME_AND_GARDEN":                 14,
	"INTERNET_AND_TELECOM":            15,
	"LAW_AND_GOVERNMENT":              16,
	"NEWS":                            17,
	"ONLINE_COMMUNITIES":              18,
	"PEOPLE_AND_SOCIETY":              19,
	"PETS_AND_ANIMALS":                20,
	"REAL_ESTATE":                     21,
	"REFERENCE":                       22,
	"SCIENCE":                         23,
	"SPORTS":                          24,
	"JOBS_AND_EDUCATION":              25,
	"SHOPPING":                        26,
}

func (x IndustryCategory) String() string {
	return proto.EnumName(IndustryCategory_name, int32(x))
}

func (IndustryCategory) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d67a566c9ae86bec, []int{0}
}

// Maximum access settings that Firebase user receive on the linked Analytics
// property.
type MaximumUserAccess int32

const (
	// Unspecified maximum user access.
	MaximumUserAccess_MAXIMUM_USER_ACCESS_UNSPECIFIED MaximumUserAccess = 0
	// Firebase users have no access to the Analytics property.
	MaximumUserAccess_NO_ACCESS MaximumUserAccess = 1
	// Firebase users have Read & Analyze access to the Analytics property.
	MaximumUserAccess_READ_AND_ANALYZE MaximumUserAccess = 2
	// Firebase users have edit access to the Analytics property, but may not
	// manage the Firebase link.
	MaximumUserAccess_EDITOR_WITHOUT_LINK_MANAGEMENT MaximumUserAccess = 3
	// Firebase users have edit access to the Analytics property and may manage
	// the Firebase link.
	MaximumUserAccess_EDITOR_INCLUDING_LINK_MANAGEMENT MaximumUserAccess = 4
)

var MaximumUserAccess_name = map[int32]string{
	0: "MAXIMUM_USER_ACCESS_UNSPECIFIED",
	1: "NO_ACCESS",
	2: "READ_AND_ANALYZE",
	3: "EDITOR_WITHOUT_LINK_MANAGEMENT",
	4: "EDITOR_INCLUDING_LINK_MANAGEMENT",
}

var MaximumUserAccess_value = map[string]int32{
	"MAXIMUM_USER_ACCESS_UNSPECIFIED":  0,
	"NO_ACCESS":                        1,
	"READ_AND_ANALYZE":                 2,
	"EDITOR_WITHOUT_LINK_MANAGEMENT":   3,
	"EDITOR_INCLUDING_LINK_MANAGEMENT": 4,
}

func (x MaximumUserAccess) String() string {
	return proto.EnumName(MaximumUserAccess_name, int32(x))
}

func (MaximumUserAccess) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d67a566c9ae86bec, []int{1}
}

// NEXT TAG: 7
// A resource message representing a Google Analytics account.
type Account struct {
	// Output only. Resource name of this account.
	// Format: accounts/{account_id}
	// Example: "accounts/100"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Time when this account was originally created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when account payload fields were last updated.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Human-readable display name for this account.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Country of business. Must be a non-deprecated code for a UN M.49 region.
	// https://unicode.org/cldr/charts/latest/supplemental/territory_containment_un_m_49.html
	CountryCode string `protobuf:"bytes,5,opt,name=country_code,json=countryCode,proto3" json:"country_code,omitempty"`
	// Output only. Indicates whether this Account is soft-deleted or not. Deleted
	// accounts are excluded from List results unless specifically requested.
	Deleted              bool     `protobuf:"varint,6,opt,name=deleted,proto3" json:"deleted,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Account) Reset()         { *m = Account{} }
func (m *Account) String() string { return proto.CompactTextString(m) }
func (*Account) ProtoMessage()    {}
func (*Account) Descriptor() ([]byte, []int) {
	return fileDescriptor_d67a566c9ae86bec, []int{0}
}

func (m *Account) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Account.Unmarshal(m, b)
}
func (m *Account) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Account.Marshal(b, m, deterministic)
}
func (m *Account) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Account.Merge(m, src)
}
func (m *Account) XXX_Size() int {
	return xxx_messageInfo_Account.Size(m)
}
func (m *Account) XXX_DiscardUnknown() {
	xxx_messageInfo_Account.DiscardUnknown(m)
}

var xxx_messageInfo_Account proto.InternalMessageInfo

func (m *Account) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Account) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Account) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *Account) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Account) GetCountryCode() string {
	if m != nil {
		return m.CountryCode
	}
	return ""
}

func (m *Account) GetDeleted() bool {
	if m != nil {
		return m.Deleted
	}
	return false
}

// NEXT TAG: 10
// A resource message representing a Google Analytics App+Web property.
type Property struct {
	// Output only. Resource name of this property.
	// Format: properties/{property_id}
	// Example: "properties/1000"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Time when the entity was originally created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when entity payload fields were last updated.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Immutable. Resource name of this property's logical parent.
	//
	// Note: The Property-Moving UI can be used to change the parent.
	// Format: accounts/{account_id}
	// Example: "accounts/100"
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// Human-readable display name for this property.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Industry associated with this property
	// Example: AUTOMOTIVE, FOOD_AND_DRINK
	IndustryCategory IndustryCategory `protobuf:"varint,6,opt,name=industry_category,json=industryCategory,proto3,enum=google.analytics.management.v1alpha.IndustryCategory" json:"industry_category,omitempty"`
	// Reporting Time Zone, used as the day boundary for reports, regardless of
	// where the data originates. If the time zone honors DST, Analytics will
	// automatically adjust for the changes.
	//
	// NOTE: Changing the time zone only affects data going forward, and is not
	// applied retroactively.
	//
	// Format: https://www.iana.org/time-zones
	// Example: "America/Los_Angeles"
	TimeZone string `protobuf:"bytes,7,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// The currency type used in reports involving monetary values.
	//
	//
	// Format: https://en.wikipedia.org/wiki/ISO_4217
	// Examples: "USD", "EUR", "JPY"
	CurrencyCode string `protobuf:"bytes,8,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// Output only. Indicates whether this Property is soft-deleted or not. Deleted properties
	// are excluded from List results unless specifically requested.
	Deleted              bool     `protobuf:"varint,9,opt,name=deleted,proto3" json:"deleted,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Property) Reset()         { *m = Property{} }
func (m *Property) String() string { return proto.CompactTextString(m) }
func (*Property) ProtoMessage()    {}
func (*Property) Descriptor() ([]byte, []int) {
	return fileDescriptor_d67a566c9ae86bec, []int{1}
}

func (m *Property) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Property.Unmarshal(m, b)
}
func (m *Property) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Property.Marshal(b, m, deterministic)
}
func (m *Property) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Property.Merge(m, src)
}
func (m *Property) XXX_Size() int {
	return xxx_messageInfo_Property.Size(m)
}
func (m *Property) XXX_DiscardUnknown() {
	xxx_messageInfo_Property.DiscardUnknown(m)
}

var xxx_messageInfo_Property proto.InternalMessageInfo

func (m *Property) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Property) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Property) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *Property) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *Property) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Property) GetIndustryCategory() IndustryCategory {
	if m != nil {
		return m.IndustryCategory
	}
	return IndustryCategory_INDUSTRY_CATEGORY_UNSPECIFIED
}

func (m *Property) GetTimeZone() string {
	if m != nil {
		return m.TimeZone
	}
	return ""
}

func (m *Property) GetCurrencyCode() string {
	if m != nil {
		return m.CurrencyCode
	}
	return ""
}

func (m *Property) GetDeleted() bool {
	if m != nil {
		return m.Deleted
	}
	return false
}

// A resource message representing a Google Analytics Android app stream.
type AndroidAppDataStream struct {
	// Output only. Resource name of this Data Stream.
	// Format: properties/{property_id}/androidAppDataStreams/{stream_id}
	// Example: "properties/1000/androidAppDataStreams/2000"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Analytics "Measurement ID", without the "G-" prefix.
	// ex: "G-1A2BCD345E" would just be "1A2BCD345E"
	MeasurementId string `protobuf:"bytes,2,opt,name=measurement_id,json=measurementId,proto3" json:"measurement_id,omitempty"`
	// Output only. ID of the corresponding Android app in Firebase, if any.
	// This ID can change if the Android app is deleted and recreated.
	FirebaseAppId string `protobuf:"bytes,3,opt,name=firebase_app_id,json=firebaseAppId,proto3" json:"firebase_app_id,omitempty"`
	// Output only. Time when this stream was originally created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when stream payload fields were last updated.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Immutable. The package name for the app being measured.
	// Example: "com.example.myandroidapp"
	PackageName string `protobuf:"bytes,6,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
	// Human-readable display name for the Data Stream.
	DisplayName          string   `protobuf:"bytes,7,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AndroidAppDataStream) Reset()         { *m = AndroidAppDataStream{} }
func (m *AndroidAppDataStream) String() string { return proto.CompactTextString(m) }
func (*AndroidAppDataStream) ProtoMessage()    {}
func (*AndroidAppDataStream) Descriptor() ([]byte, []int) {
	return fileDescriptor_d67a566c9ae86bec, []int{2}
}

func (m *AndroidAppDataStream) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AndroidAppDataStream.Unmarshal(m, b)
}
func (m *AndroidAppDataStream) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AndroidAppDataStream.Marshal(b, m, deterministic)
}
func (m *AndroidAppDataStream) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AndroidAppDataStream.Merge(m, src)
}
func (m *AndroidAppDataStream) XXX_Size() int {
	return xxx_messageInfo_AndroidAppDataStream.Size(m)
}
func (m *AndroidAppDataStream) XXX_DiscardUnknown() {
	xxx_messageInfo_AndroidAppDataStream.DiscardUnknown(m)
}

var xxx_messageInfo_AndroidAppDataStream proto.InternalMessageInfo

func (m *AndroidAppDataStream) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AndroidAppDataStream) GetMeasurementId() string {
	if m != nil {
		return m.MeasurementId
	}
	return ""
}

func (m *AndroidAppDataStream) GetFirebaseAppId() string {
	if m != nil {
		return m.FirebaseAppId
	}
	return ""
}

func (m *AndroidAppDataStream) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *AndroidAppDataStream) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *AndroidAppDataStream) GetPackageName() string {
	if m != nil {
		return m.PackageName
	}
	return ""
}

func (m *AndroidAppDataStream) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

// A resource message representing a Google Analytics IOS app stream.
type IosAppDataStream struct {
	// Output only. Resource name of this Data Stream.
	// Format: properties/{property_id}/iosAppDataStreams/{stream_id}
	// Example: "properties/1000/iosAppDataStreams/2000"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Analytics "Measurement ID", without the "G-" prefix.
	// Example: "G-1A2BCD345E" would just be "1A2BCD345E"
	MeasurementId string `protobuf:"bytes,2,opt,name=measurement_id,json=measurementId,proto3" json:"measurement_id,omitempty"`
	// Output only. ID of the corresponding iOS app in Firebase, if any.
	// This ID can change if the iOS app is deleted and recreated.
	FirebaseAppId string `protobuf:"bytes,3,opt,name=firebase_app_id,json=firebaseAppId,proto3" json:"firebase_app_id,omitempty"`
	// Output only. Time when this stream was originally created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when stream payload fields were last updated.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Immutable. The Apple App Store Bundle ID for the app
	// Example: "com.example.myiosapp"
	BundleId string `protobuf:"bytes,6,opt,name=bundle_id,json=bundleId,proto3" json:"bundle_id,omitempty"`
	// Human-readable display name for the Data Stream.
	DisplayName          string   `protobuf:"bytes,7,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IosAppDataStream) Reset()         { *m = IosAppDataStream{} }
func (m *IosAppDataStream) String() string { return proto.CompactTextString(m) }
func (*IosAppDataStream) ProtoMessage()    {}
func (*IosAppDataStream) Descriptor() ([]byte, []int) {
	return fileDescriptor_d67a566c9ae86bec, []int{3}
}

func (m *IosAppDataStream) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IosAppDataStream.Unmarshal(m, b)
}
func (m *IosAppDataStream) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IosAppDataStream.Marshal(b, m, deterministic)
}
func (m *IosAppDataStream) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IosAppDataStream.Merge(m, src)
}
func (m *IosAppDataStream) XXX_Size() int {
	return xxx_messageInfo_IosAppDataStream.Size(m)
}
func (m *IosAppDataStream) XXX_DiscardUnknown() {
	xxx_messageInfo_IosAppDataStream.DiscardUnknown(m)
}

var xxx_messageInfo_IosAppDataStream proto.InternalMessageInfo

func (m *IosAppDataStream) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *IosAppDataStream) GetMeasurementId() string {
	if m != nil {
		return m.MeasurementId
	}
	return ""
}

func (m *IosAppDataStream) GetFirebaseAppId() string {
	if m != nil {
		return m.FirebaseAppId
	}
	return ""
}

func (m *IosAppDataStream) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *IosAppDataStream) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *IosAppDataStream) GetBundleId() string {
	if m != nil {
		return m.BundleId
	}
	return ""
}

func (m *IosAppDataStream) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

// A resource message representing a Google Analytics web stream.
type WebDataStream struct {
	// Output only. Resource name of this Data Stream.
	// Format: properties/{property_id}/webDataStreams/{stream_id}
	// Example: "properties/1000/webDataStreams/2000"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Analytics "Measurement ID", without the "G-" prefix.
	// Example: "G-1A2BCD345E" would just be "1A2BCD345E"
	MeasurementId string `protobuf:"bytes,2,opt,name=measurement_id,json=measurementId,proto3" json:"measurement_id,omitempty"`
	// Output only. ID of the corresponding web app in Firebase, if any.
	// This ID can change if the web app is deleted and recreated.
	FirebaseAppId string `protobuf:"bytes,3,opt,name=firebase_app_id,json=firebaseAppId,proto3" json:"firebase_app_id,omitempty"`
	// Output only. Time when this stream was originally created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when stream payload fields were last updated.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Immutable. Domain name of the web app being measured, or empty.
	// Example: "http://www.google.com", "https://www.google.com"
	DefaultUri string `protobuf:"bytes,6,opt,name=default_uri,json=defaultUri,proto3" json:"default_uri,omitempty"`
	// Human-readable display name for the Data Stream.
	DisplayName          string   `protobuf:"bytes,7,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WebDataStream) Reset()         { *m = WebDataStream{} }
func (m *WebDataStream) String() string { return proto.CompactTextString(m) }
func (*WebDataStream) ProtoMessage()    {}
func (*WebDataStream) Descriptor() ([]byte, []int) {
	return fileDescriptor_d67a566c9ae86bec, []int{4}
}

func (m *WebDataStream) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WebDataStream.Unmarshal(m, b)
}
func (m *WebDataStream) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WebDataStream.Marshal(b, m, deterministic)
}
func (m *WebDataStream) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WebDataStream.Merge(m, src)
}
func (m *WebDataStream) XXX_Size() int {
	return xxx_messageInfo_WebDataStream.Size(m)
}
func (m *WebDataStream) XXX_DiscardUnknown() {
	xxx_messageInfo_WebDataStream.DiscardUnknown(m)
}

var xxx_messageInfo_WebDataStream proto.InternalMessageInfo

func (m *WebDataStream) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *WebDataStream) GetMeasurementId() string {
	if m != nil {
		return m.MeasurementId
	}
	return ""
}

func (m *WebDataStream) GetFirebaseAppId() string {
	if m != nil {
		return m.FirebaseAppId
	}
	return ""
}

func (m *WebDataStream) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *WebDataStream) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *WebDataStream) GetDefaultUri() string {
	if m != nil {
		return m.DefaultUri
	}
	return ""
}

func (m *WebDataStream) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

// A resource message representing a user's permissions on an Account or
// Property resource.
type UserLink struct {
	// Example format: properties/1234/userLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Email address of the user to link
	EmailAddress string `protobuf:"bytes,2,opt,name=email_address,json=emailAddress,proto3" json:"email_address,omitempty"`
	// Roles directly assigned to this user for this account or property.
	//
	// Valid values:
	// predefinedRoles/read
	// predefinedRoles/collaborate
	// predefinedRoles/edit
	// predefinedRoles/manage-users
	//
	// Excludes roles that are inherited from a higher-level entity, group,
	// or organization admin role.
	//
	// A UserLink that is updated to have an empty list of direct_roles will be
	// deleted.
	DirectRoles          []string `protobuf:"bytes,3,rep,name=direct_roles,json=directRoles,proto3" json:"direct_roles,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UserLink) Reset()         { *m = UserLink{} }
func (m *UserLink) String() string { return proto.CompactTextString(m) }
func (*UserLink) ProtoMessage()    {}
func (*UserLink) Descriptor() ([]byte, []int) {
	return fileDescriptor_d67a566c9ae86bec, []int{5}
}

func (m *UserLink) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserLink.Unmarshal(m, b)
}
func (m *UserLink) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserLink.Marshal(b, m, deterministic)
}
func (m *UserLink) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserLink.Merge(m, src)
}
func (m *UserLink) XXX_Size() int {
	return xxx_messageInfo_UserLink.Size(m)
}
func (m *UserLink) XXX_DiscardUnknown() {
	xxx_messageInfo_UserLink.DiscardUnknown(m)
}

var xxx_messageInfo_UserLink proto.InternalMessageInfo

func (m *UserLink) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UserLink) GetEmailAddress() string {
	if m != nil {
		return m.EmailAddress
	}
	return ""
}

func (m *UserLink) GetDirectRoles() []string {
	if m != nil {
		return m.DirectRoles
	}
	return nil
}

// Read-only resource used to summarize a principal's effective roles.
type AuditUserLink struct {
	// Example format: properties/1234/userLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Email address of the linked user
	EmailAddress string `protobuf:"bytes,2,opt,name=email_address,json=emailAddress,proto3" json:"email_address,omitempty"`
	// Roles directly assigned to this user for this entity.
	//
	// Format: predefinedRoles/read
	//
	// Excludes roles that are inherited from an account (if this is for a
	// property), group, or organization admin role.
	DirectRoles []string `protobuf:"bytes,3,rep,name=direct_roles,json=directRoles,proto3" json:"direct_roles,omitempty"`
	// Union of all permissions a user has at this account or property (includes
	// direct permissions, group-inherited permissions, etc.).
	//
	// Format: predefinedRoles/read
	EffectiveRoles       []string `protobuf:"bytes,4,rep,name=effective_roles,json=effectiveRoles,proto3" json:"effective_roles,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuditUserLink) Reset()         { *m = AuditUserLink{} }
func (m *AuditUserLink) String() string { return proto.CompactTextString(m) }
func (*AuditUserLink) ProtoMessage()    {}
func (*AuditUserLink) Descriptor() ([]byte, []int) {
	return fileDescriptor_d67a566c9ae86bec, []int{6}
}

func (m *AuditUserLink) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AuditUserLink.Unmarshal(m, b)
}
func (m *AuditUserLink) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AuditUserLink.Marshal(b, m, deterministic)
}
func (m *AuditUserLink) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditUserLink.Merge(m, src)
}
func (m *AuditUserLink) XXX_Size() int {
	return xxx_messageInfo_AuditUserLink.Size(m)
}
func (m *AuditUserLink) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditUserLink.DiscardUnknown(m)
}

var xxx_messageInfo_AuditUserLink proto.InternalMessageInfo

func (m *AuditUserLink) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AuditUserLink) GetEmailAddress() string {
	if m != nil {
		return m.EmailAddress
	}
	return ""
}

func (m *AuditUserLink) GetDirectRoles() []string {
	if m != nil {
		return m.DirectRoles
	}
	return nil
}

func (m *AuditUserLink) GetEffectiveRoles() []string {
	if m != nil {
		return m.EffectiveRoles
	}
	return nil
}

// Singleton resource under a WebDataStream, configuring measurement of
// additional site interactions and content.
type EnhancedMeasurementSettings struct {
	// Output only. Resource name of this Data Stream.
	// Format:
	// properties/{property_id}/webDataStreams/{stream_id}/enhancedMeasurementSettings
	// Example: "properties/1000/webDataStreams/2000/enhancedMeasurementSettings"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Indicates whether Enhanced Measurement Settings will be used to
	// automatically measure interactions and content on this web stream.
	//
	// Changing this value does not affect the settings themselves, but determines
	// whether they are respected.
	StreamEnabled bool `protobuf:"varint,2,opt,name=stream_enabled,json=streamEnabled,proto3" json:"stream_enabled,omitempty"`
	// Output only. If enabled, capture a page view event each time a page loads or the
	// website changes the browser history state.
	PageViewsEnabled bool `protobuf:"varint,3,opt,name=page_views_enabled,json=pageViewsEnabled,proto3" json:"page_views_enabled,omitempty"`
	// If enabled, capture scroll events each time a visitor gets to the bottom of
	// a page.
	ScrollsEnabled bool `protobuf:"varint,4,opt,name=scrolls_enabled,json=scrollsEnabled,proto3" json:"scrolls_enabled,omitempty"`
	// If enabled, capture an outbound click event each time a visitor clicks a
	// link that leads them away from your domain.
	OutboundClicksEnabled bool `protobuf:"varint,5,opt,name=outbound_clicks_enabled,json=outboundClicksEnabled,proto3" json:"outbound_clicks_enabled,omitempty"`
	// Capture events when your visitors view content on your site that has
	// structured data (eg, articles, blog posts, product details screens, etc.).
	ContentViewsEnabled bool `protobuf:"varint,6,opt,name=content_views_enabled,json=contentViewsEnabled,proto3" json:"content_views_enabled,omitempty"`
	// If enabled, capture a view search results event each time a visitor
	// performs a search on your site (based on a query parameter).
	SiteSearchEnabled bool `protobuf:"varint,7,opt,name=site_search_enabled,json=siteSearchEnabled,proto3" json:"site_search_enabled,omitempty"`
	// If enabled, capture a view search results event each time a visitor
	// interacts with a form on your site.
	FormInteractionsEnabled bool `protobuf:"varint,8,opt,name=form_interactions_enabled,json=formInteractionsEnabled,proto3" json:"form_interactions_enabled,omitempty"`
	// If enabled, capture video play, progress, and complete events as visitors
	// view embedded videos on your site.
	VideoEngagementEnabled bool `protobuf:"varint,9,opt,name=video_engagement_enabled,json=videoEngagementEnabled,proto3" json:"video_engagement_enabled,omitempty"`
	// If enabled, capture a file download event each time a link is clicked with
	// a common document, compressed file, application, video, or audio extension.
	FileDownloadsEnabled bool `protobuf:"varint,10,opt,name=file_downloads_enabled,json=fileDownloadsEnabled,proto3" json:"file_downloads_enabled,omitempty"`
	// If enabled, capture a click event each time a visitor clicks a link or
	// element that has data attributes beginning with "data-ga".
	DataTaggedElementClicksEnabled bool `protobuf:"varint,11,opt,name=data_tagged_element_clicks_enabled,json=dataTaggedElementClicksEnabled,proto3" json:"data_tagged_element_clicks_enabled,omitempty"`
	// If enabled, capture a page view event each time a page loads.
	PageLoadsEnabled bool `protobuf:"varint,12,opt,name=page_loads_enabled,json=pageLoadsEnabled,proto3" json:"page_loads_enabled,omitempty"`
	// If enabled, capture a page view event each time the website changes the
	// browser history state.
	PageChangesEnabled bool `protobuf:"varint,13,opt,name=page_changes_enabled,json=pageChangesEnabled,proto3" json:"page_changes_enabled,omitempty"`
	// Capture events when your visitors view content on your site that has
	// articles or blog posts.
	ArticlesAndBlogsEnabled bool `protobuf:"varint,14,opt,name=articles_and_blogs_enabled,json=articlesAndBlogsEnabled,proto3" json:"articles_and_blogs_enabled,omitempty"`
	// Capture events when your visitors view content on your site that has
	// product details screens, etc.
	ProductsAndEcommerceEnabled bool `protobuf:"varint,15,opt,name=products_and_ecommerce_enabled,json=productsAndEcommerceEnabled,proto3" json:"products_and_ecommerce_enabled,omitempty"`
	// Required. URL query parameters to interpret as site search parameters.
	// Max length is 1024 characters. Must not be empty.
	SearchQueryParameter string `protobuf:"bytes,16,opt,name=search_query_parameter,json=searchQueryParameter,proto3" json:"search_query_parameter,omitempty"`
	// Additional URL query parameters.
	// Max length is 1024 characters.
	UrlQueryParameter string `protobuf:"bytes,17,opt,name=url_query_parameter,json=urlQueryParameter,proto3" json:"url_query_parameter,omitempty"`
	// Domains to exclude from measurement. Max length is 1024 characters.
	ExcludedDomains      string   `protobuf:"bytes,18,opt,name=excluded_domains,json=excludedDomains,proto3" json:"excluded_domains,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnhancedMeasurementSettings) Reset()         { *m = EnhancedMeasurementSettings{} }
func (m *EnhancedMeasurementSettings) String() string { return proto.CompactTextString(m) }
func (*EnhancedMeasurementSettings) ProtoMessage()    {}
func (*EnhancedMeasurementSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_d67a566c9ae86bec, []int{7}
}

func (m *EnhancedMeasurementSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EnhancedMeasurementSettings.Unmarshal(m, b)
}
func (m *EnhancedMeasurementSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EnhancedMeasurementSettings.Marshal(b, m, deterministic)
}
func (m *EnhancedMeasurementSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnhancedMeasurementSettings.Merge(m, src)
}
func (m *EnhancedMeasurementSettings) XXX_Size() int {
	return xxx_messageInfo_EnhancedMeasurementSettings.Size(m)
}
func (m *EnhancedMeasurementSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_EnhancedMeasurementSettings.DiscardUnknown(m)
}

var xxx_messageInfo_EnhancedMeasurementSettings proto.InternalMessageInfo

func (m *EnhancedMeasurementSettings) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EnhancedMeasurementSettings) GetStreamEnabled() bool {
	if m != nil {
		return m.StreamEnabled
	}
	return false
}

func (m *EnhancedMeasurementSettings) GetPageViewsEnabled() bool {
	if m != nil {
		return m.PageViewsEnabled
	}
	return false
}

func (m *EnhancedMeasurementSettings) GetScrollsEnabled() bool {
	if m != nil {
		return m.ScrollsEnabled
	}
	return false
}

func (m *EnhancedMeasurementSettings) GetOutboundClicksEnabled() bool {
	if m != nil {
		return m.OutboundClicksEnabled
	}
	return false
}

func (m *EnhancedMeasurementSettings) GetContentViewsEnabled() bool {
	if m != nil {
		return m.ContentViewsEnabled
	}
	return false
}

func (m *EnhancedMeasurementSettings) GetSiteSearchEnabled() bool {
	if m != nil {
		return m.SiteSearchEnabled
	}
	return false
}

func (m *EnhancedMeasurementSettings) GetFormInteractionsEnabled() bool {
	if m != nil {
		return m.FormInteractionsEnabled
	}
	return false
}

func (m *EnhancedMeasurementSettings) GetVideoEngagementEnabled() bool {
	if m != nil {
		return m.VideoEngagementEnabled
	}
	return false
}

func (m *EnhancedMeasurementSettings) GetFileDownloadsEnabled() bool {
	if m != nil {
		return m.FileDownloadsEnabled
	}
	return false
}

func (m *EnhancedMeasurementSettings) GetDataTaggedElementClicksEnabled() bool {
	if m != nil {
		return m.DataTaggedElementClicksEnabled
	}
	return false
}

func (m *EnhancedMeasurementSettings) GetPageLoadsEnabled() bool {
	if m != nil {
		return m.PageLoadsEnabled
	}
	return false
}

func (m *EnhancedMeasurementSettings) GetPageChangesEnabled() bool {
	if m != nil {
		return m.PageChangesEnabled
	}
	return false
}

func (m *EnhancedMeasurementSettings) GetArticlesAndBlogsEnabled() bool {
	if m != nil {
		return m.ArticlesAndBlogsEnabled
	}
	return false
}

func (m *EnhancedMeasurementSettings) GetProductsAndEcommerceEnabled() bool {
	if m != nil {
		return m.ProductsAndEcommerceEnabled
	}
	return false
}

func (m *EnhancedMeasurementSettings) GetSearchQueryParameter() string {
	if m != nil {
		return m.SearchQueryParameter
	}
	return ""
}

func (m *EnhancedMeasurementSettings) GetUrlQueryParameter() string {
	if m != nil {
		return m.UrlQueryParameter
	}
	return ""
}

func (m *EnhancedMeasurementSettings) GetExcludedDomains() string {
	if m != nil {
		return m.ExcludedDomains
	}
	return ""
}

// A link between an App+Web property and a Firebase project.
type FirebaseLink struct {
	// Output only. Example format: properties/1234/firebaseLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. Firebase project resource name. When creating a FirebaseLink, you may
	// provide this resource name using either a project number or project ID.
	// Once this resource has been created, returned FirebaseLinks will always
	// have a project_name that contains a project number.
	//
	// Format: 'projects/{project number}'
	// Example: 'projects/1234'
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// Output only. Time when this FirebaseLink was originally created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Maximum user access to the App + Web property allowed to admins of
	// the linked Firebase project.
	MaximumUserAccess    MaximumUserAccess `protobuf:"varint,4,opt,name=maximum_user_access,json=maximumUserAccess,proto3,enum=google.analytics.management.v1alpha.MaximumUserAccess" json:"maximum_user_access,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *FirebaseLink) Reset()         { *m = FirebaseLink{} }
func (m *FirebaseLink) String() string { return proto.CompactTextString(m) }
func (*FirebaseLink) ProtoMessage()    {}
func (*FirebaseLink) Descriptor() ([]byte, []int) {
	return fileDescriptor_d67a566c9ae86bec, []int{8}
}

func (m *FirebaseLink) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FirebaseLink.Unmarshal(m, b)
}
func (m *FirebaseLink) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FirebaseLink.Marshal(b, m, deterministic)
}
func (m *FirebaseLink) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FirebaseLink.Merge(m, src)
}
func (m *FirebaseLink) XXX_Size() int {
	return xxx_messageInfo_FirebaseLink.Size(m)
}
func (m *FirebaseLink) XXX_DiscardUnknown() {
	xxx_messageInfo_FirebaseLink.DiscardUnknown(m)
}

var xxx_messageInfo_FirebaseLink proto.InternalMessageInfo

func (m *FirebaseLink) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FirebaseLink) GetProject() string {
	if m != nil {
		return m.Project
	}
	return ""
}

func (m *FirebaseLink) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *FirebaseLink) GetMaximumUserAccess() MaximumUserAccess {
	if m != nil {
		return m.MaximumUserAccess
	}
	return MaximumUserAccess_MAXIMUM_USER_ACCESS_UNSPECIFIED
}

// Read-only resource with the tag for sending data from a website to a
// WebDataStream.
type GlobalSiteTag struct {
	// Immutable. JavaScript code snippet to be pasted as the first item into the head tag of
	// every webpage to measure.
	Snippet              string   `protobuf:"bytes,1,opt,name=snippet,proto3" json:"snippet,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GlobalSiteTag) Reset()         { *m = GlobalSiteTag{} }
func (m *GlobalSiteTag) String() string { return proto.CompactTextString(m) }
func (*GlobalSiteTag) ProtoMessage()    {}
func (*GlobalSiteTag) Descriptor() ([]byte, []int) {
	return fileDescriptor_d67a566c9ae86bec, []int{9}
}

func (m *GlobalSiteTag) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GlobalSiteTag.Unmarshal(m, b)
}
func (m *GlobalSiteTag) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GlobalSiteTag.Marshal(b, m, deterministic)
}
func (m *GlobalSiteTag) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GlobalSiteTag.Merge(m, src)
}
func (m *GlobalSiteTag) XXX_Size() int {
	return xxx_messageInfo_GlobalSiteTag.Size(m)
}
func (m *GlobalSiteTag) XXX_DiscardUnknown() {
	xxx_messageInfo_GlobalSiteTag.DiscardUnknown(m)
}

var xxx_messageInfo_GlobalSiteTag proto.InternalMessageInfo

func (m *GlobalSiteTag) GetSnippet() string {
	if m != nil {
		return m.Snippet
	}
	return ""
}

// A link between an App+Web property and a Google Ads account.
type GoogleAdsLink struct {
	// Output only. Format: properties/{propertyId}/googleAdsLinks/{googleAdsLinkId}
	//
	// Note: googleAdsLinkId is not the Google Ads customer ID.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. Format: properties/{propertyId}
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// Immutable. Google Ads customer ID.
	CustomerId string `protobuf:"bytes,3,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Output only. If true, this link is for a Google Ads manager account.
	CanManageClients bool `protobuf:"varint,4,opt,name=can_manage_clients,json=canManageClients,proto3" json:"can_manage_clients,omitempty"`
	// Enable personalized advertising features with this integration.
	// Automatically publish my Google Analytics audience lists and Google
	// Analytics remarketing events/parameters to the linked Google Ads account.
	AdsPersonalizationEnabled bool     `protobuf:"varint,5,opt,name=ads_personalization_enabled,json=adsPersonalizationEnabled,proto3" json:"ads_personalization_enabled,omitempty"`
	XXX_NoUnkeyedLiteral      struct{} `json:"-"`
	XXX_unrecognized          []byte   `json:"-"`
	XXX_sizecache             int32    `json:"-"`
}

func (m *GoogleAdsLink) Reset()         { *m = GoogleAdsLink{} }
func (m *GoogleAdsLink) String() string { return proto.CompactTextString(m) }
func (*GoogleAdsLink) ProtoMessage()    {}
func (*GoogleAdsLink) Descriptor() ([]byte, []int) {
	return fileDescriptor_d67a566c9ae86bec, []int{10}
}

func (m *GoogleAdsLink) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GoogleAdsLink.Unmarshal(m, b)
}
func (m *GoogleAdsLink) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GoogleAdsLink.Marshal(b, m, deterministic)
}
func (m *GoogleAdsLink) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GoogleAdsLink.Merge(m, src)
}
func (m *GoogleAdsLink) XXX_Size() int {
	return xxx_messageInfo_GoogleAdsLink.Size(m)
}
func (m *GoogleAdsLink) XXX_DiscardUnknown() {
	xxx_messageInfo_GoogleAdsLink.DiscardUnknown(m)
}

var xxx_messageInfo_GoogleAdsLink proto.InternalMessageInfo

func (m *GoogleAdsLink) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GoogleAdsLink) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *GoogleAdsLink) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *GoogleAdsLink) GetCanManageClients() bool {
	if m != nil {
		return m.CanManageClients
	}
	return false
}

func (m *GoogleAdsLink) GetAdsPersonalizationEnabled() bool {
	if m != nil {
		return m.AdsPersonalizationEnabled
	}
	return false
}

func init() {
	proto.RegisterEnum("google.analytics.management.v1alpha.IndustryCategory", IndustryCategory_name, IndustryCategory_value)
	proto.RegisterEnum("google.analytics.management.v1alpha.MaximumUserAccess", MaximumUserAccess_name, MaximumUserAccess_value)
	proto.RegisterType((*Account)(nil), "google.analytics.management.v1alpha.Account")
	proto.RegisterType((*Property)(nil), "google.analytics.management.v1alpha.Property")
	proto.RegisterType((*AndroidAppDataStream)(nil), "google.analytics.management.v1alpha.AndroidAppDataStream")
	proto.RegisterType((*IosAppDataStream)(nil), "google.analytics.management.v1alpha.IosAppDataStream")
	proto.RegisterType((*WebDataStream)(nil), "google.analytics.management.v1alpha.WebDataStream")
	proto.RegisterType((*UserLink)(nil), "google.analytics.management.v1alpha.UserLink")
	proto.RegisterType((*AuditUserLink)(nil), "google.analytics.management.v1alpha.AuditUserLink")
	proto.RegisterType((*EnhancedMeasurementSettings)(nil), "google.analytics.management.v1alpha.EnhancedMeasurementSettings")
	proto.RegisterType((*FirebaseLink)(nil), "google.analytics.management.v1alpha.FirebaseLink")
	proto.RegisterType((*GlobalSiteTag)(nil), "google.analytics.management.v1alpha.GlobalSiteTag")
	proto.RegisterType((*GoogleAdsLink)(nil), "google.analytics.management.v1alpha.GoogleAdsLink")
}

func init() {
	proto.RegisterFile("google/analytics/management/v1alpha/resources.proto", fileDescriptor_d67a566c9ae86bec)
}

var fileDescriptor_d67a566c9ae86bec = []byte{
	// 2043 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x58, 0x4d, 0x6f, 0xdb, 0xc8,
	0x19, 0xae, 0x2c, 0xd9, 0x96, 0x5f, 0x5b, 0x36, 0x4d, 0x3b, 0x8e, 0xe2, 0x20, 0x59, 0xaf, 0x93,
	0x36, 0x69, 0x52, 0x48, 0xbb, 0x49, 0x9b, 0xb6, 0x5e, 0x74, 0xb1, 0x63, 0x69, 0x6c, 0x73, 0x23,
	0x91, 0x2a, 0x49, 0x25, 0x75, 0x2e, 0xc4, 0x88, 0x1c, 0x29, 0xdc, 0x50, 0x24, 0xcb, 0x8f, 0x64,
	0xbd, 0x46, 0x80, 0x1e, 0xf6, 0x50, 0xec, 0x79, 0x0f, 0xfd, 0x07, 0x05, 0xfa, 0x1f, 0x7a, 0xed,
	0xad, 0x40, 0xef, 0x05, 0x8a, 0x3d, 0xfb, 0xd6, 0x43, 0xef, 0xc5, 0xcc, 0x90, 0xfa, 0xf0, 0x47,
	0xa0, 0xed, 0x16, 0xbd, 0x74, 0x6f, 0xd4, 0xf3, 0x3e, 0xcf, 0x3b, 0x2f, 0xdf, 0x67, 0xbe, 0x28,
	0x78, 0x3c, 0x08, 0x82, 0x81, 0x47, 0xeb, 0xc4, 0x27, 0xde, 0x49, 0xe2, 0xda, 0x71, 0x7d, 0x48,
	0x7c, 0x32, 0xa0, 0x43, 0xea, 0x27, 0xf5, 0xd7, 0x1f, 0x12, 0x2f, 0x7c, 0x49, 0xea, 0x11, 0x8d,
	0x83, 0x34, 0xb2, 0x69, 0x5c, 0x0b, 0xa3, 0x20, 0x09, 0xe4, 0x3b, 0x42, 0x54, 0x1b, 0x89, 0x6a,
	0x63, 0x51, 0x2d, 0x13, 0x6d, 0xbf, 0x97, 0x67, 0x0e, 0xdd, 0x7a, 0xdf, 0xa5, 0x9e, 0x63, 0xf5,
	0xe8, 0x4b, 0xf2, 0xda, 0x0d, 0x22, 0x91, 0x65, 0xfb, 0xc6, 0x04, 0x21, 0x1f, 0x21, 0x0b, 0xe5,
	0x5a, 0xfe, 0xab, 0x97, 0xf6, 0xeb, 0x89, 0x3b, 0xa4, 0x71, 0x42, 0x86, 0xa1, 0x20, 0xec, 0xfe,
	0x6d, 0x0e, 0x16, 0x91, 0x6d, 0x07, 0xa9, 0x9f, 0xc8, 0xd7, 0xa1, 0xe4, 0x93, 0x21, 0xad, 0x16,
	0x76, 0x0a, 0xf7, 0x97, 0xf6, 0x8b, 0xdf, 0xa0, 0xa2, 0xce, 0x01, 0xf9, 0x13, 0x58, 0xb6, 0x23,
	0x4a, 0x12, 0x6a, 0x31, 0x79, 0x75, 0x6e, 0xa7, 0x70, 0x7f, 0xf9, 0xd1, 0x76, 0x2d, 0x2b, 0x3e,
	0xcf, 0x5d, 0x33, 0xf3, 0xdc, 0x42, 0x0b, 0x42, 0xc3, 0x50, 0x96, 0x21, 0x0d, 0x9d, 0x51, 0x86,
	0xe2, 0x8c, 0x19, 0x84, 0x86, 0x67, 0x78, 0x1f, 0x56, 0x1c, 0x37, 0x0e, 0x3d, 0x72, 0x62, 0xf1,
	0x22, 0x4b, 0xac, 0x48, 0x7d, 0x39, 0xc3, 0x54, 0x22, 0x28, 0xfc, 0x45, 0xa2, 0x13, 0xcb, 0x0e,
	0x1c, 0x5a, 0x9d, 0x17, 0x94, 0x0c, 0x6b, 0x04, 0x0e, 0x95, 0x6f, 0xc1, 0xa2, 0x43, 0x3d, 0x9a,
	0x50, 0xa7, 0xba, 0xb0, 0x53, 0xb8, 0x5f, 0x16, 0xe3, 0xe4, 0xd8, 0x5e, 0xe3, 0x0c, 0x7d, 0x02,
	0x0f, 0x46, 0x6e, 0x4c, 0x98, 0x21, 0x2a, 0x25, 0xa1, 0x1b, 0xd7, 0xec, 0x60, 0x58, 0xcf, 0x5b,
	0x26, 0x13, 0xf1, 0x10, 0xd7, 0x4f, 0xb3, 0xa7, 0xb7, 0xbb, 0xff, 0x2a, 0x42, 0xb9, 0x13, 0x05,
	0x21, 0x8d, 0x92, 0x93, 0x99, 0x7b, 0x5a, 0xfc, 0xce, 0x3d, 0x2d, 0x7d, 0xfb, 0x9e, 0xde, 0x84,
	0x85, 0x90, 0x44, 0xd4, 0x4f, 0xb8, 0xa5, 0xbc, 0xbc, 0x79, 0x3d, 0x83, 0x2e, 0x34, 0x7c, 0xfe,
	0x62, 0xc3, 0x7b, 0xb0, 0xee, 0xfa, 0x4e, 0x1a, 0xf3, 0x8e, 0x93, 0x84, 0x0e, 0x82, 0xe8, 0x84,
	0xf7, 0x75, 0xf5, 0xd1, 0xcf, 0x6a, 0x33, 0x4c, 0xed, 0x9a, 0x92, 0xa9, 0x1b, 0x99, 0x58, 0x97,
	0xdc, 0x73, 0x88, 0x7c, 0x13, 0x96, 0xd8, 0xeb, 0x59, 0x5f, 0x04, 0x3e, 0xad, 0x2e, 0xf2, 0x1a,
	0xca, 0x0c, 0x78, 0x11, 0xf8, 0x54, 0xbe, 0x03, 0x15, 0x3b, 0x8d, 0x22, 0xea, 0xdb, 0x99, 0xe5,
	0x65, 0x4e, 0x58, 0xc9, 0xc1, 0xf3, 0x9e, 0x2f, 0x5d, 0xe2, 0xf9, 0xe1, 0x19, 0x6a, 0xc2, 0xc3,
	0x19, 0x3c, 0x1f, 0x79, 0x7a, 0x2d, 0x14, 0x4f, 0x2e, 0x8d, 0xeb, 0xa7, 0xd9, 0xf3, 0xc9, 0xdb,
	0xdd, 0x7f, 0x14, 0x61, 0x13, 0xf9, 0x4e, 0x14, 0xb8, 0x0e, 0x0a, 0xc3, 0x26, 0x49, 0x88, 0x91,
	0x44, 0x94, 0x0c, 0xaf, 0x9e, 0x03, 0x0f, 0x60, 0x75, 0x48, 0x49, 0x9c, 0x46, 0x7c, 0x3c, 0xcb,
	0x75, 0xc6, 0x3e, 0x14, 0xf5, 0xca, 0x44, 0x48, 0x71, 0xe4, 0x87, 0xb0, 0xd6, 0x77, 0x23, 0xda,
	0x23, 0x31, 0xb5, 0x48, 0x18, 0x32, 0x72, 0x71, 0x82, 0x9c, 0xc7, 0x50, 0x18, 0x2a, 0xce, 0xf9,
	0xc9, 0x55, 0xfa, 0xce, 0x93, 0x6b, 0xfe, 0xdb, 0x4f, 0xae, 0x1f, 0xc1, 0x4a, 0x48, 0xec, 0x57,
	0x64, 0x40, 0xc5, 0xfc, 0x59, 0x18, 0x4f, 0xb1, 0xe5, 0x2c, 0x90, 0xaf, 0xda, 0xa9, 0x79, 0xb6,
	0x78, 0x61, 0x9e, 0xed, 0x7d, 0x59, 0x38, 0x43, 0xbf, 0x2b, 0xc0, 0xcf, 0x67, 0x59, 0x98, 0x97,
	0x19, 0x80, 0x2f, 0x35, 0xac, 0x4e, 0x2e, 0xe1, 0xb2, 0x85, 0x2c, 0x60, 0xde, 0x65, 0x87, 0x24,
	0xc4, 0x8a, 0x79, 0xe4, 0xed, 0xee, 0x5f, 0x8a, 0x20, 0x29, 0x41, 0xfc, 0xbd, 0xb9, 0x54, 0xde,
	0x81, 0xa5, 0x5e, 0xea, 0x3b, 0x1e, 0x65, 0xa5, 0x4e, 0x38, 0x5b, 0x16, 0xa8, 0xe2, 0xcc, 0x62,
	0xeb, 0x9b, 0x33, 0x94, 0xc0, 0xe3, 0x19, 0x4c, 0xbd, 0xd0, 0xf4, 0x5f, 0x5d, 0x6e, 0xa8, 0x7b,
	0x8e, 0x17, 0xd7, 0x4f, 0xdd, 0x20, 0xbe, 0x68, 0xe4, 0x9f, 0x8b, 0x50, 0x79, 0x4e, 0x7b, 0xff,
	0xf7, 0x2e, 0xde, 0x85, 0x65, 0x87, 0xf6, 0x49, 0xea, 0x25, 0x56, 0x1a, 0xb9, 0x93, 0x3e, 0x42,
	0x86, 0x77, 0x23, 0x77, 0x16, 0x27, 0x87, 0x67, 0xe8, 0x33, 0xf8, 0x60, 0x06, 0x27, 0xa7, 0xbb,
	0xfe, 0xe4, 0x72, 0x1b, 0xdf, 0x4c, 0x92, 0xe2, 0xfa, 0xe9, 0x1b, 0xda, 0x9b, 0xf6, 0xef, 0x9f,
	0x05, 0x28, 0x77, 0x63, 0x1a, 0xb5, 0x5c, 0xff, 0x95, 0x2c, 0x4f, 0x5a, 0x97, 0xb9, 0x76, 0x07,
	0x2a, 0x74, 0x48, 0x5c, 0xcf, 0x22, 0x8e, 0x13, 0xd1, 0x38, 0x16, 0xa6, 0xe9, 0x2b, 0x1c, 0x44,
	0x02, 0x13, 0xef, 0x15, 0x51, 0x3b, 0xb1, 0xa2, 0xc0, 0xa3, 0x71, 0xb5, 0xb8, 0x53, 0x14, 0xef,
	0xc5, 0x30, 0x9d, 0x41, 0x7b, 0xbf, 0x2f, 0x9c, 0xa1, 0x2f, 0x0b, 0x33, 0x9d, 0x0e, 0xa3, 0x7a,
	0xee, 0x5f, 0xbc, 0x12, 0xd4, 0xd3, 0x2c, 0x18, 0xd7, 0x4f, 0xd9, 0xa3, 0xe5, 0xb9, 0xfe, 0xab,
	0xb7, 0xf2, 0xc3, 0xcb, 0x5f, 0xff, 0x52, 0xf2, 0xee, 0xd7, 0x05, 0xa8, 0xa0, 0xd4, 0x71, 0x93,
	0xff, 0xc5, 0x8b, 0xcb, 0xf7, 0x60, 0x8d, 0xf6, 0xfb, 0xd4, 0x4e, 0xdc, 0xd7, 0x34, 0x63, 0x95,
	0x38, 0x6b, 0x75, 0x04, 0x73, 0xe2, 0xee, 0x37, 0x65, 0xb8, 0x89, 0xfd, 0x97, 0xc4, 0xb7, 0xa9,
	0xd3, 0x1e, 0xaf, 0x06, 0x83, 0x26, 0x89, 0xeb, 0x0f, 0xe2, 0xab, 0x17, 0xd6, 0x0f, 0x61, 0x55,
	0xd8, 0x69, 0x51, 0x9f, 0xf4, 0x3c, 0x2a, 0x16, 0x56, 0x59, 0xaf, 0x08, 0x14, 0x0b, 0x50, 0xfe,
	0x10, 0xe4, 0x90, 0x1d, 0x21, 0xaf, 0x5d, 0xfa, 0x26, 0x1e, 0x51, 0x8b, 0xe3, 0x73, 0x5c, 0x62,
	0xe1, 0x67, 0x2c, 0x9a, 0x4b, 0xee, 0xc1, 0x5a, 0x6c, 0x47, 0x81, 0xe7, 0x8d, 0xf9, 0x25, 0x9e,
	0x7a, 0x35, 0x83, 0x73, 0xe2, 0x13, 0xb8, 0x1e, 0xa4, 0x49, 0x2f, 0x48, 0x7d, 0xc7, 0xb2, 0x3d,
	0xd7, 0x7e, 0x35, 0x16, 0xcc, 0x73, 0xc1, 0xb5, 0x3c, 0xdc, 0xe0, 0xd1, 0x5c, 0xf7, 0x08, 0xae,
	0xd9, 0x81, 0x9f, 0xb0, 0xfd, 0x60, 0xba, 0x2c, 0x7e, 0xa5, 0xd4, 0x37, 0xb2, 0xe0, 0x54, 0x51,
	0x35, 0xd8, 0x88, 0xdd, 0x84, 0x5a, 0x31, 0x25, 0x91, 0xfd, 0x72, 0xa4, 0x58, 0xe4, 0x8a, 0x75,
	0x16, 0x32, 0x78, 0x24, 0xe7, 0xef, 0xc1, 0x8d, 0x7e, 0x10, 0x0d, 0x2d, 0xd7, 0x4f, 0x68, 0x44,
	0xec, 0xc4, 0x0d, 0xfc, 0xf1, 0x38, 0x65, 0xae, 0xba, 0xce, 0x08, 0xca, 0x44, 0x3c, 0xd7, 0xfe,
	0x02, 0xaa, 0xaf, 0x5d, 0x87, 0x06, 0x16, 0xf5, 0x07, 0xd9, 0x6c, 0x1d, 0x49, 0xf9, 0x0d, 0x48,
	0xdf, 0xe2, 0x71, 0x3c, 0x0a, 0xe7, 0xca, 0x9f, 0xc2, 0x56, 0xdf, 0xf5, 0xa8, 0xe5, 0x04, 0x6f,
	0x7c, 0x2f, 0x20, 0xce, 0x78, 0x48, 0xe0, 0xba, 0x4d, 0x16, 0x6d, 0xe6, 0xc1, 0x5c, 0xf5, 0x29,
	0xec, 0xf2, 0xe5, 0x99, 0x90, 0xc1, 0x80, 0x3a, 0x16, 0xf5, 0xc4, 0x90, 0xe7, 0x5a, 0xba, 0xcc,
	0x33, 0xdc, 0x66, 0x4c, 0x93, 0x13, 0xb1, 0xe0, 0x4d, 0xf7, 0xf6, 0x27, 0x99, 0xdf, 0xd3, 0xa3,
	0xaf, 0x70, 0x2d, 0xb7, 0xba, 0x35, 0x39, 0xf2, 0x07, 0xb0, 0xc9, 0xd9, 0xf6, 0x4b, 0xe2, 0x0f,
	0xe8, 0x98, 0x5f, 0xe1, 0x7c, 0x9e, 0xa9, 0x21, 0x42, 0xb9, 0xe2, 0x23, 0xd8, 0x26, 0x51, 0xe2,
	0xda, 0x1e, 0x8d, 0x2d, 0xe2, 0x3b, 0x56, 0xcf, 0x0b, 0x06, 0x63, 0xdd, 0xaa, 0x68, 0x6c, 0xce,
	0x40, 0xbe, 0xb3, 0xcf, 0xe2, 0xb9, 0xb8, 0x01, 0xb7, 0xc3, 0x28, 0x70, 0x52, 0x3b, 0x11, 0x62,
	0x6a, 0x07, 0xc3, 0x21, 0x8d, 0x6c, 0x3a, 0x4a, 0xb0, 0xc6, 0x13, 0xdc, 0xcc, 0x59, 0xc8, 0x77,
	0x70, 0xce, 0xc9, 0x93, 0xfc, 0x12, 0xb6, 0xb2, 0x49, 0xf0, 0xdb, 0x94, 0x46, 0x27, 0x56, 0x48,
	0x22, 0x32, 0xa4, 0x09, 0x8d, 0xaa, 0x52, 0xbe, 0x46, 0xe6, 0xf4, 0x4d, 0x41, 0xf9, 0x35, 0x63,
	0x74, 0x72, 0x02, 0x9b, 0x44, 0x69, 0xe4, 0x5d, 0xd0, 0xad, 0xf3, 0x35, 0xbe, 0x9e, 0x46, 0xde,
	0x39, 0xfe, 0x8f, 0x41, 0xa2, 0x9f, 0xdb, 0x5e, 0xea, 0x50, 0xc7, 0x72, 0x82, 0x21, 0x71, 0xfd,
	0xb8, 0x2a, 0x73, 0xf2, 0x5a, 0x8e, 0x37, 0x05, 0xbc, 0xf7, 0x87, 0xc2, 0x19, 0xfa, 0xba, 0x00,
	0x1f, 0xcf, 0xb0, 0xd3, 0xbd, 0x6b, 0xb9, 0xeb, 0xff, 0xd9, 0x8e, 0x5e, 0xa7, 0x57, 0xe7, 0xdc,
	0xfd, 0xfb, 0x1c, 0xac, 0x1c, 0x64, 0x67, 0x27, 0xdf, 0xf8, 0xae, 0xdc, 0x53, 0x6e, 0xc1, 0x62,
	0x18, 0x05, 0x9f, 0x51, 0x7b, 0xea, 0x83, 0x26, 0xc7, 0xfe, 0x0b, 0x9f, 0x5c, 0x7d, 0xd8, 0x18,
	0x92, 0xcf, 0xdd, 0x61, 0x3a, 0xb4, 0xf8, 0xd6, 0x4c, 0x6c, 0x9b, 0x6d, 0xb2, 0x25, 0xfe, 0xc9,
	0xf3, 0x64, 0xa6, 0x4f, 0x9e, 0xb6, 0xd0, 0xb3, 0x5d, 0x1c, 0x71, 0xb5, 0xbe, 0x3e, 0x3c, 0x0f,
	0xed, 0xb9, 0x67, 0xa8, 0x0f, 0xf5, 0x19, 0xbc, 0x98, 0xea, 0xcb, 0xe3, 0xcb, 0x9b, 0xdf, 0x9f,
	0xe0, 0xc4, 0xf5, 0xd3, 0xd1, 0x15, 0x45, 0x9c, 0x2b, 0x5f, 0x15, 0xa0, 0x72, 0xe8, 0x05, 0x3d,
	0xe2, 0x19, 0x6e, 0x42, 0x4d, 0x32, 0x60, 0x5d, 0x8c, 0x7d, 0x37, 0x0c, 0x69, 0x32, 0xee, 0xf0,
	0xbc, 0x9e, 0x63, 0x7b, 0x2f, 0xce, 0xd0, 0xf3, 0x99, 0xce, 0xfa, 0xe9, 0xac, 0x77, 0x2e, 0x2f,
	0x6e, 0x30, 0x49, 0xda, 0xfd, 0xeb, 0x1c, 0x54, 0x0e, 0x79, 0x16, 0xe4, 0xc4, 0xef, 0xf6, 0xfa,
	0x9d, 0xdf, 0xae, 0x77, 0x61, 0xd9, 0x4e, 0xe3, 0x24, 0x18, 0xd2, 0x68, 0xea, 0x16, 0x36, 0xaf,
	0x43, 0x8e, 0x2b, 0xfc, 0x6c, 0xb1, 0x89, 0x6f, 0x89, 0x37, 0x60, 0xdb, 0x15, 0xf5, 0x13, 0x61,
	0x66, 0x7e, 0xb6, 0xd8, 0xc4, 0x6f, 0xf3, 0x68, 0x43, 0x04, 0xe5, 0x8f, 0xe1, 0x26, 0xdb, 0x97,
	0x42, 0x1a, 0xc5, 0x81, 0x4f, 0x3c, 0xf7, 0x0b, 0xc2, 0x76, 0xde, 0x73, 0xc7, 0xc6, 0x0d, 0xe2,
	0xc4, 0x9d, 0x69, 0x46, 0xb6, 0xf8, 0x67, 0xbf, 0x28, 0x4d, 0x77, 0xe1, 0x8a, 0x8b, 0xd2, 0x60,
	0x92, 0x14, 0xd7, 0x4f, 0xc5, 0x6f, 0x8b, 0x55, 0xc8, 0xcd, 0x7d, 0xf0, 0xa7, 0x12, 0x48, 0xe7,
	0xbf, 0xb1, 0xe5, 0xf7, 0xe1, 0x96, 0xa2, 0x36, 0xbb, 0x86, 0xa9, 0x1f, 0x5b, 0x0d, 0x64, 0xe2,
	0x43, 0x4d, 0x3f, 0xb6, 0xba, 0xaa, 0xd1, 0xc1, 0x0d, 0xe5, 0x40, 0xc1, 0x4d, 0xe9, 0x07, 0xf2,
	0x2a, 0x00, 0xea, 0x9a, 0x5a, 0x5b, 0x33, 0x95, 0x67, 0x58, 0x2a, 0xc8, 0x77, 0xe0, 0xbd, 0xfd,
	0xae, 0xa1, 0xa8, 0xd8, 0x30, 0x2c, 0xa4, 0x36, 0xad, 0x4c, 0xaf, 0xa0, 0x96, 0xd5, 0x46, 0xfa,
	0x53, 0x6c, 0x1a, 0xd2, 0x9c, 0xbc, 0x0c, 0x8b, 0x07, 0x8a, 0x8a, 0xd4, 0x06, 0x96, 0x8a, 0x2c,
	0xc3, 0x11, 0x46, 0x2d, 0xf3, 0xa8, 0x81, 0x74, 0x2c, 0x95, 0xd8, 0x6f, 0x13, 0x37, 0x8e, 0x54,
	0xad, 0xa5, 0x1d, 0x1e, 0x4b, 0xf3, 0x32, 0xc0, 0x82, 0xa9, 0xa3, 0x67, 0xb8, 0x25, 0x2d, 0xc8,
	0x4b, 0x30, 0xaf, 0x99, 0x47, 0x58, 0x97, 0x16, 0xe5, 0x6d, 0xd8, 0x42, 0xba, 0x29, 0x06, 0xc1,
	0xaa, 0x89, 0x75, 0x13, 0x29, 0x6a, 0x1b, 0xab, 0xa6, 0x54, 0x96, 0xb7, 0x40, 0xde, 0xc7, 0xa8,
	0x6b, 0x1e, 0xf3, 0xe8, 0x81, 0x62, 0xb2, 0x72, 0xa4, 0x25, 0xb9, 0x0a, 0x9b, 0xfb, 0x9a, 0xf6,
	0x54, 0x88, 0x5a, 0x8a, 0x89, 0x75, 0x64, 0x76, 0x75, 0x2c, 0x81, 0x2c, 0xc3, 0xea, 0x81, 0xa6,
	0x35, 0x79, 0xa0, 0xa9, 0x2b, 0xea, 0x53, 0x69, 0x99, 0x0d, 0x76, 0x88, 0xda, 0xd8, 0x90, 0x56,
	0xe4, 0xeb, 0xb0, 0x71, 0xa4, 0xed, 0xef, 0x2b, 0x38, 0x93, 0x62, 0xc5, 0x60, 0xba, 0x8a, 0xbc,
	0x01, 0x6b, 0x47, 0x5a, 0x1b, 0x73, 0xf4, 0x10, 0xe9, 0x4d, 0xac, 0x4a, 0xab, 0x6c, 0x18, 0x85,
	0x55, 0xa4, 0x62, 0x93, 0x07, 0x4c, 0xdc, 0xc2, 0x0d, 0xad, 0x2d, 0xad, 0xb1, 0xc2, 0x5a, 0xe8,
	0xb9, 0x60, 0x6b, 0xcf, 0xb0, 0x2e, 0x0a, 0x96, 0xe4, 0x32, 0x94, 0x54, 0xfc, 0xdc, 0x90, 0xd6,
	0x19, 0x43, 0x53, 0x5b, 0x8a, 0x8a, 0xad, 0x86, 0xd6, 0x6e, 0x77, 0x55, 0xc5, 0x54, 0xb0, 0x21,
	0xc9, 0x0c, 0xef, 0x60, 0xad, 0xd3, 0x12, 0x43, 0x19, 0x5a, 0x43, 0xc1, 0xe6, 0xb1, 0xb4, 0x21,
	0x6f, 0x82, 0xd4, 0xc1, 0x59, 0x1b, 0x90, 0xaa, 0xb4, 0x51, 0xcb, 0x90, 0x36, 0xe5, 0x35, 0x58,
	0xd6, 0x31, 0x6a, 0x59, 0xd8, 0x30, 0x91, 0x89, 0xa5, 0x6b, 0x72, 0x05, 0x96, 0x74, 0x7c, 0x80,
	0x75, 0xcc, 0x7a, 0xbe, 0xc5, 0x0c, 0x30, 0x1a, 0x0a, 0xff, 0x71, 0x9d, 0x35, 0xd8, 0xe8, 0x68,
	0xba, 0x69, 0x48, 0x55, 0x36, 0xcc, 0xa7, 0xda, 0x7e, 0xd6, 0xd5, 0x66, 0xb7, 0x81, 0x4c, 0x45,
	0x53, 0xa5, 0x1b, 0xf2, 0x0a, 0x94, 0x8d, 0x23, 0xad, 0xd3, 0x51, 0xd4, 0x43, 0x69, 0xfb, 0xc1,
	0x1f, 0x0b, 0xb0, 0x7e, 0x61, 0x77, 0x62, 0xd6, 0xb7, 0xd1, 0x6f, 0x94, 0x76, 0xb7, 0x6d, 0x75,
	0x0d, 0xac, 0x5b, 0xa8, 0xd1, 0x60, 0xb3, 0x60, 0x7a, 0xbe, 0x54, 0x60, 0x49, 0xd5, 0xb2, 0x90,
	0x54, 0x60, 0xe5, 0xeb, 0x18, 0x35, 0xb3, 0xf2, 0x51, 0xeb, 0xf8, 0x05, 0x96, 0xe6, 0xe4, 0x5d,
	0xb8, 0x8d, 0x9b, 0x8a, 0xa9, 0xe9, 0xd6, 0x73, 0xc5, 0x3c, 0xd2, 0xba, 0xa6, 0xd5, 0x52, 0xd4,
	0xa7, 0x56, 0x1b, 0xa9, 0xe8, 0x10, 0xf3, 0x96, 0x15, 0xe5, 0xbb, 0xb0, 0x93, 0x71, 0x14, 0xb5,
	0xd1, 0xea, 0x36, 0x15, 0xf5, 0xf0, 0x02, 0xab, 0xb4, 0xff, 0x55, 0x01, 0xee, 0xd9, 0xc1, 0x70,
	0x96, 0xfd, 0x76, 0x7f, 0x55, 0xcf, 0xff, 0x73, 0xed, 0xb0, 0x0d, 0xbe, 0x53, 0x78, 0xd1, 0xce,
	0x64, 0x83, 0xc0, 0x23, 0xfe, 0xa0, 0x16, 0x44, 0x83, 0xfa, 0x80, 0xfa, 0x7c, 0xfb, 0xaf, 0x8f,
	0x57, 0xe1, 0x3b, 0xff, 0xc8, 0xfd, 0x68, 0x0c, 0xf5, 0x16, 0xb8, 0xf2, 0xf1, 0xbf, 0x03, 0x00,
	0x00, 0xff, 0xff, 0x3a, 0x27, 0xec, 0x63, 0x01, 0x16, 0x00, 0x00,
}
